/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.filters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NameFilterDialog
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/filters/NameFilterDialog.java";
    private Label labelFilterName = null;
    private Text textFilterName = null;
    private String filterName = "";
    private String[] existingNames = null;
    private String dlgTitle = null;
    private Label labelIcon = null;
    private Label labelMsg = null;
    private static final int NUM_COLS = 6;
    private Message msgFile = null;
    private Point preferredSize = null;

    public NameFilterDialog(Shell parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Filters");
    }

    public void setValues(Trace t, String title, String[] existNames) {
        this.existingNames = existNames;
        this.dlgTitle = title;
    }

    private void checkIfEnableOK(Trace t) {
        this.enableOK(t, this.isEnableOK(t));
    }

    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public String getTitle(Trace t) {
        return this.dlgTitle;
    }

    @Override
    public Image getImage(Trace t) {
        return Icons.get(Icons.iconkeyExplorerSmall);
    }

    @Override
    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_FilterCopyAsDialog";
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return false;
    }

    @Override
    public void packDialog(Trace t) {
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setVisible(false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        this.labelIcon = new Label(composite, 1);
        this.labelIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.labelIcon.setLayoutData((Object)gridData);
        this.labelMsg = new Label(composite, 0);
        this.labelMsg.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.NameInUseMsg"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 5;
        this.labelMsg.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        this.labelFilterName = new Label(composite, 0);
        this.labelFilterName.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.NewFilterName"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.labelFilterName.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.textFilterName = new Text(composite, 2048);
        this.textFilterName.setText(this.filterName);
        this.textFilterName.setTextLimit(48);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.grabExcessHorizontalSpace = true;
        this.textFilterName.setLayoutData((Object)gridData);
        this.textFilterName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                NameFilterDialog.this.checkIfEnableOK(tr);
            }
        });
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        composite.pack();
        this.preferredSize = composite.getSize();
        this.checkIfEnableOK(t);
    }

    @Override
    public boolean okPressed(Trace t) {
        return true;
    }

    @Override
    public void cancelPressed(Trace t) {
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return false;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    @Override
    public boolean isEnableOK(Trace t) {
        boolean alreadyExists = false;
        boolean enableOK = false;
        this.filterName = this.textFilterName.getText();
        int i = 0;
        while (i < this.existingNames.length) {
            if (this.existingNames[i].compareTo(this.filterName) == 0) {
                alreadyExists = true;
            }
            ++i;
        }
        this.labelIcon.setVisible(alreadyExists);
        this.labelMsg.setVisible(alreadyExists);
        enableOK = !alreadyExists && this.filterName.length() > 0;
        return enableOK;
    }
}

