/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.filters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.controls.ExtList;
import com.ibm.mq.explorer.ui.internal.filters.EditFilterDialog;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterManager;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.filters.NameFilterDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ManageFiltersDialog
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/filters/ManageFiltersDialog.java";
    private Composite compositeACERButtons = null;
    private static final int NUM_COLS = 4;
    private static final int LIST_WIDTH_HINT = 400;
    private static final int LIST_HEIGHT_HINT = 300;
    private ExtList listFilters = null;
    private Button buttonAdd = null;
    private Button buttonCopyAs = null;
    private Button buttonEdit = null;
    private Button buttonRemove = null;
    private GridData gridDataAdd = null;
    private GridData gridDataCopyAs = null;
    private GridData gridDataEdit = null;
    private GridData gridDataRemove = null;
    private ArrayList<Filter> filtersArray = null;
    private ArrayList<Filter> filtersArrayCopy = null;
    private Filter selectedFilter = null;
    private Message msgFile = null;
    private String filterId = "";
    private String instanceId = "";
    private FilterManager filterManager = null;
    private FilterProvider filterProvider = null;
    private Composite compositeControls = null;
    private Point preferredSize = null;
    private Filter lastChangedFilter = null;
    private Filter currentFilter = null;

    public ManageFiltersDialog(Shell parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Filters");
    }

    public void setValues(Trace t, FilterProvider filterProv, String filtId, String instId) {
        this.filterProvider = filterProv;
        this.filterId = filtId;
        this.instanceId = instId;
    }

    private void filterSelectionChanged(Trace t) {
        boolean enableRemoveButton = false;
        int selectedIndex = this.listFilters.getSelectionIndex();
        if (selectedIndex != -1) {
            this.selectedFilter = (Filter)this.listFilters.getObject(selectedIndex);
        }
        if (this.currentFilter == null) {
            this.currentFilter = this.filterManager.getRegisteredCurrentFilter(t, this.filterId, this.instanceId);
        }
        enableRemoveButton = !this.selectedFilter.isDefaultFilter() && this.currentFilter.getFilterUniversalId().compareTo(this.selectedFilter.getFilterUniversalId()) != 0 && this.listFilters.getItemCount() > 1;
        this.buttonEdit.setEnabled(true);
        this.buttonRemove.setEnabled(enableRemoveButton);
    }

    private void populateFilterList(Trace t) {
        this.listFilters.removeAll();
        int i = 0;
        while (i < this.filtersArray.size()) {
            Filter filter = this.filtersArray.get(i);
            int disposition = filter.getDisposition();
            if (disposition != 2 && disposition != 5 && disposition != 4) {
                this.listFilters.add(filter);
            }
            if (filter.compareTo(this.selectedFilter) == 0) {
                this.listFilters.select(this.listFilters.indexOf(filter.getFilterName()));
            }
            ++i;
        }
        this.listFilters.sort();
        this.listFilters.showSelection();
        if (this.listFilters.getSelectionIndex() == -1 && this.listFilters.getItemCount() > 0) {
            this.listFilters.select(0);
        }
        this.filterSelectionChanged(t);
    }

    private void addFilter(Trace t) {
        Filter filter = new Filter(t, this.filterId, "", false, false);
        EditFilterDialog editFilterDlg = new EditFilterDialog(t, this.getShell(), 0);
        editFilterDlg.setValues(t, filter, true, true, this.filtersArray, this.filterProvider);
        editFilterDlg.create(t);
        if (editFilterDlg.open(t)) {
            filter.resetFilterUniversalId(t);
            filter.setDisposition(1);
            this.filtersArray.add(filter);
            this.populateFilterList(t);
            this.listFilters.select(this.listFilters.indexOfObject(filter));
            this.listFilters.showSelection();
            this.filterSelectionChanged(t);
            this.lastChangedFilter = filter;
        }
    }

    private void editFilter(Trace t) {
        int index = this.listFilters.getSelectionIndex();
        Filter filter = (Filter)this.listFilters.getObject(index);
        int arrayIndex = this.filtersArray.indexOf(filter);
        boolean editName = !filter.isDefaultFilter();
        EditFilterDialog editFilterDlg = new EditFilterDialog(t, this.getShell(), 0);
        editFilterDlg.setValues(t, filter, editName, false, this.filtersArray, this.filterProvider);
        editFilterDlg.create(t);
        if (editFilterDlg.open(t)) {
            int disposition = filter.getDisposition();
            if (disposition == 0) {
                filter.setDisposition(3);
            }
            this.filtersArray.set(arrayIndex, filter);
            this.populateFilterList(t);
            this.listFilters.select(this.listFilters.indexOfObject(filter));
            this.listFilters.showSelection();
            this.filterSelectionChanged(t);
            this.lastChangedFilter = filter;
        }
    }

    private void removeFilter(Trace t) {
        int index = this.listFilters.getSelectionIndex();
        Filter filter = (Filter)this.listFilters.getObject(index);
        String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4002", (String)filter.getFilterName());
        int rc = MessageBox.showDeleteCancelMessage(t, this.getShell(), msg, 1, "AMQ4002");
        if (rc == 0) {
            int disposition = filter.getDisposition();
            if (disposition == 1) {
                filter.setDisposition(4);
            } else {
                filter.setDisposition(2);
            }
            if (this.lastChangedFilter == filter) {
                this.lastChangedFilter = null;
            }
            this.populateFilterList(t);
            this.listFilters.select(0);
            this.listFilters.showSelection();
            this.filterSelectionChanged(t);
        }
    }

    private void copyFilter(Trace t) {
        int index = this.listFilters.getSelectionIndex();
        Filter filter = (Filter)this.listFilters.getObject(index);
        String dlgTitle = this.msgFile.getMessage(t, "UI.FILTERS.Dialog.CopyFilterTitle");
        NameFilterDialog nameFilterDlg = new NameFilterDialog(this.getShell(), 0);
        nameFilterDlg.setValues(t, dlgTitle, this.listFilters.getItems());
        nameFilterDlg.create(t);
        if (nameFilterDlg.open(t)) {
            Filter newFilter = new Filter(t, filter);
            newFilter.setDefaultFilter(false);
            String newName = nameFilterDlg.getFilterName();
            newFilter.setFilterName(newName);
            newFilter.resetFilterUniversalId(t);
            newFilter.setDisposition(1);
            this.filtersArray.add(newFilter);
            this.populateFilterList(t);
            this.listFilters.select(this.listFilters.indexOfObject(newFilter));
            this.listFilters.showSelection();
            this.filterSelectionChanged(t);
            this.lastChangedFilter = newFilter;
        }
    }

    private void saveUserDefinedFilters(Trace t) {
        ArrayList<Filter> userFilters = new ArrayList<Filter>();
        int i = 0;
        while (i < this.filtersArray.size()) {
            Filter filter = this.filtersArray.get(i);
            if (!filter.isDefaultFilter()) {
                userFilters.add(filter);
            }
            ++i;
        }
        this.filterManager.setUserDefinedFilters(t, this.filterId, userFilters);
        UiPlugin.showBusyCursor(t, this.getShell(), true);
        this.filterManager.saveFilters(t);
        this.filterManager.triggerChangedListeners(t, this.filterId);
        UiPlugin.showBusyCursor(t, this.getShell(), false);
    }

    public Filter getSelectedFilter() {
        return this.selectedFilter;
    }

    public void setSelectedFilter(Filter selFilter) {
        this.selectedFilter = selFilter;
    }

    @Override
    public String getTitle(Trace t) {
        return this.msgFile.getMessage(t, "UI.FILTERS.Dialog.ManageFiltersTitle");
    }

    @Override
    public Image getImage(Trace t) {
        return Icons.get(Icons.iconkeyExplorerSmall);
    }

    @Override
    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_FilterManageDialog";
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return true;
    }

    @Override
    public void packDialog(Trace t) {
        this.preferredSize = this.compositeControls.computeSize(-1, -1);
        this.populateFilterList(t);
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        this.compositeControls = composite;
        this.filterManager = UiPlugin.getFilterManager();
        this.filtersArray = this.filterManager.getAvailableFilters(t, this.filterId);
        this.filtersArrayCopy = new ArrayList();
        for (Filter filter : this.filtersArray) {
            try {
                this.filtersArrayCopy.add(filter.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        if (this.selectedFilter == null) {
            this.selectedFilter = this.filterManager.getRegisteredCurrentFilter(t, this.filterId, this.instanceId);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setVisible(false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.Filter"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.listFilters = new ExtList(composite, 2816);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.widthHint = 400;
        gridData.heightHint = 300;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.listFilters.setLayoutData(gridData);
        this.listFilters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageFiltersDialog.this.filterSelectionChanged(tr);
            }
        });
        this.compositeACERButtons = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeACERButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.compositeACERButtons.setLayoutData((Object)gridData);
        this.buttonAdd = new Button(this.compositeACERButtons, 8);
        this.buttonAdd.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.AddSchemeButton"));
        this.gridDataAdd = new GridData();
        this.buttonAdd.setLayoutData((Object)this.gridDataAdd);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageFiltersDialog.this.addFilter(tr);
            }
        });
        this.buttonCopyAs = new Button(this.compositeACERButtons, 8);
        this.buttonCopyAs.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.CopySchemeButton"));
        this.gridDataCopyAs = new GridData();
        this.buttonCopyAs.setLayoutData((Object)this.gridDataCopyAs);
        this.buttonCopyAs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageFiltersDialog.this.copyFilter(tr);
            }
        });
        this.buttonEdit = new Button(this.compositeACERButtons, 8);
        this.buttonEdit.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.EditSchemeButton"));
        this.gridDataEdit = new GridData();
        this.buttonEdit.setLayoutData((Object)this.gridDataEdit);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageFiltersDialog.this.editFilter(tr);
            }
        });
        this.buttonRemove = new Button(this.compositeACERButtons, 8);
        this.buttonRemove.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.RemoveSchemeButton"));
        this.gridDataRemove = new GridData();
        this.buttonRemove.setLayoutData((Object)this.gridDataRemove);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageFiltersDialog.this.removeFilter(tr);
            }
        });
        label = new Label(this.compositeACERButtons, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        int maxWidth = 0;
        Point sizeAdd = this.buttonAdd.computeSize(-1, -1);
        Point sizeCopyAs = this.buttonCopyAs.computeSize(-1, -1);
        Point sizeEdit = this.buttonEdit.computeSize(-1, -1);
        Point sizeRemove = this.buttonRemove.computeSize(-1, -1);
        if (sizeAdd.x > maxWidth) {
            maxWidth = sizeAdd.x;
        }
        if (sizeCopyAs.x > maxWidth) {
            maxWidth = sizeCopyAs.x;
        }
        if (sizeEdit.x > maxWidth) {
            maxWidth = sizeEdit.x;
        }
        if (sizeRemove.x > maxWidth) {
            maxWidth = sizeRemove.x;
        }
        this.gridDataAdd.widthHint = maxWidth;
        this.gridDataCopyAs.widthHint = maxWidth;
        this.gridDataEdit.widthHint = maxWidth;
        this.gridDataRemove.widthHint = maxWidth;
    }

    @Override
    public boolean okPressed(Trace t) {
        this.saveUserDefinedFilters(t);
        return true;
    }

    @Override
    public void cancelPressed(Trace t) {
        for (Filter filter : this.filtersArray) {
            Filter cloneFilter = this.findFilterInArray(t, this.filtersArrayCopy, filter.getFilterUniversalId());
            if (cloneFilter == null) continue;
            filter.copyValuesFrom(t, cloneFilter);
        }
        this.saveUserDefinedFilters(t);
    }

    private Filter findFilterInArray(Trace t, ArrayList<Filter> array, String filterUID) {
        Filter returnFilter = null;
        Iterator<Filter> filters = array.iterator();
        while (filters.hasNext() && returnFilter == null) {
            Filter filter = filters.next();
            if (filter.getFilterUniversalId().compareTo(filterUID) != 0) continue;
            returnFilter = filter;
        }
        return returnFilter;
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return false;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    @Override
    public boolean isEnableOK(Trace t) {
        return true;
    }

    public Filter getLastChangedFilter() {
        return this.lastChangedFilter;
    }
}

