/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.filters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class FilterRegistration {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/filters/FilterRegistration.java";
    public static final String KEY_DEFAULT_FILTER = "com.ibm.mq.explorer.ui.internal.filter";
    private String filterId = "";
    private Filter defaultFilter = null;
    private Filter nullFilter = null;
    private Hashtable<String, Filter> userFilters = null;
    private Hashtable<String, Filter> selectedFilters = null;

    public FilterRegistration(Trace t, String _filterId, Filter _defaultFilter, Filter _nullFilter) {
        this.filterId = _filterId;
        this.defaultFilter = _defaultFilter;
        this.nullFilter = _nullFilter;
        this.userFilters = new Hashtable();
        this.selectedFilters = new Hashtable();
    }

    public String getFilterId() {
        return this.filterId;
    }

    public void setFilterId(String id) {
        this.filterId = id;
    }

    public Filter getDefaultFilter() {
        return this.defaultFilter;
    }

    public void setDefaultFilter(Trace t, Filter filter) {
        this.defaultFilter = filter;
    }

    public Filter getNullFilter() {
        return this.nullFilter;
    }

    public void setNullFilter(Trace t, Filter filter) {
        this.nullFilter = filter;
    }

    public boolean addUserDefinedFilter(Trace t, Filter userFilter) {
        boolean result = true;
        String key = userFilter.getKey(t);
        this.userFilters.put(key, userFilter);
        return result;
    }

    public boolean removeUserDefinedFilter(Trace t, String universalId) {
        boolean result = false;
        String key = universalId;
        if (this.userFilters.containsKey(key)) {
            this.userFilters.remove(key);
            result = true;
        }
        return result;
    }

    public Hashtable<String, Filter> getUserDefinedFilters(Trace t) {
        return this.userFilters;
    }

    public ArrayList<Filter> getUserDefinedFiltersArray(Trace t) {
        ArrayList<Filter> userDefinedFilters = new ArrayList<Filter>();
        Enumeration<Filter> enumUserFilters = this.userFilters.elements();
        while (enumUserFilters.hasMoreElements()) {
            userDefinedFilters.add(enumUserFilters.nextElement());
        }
        return userDefinedFilters;
    }

    public Filter getUserDefinedFilter(Trace t, String key) {
        Filter filter = null;
        if (this.userFilters.containsKey(key)) {
            filter = this.userFilters.get(key);
        }
        return filter;
    }

    public void removeAllUserDefinedFilters(Trace t) {
        this.userFilters.clear();
    }

    public boolean setUserDefinedFilters(Trace t, ArrayList<Filter> userDefFilters) {
        boolean result = true;
        this.removeAllUserDefinedFilters(t);
        int i = 0;
        while (i < userDefFilters.size()) {
            Filter filter = userDefFilters.get(i);
            if (!this.addUserDefinedFilter(t, filter)) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public Hashtable<String, Filter> getFilterSelections(Trace t) {
        return this.selectedFilters;
    }

    public void removeAllSelectedFilters(Trace t) {
        this.selectedFilters.clear();
    }

    public Filter getSelectedFilter(Trace t, String instanceId) {
        Filter selFilter = this.selectedFilters.get(instanceId);
        return selFilter;
    }

    public String getSelectedFilterKey(Trace t, String instanceId) {
        String key = "";
        Filter selFilter = this.getSelectedFilter(t, instanceId);
        key = selFilter.compareTo(this.defaultFilter) == 0 ? KEY_DEFAULT_FILTER : selFilter.getKey(t);
        return key;
    }

    public void setSelectedFilter(Trace t, String instanceId, Filter filter) {
        this.selectedFilters.put(instanceId, filter);
    }

    public boolean addSelectedFilter(Trace t, String instanceId, String filterKey) {
        boolean result = true;
        Filter selFilter = this.getDefaultFilter();
        selFilter = filterKey.compareTo(KEY_DEFAULT_FILTER) == 0 ? this.getDefaultFilter() : this.getUserDefinedFilter(t, filterKey);
        if (selFilter == null) {
            selFilter = this.getDefaultFilter();
        }
        this.selectedFilters.put(instanceId, selFilter);
        return result;
    }

    public void removeInstanceFromSelectedFilters(Trace t, String instanceId) {
        if (this.selectedFilters.containsKey(instanceId)) {
            this.selectedFilters.remove(instanceId);
        }
    }
}

