/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.filters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterRegistration;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class FilterPersistence {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/filters/FilterPersistence.java";
    private static String filtersFilename = "";
    private XMLMemento rootWrite = null;
    private XMLMemento rootRead = null;
    private boolean dataInvalid = false;
    private ArrayList<String> createdExampleFilterIds = null;
    private static final String ROOT_KEY = "Filters";
    private static final String VERSION_KEY = "FileVersion";
    private static final String THIS_VERSION = "1.0.0";
    private static final String EXAMPLES_CREATED_KEY = "ExamplesCreatedCount";
    private static final String EXAMPLE_FILTER_ID_KEY_PREFIX = "CreatedExampleFilterId_";
    private static final String REG_FILTER_ID_COUNT_KEY = "RegisteredFilterIdCount";
    private static final String REG_FILTER_ID_KEY_PREFIX = "RegisteredFilterId_";
    private static final String REGISTRATION_KEY_PREFIX = "FilterRegistration_";
    private static final String DEFAULT_FILTER_KEY = "DefaultFilter";
    private static final String NULL_FILTER_KEY = "NullFilter";
    private static final String USER_FILTERS_KEY = "UserFilters";
    private static final String FILTER_SELECTIONS_KEY = "FilterSelections";
    private static final String USER_DEFINED_COUNT_KEY = "UserDefinedCount";
    private static final String USER_DEFINED_FILTER_KEY_PREFIX = "UserDefinedFilter_";
    private static final String FILTER_NAME_KEY = "FilterName";
    private static final String FILTER_UID_KEY = "UniversalId";
    private static final String FILTER_ID_KEY = "Id";
    private static final String FILTER_ISDEFAULT_KEY = "IsDefault";
    private static final String FILTER_ISNULL_KEY = "IsNull";
    private static final String FILTER_NAMEVALUE_KEY = "NameValue";
    private static final String FILTER_TYPEVALUE_KEY = "TypeValue";
    private static final String FILTER_SUBTYPEVALUE_KEY = "SubtypeValue";
    private static final String FILTER_ISWHERECLAUSE_KEY = "IsWhere";
    private static final String FILTER_WHEREATTRID_KEY = "WhereAttrId";
    private static final String FILTER_WHEREOP_KEY = "WhereOp";
    private static final String FILTER_WHEREVALUETYPE_KEY = "WhereValueType";
    private static final String FILTER_WHEREVALUE_KEY = "WhereValue";
    private static final String FILTER_WHEREVALUENAME_KEY = "WhereValueName";
    private static final String FILTER_LAST_SELECTED = "LastSelected";
    private static final String FILTER_ISSCHEME_KEY = "IsScheme";
    private static final String FILTER_SCHEMENAME_KEY = "SchemeName";
    private static final String FILTER_SCHEMEISDEFAULT_KEY = "SchemeIsDefault";
    private static final String FILTER_SCHEMEID_KEY = "SchemeId";
    private static final String FILTER_SELECTION_COUNT_KEY = "SelectionCount";
    private static final String FILTER_SEL_INSTANCEID_KEY_PREFIX = "FilterSelInstanceID_";
    private static final String FILTER_SEL_FILTERKEY_KEY_PREFIX = "FilterSelFilterUID_";

    public FilterPersistence(Trace t, File workingDir) {
        filtersFilename = workingDir + File.separator + "WMQ_Filters.xml";
        this.readXMLFile(t);
        this.rootWrite = XMLMemento.createWriteRoot((String)ROOT_KEY);
        this.createdExampleFilterIds = new ArrayList();
    }

    public ArrayList<String> loadFilterRegistrationIds(Trace t) {
        ArrayList<String> filterRegistrationIds = new ArrayList<String>();
        if (this.dataInvalid) {
            this.readXMLFile(t);
            if (this.rootRead != null) {
                this.dataInvalid = false;
            }
        }
        if (this.rootRead != null) {
            Integer intCount;
            Integer intCreated = this.rootRead.getInteger(EXAMPLES_CREATED_KEY);
            if (intCreated != null) {
                int i = 0;
                while (i < intCreated) {
                    String exampleFilterId = this.rootRead.getString(EXAMPLE_FILTER_ID_KEY_PREFIX + i);
                    if (exampleFilterId != null) {
                        this.createdExampleFilterIds.add(exampleFilterId);
                    }
                    ++i;
                }
            }
            if ((intCount = this.rootRead.getInteger(REG_FILTER_ID_COUNT_KEY)) != null) {
                int i = 0;
                while (i < intCount) {
                    String filterRegId = this.rootRead.getString(REG_FILTER_ID_KEY_PREFIX + i);
                    if (filterRegId != null && filterRegId.length() > 0) {
                        filterRegistrationIds.add(filterRegId);
                    }
                    ++i;
                }
            }
        }
        return filterRegistrationIds;
    }

    public FilterRegistration loadFilterRegistration(Trace t, String filterRegId) {
        IMemento childFilterReg;
        FilterRegistration filterReg = null;
        Filter defaultFilter = null;
        Filter nullFilter = null;
        if (this.dataInvalid) {
            this.readXMLFile(t);
            if (this.rootRead != null) {
                this.dataInvalid = false;
            }
        }
        if (this.rootRead != null && (childFilterReg = this.rootRead.getChild(REGISTRATION_KEY_PREFIX + filterRegId)) != null) {
            IMemento child = childFilterReg.getChild(DEFAULT_FILTER_KEY);
            if (child != null) {
                defaultFilter = this.loadFilter(t, child);
            }
            if ((child = childFilterReg.getChild(NULL_FILTER_KEY)) != null) {
                nullFilter = this.loadFilter(t, child);
            }
            if (defaultFilter != null && nullFilter != null) {
                filterReg = new FilterRegistration(t, filterRegId, defaultFilter, nullFilter);
            }
            if (filterReg != null) {
                int i;
                Integer intCount;
                ArrayList<Filter> userFilters = new ArrayList<Filter>();
                IMemento childUserFilters = childFilterReg.getChild(USER_FILTERS_KEY);
                if (childUserFilters != null && (intCount = childUserFilters.getInteger(USER_DEFINED_COUNT_KEY)) != null) {
                    i = 0;
                    while (i < intCount) {
                        Filter userFilter = null;
                        child = childUserFilters.getChild(USER_DEFINED_FILTER_KEY_PREFIX + i);
                        if (child != null) {
                            userFilter = this.loadFilter(t, child);
                        }
                        if (userFilter != null) {
                            userFilters.add(userFilter);
                        }
                        ++i;
                    }
                }
                if (userFilters.size() > 0) {
                    filterReg.setUserDefinedFilters(t, userFilters);
                }
                if ((child = childFilterReg.getChild(FILTER_SELECTIONS_KEY)) != null && (intCount = child.getInteger(FILTER_SELECTION_COUNT_KEY)) != null) {
                    i = 0;
                    while (i < intCount) {
                        String instanceId = child.getString(FILTER_SEL_INSTANCEID_KEY_PREFIX + i);
                        String filterKey = child.getString(FILTER_SEL_FILTERKEY_KEY_PREFIX + i);
                        if (instanceId != null && instanceId.length() > 0 && filterKey != null && filterKey.length() > 0) {
                            filterReg.addSelectedFilter(t, instanceId, filterKey);
                        }
                        ++i;
                    }
                }
            } else {
                t.FFST(67, "FilterPersistence.loadFilterRegistration", 10, 50999, 0, 0, "Failed to register filter read from persistence file", "FilterRegId = " + filterRegId, null);
            }
        }
        return filterReg;
    }

    public boolean saveFilterRegistrationIds(Trace t, ArrayList<String> ids) {
        boolean result = false;
        this.rootWrite.putString(VERSION_KEY, THIS_VERSION);
        int count = this.createdExampleFilterIds.size();
        this.rootWrite.putInteger(EXAMPLES_CREATED_KEY, count);
        int i = 0;
        while (i < count) {
            this.rootWrite.putString(EXAMPLE_FILTER_ID_KEY_PREFIX + i, this.createdExampleFilterIds.get(i));
            ++i;
        }
        this.rootWrite.putInteger(REG_FILTER_ID_COUNT_KEY, ids.size());
        i = 0;
        while (i < ids.size()) {
            this.rootWrite.putString(REG_FILTER_ID_KEY_PREFIX + i, ids.get(i));
            ++i;
        }
        return result;
    }

    public boolean saveFilterRegistration(Trace t, FilterRegistration filterRegistration, boolean isPersist) {
        boolean result = false;
        IMemento childFilterReg = this.openChild(t, (IMemento)this.rootWrite, REGISTRATION_KEY_PREFIX + filterRegistration.getFilterId());
        IMemento child = this.openChild(t, childFilterReg, DEFAULT_FILTER_KEY);
        this.saveFilter(t, filterRegistration.getDefaultFilter(), child);
        child = this.openChild(t, childFilterReg, NULL_FILTER_KEY);
        this.saveFilter(t, filterRegistration.getNullFilter(), child);
        child = this.openChild(t, childFilterReg, USER_FILTERS_KEY);
        ArrayList<Filter> userFilters = filterRegistration.getUserDefinedFiltersArray(t);
        int count = userFilters.size();
        child.putInteger(USER_DEFINED_COUNT_KEY, count);
        int i = 0;
        while (i < count) {
            Filter filter = userFilters.get(i);
            IMemento userFilterChild = this.openChild(t, child, USER_DEFINED_FILTER_KEY_PREFIX + i);
            if (userFilterChild != null) {
                this.saveFilter(t, filter, userFilterChild);
            }
            ++i;
        }
        child = this.openChild(t, childFilterReg, FILTER_SELECTIONS_KEY);
        Hashtable<String, Filter> filterSelections = filterRegistration.getFilterSelections(t);
        Enumeration<String> keys = filterSelections.keys();
        count = filterSelections.size();
        child.putInteger(FILTER_SELECTION_COUNT_KEY, count);
        int i2 = 0;
        while (keys.hasMoreElements()) {
            String instanceId = keys.nextElement();
            child.putString(FILTER_SEL_INSTANCEID_KEY_PREFIX + i2, instanceId);
            Filter filter = filterSelections.get(instanceId);
            child.putString(FILTER_SEL_FILTERKEY_KEY_PREFIX + i2, filter.getKey(t));
            ++i2;
        }
        if (isPersist) {
            this.writeFilterRegistrationInfo(t);
        }
        return result;
    }

    public boolean writeFilterRegistrationInfo(Trace t) {
        this.dataInvalid = true;
        return this.writeXMLMemento(t);
    }

    private void saveFilter(Trace t, Filter filter, IMemento child) {
        child.putString(FILTER_NAME_KEY, filter.getFilterName());
        child.putString(FILTER_UID_KEY, filter.getFilterUniversalId());
        child.putString(FILTER_ID_KEY, filter.getFilterId());
        int value = filter.isDefaultFilter() ? 1 : 0;
        child.putInteger(FILTER_ISDEFAULT_KEY, value);
        value = filter.isNullFilter() ? 1 : 0;
        child.putInteger(FILTER_ISNULL_KEY, value);
        child.putString(FILTER_NAMEVALUE_KEY, filter.getNameCompareValue(t));
        child.putInteger(FILTER_TYPEVALUE_KEY, filter.getTypeValue());
        child.putInteger(FILTER_SUBTYPEVALUE_KEY, filter.getSubtypeValue());
        if (filter.isUsingWhere(t)) {
            child.putInteger(FILTER_ISWHERECLAUSE_KEY, 1);
            child.putInteger(FILTER_WHEREATTRID_KEY, filter.getWhereAttrId(t));
            child.putInteger(FILTER_WHEREOP_KEY, filter.getWhereOperation(t));
            Object whereClauseValue = filter.getWhereValue(t);
            if (whereClauseValue instanceof String) {
                child.putInteger(FILTER_WHEREVALUETYPE_KEY, 0);
                child.putString(FILTER_WHEREVALUE_KEY, (String)whereClauseValue);
            } else if (whereClauseValue instanceof Integer) {
                child.putInteger(FILTER_WHEREVALUETYPE_KEY, 1);
                child.putInteger(FILTER_WHEREVALUE_KEY, ((Integer)whereClauseValue).intValue());
            }
            child.putString(FILTER_WHEREVALUENAME_KEY, filter.getWhereValueName(t));
        } else {
            child.putInteger(FILTER_ISWHERECLAUSE_KEY, 0);
        }
        float floatDate = filter.getDateLastSelected();
        child.putFloat(FILTER_LAST_SELECTED, floatDate);
        if (filter.isAssociatedAttributeOrder()) {
            child.putInteger(FILTER_ISSCHEME_KEY, 1);
            child.putString(FILTER_SCHEMENAME_KEY, filter.getAttrOrderName());
            if (filter.isDefaultFilter()) {
                child.putInteger(FILTER_SCHEMEISDEFAULT_KEY, 1);
            } else {
                child.putInteger(FILTER_SCHEMEISDEFAULT_KEY, 0);
            }
            child.putString(FILTER_SCHEMEID_KEY, filter.getAttrOrderUniversalId());
        } else {
            child.putInteger(FILTER_ISSCHEME_KEY, 0);
        }
    }

    private Filter loadFilter(Trace t, IMemento child) {
        Filter filter = null;
        String name = child.getString(FILTER_NAME_KEY);
        String uid = child.getString(FILTER_UID_KEY);
        String id = child.getString(FILTER_ID_KEY);
        Integer intIsDefault = child.getInteger(FILTER_ISDEFAULT_KEY);
        Integer intIsNull = child.getInteger(FILTER_ISNULL_KEY);
        if (name.length() > 0 && uid.length() > 0 && id.length() > 0) {
            boolean isDefault = intIsDefault == 1;
            boolean isNull = intIsNull == 1;
            filter = new Filter(t, id, name, uid, isDefault, isNull);
        }
        if (filter != null) {
            Integer intIsScheme;
            String nameValue = child.getString(FILTER_NAMEVALUE_KEY);
            Integer typeValue = child.getInteger(FILTER_TYPEVALUE_KEY);
            Integer subtypeValue = child.getInteger(FILTER_SUBTYPEVALUE_KEY);
            filter.setNameAndTypeClauseValues(t, nameValue, typeValue, subtypeValue);
            Integer intIsWhere = child.getInteger(FILTER_ISWHERECLAUSE_KEY);
            if (intIsWhere == 1) {
                Integer intWhereAttrId = child.getInteger(FILTER_WHEREATTRID_KEY);
                Integer intWhereOp = child.getInteger(FILTER_WHEREOP_KEY);
                Integer intWhereValueType = child.getInteger(FILTER_WHEREVALUETYPE_KEY);
                Object whereValue = null;
                if (intWhereValueType == 0) {
                    whereValue = child.getString(FILTER_WHEREVALUE_KEY);
                } else if (intWhereValueType == 1) {
                    whereValue = child.getInteger(FILTER_WHEREVALUE_KEY);
                }
                String whereValueName = child.getString(FILTER_WHEREVALUENAME_KEY);
                filter.setWhereClauseValues(t, intWhereAttrId, intWhereOp, whereValue, whereValueName, intWhereValueType);
            } else {
                filter.resetWhereClauseValues(t);
            }
            Float floatDate = child.getFloat(FILTER_LAST_SELECTED);
            if (floatDate != null) {
                filter.setDateLastSelected(floatDate.longValue());
            }
            if ((intIsScheme = child.getInteger(FILTER_ISSCHEME_KEY)) == 1) {
                String attrOrderName = child.getString(FILTER_SCHEMENAME_KEY);
                Integer intSchemeIsDefault = child.getInteger(FILTER_SCHEMEISDEFAULT_KEY);
                String attrOrderUID = child.getString(FILTER_SCHEMEID_KEY);
                filter.setAssociatedAttributeOrder(attrOrderName, intSchemeIsDefault == 1, attrOrderUID);
            } else {
                filter.setAssociatedAttributeOrder(null, false, null);
            }
        }
        return filter;
    }

    private IMemento openChild(Trace t, IMemento parent, String childName) {
        IMemento child = null;
        child = parent.getChild(childName);
        if (child == null) {
            child = parent.createChild(childName);
        }
        return child;
    }

    public boolean isExampleFilterCreated(Trace t, String id) {
        boolean result = false;
        int i = 0;
        while (i < this.createdExampleFilterIds.size()) {
            String testId = this.createdExampleFilterIds.get(i);
            if (testId.compareTo(id) == 0) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public void addCreatedExampleFilterId(Trace t, String id) {
        if (!this.isExampleFilterCreated(t, id)) {
            this.createdExampleFilterIds.add(id);
        }
    }

    public static String getFilename() {
        return filtersFilename;
    }

    /*
     * Loose catch block
     */
    public void readXMLFile(Trace t) {
        InputStreamReader reader = null;
        try {
            try {
                File file = new File(filtersFilename);
                FileInputStream input = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)input, "UTF-8");
                this.rootRead = XMLMemento.createReadRoot((Reader)reader);
            }
            catch (FileNotFoundException e) {
                if (Trace.isTracing) {
                    t.data(67, "FilterPersistence.readXMLFile", 300, e.getMessage());
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "FilterPersistence.readXMLFile", 10, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
            catch (WorkbenchException e) {
                t.FFST(67, "FilterPersistence.readXMLFile", 0, -1, 0, 0, e.getMessage(), null, null);
                this.showReadError(t);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "FilterPersistence.readXMLFile", 10, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
            catch (UnsupportedEncodingException e) {
                t.FFST(67, "FilterPersistence.readXMLFile", 1, -1, 0, 0, e.getMessage(), null, null);
                this.showReadError(t);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "FilterPersistence.readXMLFile", 10, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                t.FFST(67, "FilterPersistence.readXMLFile", 10, -1, 0, 0, e1.getMessage(), null, null);
            }
        }
    }

    public boolean writeXMLMemento(Trace t) {
        boolean result = false;
        OutputStreamWriter writer = null;
        try {
            try {
                File file = new File(filtersFilename);
                FileOutputStream output = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
                this.rootWrite.save((Writer)writer);
                result = true;
            }
            catch (IOException e) {
                t.FFST(67, "FilterPersistence.writeXMLMemento", 10, -1, 0, 0, e.getMessage(), null, null);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "FilterPersistence.writeXMLMemento", 20, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                t.FFST(67, "FilterPersistence.writeXMLMemento", 20, -1, 0, 0, e1.getMessage(), null, null);
            }
        }
        return result;
    }

    public String createBackupFile(Trace t) {
        String backupFile = UiUtils.createBackupFile(t, filtersFilename);
        return backupFile;
    }

    public boolean isNewVersion(Trace t) {
        String fileVersion;
        boolean isNewVersion = false;
        if (this.dataInvalid) {
            this.readXMLFile(t);
            if (this.rootRead != null) {
                this.dataInvalid = false;
            }
        }
        if (this.rootRead != null && ((fileVersion = this.rootRead.getString(VERSION_KEY)) == null || fileVersion.compareTo(THIS_VERSION) != 0)) {
            isNewVersion = true;
        }
        return isNewVersion;
    }

    private void showReadError(Trace t) {
        String backupFile = UiUtils.createBackupFile(t, filtersFilename);
        String msgId = "AMQ4475";
        String messageWarning = CommonServices.getSystemMessage((String)msgId, (String)backupFile);
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Filters");
        MessageDialog.openWarning((Shell)UiPlugin.getShell(), (String)msgFile.getMessage(t, "UI.GENERAL.MQ"), (String)messageWarning);
    }

    public XMLMemento getRootRead() {
        if (this.rootRead == null) {
            Trace t = Trace.getDefault();
            this.readXMLFile(t);
        }
        return this.rootRead;
    }

    public void setRootWrite(XMLMemento rootWrite) {
        this.rootWrite = rootWrite;
    }
}

