/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.filters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.filters.CompareFilterLastSelectedDates;
import com.ibm.mq.explorer.ui.internal.filters.DefaultObjectFilterRegistrations;
import com.ibm.mq.explorer.ui.internal.filters.DefineExampleFilters;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterChangedEvent;
import com.ibm.mq.explorer.ui.internal.filters.FilterDefinition;
import com.ibm.mq.explorer.ui.internal.filters.FilterNotifyEvent;
import com.ibm.mq.explorer.ui.internal.filters.FilterPersistence;
import com.ibm.mq.explorer.ui.internal.filters.FilterRegistration;
import com.ibm.mq.explorer.ui.internal.filters.IFilterChangedListener;
import com.ibm.mq.explorer.ui.internal.filters.IFilterNotify;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class FilterManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/filters/FilterManager.java";
    public static final int INVALID_INDEX = -1;
    private static final String INSTANCE_ID_COMMON = "com.ibm.mq.explorer.instanceid.common";
    private ArrayList<IFilterChangedListener> changedListeners = null;
    private Hashtable<String, FilterRegistration> registrations = null;
    private FilterPersistence filterPersistence = null;
    private Message msgFile = null;
    private String nullFilterName = null;
    private FilterDefinition filterDefinition = null;
    private ArrayList<IFilterNotify> filterListeners = null;
    private static Integer lock = 0;
    private File workingDir;

    public FilterManager(Trace t, File workingDir) {
        this.workingDir = workingDir;
        this.initialise(t, true);
    }

    public void initialise(Trace t, boolean loadListeners) {
        this.filterPersistence = new FilterPersistence(t, this.workingDir);
        this.registrations = new Hashtable();
        this.filterDefinition = new FilterDefinition(t);
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Filters");
        if (loadListeners) {
            if (this.changedListeners == null) {
                this.changedListeners = new ArrayList();
            }
            if (this.filterListeners == null) {
                this.filterListeners = new ArrayList();
            }
            this.loadFilterListeners(t);
        }
        this.nullFilterName = this.msgFile.getMessage(t, "UI.FILTERS.NullFilterName");
        if (this.filterPersistence.isNewVersion(t)) {
            this.migrateFilters(t);
        } else {
            boolean foundNullFilterReg = false;
            ArrayList<String> filterRegIds = this.loadFilterRegistrationIds(t);
            int i = 0;
            while (i < filterRegIds.size()) {
                String regFilterId = filterRegIds.get(i);
                FilterRegistration filterReg = this.loadFilterRegistration(t, regFilterId);
                if (filterReg != null) {
                    Filter dfltFilter;
                    if (regFilterId.compareTo("com.ibm.mq.explorer.filterid.topics") == 0 && (dfltFilter = filterReg.getDefaultFilter()).getTypeValue() != 174) {
                        regFilterId = "com.ibm.mq.explorer.pubsub.filterid.topics";
                        filterReg.setFilterId(regFilterId);
                    }
                    this.registrations.put(regFilterId, filterReg);
                } else {
                    foundNullFilterReg = true;
                }
                ++i;
            }
            if (foundNullFilterReg) {
                String backupFileName = this.filterPersistence.createBackupFile(t);
                this.displayInvalidFilterFileWarning(t, backupFileName);
            }
            DefaultObjectFilterRegistrations.register(t, this);
            DefineExampleFilters.create(t, this);
        }
        this.saveFilters(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterRegistration loadFilterRegistration(Trace t, String regFilterId) {
        FilterRegistration filterRegistration = null;
        Integer n = lock;
        synchronized (n) {
            filterRegistration = this.filterPersistence.loadFilterRegistration(t, regFilterId);
        }
        return filterRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> loadFilterRegistrationIds(Trace t) {
        ArrayList<String> filterRegistrationIds = null;
        Integer n = lock;
        synchronized (n) {
            filterRegistrationIds = this.filterPersistence.loadFilterRegistrationIds(t);
        }
        return filterRegistrationIds;
    }

    public boolean register(Trace t, String objectId, String filterId, String filterNameRoot, int defaultFilterType, int defaultFilterSubType) {
        boolean result = this.registerFilter(t, objectId, filterId, filterNameRoot, defaultFilterType, defaultFilterSubType, null, false, null);
        return result;
    }

    public boolean register(Trace t, String objectId, String filterId, String filterNameRoot, int defaultFilterType, int defaultFilterSubType, String defaultAttrOrderName, boolean defaultAttrOrderIsDefault, String defaultAttrOrderUID) {
        boolean result = this.registerFilter(t, objectId, filterId, filterNameRoot, defaultFilterType, defaultFilterSubType, defaultAttrOrderName, defaultAttrOrderIsDefault, defaultAttrOrderUID);
        return result;
    }

    private boolean registerFilter(Trace t, String objectId, String filterId, String filterNameRoot, int defaultFilterType, int defaultFilterSubType, String defaultAttrOrderName, boolean defaultAttrOrderIsDefault, String defaultAttrOrderUID) {
        boolean result = false;
        String defaultFilterName = Message.format((String)this.msgFile.getMessage(t, "UI.FILTERS.Prefix.Default"), (String)filterNameRoot);
        String standardFilterName = Message.format((String)this.msgFile.getMessage(t, "UI.FILTERS.Prefix.Standard"), (String)filterNameRoot);
        FilterRegistration filterReg = this.getFilterRegistration(t, filterId);
        if (filterReg == null) {
            Filter defaultFilter = new Filter(t, filterId, defaultFilterName, true, false);
            defaultFilter.setNameAndTypeClauseValues(t, "*", defaultFilterType, defaultFilterSubType);
            defaultFilter.setAssociatedAttributeOrder(defaultAttrOrderName, defaultAttrOrderIsDefault, defaultAttrOrderUID);
            Filter nullFilter = new Filter(t, filterId, this.nullFilterName, false, true);
            nullFilter.setNameAndTypeClauseValues(t, "*", defaultFilterType, defaultFilterSubType);
            FilterRegistration filterRegistration = new FilterRegistration(t, filterId, defaultFilter, nullFilter);
            result = this.addFilterRegistration(t, filterId, filterRegistration);
            if (result) {
                this.createStandardFilter(t, filterId, standardFilterName, true);
            }
        } else {
            ArrayList<Filter> userDefinedFilters = this.getUserDefinedFilters(t, filterId);
            if (userDefinedFilters.size() == 0) {
                this.createStandardFilter(t, filterId, standardFilterName, true);
                this.saveFilters(t);
            }
            result = true;
        }
        return result;
    }

    public boolean unregister(Trace t, String filterId) {
        boolean result = this.removeFilterRegistration(t, filterId);
        return result;
    }

    public boolean isRegistered(Trace t, String filterId) {
        boolean result = false;
        FilterRegistration filterReg = this.getFilterRegistration(t, filterId);
        if (filterReg != null) {
            result = true;
        }
        return result;
    }

    public Filter getRegisteredCurrentFilter(Trace t, String filterId, String instanceId) {
        Filter filter = null;
        String useInstanceId = FilterManager.makeValidInstanceId(instanceId);
        FilterRegistration filterReg = this.getFilterRegistration(t, filterId);
        if (filterReg != null) {
            filter = this.getSelectedFilter(t, filterId, useInstanceId);
            if (filter == null) {
                filter = this.getSelectedFilter(t, filterId, FilterManager.makeValidInstanceId(null));
                this.setSelectedFilter(t, filterId, useInstanceId, filter, false);
            }
        } else {
            filter = new Filter(t, filterId, "", false, true);
        }
        return filter;
    }

    private static String makeValidInstanceId(String instanceId) {
        String useInstanceId = instanceId;
        if (useInstanceId == null) {
            useInstanceId = INSTANCE_ID_COMMON;
        }
        return useInstanceId;
    }

    public Filter getRegisteredDefaultFilter(Trace t, String filterId) {
        Filter filter = null;
        FilterRegistration filterReg = this.getFilterRegistration(t, filterId);
        if (filterReg != null) {
            filter = filterReg.getDefaultFilter();
        }
        return filter;
    }

    public ArrayList<Filter> getAvailableFilters(Trace t, String filterId) {
        ArrayList<Filter> array = new ArrayList<Filter>();
        FilterRegistration filterReg = this.getFilterRegistration(t, filterId);
        if (filterReg != null) {
            ArrayList<Filter> userFilters = this.getUserDefinedFilters(t, filterId);
            int i = 0;
            while (i < userFilters.size()) {
                Filter filter = userFilters.get(i);
                int disposition = filter.getDisposition();
                if (disposition != 2 && disposition != 5 && disposition != 4) {
                    array.add(filter);
                }
                ++i;
            }
        }
        return array;
    }

    public boolean addUserDefinedFilter(Trace t, String filterId, Filter userFilter) {
        boolean result = false;
        FilterRegistration filterRegistration = this.getFilterRegistration(t, filterId);
        if (filterRegistration != null) {
            result = filterRegistration.addUserDefinedFilter(t, userFilter);
        }
        return result;
    }

    public boolean isExampleFilterCreated(Trace t, String filterId, String id) {
        boolean result = false;
        String truncatedUid = id.substring(0, id.lastIndexOf("_"));
        Filter userDefinedFilter = this.getUserDefinedFilterFromUID(t, filterId, truncatedUid);
        if (userDefinedFilter != null) {
            result = true;
        }
        return result;
    }

    public boolean removeUserDefinedFilter(Trace t, String filterId, String universalId) {
        boolean result = false;
        FilterRegistration filterRegistration = this.getFilterRegistration(t, filterId);
        if (filterRegistration != null) {
            result = filterRegistration.removeUserDefinedFilter(t, universalId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUserDefinedFilters(Trace t, String filterId, ArrayList<Filter> userFilters) {
        boolean result = false;
        FilterRegistration filterRegistration = this.getFilterRegistration(t, filterId);
        if (filterRegistration != null) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (Filter filter : userFilters) {
                int disposition = filter.getDisposition();
                if (this.filterListeners.size() > 0) {
                    switch (disposition) {
                        case 1: {
                            this.notifyFilterAdded(t, filter);
                            break;
                        }
                        case 3: {
                            this.notifyFilterChanged(t, filter);
                            break;
                        }
                        case 2: {
                            if (this.notifyIsOkToDelete(t, filter)) {
                                this.notifyFilterDeleted(t, filter);
                                break;
                            }
                            disposition = 0;
                            filter.setDisposition(disposition);
                            String msgId = "AMQ4467";
                            String msgText = CommonServices.getSystemMessage((String)msgId);
                            MessageBox.showMessage(t, UiPlugin.getShell(), msgText, 2, new String[]{UiPlugin.getNLSString(t, "KEY_General", "UI.GENERAL.OK")}, 0, msgId);
                        }
                    }
                }
                if (disposition == 2 || disposition == 5 || disposition == 4) continue;
                filter.setDisposition(0);
                filters.add(filter);
            }
            result = filterRegistration.setUserDefinedFilters(t, filters);
            if (result) {
                Integer n = lock;
                synchronized (n) {
                    this.filterPersistence.saveFilterRegistration(t, filterRegistration, false);
                }
                this.triggerChangedListeners(t, filterId);
            }
        }
        return result;
    }

    public ArrayList<Filter> getUserDefinedFilters(Trace t, String filterId) {
        ArrayList<Filter> userDefinedFilters = null;
        FilterRegistration filterRegistration = this.getFilterRegistration(t, filterId);
        if (filterRegistration != null) {
            userDefinedFilters = filterRegistration.getUserDefinedFiltersArray(t);
        }
        return userDefinedFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedFilter(Trace t, String filterId, String instanceId, Filter filter, boolean triggerListeners) {
        String useInstanceId = FilterManager.makeValidInstanceId(instanceId);
        FilterRegistration filterRegistration = this.getFilterRegistration(t, filterId);
        if (filterRegistration != null) {
            filterRegistration.setSelectedFilter(t, useInstanceId, filter);
            Date date = new Date();
            filter.setDateLastSelected(date.getTime());
            Integer n = lock;
            synchronized (n) {
                this.filterPersistence.saveFilterRegistration(t, filterRegistration, true);
            }
            if (triggerListeners) {
                this.triggerSelectionChangedListeners(t, filterId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFilterRegistration(Trace t, String filterId, FilterRegistration filterReg) {
        boolean result = false;
        if (this.getFilterRegistration(t, filterId) == null) {
            this.registrations.put(filterId, filterReg);
            ArrayList<String> regFilterIds = new ArrayList<String>();
            Enumeration<String> ids = this.registrations.keys();
            while (ids.hasMoreElements()) {
                regFilterIds.add(ids.nextElement());
            }
            Integer n = lock;
            synchronized (n) {
                this.filterPersistence.saveFilterRegistrationIds(t, regFilterIds);
            }
            result = true;
        }
        return result;
    }

    public FilterRegistration getFilterRegistration(Trace t, String filterId) {
        FilterRegistration filterReg = this.registrations.get(filterId);
        return filterReg;
    }

    public FilterRegistration getFilterRegistration(Trace t, Filter filter) {
        FilterRegistration filterReg = this.registrations.get(filter.getFilterId());
        return filterReg;
    }

    public boolean removeFilterRegistration(Trace t, String filterId) {
        FilterRegistration value = this.registrations.remove(filterId);
        return value != null;
    }

    public void addChangedListener(Trace t, IFilterChangedListener listener) {
        this.changedListeners.add(listener);
    }

    public void removeChangedListener(Trace t, IFilterChangedListener listener) {
        this.changedListeners.remove(listener);
    }

    public void triggerChangedListeners(Trace t, String filterId) {
        FilterChangedEvent selEvent = new FilterChangedEvent(this, filterId);
        int i = 0;
        while (i < this.changedListeners.size()) {
            IFilterChangedListener listener = this.changedListeners.get(i);
            listener.changed(selEvent);
            ++i;
        }
    }

    public void triggerSelectionChangedListeners(Trace t, String filterId) {
        FilterChangedEvent selEvent = new FilterChangedEvent(this, filterId);
        int i = 0;
        while (i < this.changedListeners.size()) {
            IFilterChangedListener listener = this.changedListeners.get(i);
            listener.selectionChanged(selEvent);
            ++i;
        }
    }

    public FilterDefinition getFilterDefinition() {
        return this.filterDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanceDeleted(Trace t, String filterId, String instanceId) {
        FilterRegistration filterReg;
        if (filterId != null && (filterReg = this.getFilterRegistration(t, filterId)) != null) {
            filterReg.removeInstanceFromSelectedFilters(t, FilterManager.makeValidInstanceId(instanceId));
            Integer n = lock;
            synchronized (n) {
                this.filterPersistence.saveFilterRegistration(t, filterReg, true);
            }
        }
    }

    private Filter getSelectedFilter(Trace t, String filterId, String instanceId) {
        Filter filter = null;
        FilterRegistration filterRegistration = this.getFilterRegistration(t, filterId);
        if (filterRegistration != null) {
            filter = filterRegistration.getSelectedFilter(t, instanceId);
        }
        return filter;
    }

    private boolean createStandardFilter(Trace t, String filterId, String standardFilterName, boolean select) {
        boolean result = false;
        FilterRegistration filterReg = this.getFilterRegistration(t, filterId);
        if (filterReg != null) {
            Filter defaultFilter = filterReg.getDefaultFilter();
            Filter standardFilter = new Filter(t, defaultFilter);
            standardFilter.setFilterName(standardFilterName);
            standardFilter.setDefaultFilter(false);
            standardFilter.resetFilterUniversalId(t);
            this.addUserDefinedFilter(t, filterId, standardFilter);
            if (select) {
                this.setSelectedFilter(t, filterId, null, standardFilter, false);
            }
        }
        return result;
    }

    public void saveFilters(Trace t) {
        Thread saveThread = new Thread(){

            @Override
            public void run() {
                Trace tr = Trace.getDefault();
                FilterManager.this.persistFilters(tr);
            }
        };
        saveThread.setName("IBM MQ save filters");
        saveThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistFilters(Trace t) {
        Integer n = lock;
        synchronized (n) {
            ArrayList<String> regFilterIds = new ArrayList<String>();
            Enumeration<String> ids = this.registrations.keys();
            while (ids.hasMoreElements()) {
                String key = ids.nextElement();
                regFilterIds.add(key);
                FilterRegistration filterReg = this.registrations.get(key);
                this.filterPersistence.saveFilterRegistration(t, filterReg, false);
            }
            this.filterPersistence.saveFilterRegistrationIds(t, regFilterIds);
            this.filterPersistence.writeFilterRegistrationInfo(t);
        }
    }

    public Filter[] getMostRecentlySelectedFilters(Trace t, String filterId, int count) {
        Filter[] filters = new Filter[count];
        int i = 0;
        while (i < count) {
            filters[i] = null;
            ++i;
        }
        ArrayList<Filter> availFilters = this.getAvailableFilters(t, filterId);
        int size = availFilters.size();
        Filter[] filterArray = new Filter[size];
        filterArray = availFilters.toArray(filterArray);
        CompareFilterLastSelectedDates compFilterLastSelDates = new CompareFilterLastSelectedDates();
        Arrays.sort(filterArray, compFilterLastSelDates);
        int limit = count;
        if (size < limit) {
            limit = size;
        }
        int i2 = 0;
        while (i2 < limit) {
            filters[i2] = filterArray[i2];
            ++i2;
        }
        return filters;
    }

    public boolean addExampleFilter(Trace t, String exampleId, Filter filter) {
        boolean result = false;
        if (!this.isExampleFilterCreated(t, filter.getFilterId(), filter.getFilterUniversalId())) {
            if (this.addUserDefinedFilter(t, filter.getFilterId(), filter)) {
                this.filterPersistence.addCreatedExampleFilterId(t, exampleId);
                result = true;
            } else if (Trace.isTracing) {
                t.data(67, "FilterManager.addExampleFilter", 900, "Error: failed to add example Filter, filterId='" + filter.getFilterId() + "', exampleId='" + exampleId + "'");
            }
        } else {
            result = true;
        }
        return result;
    }

    public void loadFilterListeners(Trace t) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.mq.explorer.ui", "internal_addFilterListener");
        if (extensionPoint != null) {
            FilterManager.trace(t, "FilterManager.loadFilterListeners", "    label = " + extensionPoint.getLabel());
            FilterManager.trace(t, "FilterManager.loadFilterListeners", "    schemaReference = " + extensionPoint.getSchemaReference());
            FilterManager.trace(t, "FilterManager.loadFilterListeners", "    simpleIdentifier = " + extensionPoint.getSimpleIdentifier());
            FilterManager.trace(t, "FilterManager.loadFilterListeners", "    uniqueIdentifier = " + extensionPoint.getUniqueIdentifier());
            IConfigurationElement[] configArray = extensionPoint.getConfigurationElements();
            FilterManager.trace(t, "FilterManager.loadFilterListeners", "    Number of ConfigurationElements = " + configArray.length);
            int i = 0;
            while (i < configArray.length) {
                IConfigurationElement element = configArray[i];
                FilterManager.trace(t, "FilterManager.loadFilterListeners", "        name  = " + element.getName());
                FilterManager.trace(t, "FilterManager.loadFilterListeners", "        value = " + element.getValue());
                FilterManager.trace(t, "FilterManager.loadFilterListeners", "");
                ++i;
            }
            IExtension[] extensionArray = extensionPoint.getExtensions();
            FilterManager.trace(t, "FilterManager.loadFilterListeners", "    Number of Extensions = " + extensionArray.length);
            int i2 = 0;
            while (i2 < extensionArray.length) {
                IExtension extension = extensionArray[i2];
                FilterManager.trace(t, "FilterManager.loadFilterListeners", "        label = " + extension.getLabel());
                FilterManager.trace(t, "FilterManager.loadFilterListeners", "        simpleIdentifier = " + extension.getSimpleIdentifier());
                FilterManager.trace(t, "FilterManager.loadFilterListeners", "        uniqueIdentifier = " + extension.getUniqueIdentifier());
                IConfigurationElement[] configArray2 = extension.getConfigurationElements();
                FilterManager.trace(t, "FilterManager.loadFilterListeners", "        Number of ConfigurationElements = " + configArray2.length);
                int j = 0;
                while (j < configArray2.length) {
                    IConfigurationElement element = configArray2[j];
                    FilterManager.trace(t, "FilterManager.loadFilterListeners", "            element.name  = " + element.getName());
                    FilterManager.trace(t, "FilterManager.loadFilterListeners", "            element.value = " + element.getValue());
                    String plugin_id = element.getDeclaringExtension().getNamespaceIdentifier();
                    if (UiPlugin.getPluginRegistrationManager().isPluginRegistered(plugin_id)) {
                        String listenerClass = element.getAttribute("listenerClass");
                        FilterManager.trace(t, "FilterManager.loadFilterListeners", "              listenerClass         = " + listenerClass);
                        try {
                            Object obj = element.createExecutableExtension("listenerClass");
                            if (obj instanceof IFilterNotify) {
                                this.addFilterListener(t, (IFilterNotify)obj);
                            }
                        }
                        catch (CoreException coreException) {
                            if (Trace.isTracing) {
                                t.data(67, "FilterManager.loadFilterListeners", 900, "CoreException loading the listenerClass '" + listenerClass + "' for pluginId '" + plugin_id + "'");
                            }
                            t.FFST(67, "FilterManager.loadFilterListeners", 20, 50999, 0, 0, "CoreException loading listenerClass specified in internal_addFilterListener extension point", "pluginId = '" + plugin_id + "'", "listenerClass = '" + listenerClass + "'");
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
    }

    public void addFilterListener(Trace t, IFilterNotify listener) {
        this.filterListeners.add(listener);
    }

    public void removeFilterListener(Trace t, IFilterNotify listener) {
        if (this.filterListeners.contains(listener)) {
            this.filterListeners.remove(listener);
        }
    }

    private void notifyFilterAdded(Trace t, Filter filter) {
        FilterNotifyEvent event = new FilterNotifyEvent(t, filter);
        Iterator<IFilterNotify> iterator = this.filterListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().filterAdded(event);
        }
    }

    private void notifyFilterChanged(Trace t, Filter filter) {
        FilterNotifyEvent event = new FilterNotifyEvent(t, filter);
        Iterator<IFilterNotify> iterator = this.filterListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().filterChanged(event);
        }
    }

    private boolean notifyIsOkToDelete(Trace t, Filter filter) {
        boolean result = true;
        FilterNotifyEvent event = new FilterNotifyEvent(t, filter);
        Iterator<IFilterNotify> iterator = this.filterListeners.iterator();
        boolean endIterating = false;
        while (iterator.hasNext() && !endIterating) {
            if (!iterator.next().isPreventFilterDelete(event)) continue;
            result = false;
            endIterating = true;
        }
        return result;
    }

    private void notifyFilterDeleted(Trace t, Filter filter) {
        FilterNotifyEvent event = new FilterNotifyEvent(t, filter);
        Iterator<IFilterNotify> iterator = this.filterListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().filterDeleted(event);
        }
    }

    private static void trace(Trace t, String fid, String msg) {
        if (Trace.isTracing) {
            t.data(67, fid, 300, msg);
        }
    }

    private void displayInvalidFilterFileWarning(Trace t, String fileName) {
        String msgId = "AMQ4474";
        String messageWarning = CommonServices.getSystemMessage((String)msgId, (String)fileName);
        MessageDialog.openWarning((Shell)UiPlugin.getShell(), (String)this.msgFile.getMessage(t, "UI.GENERAL.MQ"), (String)messageWarning);
    }

    private void migrateFilters(Trace t) {
        boolean foundNullFilterReg = false;
        ArrayList<String> filterRegIds = this.loadFilterRegistrationIds(t);
        ArrayList<FilterRegistration> filterRegs = new ArrayList<FilterRegistration>();
        int i = 0;
        while (i < filterRegIds.size()) {
            String filterRegId = filterRegIds.get(i);
            FilterRegistration filterReg = this.loadFilterRegistration(t, filterRegId);
            if (filterReg != null) {
                Filter dfltFilter;
                if (filterRegId.compareTo("com.ibm.mq.explorer.filterid.topics") == 0 && (dfltFilter = filterReg.getDefaultFilter()).getTypeValue() != 174) {
                    filterRegId = "com.ibm.mq.explorer.pubsub.filterid.topics";
                    filterReg.setFilterId(filterRegId);
                }
                filterRegs.add(filterReg);
            } else {
                foundNullFilterReg = true;
            }
            ++i;
        }
        if (foundNullFilterReg) {
            String backupFileName = this.filterPersistence.createBackupFile(t);
            this.displayInvalidFilterFileWarning(t, backupFileName);
        }
        DefaultObjectFilterRegistrations.register(t, this);
        DefineExampleFilters.create(t, this);
        int j = 0;
        while (j < filterRegs.size()) {
            FilterRegistration filterReg = (FilterRegistration)filterRegs.get(j);
            String filterRegId = filterReg.getFilterId();
            if (this.getFilterRegistration(t, filterRegId) == null) {
                this.registrations.put(filterRegId, filterReg);
            } else {
                ArrayList<Filter> userDefinedFilters = filterReg.getUserDefinedFiltersArray(t);
                int k = 0;
                while (k < userDefinedFilters.size()) {
                    Filter userDefinedFilter = userDefinedFilters.get(k);
                    String uid = userDefinedFilter.getKey(t);
                    String truncatedUid = uid.substring(0, uid.lastIndexOf("_"));
                    Filter existingFilter = this.getUserDefinedFilterFromUID(t, filterRegId, truncatedUid);
                    if (existingFilter == null) {
                        this.addUserDefinedFilter(t, filterRegId, userDefinedFilter);
                    }
                    ++k;
                }
            }
            ++j;
        }
    }

    public Filter getUserDefinedFilterFromUID(Trace t, String orderId, String filterUID) {
        Filter matchingFilter = null;
        FilterRegistration filterRegistration = this.getFilterRegistration(t, orderId);
        if (filterRegistration != null) {
            ArrayList<Filter> userDefinedFilters = filterRegistration.getUserDefinedFiltersArray(t);
            int i = 0;
            while (i < userDefinedFilters.size()) {
                Filter userDefinedFilter = userDefinedFilters.get(i);
                String userDefinedFilterUid = userDefinedFilter.getFilterUniversalId();
                if (userDefinedFilterUid.substring(0, userDefinedFilterUid.lastIndexOf("_")).equals(filterUID)) {
                    matchingFilter = userDefinedFilter;
                }
                ++i;
            }
        }
        return matchingFilter;
    }
}

