/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.filters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLongRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeRange;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.filters.ValuePair;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.EnumAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.EnumRangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.EnumTextAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.EnumTextRangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.LongNumericAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.NumericAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.RangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.TextAttributeControl;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Composite;

public class FilterDefinition {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/filters/FilterDefinition.java";
    public static final Integer SUPPORTS_WILDCARD = 1;
    public static final Integer NOT_SUPPORT_WILDCARD = 0;
    private ValuePair valuepairLess = null;
    private ValuePair valuepairEqual = null;
    private ValuePair valuepairNotGreater = null;
    private ValuePair valuepairGreater = null;
    private ValuePair valuepairNotEqual = null;
    private ValuePair valuepairNotLess = null;
    private ValuePair valuepairContains = null;
    private ValuePair valuepairExcludes = null;
    private ValuePair valuepairLike = null;
    private ValuePair valuepairNotLike = null;
    private ValuePair valuepairContainsGen = null;
    private ValuePair valuepairExcludesGen = null;
    private Message msgFile = null;

    public FilterDefinition(Trace t) {
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Filters");
        this.valuepairLess = new ValuePair(1, this.msgFile.getMessage(t, "UI.FILTERS.Less"));
        this.valuepairLess.setUserData(NOT_SUPPORT_WILDCARD);
        this.valuepairEqual = new ValuePair(2, this.msgFile.getMessage(t, "UI.FILTERS.Equal"));
        this.valuepairEqual.setUserData(NOT_SUPPORT_WILDCARD);
        this.valuepairNotGreater = new ValuePair(3, this.msgFile.getMessage(t, "UI.FILTERS.NotGreater"));
        this.valuepairNotGreater.setUserData(NOT_SUPPORT_WILDCARD);
        this.valuepairGreater = new ValuePair(4, this.msgFile.getMessage(t, "UI.FILTERS.Greater"));
        this.valuepairGreater.setUserData(NOT_SUPPORT_WILDCARD);
        this.valuepairNotEqual = new ValuePair(5, this.msgFile.getMessage(t, "UI.FILTERS.NotEqual"));
        this.valuepairNotEqual.setUserData(NOT_SUPPORT_WILDCARD);
        this.valuepairNotLess = new ValuePair(6, this.msgFile.getMessage(t, "UI.FILTERS.NotLess"));
        this.valuepairNotLess.setUserData(NOT_SUPPORT_WILDCARD);
        this.valuepairContains = new ValuePair(10, this.msgFile.getMessage(t, "UI.FILTERS.Contains"));
        this.valuepairContains.setUserData(NOT_SUPPORT_WILDCARD);
        this.valuepairExcludes = new ValuePair(13, this.msgFile.getMessage(t, "UI.FILTERS.Excludes"));
        this.valuepairExcludes.setUserData(NOT_SUPPORT_WILDCARD);
        this.valuepairLike = new ValuePair(18, this.msgFile.getMessage(t, "UI.FILTERS.Like"));
        this.valuepairLike.setUserData(SUPPORTS_WILDCARD);
        this.valuepairNotLike = new ValuePair(21, this.msgFile.getMessage(t, "UI.FILTERS.NotLike"));
        this.valuepairNotLike.setUserData(SUPPORTS_WILDCARD);
        this.valuepairContainsGen = new ValuePair(10, this.msgFile.getMessage(t, "UI.FILTERS.ContainsGen"));
        this.valuepairContainsGen.setUserData(SUPPORTS_WILDCARD);
        this.valuepairExcludesGen = new ValuePair(13, this.msgFile.getMessage(t, "UI.FILTERS.ExcludesGen"));
        this.valuepairExcludesGen.setUserData(SUPPORTS_WILDCARD);
    }

    public ValuePair getWhereClauseOpValuePair(Trace t, int operationId, int valueType) {
        ValuePair whereClauseOpValuePair = null;
        switch (operationId) {
            case 1: {
                whereClauseOpValuePair = this.valuepairLess;
                break;
            }
            case 2: {
                whereClauseOpValuePair = this.valuepairEqual;
                break;
            }
            case 3: {
                whereClauseOpValuePair = this.valuepairNotGreater;
                break;
            }
            case 4: {
                whereClauseOpValuePair = this.valuepairGreater;
                break;
            }
            case 5: {
                whereClauseOpValuePair = this.valuepairNotEqual;
                break;
            }
            case 6: {
                whereClauseOpValuePair = this.valuepairNotLess;
                break;
            }
            case 10: {
                whereClauseOpValuePair = this.valuepairContains;
                break;
            }
            case 13: {
                whereClauseOpValuePair = this.valuepairExcludes;
                break;
            }
            case 18: {
                whereClauseOpValuePair = this.valuepairLike;
                break;
            }
            case 21: {
                whereClauseOpValuePair = this.valuepairNotLike;
                break;
            }
            case 26: {
                whereClauseOpValuePair = this.valuepairContainsGen;
                break;
            }
            case 29: {
                whereClauseOpValuePair = this.valuepairExcludesGen;
            }
        }
        return whereClauseOpValuePair;
    }

    public ArrayList getWhereClauseOperationValuePairArray(Trace t, AttrType attrType) {
        return this.getWhereClauseOperationValuePairArray(t, attrType, false);
    }

    public ArrayList getWhereClauseOperationValuePairArray(Trace t, AttrType attrType, boolean attrTypeModifier) {
        ArrayList<ValuePair> valuePairArray = new ArrayList<ValuePair>();
        int attType = attrType.getAttributeType();
        switch (attType) {
            case 2: 
            case 6: 
            case 7: 
            case 26: {
                valuePairArray.add(this.valuepairLike);
                valuePairArray.add(this.valuepairNotLike);
                valuePairArray.add(this.valuepairEqual);
                valuePairArray.add(this.valuepairNotEqual);
                valuePairArray.add(this.valuepairGreater);
                valuePairArray.add(this.valuepairNotGreater);
                valuePairArray.add(this.valuepairLess);
                valuePairArray.add(this.valuepairNotLess);
                break;
            }
            case 8: 
            case 9: 
            case 15: {
                valuePairArray.add(this.valuepairContains);
                valuePairArray.add(this.valuepairExcludes);
                valuePairArray.add(this.valuepairContainsGen);
                valuePairArray.add(this.valuepairExcludesGen);
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 12: 
            case 29: {
                valuePairArray.add(this.valuepairEqual);
                valuePairArray.add(this.valuepairNotEqual);
                valuePairArray.add(this.valuepairGreater);
                valuePairArray.add(this.valuepairNotGreater);
                valuePairArray.add(this.valuepairLess);
                valuePairArray.add(this.valuepairNotLess);
                break;
            }
            case 14: {
                valuePairArray.add(this.valuepairEqual);
                valuePairArray.add(this.valuepairNotEqual);
                valuePairArray.add(this.valuepairGreater);
                valuePairArray.add(this.valuepairNotGreater);
                valuePairArray.add(this.valuepairLess);
                valuePairArray.add(this.valuepairNotLess);
                break;
            }
            case 11: {
                if (attrTypeModifier) {
                    valuePairArray.add(this.valuepairEqual);
                    valuePairArray.add(this.valuepairNotEqual);
                    break;
                }
                valuePairArray.add(this.valuepairEqual);
                valuePairArray.add(this.valuepairNotEqual);
                valuePairArray.add(this.valuepairGreater);
                valuePairArray.add(this.valuepairNotGreater);
                valuePairArray.add(this.valuepairLess);
                valuePairArray.add(this.valuepairNotLess);
                break;
            }
            case 3: {
                valuePairArray.add(this.valuepairEqual);
                valuePairArray.add(this.valuepairNotEqual);
                break;
            }
            case 13: {
                if (attrTypeModifier) {
                    valuePairArray.add(this.valuepairEqual);
                    valuePairArray.add(this.valuepairNotEqual);
                    break;
                }
                valuePairArray.add(this.valuepairLike);
                valuePairArray.add(this.valuepairNotLike);
                valuePairArray.add(this.valuepairEqual);
                valuePairArray.add(this.valuepairNotEqual);
                valuePairArray.add(this.valuepairGreater);
                valuePairArray.add(this.valuepairNotGreater);
                valuePairArray.add(this.valuepairLess);
                valuePairArray.add(this.valuepairNotLess);
                break;
            }
            case 5: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            default: {
                System.out.println("** Unhandled AttrType " + attType + " **");
            }
        }
        return valuePairArray;
    }

    public static AttributeControl createWhereClauseValueControl(Trace t, AttrType attrType, Composite parent) {
        AttributeControl attrControl = null;
        Object value = null;
        Integer[] intKeys = null;
        String[] stringKeys = null;
        if (Trace.isTracing) {
            t.data(67, "FilterDefinition.createWhereClauseValueControl", 300, "getting AttributeControl for AttrType: " + attrType);
        }
        switch (attrType.getAttributeType()) {
            case 3: {
                AttrTypeEnum attrTypeEnum = (AttrTypeEnum)attrType;
                intKeys = attrTypeEnum.getEnumerationIds(t);
                value = intKeys[0];
                attrControl = new EnumAttributeControl(t, parent, 0, attrType, value);
                break;
            }
            case 6: {
                value = "";
                attrControl = new TextAttributeControl(t, parent, 0, attrType, value, false);
                break;
            }
            case 9: {
                AttrTypeFixedLengthStringEnum attrTypeFixedLengthStringEnum = (AttrTypeFixedLengthStringEnum)attrType;
                stringKeys = attrTypeFixedLengthStringEnum.getEnumerationIds(t);
                value = attrTypeFixedLengthStringEnum.getEnumeratedValue(t, stringKeys[0]);
                attrControl = new EnumTextAttributeControl(t, parent, 0, attrType, value);
                break;
            }
            case 1: {
                value = "0";
                attrControl = new TextAttributeControl(t, parent, 0, attrType, value, false);
                break;
            }
            case 7: {
                value = "";
                attrControl = new TextAttributeControl(t, parent, 0, attrType, value, false);
                break;
            }
            case 26: {
                value = "";
                attrControl = new TextAttributeControl(t, parent, 0, attrType, value, false);
                break;
            }
            case 4: {
                AttrTypeRange attrTypeRange = (AttrTypeRange)attrType;
                value = attrTypeRange.getMinimumValue();
                attrControl = new RangeAttributeControl(t, parent, 0, attrType, value);
                break;
            }
            case 29: {
                AttrTypeLongRange attrTypeLongRange = (AttrTypeLongRange)attrType;
                value = attrTypeLongRange.getMinimumValue();
                attrControl = new LongNumericAttributeControl(t, parent, 0, attrType, value);
                break;
            }
            case 2: {
                value = "";
                attrControl = new TextAttributeControl(t, parent, 0, attrType, value, false);
                break;
            }
            case 8: {
                value = "";
                attrControl = new TextAttributeControl(t, parent, 0, attrType, value, false);
                break;
            }
            case 11: {
                AttrTypeEnumRange attrTypeEnumRange = (AttrTypeEnumRange)attrType;
                value = attrTypeEnumRange.getMinimumValue();
                attrControl = new EnumRangeAttributeControl(t, parent, 0, attrType, value);
                break;
            }
            case 10: {
                value = "0";
                attrControl = new NumericAttributeControl(t, parent, 0, attrType, value);
                break;
            }
            case 12: {
                value = "0";
                attrControl = new LongNumericAttributeControl(t, parent, 0, attrType, value);
                break;
            }
            case 13: {
                AttrTypeFixedLengthStringEnumRange attrTypeFixedLengthStringEnumRange = (AttrTypeFixedLengthStringEnumRange)attrType;
                stringKeys = attrTypeFixedLengthStringEnumRange.getEnumerationIds(t);
                value = attrTypeFixedLengthStringEnumRange.getEnumeratedValue(t, stringKeys[0]);
                attrControl = new EnumTextRangeAttributeControl(t, parent, 0, attrType, value);
                break;
            }
            case 5: 
            case 16: 
            case 17: 
            case 18: {
                if (!Trace.isTracing) break;
                t.data(67, "FilterDefinition.createWhereClauseValueControl", 300, "AttrType: " + attrType + "not currently supported for this AttrType");
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(67, "FilterDefinition.createWhereClauseValueControl", 900, "AttrType: " + attrType + "failed to return an AttributeControl this AttrType");
            }
        }
        return attrControl;
    }

    public static int getValueType(Trace t, AttrType attrType) {
        int valueType = 0;
        switch (attrType.getAttributeType()) {
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                valueType = 1;
                break;
            }
            default: {
                valueType = 0;
            }
        }
        return valueType;
    }
}

