/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.filters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.Date;

public class Filter
implements Comparable<Filter>,
Cloneable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/filters/Filter.java";
    public static final String MATCH_NAME_ANY = "*";
    public static final int VALUE_TYPE_STRING = 0;
    public static final int VALUE_TYPE_INT = 1;
    public static final int VALUE_UNLIMITED = -1;
    public static final int DISPOSITION_NONE = 0;
    public static final int DISPOSITION_ADDED = 1;
    public static final int DISPOSITION_DELETED = 2;
    public static final int DISPOSITION_CHANGED = 3;
    public static final int DISPOSITION_IGNORE = 4;
    public static final int DISPOSITION_DELETEDONE = 5;
    private int disposition = 0;
    private String filterId = "";
    private String filterName = "";
    private String filterUniversalId = "";
    private boolean isDefaultFilter = false;
    private boolean isNullFilter = false;
    private String nameClauseValue = null;
    private int typeValue = -1;
    private int subtypeValue = -1;
    private int whereClauseAttrId = -1;
    private int whereClauseOpId = -1;
    private Object whereClauseValue = null;
    private String whereClauseValueName = null;
    private int whereClauseValueType = -1;
    private boolean isUsingWhereClause = false;
    private PCFFilter pcfFilter = null;
    private String attrOrderName = null;
    private boolean attrOrderIsDefault = false;
    private String attrOrderUniversalId = null;
    private long dateLastSelected = 0L;
    private static Message msgFile = null;

    public Filter(Trace t, String id, String name, boolean isDefault, boolean isNull) {
        this.filterId = id;
        this.filterName = name;
        this.isDefaultFilter = isDefault;
        this.isNullFilter = isNull;
        this.nameClauseValue = MATCH_NAME_ANY;
        Date date = new Date();
        this.filterUniversalId = String.valueOf(this.filterName) + "_" + date.toString();
        msgFile = UiPlugin.getUIMessages(t, "KEY_Filters");
    }

    public Filter(Trace t, String id, String name, String uid, boolean isDefault, boolean isNull) {
        this.filterId = id;
        this.filterName = name;
        this.isDefaultFilter = isDefault;
        this.isNullFilter = isNull;
        this.nameClauseValue = MATCH_NAME_ANY;
        this.filterUniversalId = uid;
        msgFile = UiPlugin.getUIMessages(t, "KEY_Filters");
    }

    public Filter(Trace t, Filter sourceFilter) {
        Date date = new Date();
        this.filterId = sourceFilter.filterId;
        this.filterName = sourceFilter.filterName;
        this.filterUniversalId = String.valueOf(sourceFilter.filterName) + "_" + date.toString();
        this.isDefaultFilter = sourceFilter.isDefaultFilter;
        this.isNullFilter = sourceFilter.isNullFilter;
        this.nameClauseValue = sourceFilter.nameClauseValue;
        this.typeValue = sourceFilter.typeValue;
        this.subtypeValue = sourceFilter.subtypeValue;
        this.whereClauseAttrId = sourceFilter.whereClauseAttrId;
        this.whereClauseOpId = sourceFilter.whereClauseOpId;
        this.whereClauseValue = sourceFilter.whereClauseValue;
        this.whereClauseValueName = sourceFilter.whereClauseValueName;
        this.whereClauseValueType = sourceFilter.whereClauseValueType;
        this.attrOrderName = sourceFilter.attrOrderName;
        this.attrOrderIsDefault = sourceFilter.attrOrderIsDefault;
        this.attrOrderUniversalId = sourceFilter.attrOrderUniversalId;
        this.isUsingWhereClause = sourceFilter.isUsingWhereClause;
        this.pcfFilter = sourceFilter.pcfFilter;
    }

    public final Filter clone() throws CloneNotSupportedException {
        Filter filter = (Filter)super.clone();
        return filter;
    }

    public void copyValuesFrom(Trace t, Filter sourceFilter) {
        this.disposition = sourceFilter.disposition;
        this.dateLastSelected = sourceFilter.dateLastSelected;
        this.filterId = sourceFilter.filterId;
        this.filterName = sourceFilter.filterName;
        this.filterUniversalId = sourceFilter.filterUniversalId;
        this.isDefaultFilter = sourceFilter.isDefaultFilter;
        this.isNullFilter = sourceFilter.isNullFilter;
        this.nameClauseValue = sourceFilter.nameClauseValue;
        this.typeValue = sourceFilter.typeValue;
        this.subtypeValue = sourceFilter.subtypeValue;
        this.whereClauseAttrId = sourceFilter.whereClauseAttrId;
        this.whereClauseOpId = sourceFilter.whereClauseOpId;
        this.whereClauseValue = sourceFilter.whereClauseValue;
        this.whereClauseValueName = sourceFilter.whereClauseValueName;
        this.whereClauseValueType = sourceFilter.whereClauseValueType;
        this.attrOrderName = sourceFilter.attrOrderName;
        this.attrOrderIsDefault = sourceFilter.attrOrderIsDefault;
        this.attrOrderUniversalId = sourceFilter.attrOrderUniversalId;
        this.isUsingWhereClause = sourceFilter.isUsingWhereClause;
        this.pcfFilter = sourceFilter.pcfFilter;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String string) {
        this.filterName = string;
    }

    public String getFilterUniversalId() {
        return this.filterUniversalId;
    }

    @Override
    public int compareTo(Filter filter) {
        return filter.getFilterUniversalId().compareTo(this.getFilterUniversalId());
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Filter) {
            result = ((Filter)obj).getFilterUniversalId().equals(this.getFilterUniversalId());
        }
        return result;
    }

    public boolean isDefaultFilter() {
        return this.isDefaultFilter;
    }

    public void setDefaultFilter(boolean b) {
        this.isDefaultFilter = b;
    }

    public boolean isNullFilter() {
        return this.isNullFilter;
    }

    public void setNullFilter(boolean b) {
        this.isNullFilter = b;
    }

    public void resetFilterUniversalId(Trace t) {
        Date date = new Date();
        this.filterUniversalId = String.valueOf(this.filterName) + "_" + date.toString();
    }

    public String getKey(Trace t) {
        String key = this.filterUniversalId;
        if (this.isDefaultFilter()) {
            key = "com.ibm.mq.explorer.ui.internal.filter";
        }
        return key;
    }

    public String toString() {
        return this.filterName;
    }

    public void setNameAndTypeClauseValues(Trace t, String nameValue, int type, int subtype) {
        this.nameClauseValue = nameValue;
        this.typeValue = type;
        this.subtypeValue = subtype;
    }

    public void setWhereClauseValues(Trace t, int attrId, int opId, Object value, String valueName, int valueType) {
        this.whereClauseAttrId = attrId;
        this.whereClauseOpId = opId;
        this.whereClauseValue = value;
        this.whereClauseValueName = valueName;
        this.whereClauseValueType = valueType;
        boolean bl = this.isUsingWhereClause = attrId != -1 && opId != -1 && value != null && valueName != null && valueType != -1;
        if (this.isUsingWhereClause) {
            if (this.whereClauseValueType == 0) {
                String whereValue = (String)this.whereClauseValue;
                this.pcfFilter = new PCFFilter(attrId, opId, whereValue);
            } else if (this.whereClauseValueType == 1) {
                int whereValue = (Integer)this.whereClauseValue;
                this.pcfFilter = new PCFFilter(attrId, opId, whereValue);
            }
        } else {
            this.pcfFilter = null;
        }
    }

    public void resetWhereClauseValues(Trace t) {
        this.whereClauseAttrId = -1;
        this.whereClauseOpId = -1;
        this.whereClauseValue = null;
        this.whereClauseValueName = null;
        this.whereClauseValueType = -1;
        this.isUsingWhereClause = false;
        this.pcfFilter = null;
    }

    private DmObjectFilter createDmObjectFilter(Trace t) {
        DmObjectFilter dmObjectFilter = null;
        dmObjectFilter = this.isUsingWhereClause && this.pcfFilter != null ? (this.subtypeValue != -1 ? new DmObjectFilter(t, this.nameClauseValue, this.typeValue, this.subtypeValue, this.pcfFilter) : new DmObjectFilter(t, this.nameClauseValue, this.typeValue, this.pcfFilter)) : (this.subtypeValue != -1 ? new DmObjectFilter(t, this.nameClauseValue, this.typeValue, this.subtypeValue) : new DmObjectFilter(t, this.nameClauseValue, this.typeValue));
        return dmObjectFilter;
    }

    public DmObjectFilter getDmObjectFilter(Trace t) {
        return this.createDmObjectFilter(t);
    }

    public boolean isUsingSubType() {
        boolean result = this.subtypeValue > 0;
        return result;
    }

    public boolean isUsingWhere(Trace t) {
        boolean result = this.whereClauseAttrId != -1;
        return result;
    }

    public String getNameCompareValue(Trace t) {
        return this.nameClauseValue;
    }

    public int getTypeCompareValue(Trace t) {
        return this.subtypeValue;
    }

    public String getTypeCompareValueName(Trace t, FilterProvider filterProvider) {
        String typeCompValue = "";
        typeCompValue = filterProvider.getNameForSubType(t, this.subtypeValue);
        return typeCompValue;
    }

    public int getWhereAttrId(Trace t) {
        return this.whereClauseAttrId;
    }

    public String getWhereAttrName(Trace t, FilterProvider filterProvider) {
        String attrName = filterProvider.getAttributeName(t, this.getWhereAttrId(t));
        return attrName;
    }

    public int getWhereOperation(Trace t) {
        return this.whereClauseOpId;
    }

    public String getWhereOperationName(Trace t) {
        return Filter.getOperationName(t, this.whereClauseOpId, this.whereClauseValueType);
    }

    public Object getWhereValue(Trace t) {
        return this.whereClauseValue;
    }

    public String getWhereValueName(Trace t) {
        return this.whereClauseValueName;
    }

    public int getWhereValueType(Trace t) {
        return this.whereClauseValueType;
    }

    public static String getOperationName(Trace t, int op, int valueType) {
        String name = "";
        if (op != -1) {
            switch (op) {
                case 1: {
                    name = msgFile.getMessage(t, "UI.FILTERS.Less");
                    break;
                }
                case 2: {
                    if (valueType == 1) {
                        name = msgFile.getMessage(t, "UI.FILTERS.Equal");
                        break;
                    }
                    name = msgFile.getMessage(t, "UI.FILTERS.Like");
                    break;
                }
                case 3: {
                    name = msgFile.getMessage(t, "UI.FILTERS.NotGreater");
                    break;
                }
                case 4: {
                    name = msgFile.getMessage(t, "UI.FILTERS.Greater");
                    break;
                }
                case 5: {
                    name = msgFile.getMessage(t, "UI.FILTERS.NotEqual");
                    break;
                }
                case 6: {
                    name = msgFile.getMessage(t, "UI.FILTERS.NotLess");
                    break;
                }
                case 10: {
                    name = msgFile.getMessage(t, "UI.FILTERS.Contains");
                    break;
                }
                case 13: {
                    name = msgFile.getMessage(t, "UI.FILTERS.Excludes");
                    break;
                }
                case 18: {
                    name = msgFile.getMessage(t, "UI.FILTERS.Like");
                    break;
                }
                case 21: {
                    name = msgFile.getMessage(t, "UI.FILTERS.NotLike");
                    break;
                }
                case 26: {
                    name = msgFile.getMessage(t, "UI.FILTERS.Contains");
                    break;
                }
                case 29: {
                    name = msgFile.getMessage(t, "UI.FILTERS.Excludes");
                    break;
                }
                default: {
                    System.out.println("no operation name for " + op);
                }
            }
        }
        return name;
    }

    public boolean isAssociatedAttributeOrder() {
        boolean result = this.attrOrderName != null;
        return result;
    }

    public String getAttrOrderName() {
        return this.attrOrderName;
    }

    public boolean isAttrOrderDefault() {
        return this.attrOrderIsDefault;
    }

    public String getAttrOrderUniversalId() {
        return this.attrOrderUniversalId;
    }

    public void setAssociatedAttributeOrder(String name, boolean isDefault, String universalId) {
        this.attrOrderName = name;
        this.attrOrderIsDefault = isDefault;
        this.attrOrderUniversalId = universalId;
    }

    public String[] getFilterAsTextArray(Trace t, FilterProvider filterProvider) {
        String[] textArray = new String[7];
        int index = 0;
        textArray[index++] = String.valueOf(msgFile.getMessage(t, "UI.FILTERS.Dialog.Name")) + " " + msgFile.getMessage(t, "UI.FILTERS.Like") + " " + this.getNameCompareValue(t);
        if (this.isUsingSubType()) {
            textArray[index++] = "    " + msgFile.getMessage(t, "UI.FILTERS.And");
            textArray[index++] = String.valueOf(msgFile.getMessage(t, "UI.FILTERS.TypeEquals")) + " " + this.getTypeCompareValueName(t, filterProvider);
        }
        if (this.isUsingWhere(t)) {
            textArray[index++] = "    " + msgFile.getMessage(t, "UI.FILTERS.And");
            textArray[index++] = String.valueOf(this.getWhereAttrName(t, filterProvider)) + " " + this.getWhereOperationName(t) + " " + this.getWhereValueName(t);
        }
        if (this.isAssociatedAttributeOrder()) {
            textArray[index++] = "";
            textArray[index++] = Message.format((String)msgFile.getMessage(t, "UI.FILTERS.Dialog.UseColumnScheme"), (String)this.attrOrderName);
        }
        while (index < 7) {
            textArray[index++] = "";
        }
        return textArray;
    }

    public int getTypeValue() {
        return this.typeValue;
    }

    public int getSubtypeValue() {
        return this.subtypeValue;
    }

    public long getDateLastSelected() {
        return this.dateLastSelected;
    }

    public void setDateLastSelected(long date) {
        this.dateLastSelected = date;
    }

    public boolean doesObjectMatch(Trace t, UiMQObject uiMQObject) {
        boolean result = false;
        if (uiMQObject != null) {
            IDmObject dmObject = uiMQObject.getDmObject();
            String testName = this.getNameCompareValue(t);
            if (testName.compareTo(MATCH_NAME_ANY) == 0) {
                result = true;
            } else {
                testName = this.substringToFirstStar(t, testName);
                result = dmObject.getTitle().startsWith(testName);
            }
            if (result && this.isUsingSubType() && dmObject.getObjectSubType(t) != this.getSubtypeValue()) {
                result = false;
            }
            if (result && this.isUsingWhere(t)) {
                Attr attr = dmObject.getAttribute(t, this.getWhereAttrId(t), 0);
                if (attr == null) {
                    result = false;
                } else {
                    Object objValue = attr.getValue(t);
                    Object testValue = this.getWhereValue(t);
                    int testOp = this.getWhereOperation(t);
                    int attrType = attr.getAttrType().getAttributeType();
                    block0 : switch (attrType) {
                        case 1: 
                        case 3: 
                        case 4: {
                            if (testValue == null || objValue == null) break;
                            int intTestValue = (Integer)testValue;
                            int intObjValue = (Integer)objValue;
                            switch (testOp) {
                                case 2: {
                                    result = intObjValue == intTestValue;
                                    break;
                                }
                                case 5: {
                                    result = intObjValue != intTestValue;
                                    break;
                                }
                                case 4: {
                                    result = intObjValue > intTestValue;
                                    break;
                                }
                                case 3: {
                                    result = intObjValue <= intTestValue;
                                    break;
                                }
                                case 1: {
                                    result = intObjValue < intTestValue;
                                    break;
                                }
                                case 6: {
                                    result = intObjValue >= intTestValue;
                                }
                            }
                            break;
                        }
                        case 11: {
                            if (testValue == null || objValue == null) break;
                            int intTestValue = (Integer)testValue;
                            int intObjValue = (Integer)objValue;
                            if (intTestValue == -1) {
                                intTestValue = Integer.MAX_VALUE;
                            }
                            if (intObjValue == -1) {
                                intObjValue = Integer.MAX_VALUE;
                            }
                            switch (testOp) {
                                case 2: {
                                    result = intObjValue == intTestValue;
                                    break;
                                }
                                case 5: {
                                    result = intObjValue != intTestValue;
                                    break;
                                }
                                case 4: {
                                    result = intObjValue > intTestValue;
                                    break;
                                }
                                case 3: {
                                    result = intObjValue <= intTestValue;
                                    break;
                                }
                                case 1: {
                                    result = intObjValue < intTestValue;
                                    break;
                                }
                                case 6: {
                                    result = intObjValue >= intTestValue;
                                }
                            }
                            break;
                        }
                        case 12: 
                        case 27: 
                        case 29: {
                            if (testValue == null || objValue == null) break;
                            long longTestValue = (Long)testValue;
                            long longObjValue = (Long)objValue;
                            switch (testOp) {
                                case 2: {
                                    result = longObjValue == longTestValue;
                                    break;
                                }
                                case 5: {
                                    result = longObjValue != longTestValue;
                                    break;
                                }
                                case 4: {
                                    result = longObjValue > longTestValue;
                                    break;
                                }
                                case 3: {
                                    result = longObjValue <= longTestValue;
                                    break;
                                }
                                case 1: {
                                    result = longObjValue < longTestValue;
                                    break;
                                }
                                case 6: {
                                    result = longObjValue >= longTestValue;
                                }
                            }
                            break;
                        }
                        case 28: {
                            if (testValue == null || objValue == null) break;
                            long longTestValue = (Long)testValue;
                            long longObjValue = (Long)objValue;
                            if (longTestValue == -1L) {
                                longTestValue = Long.MAX_VALUE;
                            }
                            if (longObjValue == -1L) {
                                longObjValue = Long.MAX_VALUE;
                            }
                            switch (testOp) {
                                case 2: {
                                    result = longObjValue == longTestValue;
                                    break;
                                }
                                case 5: {
                                    result = longObjValue != longTestValue;
                                    break;
                                }
                                case 4: {
                                    result = longObjValue > longTestValue;
                                    break;
                                }
                                case 3: {
                                    result = longObjValue <= longTestValue;
                                    break;
                                }
                                case 1: {
                                    result = longObjValue < longTestValue;
                                    break;
                                }
                                case 6: {
                                    result = longObjValue >= longTestValue;
                                }
                            }
                            break;
                        }
                        case 2: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 26: {
                            String strTestValue = (String)testValue;
                            String strObjValue = (String)objValue;
                            switch (testOp) {
                                case 18: {
                                    strTestValue = this.substringToFirstStar(t, strTestValue);
                                    result = strObjValue != null && strObjValue.startsWith(strTestValue);
                                    break block0;
                                }
                                case 21: {
                                    strTestValue = this.substringToFirstStar(t, strTestValue);
                                    result = strObjValue != null && !strObjValue.startsWith(strTestValue);
                                    break block0;
                                }
                                case 2: {
                                    result = strObjValue != null && strObjValue.equals(strTestValue);
                                    break block0;
                                }
                                case 5: {
                                    result = strObjValue != null && !strObjValue.equals(strTestValue);
                                    break block0;
                                }
                                case 4: {
                                    result = strObjValue != null && strObjValue.compareTo(strTestValue) > 0;
                                    break block0;
                                }
                                case 3: {
                                    result = strObjValue != null && strObjValue.compareTo(strTestValue) <= 0;
                                    break block0;
                                }
                                case 1: {
                                    result = strObjValue != null && strObjValue.compareTo(strTestValue) < 0;
                                    break block0;
                                }
                                case 6: {
                                    result = strObjValue != null && strObjValue.compareTo(strTestValue) >= 0;
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private String substringToFirstStar(Trace t, String inputString) {
        String outputString = new String(inputString);
        int pos = outputString.indexOf(42);
        if (pos != -1) {
            outputString = outputString.substring(0, pos);
        }
        return outputString;
    }

    public int getDisposition() {
        return this.disposition;
    }

    public void setDisposition(int dispos) {
        this.disposition = dispos;
    }
}

