/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.filters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeWMQName;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.filters.CompareAttrTypeDisplayTitles;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterDefinition;
import com.ibm.mq.explorer.ui.internal.filters.FilterManager;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.filters.SelectAttributeDialog;
import com.ibm.mq.explorer.ui.internal.filters.ValuePair;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.EnumRangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditFilterDialog
extends ExtDialog
implements IAttributeModifiedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/filters/EditFilterDialog.java";
    private static final int CONTROL_WIDTH_HINT = 120;
    private static final int INDENT_FOR_CONTROLS = 20;
    private static final char CHAR_QUOTE = '\'';
    private static final char CHAR_L_BRACKET = '(';
    private static final char CHAR_R_BRACKET = ')';
    private static final char CHAR_ASTERIX = '*';
    private static final String MATCH_VALID_MQ_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789%/._'()*";
    private static final int NUM_COLS = 6;
    private Composite compMsg = null;
    private Label labelIcon = null;
    private Label labelMsg = null;
    private Message msgFile = null;
    private Filter editFilter = null;
    private boolean isEditName = false;
    private String originalName = null;
    private boolean isAddOp = false;
    private ArrayList allFilters = null;
    private Label labelFilterName = null;
    private Text textFilterName = null;
    private Text labelNameAttr = null;
    private GridData gridDataNameAttr = null;
    private Text labelNameOp = null;
    private GridData gridDataNameOp = null;
    private Composite compositeNameValue = null;
    private Text textNameValue = null;
    private GridData gridDataNameValue = null;
    private Text labelTypeAnd = null;
    private Text labelTypeAttr = null;
    private GridData gridDataTypeAttr = null;
    private Text labelTypeOp = null;
    private GridData gridDataTypeOp = null;
    private ExtCombo comboTypeEnum = null;
    private GridData gridDataTypeEnum = null;
    private Button buttonClear = null;
    private GridData gridDataClear = null;
    private Button checkboxAnd = null;
    private boolean isUsingWhereClause = false;
    private Composite compositeWhereAttr = null;
    private GridData gridDataWhereAttr = null;
    private Text textWhereAttr = null;
    private Button buttonWhereAttrSel = null;
    private Composite compositeWhereOp = null;
    private GridData gridDataWhereOp = null;
    private ExtCombo comboWhereOp = null;
    private Composite compositeWhereValue = null;
    private GridData gridDataWhereValue = null;
    private StackLayout compositeWhereValueStackLayout = null;
    private Label labelWhereValueUnused = null;
    private Button checkboxApplyScheme = null;
    private ExtCombo comboScheme = null;
    private ArrayList attrOrders = null;
    private FilterProvider filterProvider = null;
    private int[] whereClauseAttrIds = null;
    private Hashtable<Integer, AttrType> whereClauseAttrTypeTable = null;
    private Hashtable<AttrType, Integer> whereClauseAttrIdTable = null;
    private Hashtable<Integer, AttributeControl> whereClauseAttrValueControlTable = null;
    private AttrType whereClauseAttrType = null;
    private int whereClauseOp = -1;
    private Object whereClauseValue = null;
    private FilterDefinition filterDefinition = null;
    private Point preferredSize = null;
    private boolean isManagerSaveOnOKMode = false;
    private FilterManager filterManager = null;
    private String filterId = null;
    private Pattern regularExpression = null;
    private int maxLength = -1;
    private boolean isMQCharSet = false;

    public EditFilterDialog(Trace t, Shell parent, int style) {
        super(parent, style);
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Filters");
        this.filterDefinition = UiPlugin.getFilterManager().getFilterDefinition();
    }

    public void setValues(Trace t, Filter filter, boolean editName, boolean isAdd, ArrayList allFilts, FilterProvider filterProv) {
        AttrType attrType;
        this.editFilter = filter;
        this.isEditName = editName;
        this.isAddOp = isAdd;
        this.allFilters = allFilts;
        this.filterProvider = filterProv;
        this.originalName = new String(filter.getFilterName());
        if (this.filterProvider.isUseWhereClauseToFilter(t)) {
            this.whereClauseAttrIds = this.filterProvider.getWhereClauseAttributeIds(t);
        }
        if ((attrType = this.filterProvider.getAttrTypeForAttributeId(t, this.filterProvider.getNameClauseAttributeId(t))) != null) {
            if (attrType instanceof AttrTypeString) {
                this.regularExpression = ((AttrTypeString)attrType).getRegularExpression();
            }
            if (attrType instanceof AttrTypeFixedLengthString) {
                this.maxLength = ((AttrTypeFixedLengthString)attrType).getLength();
            }
            if (attrType instanceof AttrTypeWMQName) {
                this.isMQCharSet = true;
            }
        }
    }

    private ValuePair getWhereClauseOpValuePair(Trace t) {
        this.whereClauseOp = this.editFilter.getWhereOperation(t);
        int whereClauseValueType = this.editFilter.getWhereValueType(t);
        ValuePair whereClauseOpValuePair = this.filterDefinition.getWhereClauseOpValuePair(t, this.whereClauseOp, whereClauseValueType);
        return whereClauseOpValuePair;
    }

    private void createAttrTypeTables(Trace t) {
        this.whereClauseAttrTypeTable = new Hashtable();
        this.whereClauseAttrIdTable = new Hashtable();
        this.whereClauseAttrValueControlTable = new Hashtable();
        int i = 0;
        while (i < this.whereClauseAttrIds.length) {
            if (this.whereClauseAttrIds[i] != 63) {
                Integer intAttrId = this.whereClauseAttrIds[i];
                AttrType attrType = this.filterProvider.getAttrTypeForAttributeId(t, this.whereClauseAttrIds[i]);
                AttributeControl attrCtrl = FilterDefinition.createWhereClauseValueControl(t, attrType, this.compositeWhereValue);
                if (attrCtrl != null) {
                    attrCtrl.addModifyListener(this, 0);
                    this.whereClauseAttrTypeTable.put(intAttrId, attrType);
                    this.whereClauseAttrIdTable.put(attrType, intAttrId);
                    this.whereClauseAttrValueControlTable.put(intAttrId, attrCtrl);
                }
            }
            ++i;
        }
    }

    private void resizeControls(Trace t) {
        int maxHeight = 0;
        Point sizeAttr = this.labelNameAttr.computeSize(-1, -1);
        Point sizeOp = this.labelNameOp.computeSize(-1, -1);
        Point sizeValue = this.textNameValue.computeSize(-1, -1);
        if (sizeAttr.y > maxHeight) {
            maxHeight = sizeAttr.y;
        }
        if (sizeOp.y > maxHeight) {
            maxHeight = sizeOp.y;
        }
        if (sizeValue.y > maxHeight) {
            maxHeight = sizeValue.y;
        }
        this.gridDataNameAttr.heightHint = maxHeight;
        this.gridDataNameOp.heightHint = maxHeight;
        this.gridDataNameValue.heightHint = maxHeight;
        if (this.filterProvider.isUseSubTypesToFilter(t)) {
            maxHeight = 0;
            sizeAttr = this.labelTypeAttr.computeSize(-1, -1);
            sizeOp = this.labelTypeOp.computeSize(-1, -1);
            sizeValue = this.comboTypeEnum.computeSize(-1, -1);
            if (sizeAttr.y > maxHeight) {
                maxHeight = sizeAttr.y;
            }
            if (sizeOp.y > maxHeight) {
                maxHeight = sizeOp.y;
            }
            if (sizeValue.y > maxHeight) {
                maxHeight = sizeValue.y;
            }
            this.gridDataTypeAttr.heightHint = maxHeight;
            this.gridDataTypeOp.heightHint = maxHeight;
            this.gridDataTypeEnum.heightHint = maxHeight;
        }
        if (this.filterProvider.isUseWhereClauseToFilter(t)) {
            maxHeight = 0;
            sizeAttr = this.compositeWhereAttr.computeSize(-1, -1);
            sizeOp = this.comboWhereOp.computeSize(-1, -1);
            sizeValue = this.compositeWhereValue.computeSize(-1, -1);
            if (sizeAttr.y > maxHeight) {
                maxHeight = sizeAttr.y;
            }
            if (sizeOp.y > maxHeight) {
                maxHeight = sizeOp.y;
            }
            if (sizeValue.y > maxHeight) {
                maxHeight = sizeValue.y;
            }
            this.gridDataWhereAttr.heightHint = maxHeight;
            this.gridDataWhereOp.heightHint = maxHeight;
            this.gridDataWhereValue.heightHint = maxHeight;
        }
    }

    private void addNameClauseControls(Trace t, Composite composite) {
        Composite compositeNameControls = new Composite(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.horizontalIndent = 20;
        compositeNameControls.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = true;
        compositeNameControls.setLayout((Layout)gridLayout);
        this.labelNameAttr = new Text(compositeNameControls, 2048);
        String text = this.filterProvider.getAttributeName(t, this.filterProvider.getNameClauseAttributeId(t));
        this.labelNameAttr.setText(text);
        UiUtils.makeTextControlReadOnly(t, this.labelNameAttr, true);
        this.gridDataNameAttr = new GridData(768);
        this.gridDataNameAttr.horizontalSpan = 2;
        this.gridDataNameAttr.widthHint = 120;
        this.labelNameAttr.setLayoutData((Object)this.gridDataNameAttr);
        this.labelNameOp = new Text(compositeNameControls, 2048);
        this.labelNameOp.setText(this.msgFile.getMessage(t, "UI.FILTERS.Like"));
        UiUtils.makeTextControlReadOnly(t, this.labelNameOp, true);
        this.gridDataNameOp = new GridData(768);
        this.gridDataNameOp.horizontalSpan = 2;
        this.gridDataNameOp.widthHint = 120;
        this.labelNameOp.setLayoutData((Object)this.gridDataNameOp);
        this.compositeNameValue = new Composite(compositeNameControls, 0);
        this.gridDataNameValue = new GridData(768);
        this.gridDataNameValue.horizontalSpan = 2;
        this.gridDataNameValue.widthHint = 120;
        this.compositeNameValue.setLayoutData((Object)this.gridDataNameValue);
        FillLayout fillLayout = new FillLayout();
        this.compositeNameValue.setLayout((Layout)fillLayout);
        this.textNameValue = new Text(this.compositeNameValue, 2048);
        this.textNameValue.setText(this.editFilter.getNameCompareValue(t));
        this.textNameValue.setEditable(true);
        if (this.maxLength > 0) {
            this.textNameValue.setTextLimit(this.maxLength);
        }
        if (!this.isEditName) {
            this.textNameValue.setFocus();
        }
        this.textNameValue.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Trace tr = Trace.getDefault();
                StringValidation.verifyPCFFilterStringValue(tr, e);
            }
        });
        this.textNameValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                EditFilterDialog.this.checkIfEnableOK(tr);
            }
        });
    }

    private void addTypeClauseControls(Trace t, Composite composite) {
        UiUtils.createBlankLine(composite, 6);
        UiUtils.createBlankLine(composite, 6);
        this.labelTypeAnd = new Text(composite, 0);
        this.labelTypeAnd.setText("- " + this.msgFile.getMessage(t, "UI.FILTERS.And") + " -");
        UiUtils.makeTextControlReadOnly(t, this.labelTypeAnd, true);
        this.labelTypeAnd.setVisible(true);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.labelTypeAnd.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        Composite compositeTypeControls = new Composite(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.horizontalIndent = 20;
        compositeTypeControls.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = true;
        compositeTypeControls.setLayout((Layout)gridLayout);
        this.labelTypeAttr = new Text(compositeTypeControls, 2048);
        String text = this.filterProvider.getAttributeName(t, this.filterProvider.getTypeClauseAttributeId(t));
        this.labelTypeAttr.setText(text);
        UiUtils.makeTextControlReadOnly(t, this.labelTypeAttr, true);
        this.gridDataTypeAttr = new GridData(768);
        this.gridDataTypeAttr.horizontalSpan = 2;
        this.gridDataTypeAttr.widthHint = 120;
        this.labelTypeAttr.setLayoutData((Object)this.gridDataTypeAttr);
        this.labelTypeOp = new Text(compositeTypeControls, 2048);
        this.labelTypeOp.setText(Filter.getOperationName(t, 2, 1));
        UiUtils.makeTextControlReadOnly(t, this.labelTypeOp, true);
        this.gridDataTypeOp = new GridData(768);
        this.gridDataTypeOp.horizontalSpan = 2;
        this.gridDataTypeOp.widthHint = 120;
        this.labelTypeOp.setLayoutData((Object)this.gridDataTypeOp);
        this.comboTypeEnum = new ExtCombo(compositeTypeControls, 2060);
        int[] subTypes = this.filterProvider.getDataModelObjectSubTypes(t);
        int allSubType = this.filterProvider.getDataModelObjectAllSubType(t);
        boolean allAdded = false;
        int selIndex = -1;
        int i = 0;
        while (i < subTypes.length) {
            ValuePair valuePair = new ValuePair(subTypes[i], this.filterProvider.getNameForSubType(t, subTypes[i]));
            this.comboTypeEnum.add(valuePair);
            if (subTypes[i] == allSubType) {
                allAdded = true;
            }
            if (subTypes[i] == this.editFilter.getTypeCompareValue(t)) {
                selIndex = i;
            }
            ++i;
        }
        if (!allAdded) {
            ValuePair valuePair = new ValuePair(allSubType, this.filterProvider.getNameForSubType(t, allSubType));
            this.comboTypeEnum.add(valuePair);
            if (allSubType == this.editFilter.getTypeCompareValue(t) || selIndex == -1) {
                selIndex = subTypes.length;
            }
        }
        if (selIndex == -1) {
            selIndex = 0;
        }
        this.comboTypeEnum.select(selIndex);
        this.gridDataTypeEnum = new GridData(768);
        this.gridDataTypeEnum.horizontalSpan = 2;
        this.gridDataTypeEnum.widthHint = 120;
        this.comboTypeEnum.setLayoutData(this.gridDataTypeEnum);
    }

    private void addWhereClauseControls(Trace t, Composite composite) {
        this.isUsingWhereClause = this.editFilter.isUsingWhere(t);
        UiUtils.createBlankLine(composite, 6);
        UiUtils.createBlankLine(composite, 6);
        this.checkboxAnd = new Button(composite, 32);
        this.checkboxAnd.setText("- " + this.msgFile.getMessage(t, "UI.FILTERS.And") + " -");
        this.checkboxAnd.setVisible(true);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.checkboxAnd.setLayoutData((Object)gridData);
        this.checkboxAnd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditFilterDialog.this.andSelectionChanged(tr);
            }
        });
        Label label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        Composite compositeWhereControls = new Composite(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.horizontalIndent = 20;
        compositeWhereControls.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = true;
        compositeWhereControls.setLayout((Layout)gridLayout);
        this.compositeWhereAttr = new Composite(compositeWhereControls, 0);
        this.gridDataWhereAttr = new GridData(768);
        this.gridDataWhereAttr.horizontalSpan = 2;
        this.gridDataWhereAttr.verticalAlignment = 1;
        this.compositeWhereAttr.setLayoutData((Object)this.gridDataWhereAttr);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeWhereAttr.setLayout((Layout)gridLayout);
        boolean isMultipleWhereClauseAttrs = this.whereClauseAttrIds.length > 1;
        this.textWhereAttr = new Text(this.compositeWhereAttr, 2048);
        UiUtils.makeTextControlReadOnly(t, this.textWhereAttr, true);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = isMultipleWhereClauseAttrs ? 1 : 2;
        this.textWhereAttr.setLayoutData((Object)gridData);
        if (isMultipleWhereClauseAttrs) {
            this.buttonWhereAttrSel = new Button(this.compositeWhereAttr, 8);
            this.buttonWhereAttrSel.setText(this.msgFile.getMessage(t, "UI.FILTERS.Button.ShowAttributes"));
            gridData = new GridData();
            gridData.grabExcessVerticalSpace = true;
            this.buttonWhereAttrSel.setLayoutData((Object)gridData);
            this.buttonWhereAttrSel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    EditFilterDialog.this.selectWhereAttr(tr);
                }
            });
        }
        this.compositeWhereOp = new Composite(compositeWhereControls, 0);
        this.gridDataWhereOp = new GridData(768);
        this.gridDataWhereOp.horizontalSpan = 2;
        this.gridDataWhereOp.verticalAlignment = 1;
        this.compositeWhereOp.setLayoutData((Object)this.gridDataWhereOp);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeWhereOp.setLayout((Layout)gridLayout);
        this.comboWhereOp = new ExtCombo(this.compositeWhereOp, 2060);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.comboWhereOp.setLayoutData(gridData);
        this.comboWhereOp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditFilterDialog.this.comboWhereOpSelectionChanged(tr);
            }
        });
        this.compositeWhereValue = new Composite(compositeWhereControls, 0);
        this.gridDataWhereValue = new GridData(768);
        this.gridDataWhereValue.horizontalSpan = 2;
        this.gridDataWhereValue.verticalAlignment = 1;
        this.compositeWhereValue.setLayoutData((Object)this.gridDataWhereValue);
        this.compositeWhereValueStackLayout = new StackLayout();
        this.compositeWhereValue.setLayout((Layout)this.compositeWhereValueStackLayout);
        this.labelWhereValueUnused = new Label(this.compositeWhereValue, 2048);
        this.compositeWhereValueStackLayout.topControl = this.labelWhereValueUnused;
        this.createAttrTypeTables(t);
        if (this.editFilter.isUsingWhere(t)) {
            this.checkboxAnd.setSelection(true);
            int attrId = this.editFilter.getWhereAttrId(t);
            AttrType attrType = this.whereClauseAttrTypeTable.get(attrId);
            if (attrType != null) {
                this.whereClauseAttrType = attrType;
                this.whereClauseAttributeChanged(t);
                ValuePair whereClauseOpValuePair = this.getWhereClauseOpValuePair(t);
                int selIndex = this.comboWhereOp.indexOfObject(whereClauseOpValuePair);
                if (selIndex == -1) {
                    selIndex = 0;
                }
                this.comboWhereOp.select(selIndex);
                Object value = this.editFilter.getWhereValue(t);
                if (value != null) {
                    AttributeControl attrCtrl = (AttributeControl)this.compositeWhereValueStackLayout.topControl;
                    attrCtrl.setValue(t, value);
                }
            }
        } else {
            this.checkboxAnd.setSelection(false);
        }
        this.andSelectionChanged(t);
    }

    private void addAttributeOrderControls(Trace t, Composite composite) {
        Label label = new Label(composite, 0);
        label.setVisible(false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        this.checkboxApplyScheme = new Button(composite, 32);
        this.checkboxApplyScheme.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.ApplyColumnScheme"));
        this.checkboxApplyScheme.setSelection(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        this.checkboxApplyScheme.setLayoutData((Object)gridData);
        this.checkboxApplyScheme.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditFilterDialog.this.applySchemeSelectionChanged(tr);
            }
        });
        Composite compAttrOrderControls = new Composite(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.horizontalIndent = 20;
        compAttrOrderControls.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = true;
        compAttrOrderControls.setLayout((Layout)gridLayout);
        this.comboScheme = new ExtCombo(compAttrOrderControls, 2060);
        this.populateComboScheme(t);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 6;
        this.comboScheme.setLayoutData(gridData);
        UiUtils.createBlankLine(composite, 6);
    }

    protected void checkIfEnableOK(Trace t) {
        this.enableOK(t, this.isEnableOK(t));
    }

    public void whereClauseAttributeChanged(Trace t) {
        this.textWhereAttr.setText(this.whereClauseAttrType.getDisplayTitle());
        this.comboWhereOp.removeAll();
        ArrayList array = this.filterDefinition.getWhereClauseOperationValuePairArray(t, this.whereClauseAttrType);
        int i = 0;
        while (i < array.size()) {
            ValuePair valuePair = (ValuePair)array.get(i);
            this.comboWhereOp.add(valuePair);
            ++i;
        }
        this.comboWhereOp.select(0);
        Integer intAttrId = this.whereClauseAttrIdTable.get(this.whereClauseAttrType);
        AttributeControl attrCtrl = null;
        this.compositeWhereValueStackLayout.topControl = intAttrId != null ? ((attrCtrl = this.whereClauseAttrValueControlTable.get(intAttrId)) != null ? attrCtrl : this.labelWhereValueUnused) : this.labelWhereValueUnused;
        this.compositeWhereValue.layout();
        this.getShell().layout();
        this.whereClauseValue = attrCtrl == null ? null : attrCtrl.getValue(t);
        this.comboWhereOpSelectionChanged(t);
        this.checkIfEnableOK(t);
    }

    public void whereClauseValueChanged(Trace t) {
        this.whereClauseValueChanged(t, null);
    }

    public void whereClauseValueChanged(Trace t, AttributeModifiedEvent event) {
        Object valueControl = null;
        valueControl = event != null ? event.getSource() : this.compositeWhereValueStackLayout.topControl;
        int selIndex = this.comboWhereOp.getSelectionIndex();
        ValuePair whereClauseOpValuePair = null;
        whereClauseOpValuePair = selIndex >= 0 ? (ValuePair)this.comboWhereOp.getObject(selIndex) : this.getWhereClauseOpValuePair(t);
        if (valueControl != null && valueControl instanceof EnumRangeAttributeControl) {
            EnumRangeAttributeControl control = (EnumRangeAttributeControl)((Object)valueControl);
            this.comboWhereOp.removeAll();
            ArrayList array = this.filterDefinition.getWhereClauseOperationValuePairArray(t, this.whereClauseAttrType, control.isPredefined(t));
            int i = 0;
            while (i < array.size()) {
                ValuePair valuePair = (ValuePair)array.get(i);
                this.comboWhereOp.add(valuePair);
                ++i;
            }
            selIndex = this.comboWhereOp.indexOfObject(whereClauseOpValuePair);
            if (selIndex >= 0) {
                this.comboWhereOp.select(selIndex);
            } else {
                this.comboWhereOp.select(0);
            }
        }
    }

    protected void andSelectionChanged(Trace t) {
        Collection<AttrType> values;
        int size;
        this.isUsingWhereClause = this.checkboxAnd.getSelection();
        this.enableWhereClauseControls(t, this.isUsingWhereClause);
        if (this.whereClauseAttrType == null && (size = (values = this.whereClauseAttrTypeTable.values()).size()) > 0) {
            AttrType[] attrTypes = values.toArray(new AttrType[size]);
            CompareAttrTypeDisplayTitles compareAttrTypeNames = new CompareAttrTypeDisplayTitles();
            Arrays.sort(attrTypes, compareAttrTypeNames);
            this.whereClauseAttrType = attrTypes[0];
            this.whereClauseAttributeChanged(t);
        }
        this.checkIfEnableOK(t);
    }

    private void enableWhereClauseControls(Trace t, boolean isEnable) {
        this.compositeWhereAttr.setEnabled(isEnable);
        this.textWhereAttr.setEnabled(isEnable);
        if (this.buttonWhereAttrSel != null) {
            this.buttonWhereAttrSel.setEnabled(isEnable);
        }
        this.comboWhereOp.setEnabled(isEnable);
        this.compositeWhereValue.setEnabled(isEnable);
        Enumeration<AttributeControl> elements = this.whereClauseAttrValueControlTable.elements();
        while (elements.hasMoreElements()) {
            AttributeControl attrCtrl = elements.nextElement();
            attrCtrl.setEnabled(isEnable);
        }
    }

    protected void applySchemeSelectionChanged(Trace t) {
        boolean isApplyScheme = this.checkboxApplyScheme.getSelection();
        this.comboScheme.setEnabled(isApplyScheme);
    }

    private void populateComboScheme(Trace t) {
        AttributeOrderManager attrOrderManager = UiPlugin.getAttributeOrderManager();
        this.attrOrders = attrOrderManager.getUserDefinedOrders(t, this.filterProvider.getAttributeOrderId());
        int i = 0;
        while (i < this.attrOrders.size()) {
            AttributeOrder attrOrder = (AttributeOrder)this.attrOrders.get(i);
            this.comboScheme.add(attrOrder.getOrderName(t));
            ++i;
        }
        this.comboScheme.sort();
        boolean attrOrderSelected = false;
        String attrOrderUID = this.editFilter.getAttrOrderUniversalId();
        if (attrOrderUID != null) {
            this.checkboxApplyScheme.setSelection(true);
            int i2 = 0;
            while (i2 < this.attrOrders.size()) {
                AttributeOrder attrOrder = (AttributeOrder)this.attrOrders.get(i2);
                if (attrOrder.getOrderUniversalId().compareTo(attrOrderUID) == 0) {
                    this.comboScheme.select(this.comboScheme.indexOf(attrOrder.getOrderName(t)));
                    attrOrderSelected = true;
                    break;
                }
                ++i2;
            }
        } else {
            this.checkboxApplyScheme.setSelection(false);
        }
        if (!attrOrderSelected && this.comboScheme.getItemCount() > 0) {
            this.comboScheme.select(0);
        }
        this.applySchemeSelectionChanged(t);
    }

    protected void clearFilter(Trace t) {
        this.textNameValue.setText("*");
        if (this.filterProvider.isUseSubTypesToFilter(t)) {
            int i = 0;
            while (i < this.comboTypeEnum.getItemCount()) {
                ValuePair valuePair = (ValuePair)this.comboTypeEnum.getObject(i);
                if (valuePair.getValue() == this.filterProvider.getDataModelObjectAllSubType(t)) {
                    this.comboTypeEnum.select(i);
                    break;
                }
                ++i;
            }
        }
        if (this.filterProvider.isUseWhereClauseToFilter(t)) {
            this.checkboxAnd.setSelection(false);
            this.andSelectionChanged(t);
        }
        this.checkboxApplyScheme.setSelection(false);
        this.applySchemeSelectionChanged(t);
    }

    private void updateFilterWithSelections(Trace t) {
        this.editFilter.setFilterName(this.textFilterName.getText());
        String nameMatchValue = this.textNameValue.getText();
        int type = this.filterProvider.getDataModelObjectType(t);
        if (this.filterProvider.isUseSubTypesToFilter(t)) {
            ValuePair subType = (ValuePair)this.comboTypeEnum.getObject(this.comboTypeEnum.getSelectionIndex());
            this.editFilter.setNameAndTypeClauseValues(t, nameMatchValue, type, subType.getValue());
        } else {
            this.editFilter.setNameAndTypeClauseValues(t, nameMatchValue, type, -1);
        }
        if (this.filterProvider.isUseWhereClauseToFilter(t) && this.isUsingWhereClause) {
            Object value;
            Integer intAttrId = this.whereClauseAttrIdTable.get(this.whereClauseAttrType);
            ValuePair opValuePair = (ValuePair)this.comboWhereOp.getObject(this.comboWhereOp.getSelectionIndex());
            AttributeControl attrCtrl = (AttributeControl)this.compositeWhereValueStackLayout.topControl;
            int valueType = FilterDefinition.getValueType(t, this.whereClauseAttrType);
            Object setValue = value = attrCtrl.getValue(t);
            if (valueType == 1 && value instanceof String) {
                try {
                    String strValue = (String)value;
                    setValue = Integer.valueOf(strValue);
                }
                catch (NumberFormatException numberFormatException) {
                    setValue = 0;
                }
            } else if (valueType == 0 && value instanceof Integer) {
                setValue = value.toString();
            }
            this.editFilter.setWhereClauseValues(t, intAttrId, opValuePair.getValue(), setValue, attrCtrl.toString(), valueType);
        } else {
            this.editFilter.resetWhereClauseValues(t);
        }
        AttributeOrder selAttrOrder = null;
        if (this.checkboxApplyScheme.getSelection()) {
            int index = this.comboScheme.getSelectionIndex();
            String attrOrderName = this.comboScheme.getObject(index).toString();
            int i = 0;
            while (i < this.attrOrders.size()) {
                AttributeOrder attrOrder = (AttributeOrder)this.attrOrders.get(i);
                if (attrOrder.getOrderName(t).compareTo(attrOrderName) == 0) {
                    selAttrOrder = attrOrder;
                    break;
                }
                ++i;
            }
        }
        if (this.checkboxApplyScheme.getSelection() && selAttrOrder != null) {
            this.editFilter.setAssociatedAttributeOrder(selAttrOrder.getOrderName(t), selAttrOrder.isDefaultOrder(), selAttrOrder.getOrderUniversalId());
        } else {
            this.editFilter.setAssociatedAttributeOrder(null, false, null);
        }
    }

    protected void selectWhereAttr(Trace t) {
        SelectAttributeDialog selectAttrDlg = new SelectAttributeDialog(this.getShell(), 0);
        selectAttrDlg.setValues(t, this.whereClauseAttrTypeTable, this.whereClauseAttrType);
        selectAttrDlg.create(t);
        if (selectAttrDlg.open(t)) {
            this.whereClauseAttrType = selectAttrDlg.getSelectedAttrType();
            if (this.whereClauseAttrType != null) {
                this.whereClauseAttributeChanged(t);
            }
        }
    }

    @Override
    public void attrModified(AttributeModifiedEvent event) {
        Trace t = Trace.getDefault();
        Object newValue = event.getNewValue();
        if (newValue != null && !newValue.equals(this.whereClauseValue)) {
            this.whereClauseValueChanged(t, event);
        }
        this.whereClauseValue = event.getNewValue();
        this.checkIfEnableOK(t);
    }

    protected void comboWhereOpSelectionChanged(Trace t) {
        ValuePair opValuePair = (ValuePair)this.comboWhereOp.getObject(this.comboWhereOp.getSelectionIndex());
        this.whereClauseOp = opValuePair.getValue();
        int selIndex = this.comboWhereOp.getSelectionIndex();
        ValuePair whereClauseOpValuePair = (ValuePair)this.comboWhereOp.getObject(selIndex);
        AttributeControl attrCtrl = (AttributeControl)this.compositeWhereValueStackLayout.topControl;
        Integer data = (Integer)whereClauseOpValuePair.getUserData();
        if (data == FilterDefinition.SUPPORTS_WILDCARD) {
            attrCtrl.setAdditionalValidCharacters(t, "'*");
        } else {
            attrCtrl.setAdditionalValidCharacters(t, "");
        }
        this.checkIfEnableOK(t);
    }

    @Override
    public String getTitle(Trace t) {
        String title = this.isAddOp ? this.msgFile.getMessage(t, "UI.FILTERS.Dialog.AddFilterTitle") : this.msgFile.getMessage(t, "UI.FILTERS.Dialog.EditFilterTitle");
        return title;
    }

    @Override
    public Image getImage(Trace t) {
        return Icons.get(Icons.iconkeyExplorerSmall);
    }

    @Override
    public String getHelpId(Trace t) {
        String helpId = this.isAddOp ? "com.ibm.mq.explorer.ui.infopop.UI_FilterAddDialog" : "com.ibm.mq.explorer.ui.infopop.UI_FilterEditDialog";
        return helpId;
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return false;
    }

    @Override
    public void packDialog(Trace t) {
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        this.compMsg = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.compMsg.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        this.compMsg.setLayoutData((Object)gridData);
        this.labelIcon = new Label(this.compMsg, 1);
        this.labelIcon.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.labelIcon.setLayoutData((Object)gridData);
        this.labelMsg = new Label(this.compMsg, 0);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.labelMsg.setLayoutData((Object)gridData);
        this.labelFilterName = new Label(composite, 0);
        this.labelFilterName.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.FilterName"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.labelFilterName.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.textFilterName = new Text(composite, 2048);
        this.textFilterName.setText(this.editFilter.getFilterName());
        if (!this.isEditName) {
            UiUtils.makeTextControlReadOnly(t, this.textFilterName, true);
        }
        this.textFilterName.setTextLimit(48);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.horizontalIndent = 20;
        gridData.grabExcessHorizontalSpace = true;
        this.textFilterName.setLayoutData((Object)gridData);
        this.textFilterName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                EditFilterDialog.this.checkIfEnableOK(tr);
            }
        });
        UiUtils.createBlankLine(composite, 6);
        UiUtils.createBlankLine(composite, 6);
        Group groupFilterEdit = new Group(composite, 0);
        groupFilterEdit.setText(Message.format((String)this.msgFile.getMessage(t, "UI.FILTERS.Dialog.IncludeObjects"), (String)this.filterProvider.getGenericObjectName(t)));
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        groupFilterEdit.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = true;
        groupFilterEdit.setLayout((Layout)gridLayout);
        UiUtils.createBlankLine((Composite)groupFilterEdit, 6);
        this.addNameClauseControls(t, (Composite)groupFilterEdit);
        if (this.filterProvider.isUseSubTypesToFilter(t)) {
            this.addTypeClauseControls(t, (Composite)groupFilterEdit);
        }
        if (this.filterProvider.isUseWhereClauseToFilter(t)) {
            this.addWhereClauseControls(t, (Composite)groupFilterEdit);
        }
        UiUtils.createBlankLine(composite, 6);
        this.addAttributeOrderControls(t, composite);
        this.resizeControls(t);
        this.labelMsg.setText(this.msgFile.getMessage(t, "UI.GENERAL.MQ.NAME.INVALID.CHARS"));
        composite.pack();
        this.preferredSize = composite.getSize();
        this.labelMsg.setText("");
        if (this.isAddOp) {
            this.clearFilter(t);
        }
        if (this.filterProvider.isUseWhereClauseToFilter(t)) {
            this.whereClauseValueChanged(t);
        }
        this.checkIfEnableOK(t);
    }

    @Override
    public boolean okPressed(Trace t) {
        this.updateFilterWithSelections(t);
        if (this.isManagerSaveOnOKMode && this.filterManager != null && this.filterId != null) {
            UiPlugin.showBusyCursor(t, this.getShell(), true);
            this.filterManager.saveFilters(t);
            this.filterManager.triggerChangedListeners(t, this.filterId);
            UiPlugin.showBusyCursor(t, this.getShell(), false);
        }
        return true;
    }

    @Override
    public void cancelPressed(Trace t) {
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return true;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.buttonClear = new Button(composite, 8);
        this.buttonClear.setText(this.msgFile.getMessage(t, "UI.GENERAL.CLEAR"));
        this.gridDataClear = new GridData(768);
        this.gridDataClear.horizontalAlignment = 1;
        this.gridDataClear.horizontalSpan = 1;
        this.buttonClear.setLayoutData((Object)this.gridDataClear);
        this.buttonClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditFilterDialog.this.clearFilter(tr);
            }
        });
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    @Override
    public boolean isEnableOK(Trace t) {
        boolean isError = false;
        String errorMsg = "";
        boolean alreadyExists = false;
        boolean nameValueError = false;
        boolean enableOK = false;
        boolean lengthOK = false;
        String filterName = this.textFilterName.getText();
        String nameValue = this.textNameValue.getText();
        if (this.isEditName) {
            boolean bl = lengthOK = filterName.length() > 0;
            if (lengthOK) {
                if (filterName.compareTo(this.originalName) != 0) {
                    int i = 0;
                    while (i < this.allFilters.size()) {
                        Filter filter = (Filter)this.allFilters.get(i);
                        if (filter.getFilterName().compareTo(filterName) == 0) {
                            alreadyExists = true;
                            isError = true;
                            errorMsg = this.msgFile.getMessage(t, "UI.FILTERS.Dialog.NameInUseMsg");
                        }
                        ++i;
                    }
                }
            } else {
                isError = true;
                errorMsg = this.msgFile.getMessage(t, "UI.FILTERS.Dialog.NoNameMsg");
            }
        }
        if (!isError) {
            errorMsg = this.checkMatchStringIsValid(t, nameValue);
            if (errorMsg != null) {
                nameValueError = true;
                isError = true;
            }
            if (this.isUsingWhereClause) {
                boolean whereClauseValueOK = true;
                if (this.whereClauseValue == null) {
                    whereClauseValueOK = false;
                } else if (this.whereClauseValue instanceof String) {
                    String string = (String)this.whereClauseValue;
                    if (string.length() == 0) {
                        whereClauseValueOK = false;
                    }
                    if ((this.whereClauseOp == 18 || this.whereClauseOp == 21) && errorMsg == null && (errorMsg = this.checkMatchStringIsValid(t, string)) != null) {
                        whereClauseValueOK = false;
                        isError = true;
                    }
                }
                enableOK = lengthOK && !alreadyExists && !nameValueError && filterName.length() > 0 && nameValue.length() > 0 && whereClauseValueOK;
            } else {
                enableOK = lengthOK && !alreadyExists && !nameValueError && filterName.length() > 0 && nameValue.length() > 0;
            }
        }
        this.labelIcon.setVisible(isError);
        this.labelMsg.setVisible(isError);
        if (isError) {
            this.labelMsg.setText(errorMsg);
        }
        return enableOK;
    }

    private String checkMatchStringIsValid(Trace t, String matchString) {
        String errorMsg = null;
        int quoteCount = 0;
        int leftBracketCount = 0;
        int rightBracketCount = 0;
        int lastPos = matchString.length() - 1;
        boolean isAsterixNotAtEnd = false;
        int i = 0;
        while (i < matchString.length()) {
            if (matchString.charAt(i) == '\'') {
                ++quoteCount;
            } else if (matchString.charAt(i) == '(') {
                ++leftBracketCount;
            } else if (matchString.charAt(i) == ')') {
                ++rightBracketCount;
            } else if (matchString.charAt(i) == '*' && i != lastPos) {
                isAsterixNotAtEnd = true;
            }
            ++i;
        }
        if (quoteCount % 2 != 0) {
            errorMsg = this.msgFile.getMessage(t, "UI.FILTERS.Dialog.UnmatchedQuoteMsg");
        } else if (leftBracketCount != rightBracketCount) {
            errorMsg = this.msgFile.getMessage(t, "UI.FILTERS.Dialog.UnmatchedBracketMsg");
        } else if (isAsterixNotAtEnd) {
            errorMsg = this.msgFile.getMessage(t, "UI.FILTERS.Dialog.NonFinalAsterixMsg");
        }
        if (errorMsg == null && matchString.length() > 0) {
            if (this.regularExpression != null) {
                Matcher m = this.regularExpression.matcher(matchString);
                if (!m.matches()) {
                    errorMsg = StringValidation.getMessageForPattern(t, this.regularExpression);
                }
            } else if (this.isMQCharSet && !StringValidation.verifyString(t, matchString, MATCH_VALID_MQ_CHARS)) {
                errorMsg = this.msgFile.getMessage(t, "UI.GENERAL.MQ.NAME.INVALID.CHARS");
            }
        }
        return errorMsg;
    }

    public void setManagerSaveOnOKMode(Trace t, FilterManager filterMgr, String filtId) {
        this.isManagerSaveOnOKMode = true;
        this.filterManager = filterMgr;
        this.filterId = filtId;
    }
}

