/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.filters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.objects.DmChannelStatusCurrent;
import com.ibm.mq.explorer.core.internal.objects.DmListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueStatusQueue;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterManager;

public class DefineExampleFilters {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/filters/DefineExampleFilters.java";

    public static void create(Trace t, FilterManager filterManager) {
        Message msgFileFilters = UiPlugin.getUIMessages(t, "KEY_Filters");
        DefineExampleFilters.createExamplesForQueueManagers(t, filterManager, msgFileFilters);
        DefineExampleFilters.createExamplesForQueues(t, filterManager, msgFileFilters);
        DefineExampleFilters.createExamplesForQueueStatus(t, filterManager, msgFileFilters);
        DefineExampleFilters.createExamplesForChannels(t, filterManager, msgFileFilters);
        DefineExampleFilters.createExamplesForChannelStatus(t, filterManager, msgFileFilters);
        DefineExampleFilters.createExamplesForChannelAuthenticationRecords(t, filterManager, msgFileFilters);
        DefineExampleFilters.createExamplesForListeners(t, filterManager, msgFileFilters);
    }

    public static void createExamplesForQueueManagers(Trace t, FilterManager filterManager, Message msgFileFilters) {
        Filter filter;
        String filterName;
        String WINDOWS_QMGRS_ID;
        String value;
        int i;
        Integer[] keys;
        AttrTypeEnum attrTypeEnum;
        String attrName = DmQueueManager.getAttributeTitle((Trace)t, (int)32);
        AttrType attrType = DmQueueManager.getAttributeType((Trace)t, (int)32);
        if (attrType != null && attrType instanceof AttrTypeEnum) {
            attrTypeEnum = (AttrTypeEnum)attrType;
            keys = attrTypeEnum.getEnumerationIds(t);
            i = 0;
            while (i < keys.length) {
                value = attrTypeEnum.getEnumeratedValue(t, (Number)keys[i]);
                WINDOWS_QMGRS_ID = "com.ibm.mq.explorer.filters.example.queuemanager." + attrName + "." + value;
                filterName = Message.format((String)msgFileFilters.getMessage(t, "UI.FILTERS.Automatic.Name"), (String)attrName, (String)value);
                filter = new Filter(t, "com.ibm.mq.explorer.filterid.qmgrs", filterName, false, false);
                filter.setNameAndTypeClauseValues(t, "*", 2, -1);
                filter.setWhereClauseValues(t, 32, 2, keys[i], value, 1);
                if (!filterManager.addExampleFilter(t, WINDOWS_QMGRS_ID, filter) && Trace.isTracing) {
                    t.data(67, "DefineExampleFilters.createExamplesForQueueManagers", 900, "Error: failed to add example Filter for queue manager: " + attrName + "=" + value);
                }
                ++i;
            }
        }
        attrName = DmQueueManager.getAttributeTitle((Trace)t, (int)31);
        attrType = DmQueueManager.getAttributeType((Trace)t, (int)12006);
        if (attrType != null && attrType instanceof AttrTypeEnum) {
            attrTypeEnum = (AttrTypeEnum)attrType;
            keys = attrTypeEnum.getEnumerationIds(t);
            i = 0;
            while (i < keys.length) {
                value = attrTypeEnum.getEnumeratedValue(t, (Number)keys[i]);
                WINDOWS_QMGRS_ID = "com.ibm.mq.explorer.filters.example.queuemanager." + attrName + "." + value;
                filterName = Message.format((String)msgFileFilters.getMessage(t, "UI.FILTERS.Automatic.Name"), (String)attrName, (String)value);
                filter = new Filter(t, "com.ibm.mq.explorer.filterid.qmgrs", filterName, false, false);
                filter.setNameAndTypeClauseValues(t, "*", 2, -1);
                filter.setWhereClauseValues(t, 31, 2, keys[i], value, 1);
                if (!filterManager.addExampleFilter(t, WINDOWS_QMGRS_ID, filter) && Trace.isTracing) {
                    t.data(67, "DefineExampleFilters.createExamplesForQueueManagers", 900, "Error: failed to add example Filter for queue manager: " + attrName + "=" + value);
                }
                ++i;
            }
        }
    }

    public static void createExamplesForQueues(Trace t, FilterManager filterManager, Message msgFileFilters) {
        String filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.QueuesLocal");
        Filter filter = new Filter(t, "com.ibm.mq.explorer.filterid.queues", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 13, 1);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.queueslocal", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForQueues", 900, "Error: failed to add example Filter for all local queues");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.QueuesRemote");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.queues", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 13, 6);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.queuesremote", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForQueues", 900, "Error: failed to add example Filter for all remote queues");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.QueuesModel");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.queues", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 13, 2);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.queuesmodel", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForQueues", 900, "Error: failed to add example Filter for all model queues");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.QueuesAlias");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.queues", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 13, 3);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.queuesalias", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForQueues", 900, "Error: failed to add example Filter for all alias queues");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.QueuesWithMessages");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.queues", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 13, 1001);
        filter.setWhereClauseValues(t, 3, 4, 0, "0", 1);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.queueswithmsgs", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForQueues", 900, "Error: failed to add example Filter for all queues with messages");
        }
    }

    public static void createExamplesForQueueStatus(Trace t, FilterManager filterManager, Message msgFileFilters) {
        AttrType attrType;
        String filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.QueueStatusWithMessages");
        Filter filter = new Filter(t, "com.ibm.mq.explorer.filterid.queuestatus", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 1008, -1);
        filter.setWhereClauseValues(t, 3, 4, 0, "0", 1);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.queuestatuswithmsgs", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForQueueStatus", 900, "Error: failed to add example Filter for all queuestatus objects with messages");
        }
        if ((attrType = DmQueueStatusQueue.getAttributeType((Trace)t, (int)1027)) != null && attrType instanceof AttrTypeEnum) {
            AttrTypeEnum attrTypeEnum = (AttrTypeEnum)attrType;
            String attrName = attrTypeEnum.getEnumeratedValue(t, (Number)1);
            filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.QueueStatusWithUncommittedMessages");
            filter = new Filter(t, "com.ibm.mq.explorer.filterid.queuestatus", filterName, false, false);
            filter.setNameAndTypeClauseValues(t, "*", 1008, -1);
            filter.setWhereClauseValues(t, 1027, 2, 1, attrName, 1);
            if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.queuestatuswithuncommittedmsgs", filter) && Trace.isTracing) {
                t.data(67, "DefineExampleFilters.createExamplesForQueueStatus", 900, "Error: failed to add example Filter for all queuestatus objects with messages");
            }
        }
    }

    public static void createExamplesForChannelAuthenticationRecords(Trace t, FilterManager filterManager, Message msgFileFilters) {
        String filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChlAuth.AddressMap");
        Filter filter = new Filter(t, "com.ibm.mq.explorer.filterid.chlauth", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 204, 4);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.chlauth.addressmap", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannelAuthenticationRecords", 900, "Error: failed to add example filter for all Address Map Channel Authentication Records");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChlAuth.UserMap");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.chlauth", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 204, 5);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.chlauth.usermap", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannelAuthenticationRecords", 900, "Error: failed to add example filter for all Client User ID Map Channel Authentication Records");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChlAuth.QmgrMap");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.chlauth", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 204, 6);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.chlauth.qmgrmap", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannelAuthenticationRecords", 900, "Error: failed to add example filter for all Remote Queue Manager Name Map Channel Authentication Records");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChlAuth.SSLPeerMap");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.chlauth", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 204, 3);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.chlauth.sslpeermap", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannelAuthenticationRecords", 900, "Error: failed to add example filter for all SSL Peer Map Channel Authentication Records");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChlAuth.BlockUser");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.chlauth", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 204, 1);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.chlauth.blockuser", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannelAuthenticationRecords", 900, "Error: failed to add example filter for all Blocked User ID List Channel Authentication Records");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChlAuth.BlockAddr");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.chlauth", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 204, 2);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.chlauth.blockaddr", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannelAuthenticationRecords", 900, "Error: failed to add example filter for the Blocked Address List Channel Authentication Record");
        }
    }

    public static void createExamplesForChannels(Trace t, FilterManager filterManager, Message msgFileFilters) {
        String filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChannelsSender");
        Filter filter = new Filter(t, "com.ibm.mq.explorer.filterid.channels", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 25, 1);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.channelssender", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannels", 900, "Error: failed to add example Filter for all sender channels");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChannelsServer");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.channels", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 25, 2);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.channelsserver", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannels", 900, "Error: failed to add example Filter for all server channels");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChannelsRequester");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.channels", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 25, 4);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.channelsrequester", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannels", 900, "Error: failed to add example Filter for all requester channels");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChannelsReceiver");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.channels", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 25, 3);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.channelsreceiver", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannels", 900, "Error: failed to add example Filter for all receiver channels");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChannelsClusterSender");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.channels", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 25, 9);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.channelsclustersender", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannels", 900, "Error: failed to add example Filter for all cluster sender channels");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChannelsClusterReceiver");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.channels", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 25, 8);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.channelsclusterreceiver", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannels", 900, "Error: failed to add example Filter for all cluster receiver channels");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChannelsServerConnection");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.channels", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 25, 7);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.channelsserverconnection", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannels", 900, "Error: failed to add example Filter for all server connection channels");
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChannelsAMQP");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.channels", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 25, 11);
        if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.channelsamqp", filter) && Trace.isTracing) {
            t.data(67, "DefineExampleFilters.createExamplesForChannels", 900, "Error: failed to add example Filter for all AMQP channels");
        }
    }

    public static void createExamplesForChannelStatus(Trace t, FilterManager filterManager, Message msgFileFilters) {
        String attrName;
        AttrTypeEnum attrTypeEnum;
        AttrType attrType = DmChannelStatusCurrent.getAttributeType((Trace)t, (int)1527);
        String filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChannelStatusStopped");
        Filter filter = new Filter(t, "com.ibm.mq.explorer.filterid.channelstatus", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 1009, -1);
        if (attrType != null && attrType instanceof AttrTypeEnum) {
            attrTypeEnum = (AttrTypeEnum)attrType;
            attrName = attrTypeEnum.getEnumeratedValue(t, (Number)6);
            filter.setWhereClauseValues(t, 1527, 2, 6, attrName, 1);
            if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.channelstatusstopped", filter) && Trace.isTracing) {
                t.data(67, "DefineExampleFilters.createExamplesForChannelStatus", 900, "Error: failed to add example Filter for all stopped channels");
            }
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChannelStatusRetrying");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.channelstatus", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 1009, -1);
        if (attrType != null && attrType instanceof AttrTypeEnum) {
            attrTypeEnum = (AttrTypeEnum)attrType;
            attrName = attrTypeEnum.getEnumeratedValue(t, (Number)5);
            filter.setWhereClauseValues(t, 1527, 2, 5, attrName, 1);
            if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.channelstatusretrying", filter) && Trace.isTracing) {
                t.data(67, "DefineExampleFilters.createExamplesForChannelStatus", 900, "Error: failed to add example Filter for all retrying channels");
            }
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ChannelStatusSwitching");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.channelstatus", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 1009, -1);
        if (attrType != null && attrType instanceof AttrTypeEnum) {
            attrTypeEnum = (AttrTypeEnum)attrType;
            attrName = attrTypeEnum.getEnumeratedValue(t, (Number)14);
            filter.setWhereClauseValues(t, 1527, 2, 14, attrName, 1);
            if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.channelstatusswitching", filter) && Trace.isTracing) {
                t.data(67, "DefineExampleFilters.createExamplesForChannelStatus", 900, "Error: failed to add example Filter for all switching channels");
            }
        }
    }

    public static void createExamplesForListeners(Trace t, FilterManager filterManager, Message msgFileFilters) {
        String attrName;
        AttrTypeEnum attrTypeEnum;
        AttrType attrType = DmListener.getAttributeType((Trace)t, (int)1501);
        String filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ListenersTCP");
        Filter filter = new Filter(t, "com.ibm.mq.explorer.filterid.listeners", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 97, -1);
        if (attrType != null && attrType instanceof AttrTypeEnum) {
            attrTypeEnum = (AttrTypeEnum)attrType;
            attrName = attrTypeEnum.getEnumeratedValue(t, (Number)2);
            filter.setWhereClauseValues(t, 1501, 2, 2, attrName, 1);
            if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.listenerstcp", filter) && Trace.isTracing) {
                t.data(67, "DefineExampleFilters.createExamplesForListeners", 900, "Error: failed to add example Filter for all TCP listeners");
            }
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ListenersNetBIOS");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.listeners", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 97, -1);
        if (attrType != null && attrType instanceof AttrTypeEnum) {
            attrTypeEnum = (AttrTypeEnum)attrType;
            attrName = attrTypeEnum.getEnumeratedValue(t, (Number)3);
            filter.setWhereClauseValues(t, 1501, 2, 3, attrName, 1);
            if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.listenersnetbios", filter) && Trace.isTracing) {
                t.data(67, "DefineExampleFilters.createExamplesForListeners", 900, "Error: failed to add example Filter for all TCP listeners");
            }
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ListenersSPX");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.listeners", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 97, -1);
        if (attrType != null && attrType instanceof AttrTypeEnum) {
            attrTypeEnum = (AttrTypeEnum)attrType;
            attrName = attrTypeEnum.getEnumeratedValue(t, (Number)4);
            filter.setWhereClauseValues(t, 1501, 2, 4, attrName, 1);
            if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.listenersspx", filter) && Trace.isTracing) {
                t.data(67, "DefineExampleFilters.createExamplesForListeners", 900, "Error: failed to add example Filter for all TCP listeners");
            }
        }
        filterName = msgFileFilters.getMessage(t, "UI.FILTERS.Examples.ListenersLU62");
        filter = new Filter(t, "com.ibm.mq.explorer.filterid.listeners", filterName, false, false);
        filter.setNameAndTypeClauseValues(t, "*", 97, -1);
        if (attrType != null && attrType instanceof AttrTypeEnum) {
            attrTypeEnum = (AttrTypeEnum)attrType;
            attrName = attrTypeEnum.getEnumeratedValue(t, (Number)1);
            filter.setWhereClauseValues(t, 1501, 2, 1, attrName, 1);
            if (!filterManager.addExampleFilter(t, "com.ibm.mq.explorer.filters.example.listenerslu62", filter) && Trace.isTracing) {
                t.data(67, "DefineExampleFilters.createExamplesForListeners", 900, "Error: failed to add example Filter for all TCP listeners");
            }
        }
    }
}

