/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertree;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableUpdate;
import com.ibm.mq.explorer.ui.internal.explorertree.ExplorerTree;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;

public class ExplorerTreeDMListener
implements DmQueueManagerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/explorertree/ExplorerTreeDMListener.java";
    private ExplorerTree explorerTree = null;
    private boolean isListening = false;
    private boolean inUpdate = false;
    private IDmObservable observableObject = null;

    public ExplorerTreeDMListener(Trace t, ExplorerTree expTree) {
        this.explorerTree = expTree;
    }

    public boolean startListening(Trace t, IDmObservable observable, DmObjectFilter filter) {
        boolean ret = false;
        if (Trace.isTracing) {
            String traceText = "";
            traceText = filter == null ? "null filter passed OK to start listening call" : "filter passed to start listening call: " + filter.toString(t);
            t.data(67, "ExplorerTreeDMListener.startListening", 300, traceText);
        }
        if (Trace.isTracing) {
            t.data(67, "ExplorerTreeDMListener.startListening", 300, "starting to listen to: " + observable);
        }
        if (ret = observable.addObserver(t, (DmObjectListener)this, filter)) {
            this.isListening = true;
            this.observableObject = observable;
            if (Trace.isTracing) {
                t.data(67, "ExplorerTreeDMListener.startListening", 300, "Listen succesful");
            }
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTreeDMListener.startListening", 900, "Failed to add observer to observable object " + observable.getObservableName());
        }
        return ret;
    }

    public boolean stopListening(Trace t, IDmObservable observable) {
        boolean ret = false;
        if (observable != null) {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTreeDMListener.stopListening", 300, "stopping listen to: " + observable);
            }
            ret = observable.deleteObserver(t, (DmObjectListener)this);
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTreeDMListener.stopListening", 900, "null observable passed in");
        }
        if (ret) {
            this.isListening = false;
            if (Trace.isTracing) {
                t.data(67, "ExplorerTreeDMListener.stopListening", 300, "Succesfully removed listener");
            }
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTreeDMListener.stopListening", 900, "failed to removed listener");
        }
        return ret;
    }

    public void dmObjectAdded(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        String logText = "dmObjectAdded event received - ";
        logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
        logText = String.valueOf(logText) + " name=" + object.toString(t);
        if (Trace.isTracing) {
            t.data(67, "ExplorerTreeDMListener.dmObjectAdded", 500, logText);
        }
        t.eventReceived("ExplorerTreeDMListener.dmObjectAdded", 2, logText);
        if (!this.inUpdate) {
            this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 8, 5), true);
            this.inUpdate = true;
        }
        this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 1, object), false);
    }

    public void dmObjectChanged(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        String logText = "dmObjectChanged event received - ";
        logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
        logText = String.valueOf(logText) + " name=" + object.toString(t);
        if (Trace.isTracing) {
            t.data(67, "ExplorerTreeDMListener.dmObjectChanged", 500, logText);
        }
        t.eventReceived("ExplorerTreeDMListener.dmObjectChanged", 2, logText);
        if (!this.inUpdate) {
            this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 8, 5), true);
            this.inUpdate = true;
        }
        this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 2, object), false);
    }

    public void dmObjectDeleted(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        String logText = "dmObjectDeleted event received - ";
        logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
        logText = String.valueOf(logText) + " name=" + object.toString(t);
        if (Trace.isTracing) {
            t.data(67, "ExplorerTreeDMListener.dmObjectDeleted", 500, logText);
        }
        t.eventReceived("ExplorerTreeDMListener.dmObjectDeleted", 2, logText);
        if (!this.inUpdate) {
            this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 8, 5), true);
            this.inUpdate = true;
        }
        this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 3, object), false);
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        String logText = "dmQmgrConnected event received - ";
        logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
        logText = String.valueOf(logText) + " name=" + object.toString(t);
        if (Trace.isTracing) {
            t.data(67, "ExplorerTreeDMListener.dmQueueManagerConnected", 500, logText);
        }
        t.eventReceived("ExplorerTreeDMListener.dmQueueManagerConnected", 2, logText);
        this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 2, object), false);
        UiPlugin.asyncRefreshAllViews(t, "com.ibm.mq.explorer.queuemanager", false);
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        String logText = "dmQmgrDisconnected event received - ";
        logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
        logText = String.valueOf(logText) + " name=" + object.toString(t);
        if (Trace.isTracing) {
            t.data(67, "ExplorerTreeDMListener.dmQueueManagerDisconnected", 500, logText);
        }
        t.eventReceived("ExplorerTreeDMListener.dmQueueManagerDisconnected", 2, logText);
        this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 2, object), false);
        UiPlugin.asyncRefreshAllViews(t, "com.ibm.mq.explorer.queuemanager", false);
    }

    public void dmRefreshComplete(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmCoreException e = event.getException();
        if (e != null) {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTreeDMListener.dmRefreshComplete", 900, "refresh completed with unexpected error: cc=" + e.getCompCode() + " rc=" + e.getReasonCode());
            }
            this.displayExceptionErrorMessage(t, e);
            this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 6), true);
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTreeDMListener.dmRefreshComplete", 500, "refresh completed");
        }
        this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 7), true);
    }

    public void dmObjectListDone(DmObjectListEvent event) {
        Trace t = Trace.getDefault();
        System.out.println(">> unexpected dmObjectListDone ignored!!");
        if (Trace.isTracing) {
            t.data(67, "ExplorerTreeDMListener.dmObjectListDone", 900, "unexpected dmObjectListDone ignored");
        }
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        String logText = "dmQmgrConnecting event received - ";
        logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
        logText = String.valueOf(logText) + " name=" + object.toString(t);
        t.eventReceived("ExplorerTreeDMListener.dmQueueManagerConnecting", 2, logText);
        this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 2, object), false);
        UiPlugin.asyncRefreshAllViews(t, "com.ibm.mq.explorer.queuemanager", false);
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
        DmCoreException e;
        final Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "ExplorerTreeDMListener.dmObjectSummary", 300, "count = " + event.getCount());
        }
        if ((e = event.getException()) != null) {
            switch (e.getReasonCode()) {
                case 2009: 
                case 2033: 
                case 2322: {
                    if (Trace.isTracing) {
                        t.data(67, "ExplorerTreeDMListener.dmObjectSummary", 900, "dmObjectSummary with connection or timeout error, stop listening");
                    }
                    if (UiPlugin.isShutdownInProgress()) break;
                    UiPlugin.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ExplorerTreeDMListener.this.explorerTree.isDisposed()) {
                                if (ExplorerTreeDMListener.this.isListening) {
                                    ExplorerTreeDMListener.this.explorerTree.stopListener(t, ExplorerTreeDMListener.this.observableObject);
                                }
                                ExplorerTreeDMListener.this.explorerTree.removeAll(t);
                            }
                        }
                    });
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(67, "ExplorerTreeDMListener.dmObjectSummary", 900, "dmObjectSummary with unexpected error: cc=" + e.getCompCode() + " rc=" + e.getReasonCode());
                    }
                    this.displayExceptionErrorMessage(t, e);
                    this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 6), true);
                }
            }
        }
        this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 8, 4), false);
        this.explorerTree.queueUpdate(t, new ExplorerTableUpdate(t, 5), true);
        this.inUpdate = false;
    }

    private void displayExceptionErrorMessage(final Trace t, final DmCoreException e) {
        if (!UiPlugin.isShutdownInProgress()) {
            UiPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ExplorerTreeDMListener.this.explorerTree.isDisposed() && ExplorerTreeDMListener.this.explorerTree.isShowListenerExceptions()) {
                        MessageBox.showExceptionMessage(t, UiPlugin.getShell(), e);
                    }
                }
            });
        }
    }
}

