/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertree;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObjectLink;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentProvider;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableUpdate;
import com.ibm.mq.explorer.ui.internal.explorertree.ExplorerTreeDMListener;
import com.ibm.mq.explorer.ui.internal.explorertree.ExplorerTreeLabelProvider;
import com.ibm.mq.explorer.ui.internal.explorertree.ExplorerTreeSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertree.ExplorerTreeSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.explorertree.IHelpIdProvider;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.views.ExplorerViewPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ExplorerTree
extends Composite
implements DisposeListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/explorertree/ExplorerTree.java";
    public static final int ALL_LEVELS = -1;
    private TreeViewer treeViewer = null;
    private Tree tree = null;
    private ExplorerTableContentProvider contentProvider = null;
    private ArrayList<UiMQObject> items = new ArrayList();
    private Hashtable<IDmObject, UiMQObject> hashtable = new Hashtable();
    private int updateCounter = 0;
    private IUiMQObjectFactory uiMQObjectFactory = null;
    private UiMQObject parentObjectForFactory = null;
    private boolean isTreeRedraw = true;
    private Vector<ExplorerTreeSelectionChangedListener> selChangedListeners = new Vector();
    private List<ExplorerTableUpdate> listUpdateQueue = Collections.synchronizedList(new LinkedList());
    private boolean isUpdateQueueActive = false;
    private int updatesSinceNotify = 0;
    private int updateBatchSize = 100;
    private boolean isDMListenerUpdate = false;
    private ExplorerTreeDMListener explorerTreeDMListener = null;
    private boolean isShowListenerExceptions = true;
    private MenuManager menuMgr = null;
    private boolean contextMenuRegistered = false;
    private boolean enableContextMenu = true;
    private Object contextObject = null;
    private ExplorerViewPart explorerViewPart = null;
    private IHelpIdProvider helpIdProvider = null;
    private boolean isEnabled = true;
    private boolean isListening = false;
    private IDmObservable observableObject = null;

    public ExplorerTree(Trace t, Composite parent, int style, boolean contextMenu, Object contextObj) {
        super(parent, style);
        this.explorerTreeDMListener = new ExplorerTreeDMListener(t, this);
        this.isUpdateQueueActive = true;
        this.enableContextMenu = contextMenu;
        this.contextObject = contextObj;
        FillLayout fillLayout = new FillLayout();
        this.setLayout((Layout)fillLayout);
        this.treeViewer = new TreeViewer((Composite)this, 2820);
        this.tree = this.treeViewer.getTree();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ExplorerTreeLabelProvider());
        this.contentProvider = new ExplorerTableContentProvider(t, this.hashtable, true);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.addTreeSelectionListener(t);
        this.treeViewer.setInput(this.items);
        if (this.enableContextMenu) {
            this.hookTableContextMenu(t);
        }
        this.addDisposeListener(this);
    }

    public void setSorter(Trace t, ViewerSorter sorter) {
        this.treeViewer.setSorter(sorter);
    }

    public void beginUpdate(Trace t) {
        UiPlugin.showBusyCursor(t, true);
        this.setTreeRedraw(t, false);
        ++this.updateCounter;
    }

    public void removeAll(Trace t) {
        this.items.clear();
        this.hashtable.clear();
        this.treeViewer.refresh();
        this.tree.redraw();
    }

    public void addTreeItem(Trace t, UiMQObject object) {
        boolean addObject = true;
        IDmObjectLink parent = null;
        IDmObject dmObject = object.getDmObject();
        if (dmObject instanceof IDmObjectLink && (parent = ((IDmObjectLink)dmObject).getParent(t)) != null && this.hashtable.containsKey(parent)) {
            addObject = false;
        }
        if (addObject) {
            this.items.add(object);
            this.hashtable.put(object.getDmObject(), object);
        }
    }

    public boolean removeTreeItem(Trace t, UiMQObject object) {
        boolean result = this.deleteItem(object);
        return result;
    }

    public void endUpdate(Trace t) {
        if (!this.isListening) {
            this.processUpdates(t, this.updatesSinceNotify);
            this.updatesSinceNotify = 0;
        }
        if (this.updateCounter > 0) {
            this.setTreeRedraw(t, true);
            this.treeViewer.refresh();
            this.tree.redraw();
            --this.updateCounter;
            this.isDMListenerUpdate = false;
            UiPlugin.showBusyCursor(t, false);
        }
    }

    public void asyncBeginUpdate(Trace t) {
        this.queueUpdate(t, new ExplorerTableUpdate(t, 4, null), true);
    }

    public void asyncAddTreeItem(Trace t, UiMQObject object) {
        boolean notifyNow = this.updateCounter == 0;
        this.queueUpdate(t, new ExplorerTableUpdate(t, 1, object), notifyNow);
    }

    public void asyncRemoveAll(Trace t) {
        this.queueUpdate(t, new ExplorerTableUpdate(t, 6, null), true);
    }

    public void asyncEndUpdate(Trace t) {
        this.queueUpdate(t, new ExplorerTableUpdate(t, 5, null), true);
    }

    protected boolean addItem(Object item) {
        Trace t = Trace.getDefault();
        boolean result = false;
        if (!this.isDMListenerUpdate) {
            this.beginUpdate(t);
            this.isDMListenerUpdate = true;
        }
        UiMQObject uiMQObject = null;
        if (item instanceof UiMQObject) {
            ExplorerTree.trace(t, "ExplorerTree.addItem", "item being added is a UiMQObject");
            uiMQObject = (UiMQObject)item;
        } else if (item instanceof DmObject) {
            ExplorerTree.trace(t, "ExplorerTree.addItem", "item being added is a DmObject");
            uiMQObject = this.hashtable.get(item);
        }
        if (uiMQObject != null) {
            if (this.items.contains(uiMQObject)) {
                ExplorerTree.trace(t, "ExplorerTree.addItem", "UiMQObject " + uiMQObject.toString() + " is already in tree, refreshing it");
                this.treeViewer.update((Object)uiMQObject.getExternalObject(), null);
                result = true;
            } else {
                ExplorerTree.trace(t, "ExplorerTree.addItem", "adding supplied UiMQObject " + uiMQObject.toString());
                this.addTreeItem(t, uiMQObject);
                result = true;
            }
        } else {
            ExplorerTree.trace(t, "ExplorerTree.addItem", "DmObject added, does not exist in tree, trying to create using factory");
            if (this.uiMQObjectFactory != null && item instanceof IDmObject) {
                DmObject dmObject = (DmObject)item;
                uiMQObject = this.uiMQObjectFactory.create(t, (IDmObject)dmObject, this.parentObjectForFactory);
                if (uiMQObject != null) {
                    ExplorerTree.trace(t, "ExplorerTree.addItem", "adding UiMQObject " + uiMQObject.toString());
                    this.addTreeItem(t, uiMQObject);
                    result = true;
                } else {
                    ExplorerTree.trace(t, "ExplorerTree.addItem", "failed to create uiMQObject from factory " + dmObject);
                }
            } else if (this.uiMQObjectFactory == null) {
                ExplorerTree.trace(t, "ExplorerTree.addItem", "No object factory, unable to make UiMQObject from object " + item.toString());
            } else {
                ExplorerTree.trace(t, "ExplorerTree.addItem", "Object " + item.toString() + " is not a DmObject, unable to make UiMQObject from it");
            }
        }
        return result;
    }

    protected boolean refreshItem(Object item) {
        DmObject dmObject;
        Trace t = Trace.getDefault();
        boolean result = false;
        UiMQObject uiMQObject = null;
        if (item instanceof UiMQObject) {
            uiMQObject = (UiMQObject)item;
        } else if (item instanceof DmObject && (uiMQObject = this.hashtable.get(dmObject = (DmObject)item)) == null) {
            ExplorerTree.trace(t, "ExplorerTree.refreshItem", "dmObject " + ((DmObject)item).getTitle() + " not in tree, ignoring");
        }
        if (uiMQObject != null) {
            ExplorerTree.trace(t, "ExplorerTree.refreshItem", "refreshing UiMQObject " + uiMQObject.toString());
            if (this.items.contains(uiMQObject)) {
                if (!this.isDMListenerUpdate) {
                    this.beginUpdate(t);
                    this.isDMListenerUpdate = true;
                }
                ExplorerTree.trace(t, "ExplorerTree.refreshItem", "UiMQObject " + uiMQObject.toString() + " is in tree, refreshing it");
                this.treeViewer.update((Object)uiMQObject.getExternalObject(), null);
                result = true;
            } else {
                ExplorerTree.trace(t, "ExplorerTree.refreshItem", "UiMQObject " + uiMQObject.toString() + " not in tree, ignoring");
            }
        }
        return result;
    }

    protected boolean deleteItem(Object item) {
        Trace t = Trace.getDefault();
        boolean result = false;
        UiMQObject uiMQObject = null;
        if (item instanceof UiMQObject) {
            uiMQObject = (UiMQObject)item;
        } else if (item instanceof DmObject && (uiMQObject = this.hashtable.get(item)) == null) {
            ExplorerTree.trace(t, "ExplorerTree.deleteItem", "dmObject " + ((DmObject)item).getTitle() + " not in tree, ignoring");
        }
        if (uiMQObject != null) {
            ExplorerTree.trace(t, "ExplorerTree.deleteItem", "deleting UiMQObject " + uiMQObject.toString());
            if (this.items.remove(uiMQObject)) {
                if (!this.isDMListenerUpdate) {
                    this.beginUpdate(t);
                    this.isDMListenerUpdate = true;
                }
                ExplorerTree.trace(t, "ExplorerTree.deleteItem", "UiMQObject " + uiMQObject.toString() + " was in tree, removing it");
                IDmObject dmObject = uiMQObject.getDmObject();
                this.hashtable.remove(dmObject);
                result = true;
            } else {
                ExplorerTree.trace(t, "ExplorerTree.deleteItem", "UiMQObject " + uiMQObject.toString() + " not in tree, ignoring");
            }
        }
        return result;
    }

    private void setTreeRedraw(Trace t, boolean isRedraw) {
        if (this.isTreeRedraw != isRedraw) {
            this.tree.setRedraw(isRedraw);
            this.isTreeRedraw = isRedraw;
        }
    }

    private void addTreeSelectionListener(Trace t) {
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UiMQObject selObject = null;
                TreeItem[] selObjects = ExplorerTree.this.tree.getSelection();
                if (selObjects.length > 0) {
                    TreeItem treeItem = selObjects[0];
                    Object object = treeItem.getData();
                    if (object instanceof MQExtObject) {
                        MQExtObject mqExtObject = (MQExtObject)object;
                        selObject = (UiMQObject)mqExtObject.getInternalObject();
                    } else if (object instanceof UiMQObject) {
                        selObject = (UiMQObject)object;
                    }
                }
                if (selObject != null) {
                    if (ExplorerTree.this.helpIdProvider != null) {
                        String helpId = ExplorerTree.this.helpIdProvider.getHelpId(selObject);
                        UiPlugin.getHelpSystem().setHelp((Control)ExplorerTree.this.treeViewer.getTree(), helpId);
                    }
                    ExplorerTreeSelectionChangedEvent selEvent = new ExplorerTreeSelectionChangedEvent((Object)this, selObject);
                    int size = ExplorerTree.this.selChangedListeners.size();
                    int i = 0;
                    while (i < size) {
                        ExplorerTreeSelectionChangedListener listener = (ExplorerTreeSelectionChangedListener)ExplorerTree.this.selChangedListeners.elementAt(i);
                        listener.selChanged(selEvent);
                        ++i;
                    }
                }
            }
        });
    }

    public void addSelChangedListener(Trace t, ExplorerTreeSelectionChangedListener listener) {
        this.selChangedListeners.addElement(listener);
    }

    public void removeSelChangedListener(Trace t, ExplorerTreeSelectionChangedListener listener) {
        this.selChangedListeners.removeElement(listener);
    }

    public void setUiMQObjectFactoryClass(Trace t, IUiMQObjectFactory factoryClass, UiMQObject parentToNewObjects) {
        this.uiMQObjectFactory = factoryClass;
        this.parentObjectForFactory = parentToNewObjects;
        this.contentProvider.setUiMQObjectFactoryClass(t, factoryClass, parentToNewObjects);
    }

    private static void trace(Trace t, String fid, String msg) {
        if (Trace.isTracing) {
            t.data(67, fid, 300, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpdate(Trace t, ExplorerTableUpdate update, boolean notifyNow) {
        if (this.isUpdateQueueActive) {
            List<ExplorerTableUpdate> list = this.listUpdateQueue;
            synchronized (list) {
                this.listUpdateQueue.add(update);
                ++this.updatesSinceNotify;
            }
            if (this.updatesSinceNotify >= this.updateBatchSize || notifyNow) {
                if (Trace.isTracing) {
                    t.data(67, "ExplorerTree.queueUpdate", 300, "calling ExplorerTree to process updates, depth = " + this.listUpdateQueue.size());
                }
                final int count = this.updatesSinceNotify;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ExplorerTree.this.isDisposed()) {
                            Trace tr = Trace.getDefault();
                            ExplorerTree.this.processUpdates(tr, count);
                        }
                    }
                });
                this.updatesSinceNotify = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdates(Trace t, int count) {
        List<ExplorerTableUpdate> list = this.listUpdateQueue;
        synchronized (list) {
            int i = 0;
            while (i < count && this.listUpdateQueue.size() > 0) {
                ExplorerTableUpdate obj = this.listUpdateQueue.remove(0);
                if (obj != null && obj instanceof ExplorerTableUpdate) {
                    ExplorerTableUpdate update = obj;
                    int updateType = update.getUpdateType();
                    if (Trace.isTracing) {
                        t.data(67, "ExplorerTree.processUpdates", 300, "processing update, type = " + updateType);
                    }
                    switch (updateType) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.addItem(update.getObject());
                            break;
                        }
                        case 2: {
                            this.refreshItem(update.getObject());
                            break;
                        }
                        case 3: {
                            this.deleteItem(update.getObject());
                            break;
                        }
                        case 5: {
                            this.endUpdate(t);
                            break;
                        }
                        case 6: {
                            this.removeAll(t);
                            break;
                        }
                        case 7: {
                            UiPlugin.showBusyCursor(t, this.getShell(), false);
                            break;
                        }
                        case 8: {
                            break;
                        }
                        default: {
                            if (!Trace.isTracing) break;
                            t.data(67, "ExplorerTree.processUpdates", 900, "unknown updateType " + updateType + " ignored");
                        }
                    }
                }
                ++i;
            }
            if (Trace.isTracing) {
                t.data(67, "ExplorerTree.processUpdates", 300, "finished processing " + count + " updates, depth now " + this.listUpdateQueue.size());
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        Trace t = Trace.getDefault();
        this.isUpdateQueueActive = false;
        if (this.isListening) {
            this.stopListener(t, this.observableObject);
        }
    }

    public boolean startListener(Trace t, IDmObservable observable, int objectId) {
        DmObjectFilter dmObjectFilter = new DmObjectFilter(t, objectId);
        boolean res = this.startListener(t, observable, dmObjectFilter, false);
        return res;
    }

    public boolean startListener(Trace t, IDmObservable observable, DmObjectFilter filter) {
        boolean res = false;
        boolean filterProvided = true;
        if (filter == null) {
            filterProvided = false;
        }
        res = this.startListener(t, observable, filter, filterProvided);
        return res;
    }

    private boolean startListener(Trace t, IDmObservable observable, DmObjectFilter filter, boolean isExplicit) {
        boolean res = false;
        if (!this.isListening) {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTree.startListener", 300, "starting to listen - clearing up");
            }
            this.listUpdateQueue.clear();
            this.isUpdateQueueActive = true;
        }
        UiPlugin.showBusyCursor(t, this.getShell(), true);
        res = this.explorerTreeDMListener.startListening(t, observable, filter);
        if (res) {
            this.isListening = true;
            this.observableObject = observable;
        } else {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTree.startListener", 300, "failed to start listening");
            }
            UiPlugin.showBusyCursor(t, this.getShell(), false);
            if (isExplicit) {
                String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4169");
                MessageBox.showMessageFailure(t, this.getShell(), msg, "AMQ4169");
            } else {
                String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4168");
                MessageBox.showMessageFailure(t, this.getShell(), msg, "AMQ4168");
            }
        }
        return res;
    }

    public boolean stopListener(Trace t, IDmObservable observable) {
        boolean res = false;
        this.isUpdateQueueActive = false;
        res = this.explorerTreeDMListener.stopListening(t, observable);
        if (res) {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTree.stopListener", 300, "stopped listening - clearing up");
            }
            if (this.isListening) {
                this.isListening = false;
                this.observableObject = null;
                this.listUpdateQueue.clear();
            }
        }
        return res;
    }

    public boolean isListening(Trace t) {
        return this.isListening;
    }

    public boolean isShowListenerExceptions() {
        return this.isShowListenerExceptions;
    }

    public void setShowListenerExceptions(boolean show) {
        this.isShowListenerExceptions = show;
    }

    public void addViewerFilter(Trace t, ViewerFilter filter) {
        this.treeViewer.addFilter(filter);
    }

    public void removeViewerFilter(Trace t, ViewerFilter filter) {
        this.treeViewer.removeFilter(filter);
    }

    public void resetViewerFilters(Trace t) {
        this.treeViewer.resetFilters();
    }

    private void hookTableContextMenu(Trace t) {
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Trace tr = Trace.getDefault();
                ExplorerTree.this.fillTreeContextMenu(tr, manager);
                IContributionItem[] contributions = manager.getItems();
                if (contributions.length == 0) {
                    manager.add((IContributionItem)new Separator("additions"));
                }
            }
        });
        Menu menu = this.menuMgr.createContextMenu((Control)this.tree);
        this.tree.setMenu(menu);
        if (this.explorerViewPart != null) {
            this.explorerViewPart.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.treeViewer);
            this.contextMenuRegistered = true;
        }
    }

    private void fillTreeContextMenu(Trace t, IMenuManager manager) {
        Object object;
        UiMQObject selObject = null;
        ISelection selection = this.treeViewer.getSelection();
        if (selection != null && (object = ((IStructuredSelection)selection).getFirstElement()) != null) {
            if (object instanceof MQExtObject) {
                MQExtObject mqExtObject = (MQExtObject)object;
                selObject = (UiMQObject)mqExtObject.getInternalObject();
            } else if (object instanceof UiMQObject) {
                selObject = (UiMQObject)object;
            }
        }
        if (selObject != null) {
            selObject.appendToContextMenu(this.getShell(), manager, this.contextObject);
            manager.add((IContributionItem)new Separator("com.ibm.mq.explorer.explorertable"));
        }
    }

    public void setViewPart(Trace t, ExplorerViewPart part) {
        this.explorerViewPart = part;
        if (!this.contextMenuRegistered) {
            this.explorerViewPart.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.treeViewer);
            this.contextMenuRegistered = true;
        }
    }

    public void refresh(Trace t) {
        if (this.isListening) {
            this.observableObject.refreshObservable(t);
        }
    }

    public void setHelpIdProvider(Trace t, IHelpIdProvider provider) {
        this.helpIdProvider = provider;
    }

    public void expandAll(Trace t) {
        this.treeViewer.expandAll();
    }

    public void expandToLevel(int level) {
        this.treeViewer.expandToLevel(level);
    }

    public boolean isTreeEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        Trace t = Trace.getDefault();
        super.setEnabled(enabled);
        if (this.tree != null) {
            this.tree.setEnabled(enabled);
            this.removeAll(t);
        }
        this.isEnabled = enabled;
    }
}

