/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class StatusBar
extends Composite {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/explorertable/StatusBar.java";
    private Composite compNormal = null;
    private Text[] normalLabels = null;
    private ProgressBar normalProgBar = null;
    private Composite compCompressedLabel = null;
    private Text[] compressedLabels = null;
    private Composite compCompressedProgBar = null;
    private ProgressBar compressedProgBar = null;
    private ProgressBar progressBar = null;
    private Composite stackComposite = null;
    private StackLayout stackLayout = null;
    private boolean isCompressedMode = false;
    private int widthNormalProgBar = 0;
    private boolean isForceCompressedMode = false;

    public StatusBar(Trace t, Composite parent, int style) {
        super(parent, style);
        this.createControls(t, 1);
    }

    public StatusBar(Trace t, Composite parent, int style, int numTextAreas) {
        super(parent, style);
        this.createControls(t, numTextAreas);
    }

    private void createControls(Trace t, int numTextAreas) {
        int numLabels = numTextAreas;
        if (numLabels < 1) {
            numLabels = 1;
        }
        FillLayout fillLayout = new FillLayout();
        this.setLayout((Layout)fillLayout);
        this.stackComposite = new Composite((Composite)this, 0);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.compNormal = new Composite(this.stackComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numLabels + 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.compNormal.setLayout((Layout)gridLayout);
        this.normalLabels = new Text[numLabels];
        int i = 0;
        while (i < numLabels) {
            this.normalLabels[i] = new Text(this.compNormal, 2048);
            UiUtils.makeTextControlReadOnly(t, this.normalLabels[i], true);
            GridData gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 1;
            this.normalLabels[i].setLayoutData((Object)gridData);
            ++i;
        }
        this.normalProgBar = new ProgressBar(this.compNormal, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.horizontalSpan = 1;
        this.normalProgBar.setLayoutData((Object)gridData);
        this.normalProgBar.setVisible(false);
        this.widthNormalProgBar = this.normalProgBar.computeSize((int)-1, (int)-1).x;
        this.compressedLabels = new Text[numLabels];
        this.compCompressedLabel = new Composite(this.stackComposite, 0);
        if (numLabels == 1) {
            fillLayout = new FillLayout();
            this.compCompressedLabel.setLayout((Layout)fillLayout);
            this.compressedLabels[0] = new Text(this.compCompressedLabel, 2048);
            UiUtils.makeTextControlReadOnly(t, this.compressedLabels[0], true);
        } else {
            gridLayout = new GridLayout();
            gridLayout.numColumns = numLabels;
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.compCompressedLabel.setLayout((Layout)gridLayout);
            int i2 = 0;
            while (i2 < numLabels) {
                this.compressedLabels[i2] = new Text(this.compCompressedLabel, 2048);
                UiUtils.makeTextControlReadOnly(t, this.compressedLabels[i2], true);
                gridData = new GridData(768);
                gridData.grabExcessHorizontalSpace = true;
                gridData.horizontalSpan = 1;
                this.compressedLabels[i2].setLayoutData((Object)gridData);
                ++i2;
            }
        }
        this.compCompressedProgBar = new Composite(this.stackComposite, 0);
        fillLayout = new FillLayout();
        this.compCompressedProgBar.setLayout((Layout)fillLayout);
        this.compressedProgBar = new ProgressBar(this.compCompressedProgBar, 258);
        this.stackLayout.topControl = this.compNormal;
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                StatusBar.this.statusBarResized(Trace.getDefault());
            }
        });
        this.statusBarResized(t);
    }

    public void showMessage(Trace t, String msg) {
        if (Trace.isTracing) {
            t.data(67, "StatusBar.showMessage", 300, "Showing status message: " + msg);
        }
        String text = " " + msg + " ";
        if (!this.normalLabels[0].isDisposed()) {
            this.normalLabels[0].setText(text);
        }
        if (!this.compressedLabels[0].isDisposed()) {
            this.compressedLabels[0].setText(text);
        }
    }

    public void showMessage(Trace t, String msg, int indexTextArea) {
        if (Trace.isTracing) {
            t.data(67, "StatusBar.showMessage", 300, "Showing status message, index: " + indexTextArea + "  text: " + msg);
        }
        String text = " " + msg + " ";
        if (indexTextArea < this.normalLabels.length && !this.normalLabels[indexTextArea].isDisposed()) {
            this.normalLabels[indexTextArea].setText(text);
        }
        if (indexTextArea < this.compressedLabels.length && !this.compressedLabels[indexTextArea].isDisposed()) {
            this.compressedLabels[indexTextArea].setText(text);
        }
    }

    public void setProgressBarVisible(Trace t, boolean visible) {
        boolean showProgressBar;
        boolean bl = showProgressBar = visible && UiPlugin.isShowAnimations();
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setVisible(showProgressBar);
            if (this.isCompressedMode) {
                this.stackLayout.topControl = showProgressBar ? this.compCompressedProgBar : this.compCompressedLabel;
                this.stackComposite.layout();
                this.stackComposite.redraw();
                this.stackComposite.update();
            }
        }
    }

    private void statusBarResized(Trace t) {
        int widthBar = this.getSize().x;
        if (this.widthNormalProgBar * 3 > widthBar || this.isForceCompressedMode) {
            if (!this.isCompressedMode) {
                this.stackLayout.topControl = this.compCompressedLabel;
                this.progressBar = this.compressedProgBar;
                this.isCompressedMode = true;
                this.stackComposite.layout();
                this.stackComposite.redraw();
                this.stackComposite.update();
            }
        } else if (this.isCompressedMode) {
            this.stackLayout.topControl = this.compNormal;
            this.progressBar = this.normalProgBar;
            this.isCompressedMode = false;
            this.stackComposite.layout();
            this.stackComposite.redraw();
            this.stackComposite.update();
        }
    }

    public void setCompressedMode(Trace t) {
        this.isForceCompressedMode = true;
        this.statusBarResized(t);
    }
}

