/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.EditAttributeOrderDialog;
import com.ibm.mq.explorer.ui.internal.attributeorder.ManageAttributeOrdersDialog;
import com.ibm.mq.explorer.ui.internal.attributeorder.SelectAttributeOrderDialog;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SchemeBar
extends Composite
implements AccessibleListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/explorertable/SchemeBar.java";
    private static final int MOST_RECENT_COUNT = 5;
    private String attrOrderId = null;
    private String instanceId = null;
    private boolean isSecondaryOrder = false;
    private Label labelPrompt = null;
    private Text labelScheme = null;
    private ToolBar toolBar = null;
    private ToolItem toolItem = null;
    private Menu menuSelect = null;
    private MenuManager menuManager = null;
    private Action[] actionsMostRecentSchemes = null;
    private Action actionSelectScheme = null;
    private Action actionManageSchemes = null;
    private Action actionEditScheme = null;
    private AttributeOrderManager attrOrderManager = null;
    private AttributeOrder currentAttributeOrder = null;
    private ArrayList<Action> additionalActions = null;
    private Message msgFile = null;

    public SchemeBar(Trace t, Composite parent, int style) {
        super(parent, style);
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Tables");
        this.attrOrderManager = UiPlugin.getAttributeOrderManager();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        this.setLayout((Layout)gridLayout);
        this.labelPrompt = new Label((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        this.labelPrompt.setLayoutData((Object)gridData);
        this.labelPrompt.setText(" " + this.msgFile.getMessage(t, "UI.TABLES.Scheme.Label"));
        this.labelScheme = new Text((Composite)this, 0);
        UiUtils.makeTextControlReadOnly(t, this.labelScheme, true);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        this.labelScheme.setLayoutData((Object)gridData);
        this.toolBar = new ToolBar((Composite)this, 0x800000);
        this.toolItem = new ToolItem(this.toolBar, 0x800008);
        this.toolItem.setImage(Icons.get(Icons.iconkeyMenuArrow));
        this.toolItem.setToolTipText(this.msgFile.getMessage(t, "UI.TABLES.Scheme.Button"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 2;
        this.toolBar.setLayoutData((Object)gridData);
        this.toolItem.setEnabled(true);
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Trace tr = Trace.getDefault();
                SchemeBar.this.fillSelectMenu(tr, manager);
            }
        });
        this.menuSelect = this.menuManager.createContextMenu((Control)this.toolBar);
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SchemeBar.this.menuSelect.setVisible(true);
            }
        });
        this.toolBar.pack();
        this.toolBar.getAccessible().addAccessibleListener((AccessibleListener)this);
        this.setMenu(this.menuSelect);
        this.labelScheme.setMenu(this.menuSelect);
        this.labelPrompt.setMenu(this.menuSelect);
    }

    private void fillSelectMenu(Trace t, IMenuManager menuMgr) {
        if (this.actionsMostRecentSchemes == null) {
            this.actionsMostRecentSchemes = new Action[5];
            int i = 0;
            while (i < 5) {
                this.actionsMostRecentSchemes[i] = new Action(){

                    public void run() {
                        Trace tr = Trace.getDefault();
                        SchemeBar.this.selectRecentAttributeOrder(tr, this.getId());
                    }
                };
                ++i;
            }
        }
        if (this.actionSelectScheme == null) {
            this.actionSelectScheme = new Action(){

                public void run() {
                    Trace tr = Trace.getDefault();
                    SchemeBar.this.selectScheme(tr);
                }
            };
            this.actionSelectScheme.setText(this.msgFile.getMessage(t, "UI.TABLES.Scheme.Button"));
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionSelectScheme, "com.ibm.mq.explorer.ui.infopop.UI_SelectScheme_MenuItem");
        }
        if (this.actionManageSchemes == null) {
            this.actionManageSchemes = new Action(){

                public void run() {
                    Trace tr = Trace.getDefault();
                    SchemeBar.this.manageAttributeOrders(tr);
                }
            };
            this.actionManageSchemes.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.ManageSchemes"));
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionManageSchemes, "com.ibm.mq.explorer.ui.infopop.UI_ManageScheme_MenuItem");
        }
        if (this.actionEditScheme == null) {
            this.actionEditScheme = new Action(){

                public void run() {
                    Trace tr = Trace.getDefault();
                    SchemeBar.this.editCurrentAttributeOrder(tr);
                }
            };
            this.actionEditScheme.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.EditCurrentScheme"));
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionEditScheme, "com.ibm.mq.explorer.ui.infopop.UI_EditCurrentScheme_MenuItem");
        }
        AttributeOrder[] recentAttrOrders = this.attrOrderManager.getMostRecentlySelectedAttributeOrders(t, this.attrOrderId, 5);
        int i = 0;
        while (i < recentAttrOrders.length) {
            if (recentAttrOrders[i] != null) {
                this.actionsMostRecentSchemes[i].setText(recentAttrOrders[i].getOrderName(t));
                this.actionsMostRecentSchemes[i].setId(recentAttrOrders[i].getOrderName(t));
                UiPlugin.getHelpSystem().setHelp((IAction)this.actionsMostRecentSchemes[i], "com.ibm.mq.explorer.ui.infopop.UI_SuppliedScheme_MenuItem");
                menuMgr.add((IAction)this.actionsMostRecentSchemes[i]);
            }
            ++i;
        }
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.actionSelectScheme);
        menuMgr.add((IAction)this.actionManageSchemes);
        if (this.currentAttributeOrder != null) {
            menuMgr.add((IAction)this.actionEditScheme);
        }
        if (this.additionalActions != null) {
            i = 0;
            while (i < this.additionalActions.size()) {
                Action action = this.additionalActions.get(i);
                menuMgr.add((IAction)action);
                ++i;
            }
        }
    }

    public void setInstance(Trace t, String instId, boolean isSecondary) {
        this.instanceId = instId;
        this.isSecondaryOrder = isSecondary;
        this.showCurrentSchemeName(t);
    }

    public void setScheme(Trace t, AttributeOrder attrOrder) {
        this.currentAttributeOrder = attrOrder;
        this.attrOrderId = this.currentAttributeOrder.getOrderId();
        this.showCurrentSchemeName(t);
    }

    private void selectScheme(Trace t) {
        SelectAttributeOrderDialog selAttrOrderDlg = new SelectAttributeOrderDialog(this.getShell(), 0);
        selAttrOrderDlg.setValues(t, this.attrOrderId, this.instanceId, this.isSecondaryOrder);
        selAttrOrderDlg.create(t);
        selAttrOrderDlg.open(t);
    }

    private void showCurrentSchemeName(Trace t) {
        String fullName = "";
        String name1 = this.currentAttributeOrder.getOrderName(t);
        if (this.currentAttributeOrder.isDualOrder()) {
            String name2 = this.currentAttributeOrder.getDualOrderName(t, this.isSecondaryOrder);
            fullName = Message.format((String)this.msgFile.getMessage(t, "UI.SCHEMES.SchemeBar.SchemeName"), (String)name1, (String)name2);
        } else {
            fullName = name1;
        }
        this.labelScheme.setText(fullName);
        this.layout();
    }

    private void manageAttributeOrders(Trace t) {
        AttributeOrder attrOrder;
        ManageAttributeOrdersDialog manageAttrOrdersDlg = new ManageAttributeOrdersDialog(this.getShell(), 0);
        manageAttrOrdersDlg.setValues(t, this.attrOrderId, this.instanceId);
        manageAttrOrdersDlg.setSecondaryOrder(this.isSecondaryOrder);
        manageAttrOrdersDlg.create(t);
        if (manageAttrOrdersDlg.open(t) && (attrOrder = manageAttrOrdersDlg.getSelectedAttrOrder()) != null) {
            this.attrOrderManager.setSelectedAttrOrder(t, this.attrOrderId, this.instanceId, attrOrder, true, false);
            this.showCurrentSchemeName(t);
        }
    }

    private void editCurrentAttributeOrder(Trace t) {
        boolean editName = !this.currentAttributeOrder.isDefaultOrder();
        ArrayList<AttributeOrder> attrOrdersArray = this.attrOrderManager.getAvailableAttributeOrders(t, this.attrOrderId);
        EditAttributeOrderDialog editAttrOrderDlg = new EditAttributeOrderDialog(this.getShell(), 0);
        AttributeOrder dfltAttrOrder = this.attrOrderManager.getDefaultAttributeOrder(t, this.attrOrderId);
        editAttrOrderDlg.setValues(t, this.currentAttributeOrder, dfltAttrOrder, editName, false, attrOrdersArray);
        editAttrOrderDlg.create(t);
        editAttrOrderDlg.setManagerSaveOnOKMode(t, this.attrOrderManager, this.attrOrderId);
        if (this.isSecondaryOrder) {
            editAttrOrderDlg.selectSecondaryOrder(t);
        }
        if (editAttrOrderDlg.open(t)) {
            this.showCurrentSchemeName(t);
        }
    }

    private void selectRecentAttributeOrder(Trace t, String name) {
        ArrayList<AttributeOrder> attrOrders = this.attrOrderManager.getAvailableAttributeOrders(t, this.attrOrderId);
        int i = 0;
        while (i < attrOrders.size()) {
            AttributeOrder attrOrder = attrOrders.get(i);
            if (attrOrder.getOrderName(t).compareTo(name) == 0) {
                this.attrOrderManager.setSelectedAttrOrder(t, this.attrOrderId, this.instanceId, attrOrder, true, true);
                this.showCurrentSchemeName(t);
                break;
            }
            ++i;
        }
    }

    public void addAdditionalMenuAction(Trace t, Action action) {
        if (this.additionalActions == null) {
            this.additionalActions = new ArrayList();
        }
        this.additionalActions.add(action);
    }

    public void getName(AccessibleEvent e) {
        e.result = this.msgFile.getMessage(Trace.getDefault(), "UI.TABLES.Scheme.Button");
    }

    public void getHelp(AccessibleEvent e) {
    }

    public void getKeyboardShortcut(AccessibleEvent e) {
    }

    public void getDescription(AccessibleEvent e) {
        e.result = "";
    }
}

