/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.filters.EditFilterDialog;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterManager;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.filters.ManageFiltersDialog;
import com.ibm.mq.explorer.ui.internal.filters.SelectFilterDialog;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FilterBar
extends Composite
implements AccessibleListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/explorertable/FilterBar.java";
    private static final int MOST_RECENT_COUNT = 10;
    private Label labelPrompt = null;
    private Text labelFilter = null;
    private ToolBar toolBar = null;
    private ToolItem toolItem = null;
    private Menu menuSelect = null;
    private MenuManager menuManager = null;
    private Action[] actionsMostRecentFilters = null;
    private Action actionSelectFilter = null;
    private Action actionManageFilters = null;
    private Action actionEditFilter = null;
    private FilterManager filterManager = null;
    private Filter currentFilter = null;
    private String filterId = "";
    private String instanceId = null;
    private FilterProvider filterProvider = null;
    private boolean filteringAvailable = true;
    private Message msgFile = null;

    public FilterBar(Trace t, Composite parent, int style) {
        super(parent, style);
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Tables");
        this.filterManager = UiPlugin.getFilterManager();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        this.setLayout((Layout)gridLayout);
        this.labelPrompt = new Label((Composite)this, 0);
        this.labelPrompt.setEnabled(false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        this.labelPrompt.setLayoutData((Object)gridData);
        this.labelPrompt.setText(" " + this.msgFile.getMessage(t, "UI.TABLES.Filter.Label"));
        this.labelFilter = new Text((Composite)this, 0);
        UiUtils.makeTextControlReadOnly(t, this.labelFilter, true);
        this.labelFilter.setEnabled(false);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        this.labelFilter.setLayoutData((Object)gridData);
        this.toolBar = new ToolBar((Composite)this, 0x800000);
        this.toolItem = new ToolItem(this.toolBar, 0x800008);
        this.toolItem.setImage(Icons.get(Icons.iconkeyMenuArrow));
        this.toolItem.setToolTipText(this.msgFile.getMessage(t, "UI.TABLES.Filter.Button"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 2;
        this.toolBar.setLayoutData((Object)gridData);
        this.toolItem.setEnabled(false);
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Trace tr = Trace.getDefault();
                FilterBar.this.fillSelectMenu(tr, manager);
            }
        });
        this.menuSelect = this.menuManager.createContextMenu((Control)this.toolBar);
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = FilterBar.this.toolItem.getBounds();
                Point pt = new Point(rect.x + rect.width, rect.y + rect.height);
                pt = FilterBar.this.toolBar.toDisplay(pt);
                FilterBar.this.menuSelect.setLocation(pt.x, pt.y);
                FilterBar.this.menuSelect.setVisible(true);
            }
        });
        this.toolBar.pack();
        this.toolBar.getAccessible().addAccessibleListener((AccessibleListener)this);
        this.setMenu(this.menuSelect);
        this.labelFilter.setMenu(this.menuSelect);
        this.labelPrompt.setMenu(this.menuSelect);
    }

    private void fillSelectMenu(Trace t, IMenuManager menuMgr) {
        if (this.actionsMostRecentFilters == null) {
            this.actionsMostRecentFilters = new Action[10];
            int i = 0;
            while (i < 10) {
                this.actionsMostRecentFilters[i] = new Action(){

                    public void run() {
                        Trace tr = Trace.getDefault();
                        FilterBar.this.selectRecentFilter(tr, this.getId());
                    }
                };
                ++i;
            }
        }
        if (this.actionSelectFilter == null) {
            this.actionSelectFilter = new Action(){

                public void run() {
                    Trace tr = Trace.getDefault();
                    FilterBar.this.selectFilter(tr);
                }
            };
            this.actionSelectFilter.setText(this.msgFile.getMessage(t, "UI.TABLES.Filter.Button"));
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionSelectFilter, "com.ibm.mq.explorer.ui.infopop.UI_SelectFilter_MenuItem");
        }
        if (this.actionManageFilters == null) {
            this.actionManageFilters = new Action(){

                public void run() {
                    Trace tr = Trace.getDefault();
                    FilterBar.this.manageFilters(tr);
                }
            };
            this.actionManageFilters.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.ManageFilters"));
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionManageFilters, "com.ibm.mq.explorer.ui.infopop.UI_ManageFilter_MenuItem");
        }
        if (this.actionEditFilter == null) {
            this.actionEditFilter = new Action(){

                public void run() {
                    Trace tr = Trace.getDefault();
                    FilterBar.this.editCurrentFilter(tr);
                }
            };
            this.actionEditFilter.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.EditCurrentFilter"));
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionEditFilter, "com.ibm.mq.explorer.ui.infopop.UI_EditCurrentFilter_MenuItem");
        }
        Filter[] recentFilters = this.filterManager.getMostRecentlySelectedFilters(t, this.filterId, 10);
        int i = 0;
        while (i < recentFilters.length) {
            if (recentFilters[i] != null) {
                this.actionsMostRecentFilters[i].setText(recentFilters[i].getFilterName());
                this.actionsMostRecentFilters[i].setId(recentFilters[i].getFilterName());
                UiPlugin.getHelpSystem().setHelp((IAction)this.actionsMostRecentFilters[i], "com.ibm.mq.explorer.ui.infopop.UI_SuppliedFilter_MenuItem");
                menuMgr.add((IAction)this.actionsMostRecentFilters[i]);
            }
            ++i;
        }
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.actionSelectFilter);
        menuMgr.add((IAction)this.actionManageFilters);
        if (this.currentFilter != null) {
            if (this.currentFilter.isDefaultFilter()) {
                this.actionEditFilter.setEnabled(false);
            } else {
                this.actionEditFilter.setEnabled(true);
            }
            menuMgr.add((IAction)this.actionEditFilter);
        }
    }

    public void setInstance(Trace t, String filtId, String instId) {
        this.filterId = filtId;
        this.instanceId = instId;
        this.showCurrentFilterName(t);
        this.layout();
    }

    private void showCurrentFilterName(Trace t) {
        this.currentFilter = this.filterManager.getRegisteredCurrentFilter(t, this.filterId, this.instanceId);
        if (this.filteringAvailable) {
            if (this.currentFilter != null) {
                this.labelFilter.setText(this.currentFilter.getFilterName());
            } else {
                Message msg = UiPlugin.getUIMessages(t, "KEY_Filters");
                this.labelFilter.setText(msg.getMessage(t, "UI.FILTERS.NullFilterName"));
            }
        } else {
            Message msg = UiPlugin.getUIMessages(t, "KEY_Filters");
            this.labelFilter.setText(msg.getMessage(t, "UI.FILTERS.FilterUnavailable"));
        }
        this.toolItem.setEnabled(this.filteringAvailable);
        this.layout();
    }

    private void selectFilter(Trace t) {
        SelectFilterDialog selFilterDlg = new SelectFilterDialog(this.getShell(), 0);
        selFilterDlg.setValues(t, this.filterProvider, this.filterId, this.instanceId);
        selFilterDlg.create(t);
        if (selFilterDlg.open(t)) {
            this.showCurrentFilterName(t);
        }
    }

    private void manageFilters(Trace t) {
        ManageFiltersDialog manageFiltersDlg = new ManageFiltersDialog(this.getShell(), 0);
        manageFiltersDlg.setValues(t, this.filterProvider, this.filterId, this.instanceId);
        manageFiltersDlg.create(t);
        if (manageFiltersDlg.open(t)) {
            Filter filter = manageFiltersDlg.getSelectedFilter();
            if (filter != null && !this.currentFilter.equals(filter)) {
                this.filterManager.setSelectedFilter(t, this.filterId, this.instanceId, filter, true);
            }
            this.showCurrentFilterName(t);
        }
    }

    private void editCurrentFilter(Trace t) {
        boolean editName = !this.currentFilter.isDefaultFilter();
        ArrayList<Filter> filtersArray = this.filterManager.getAvailableFilters(t, this.filterId);
        EditFilterDialog editFilterDlg = new EditFilterDialog(t, this.getShell(), 0);
        editFilterDlg.setValues(t, this.currentFilter, editName, false, filtersArray, this.filterProvider);
        editFilterDlg.create(t);
        editFilterDlg.setManagerSaveOnOKMode(t, this.filterManager, this.filterId);
        if (editFilterDlg.open(t)) {
            this.showCurrentFilterName(t);
        }
    }

    private void selectRecentFilter(Trace t, String name) {
        if (this.currentFilter.getFilterName().compareTo(name) != 0) {
            ArrayList<Filter> filters = this.filterManager.getAvailableFilters(t, this.filterId);
            int i = 0;
            while (i < filters.size()) {
                Filter filter = filters.get(i);
                if (filter.getFilterName().compareTo(name) == 0) {
                    this.filterManager.setSelectedFilter(t, this.filterId, this.instanceId, filter, true);
                    this.showCurrentFilterName(t);
                    break;
                }
                ++i;
            }
        } else if (Trace.isTracing) {
            t.data(67, "FilterBar.selectRecentFilter", 300, "New filter same as current filter : " + name);
        }
    }

    public void setFilterProvider(FilterProvider filterProv) {
        this.filterProvider = filterProv;
        this.labelPrompt.setEnabled(this.filterProvider != null);
        this.labelFilter.setEnabled(this.filterProvider != null);
        this.toolItem.setEnabled(this.filterProvider != null);
        if (filterProv == null) {
            this.filteringAvailable = false;
        }
    }

    public void setFilteringAvailable(Trace t, boolean available) {
        this.filteringAvailable = available;
        this.showCurrentFilterName(t);
    }

    public void getName(AccessibleEvent e) {
        e.result = this.msgFile.getMessage(Trace.getDefault(), "UI.TABLES.Filter.Button");
    }

    public void getHelp(AccessibleEvent e) {
    }

    public void getKeyboardShortcut(AccessibleEvent e) {
    }

    public void getDescription(AccessibleEvent e) {
        e.result = "";
    }
}

