/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrBoolean;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableLabelProvider;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class ExplorerTableLabelProvider
extends ExtTableLabelProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/explorertable/ExplorerTableLabelProvider.java";
    protected AttributeOrder attrOrder = null;
    private int iconAttributeId = -1;
    protected boolean isInstanceSecondary = false;
    protected boolean isTickCrossMode = false;
    private Image imageTick = Icons.get(Icons.iconkeyTick);
    private Image imageCross = Icons.get(Icons.iconkeyCross);

    @Override
    public Image getImageForColumn(Object element, int columnIndex) {
        Trace t = Trace.getDefault();
        Image image = null;
        boolean showImage = false;
        boolean showTickCrossImage = false;
        int attrId = 0;
        if (this.attrOrder != null) {
            UiMQObject uiMQObject = null;
            if (element instanceof UiMQObject) {
                uiMQObject = (UiMQObject)element;
            } else if (element instanceof MQExtObject) {
                MQExtObject mqExtObject = (MQExtObject)element;
                uiMQObject = (UiMQObject)mqExtObject.getInternalObject();
            }
            if (uiMQObject != null) {
                AttributeOrderItem attrOrderItem = this.attrOrder.getAttributeOrderItemFromPosition(t, columnIndex, this.isInstanceSecondary);
                if (attrOrderItem != null) {
                    attrId = attrOrderItem.getAttributeId();
                    if (attrId == this.iconAttributeId) {
                        showImage = true;
                    } else if (this.isTickCrossMode && uiMQObject.isAttributeTypeBoolean(t, attrId)) {
                        showTickCrossImage = true;
                    }
                }
                if (showImage) {
                    uiMQObject.updateIcon();
                    image = uiMQObject.getImage();
                } else if (showTickCrossImage) {
                    Attr attr = uiMQObject.getDmObject().getAttribute(t, attrId, 0);
                    AttrBoolean attrBoolean = (AttrBoolean)attr;
                    Boolean value = (Boolean)attrBoolean.getValue(t);
                    image = value != false ? this.imageTick : this.imageCross;
                }
            }
        }
        return image;
    }

    @Override
    public String getTextForColumn(Object element, int columnIndex) {
        AttributeOrderItem attrOrderItem;
        Trace t = Trace.getDefault();
        String colText = null;
        UiMQObject uiMQObject = null;
        if (element instanceof UiMQObject) {
            uiMQObject = (UiMQObject)element;
        } else if (element instanceof MQExtObject) {
            MQExtObject mqExtObject = (MQExtObject)element;
            uiMQObject = (UiMQObject)mqExtObject.getInternalObject();
        }
        if (uiMQObject != null && this.attrOrder != null && (attrOrderItem = this.attrOrder.getAttributeOrderItemFromPosition(t, columnIndex, this.isInstanceSecondary)) != null) {
            int attrId = attrOrderItem.getAttributeId();
            Attr attr = uiMQObject.getDmObject().getAttribute(t, attrId, 0);
            if (!uiMQObject.isAttributeValidToDisplay(attrId)) {
                colText = null;
            } else if (this.isTickCrossMode && uiMQObject.isAttributeTypeBoolean(t, attrId)) {
                colText = "";
            } else if (attr != null) {
                colText = attr.toString(t);
                if (colText.equals("[not_found]")) {
                    Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
                    colText = msgFile != null ? msgFile.getMessage(t, "UI.GENERAL.NOT.FOUND") : "";
                    if (Trace.isTracing) {
                        t.data(67, "ExplorerTableLabelProvider.getTextForColumn", 900, "no valid string for enum value found for attr: " + attr);
                    }
                }
            } else {
                colText = uiMQObject.getAttributeValue(t, attrOrderItem.getAttributeId());
            }
        }
        if (Trace.isTracing) {
            if (colText != null) {
                t.data(67, "ExplorerTableLabelProvider.getTextForColumn", 300, "Text for cell in column " + columnIndex + ": " + colText);
            } else {
                t.data(67, "ExplorerTableLabelProvider.getTextForColumn", 300, "No text for cell in column " + columnIndex);
            }
        }
        return colText;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void setAttributeOrder(AttributeOrder order) {
        this.attrOrder = order;
    }

    public void setIconAttributeId(int attrId) {
        this.iconAttributeId = attrId;
    }

    public void setInstanceSecondary(boolean isSecondary) {
        this.isInstanceSecondary = isSecondary;
    }

    public void setTickCrossMode(boolean isTickCross, Image imgTick, Image imgCross) {
        this.isTickCrossMode = isTickCross;
        if (imgTick != null) {
            this.imageTick = imgTick;
        }
        if (imgCross != null) {
            this.imageCross = imgCross;
        }
    }
}

