/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableUpdate;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ExplorerTableDMListener
implements DmQueueManagerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/explorertable/ExplorerTableDMListener.java";
    private ExplorerTable explorerTable = null;
    private boolean isListening = false;
    private boolean inUpdate = false;
    private IDmObservable observableObject = null;
    private boolean isSuppressEventsForHiddenQmgrs = true;

    public ExplorerTableDMListener(Trace t, ExplorerTable expTable) {
        this.explorerTable = expTable;
    }

    public boolean startListening(Trace t, IDmObservable observable, DmObjectFilter filter) {
        boolean ret = false;
        if (Trace.isTracing) {
            String traceText = "";
            traceText = filter == null ? "null filter passed OK to start listening call" : "filter passed to start listening call: " + filter.toString(t);
            t.data(67, "ExplorerTableDMListener.startListening", 300, traceText);
        }
        if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.startListening", 300, "starting to listen to: " + observable);
        }
        if (ret = observable.addObserver(t, (DmObjectListener)this, filter)) {
            this.isListening = true;
            this.observableObject = observable;
            if (Trace.isTracing) {
                t.data(67, "ExplorerTableDMListener.startListening", 300, "Listen succesful");
            }
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.startListening", 900, "Failed to add observer to observable object " + observable.getObservableName());
        }
        return ret;
    }

    public boolean stopListening(Trace t, IDmObservable observable) {
        boolean ret = false;
        if (observable != null) {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTableDMListener.stopListening", 300, "stopping listen to: " + observable);
            }
            ret = observable.deleteObserver(t, (DmObjectListener)this);
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.stopListening", 900, "null observable passed in");
        }
        if (ret) {
            this.isListening = false;
            this.observableObject = null;
            if (Trace.isTracing) {
                t.data(67, "ExplorerTableDMListener.stopListening", 300, "Succesfully removed listener");
            }
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.stopListening", 900, "failed to removed listener");
        }
        return ret;
    }

    public void dmObjectAdded(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        String logText = "dmObjectAdded event received - ";
        logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
        logText = String.valueOf(logText) + " name=" + object.toString(t);
        if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.dmObjectAdded", 300, logText);
        }
        t.eventReceived("ExplorerTableDMListener.dmObjectAdded", 2, logText);
        if (!this.inUpdate) {
            this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 8, 5), true, false);
            this.inUpdate = true;
        }
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 1, object), false, false);
    }

    public void dmObjectChanged(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        String logText = "dmObjectChanged event received - ";
        logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
        logText = String.valueOf(logText) + " name=" + object.toString(t);
        if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.dmObjectChanged", 300, logText);
        }
        t.eventReceived("ExplorerTableDMListener.dmObjectChanged", 2, logText);
        if (!this.inUpdate) {
            this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 8, 5), true, false);
            this.inUpdate = true;
        }
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 2, object), false, false);
    }

    public void dmObjectDeleted(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        String logText = "dmObjectDeleted event received - ";
        logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
        logText = String.valueOf(logText) + " name=" + object.toString(t);
        if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.dmObjectDeleted", 300, logText);
        }
        t.eventReceived("ExplorerTableDMListener.dmObjectDeleted", 2, logText);
        if (!this.inUpdate) {
            this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 8, 5), true, false);
            this.inUpdate = true;
        }
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 3, object), false, false);
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        String logText = "dmQmgrConnected event received - ";
        logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
        logText = String.valueOf(logText) + " name=" + object.toString(t);
        if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.dmQueueManagerConnected", 300, logText);
        }
        t.eventReceived("ExplorerTableDMListener.dmQueueManagerConnected", 2, logText);
        boolean isProcessEvent = true;
        if (object instanceof DmQueueManager && this.isSuppressEventsForHiddenQmgrs) {
            isProcessEvent = ((DmQueueManager)object).isVisible(t);
        }
        if (isProcessEvent) {
            this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 2, object), false, false);
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.dmQueueManagerConnected", 300, "connected event suppressed for hidden queue manager '" + object.toString(t) + "'");
        }
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        String logText = "dmQmgrDisconnected event received - ";
        logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
        logText = String.valueOf(logText) + " name=" + object.toString(t);
        if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.dmQueueManagerDisconnected", 300, logText);
        }
        t.eventReceived("ExplorerTableDMListener.dmQueueManagerDisconnected", 2, logText);
        boolean isProcessEvent = true;
        if (object instanceof DmQueueManager && this.isSuppressEventsForHiddenQmgrs) {
            isProcessEvent = ((DmQueueManager)object).isVisible(t);
        }
        if (isProcessEvent) {
            this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 2, object), false, false);
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.dmQueueManagerDisconnected", 300, "disconnected event suppressed for hidden queue manager '" + object.toString(t) + "'");
        }
    }

    public void dmRefreshComplete(DmObjectEvent event) {
        DmObject object;
        Trace t = Trace.getDefault();
        DmCoreException e = event.getException();
        if (e != null) {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTableDMListener.dmRefreshComplete", 900, "refresh completed with unexpected error: cc=" + e.getCompCode() + " rc=" + e.getReasonCode());
            }
            this.displayExceptionErrorMessage(t, e);
            this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 6), true, false);
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.dmRefreshComplete", 300, "refresh completed");
        }
        boolean isProcessEvent = true;
        if (event.getSource() instanceof DmObject && (object = (DmObject)event.getSource()) != null && object instanceof DmQueueManager && this.isSuppressEventsForHiddenQmgrs) {
            isProcessEvent = ((DmQueueManager)object).isVisible(t);
        }
        if (isProcessEvent) {
            this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 7), true, false);
        } else if (Trace.isTracing && event.getSource() instanceof DmObject) {
            object = (DmObject)event.getSource();
            t.data(67, "ExplorerTableDMListener.dmRefreshComplete", 300, "refreshComplete event suppressed for hidden queue manager '" + object.toString(t) + "'");
        }
    }

    public void dmObjectListDone(DmObjectListEvent event) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.dmObjectListDone", 900, "unexpected dmObjectListDone ignored");
        }
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        String logText = "dmQmgrConnecting event received - ";
        logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
        logText = String.valueOf(logText) + " name=" + object.toString(t);
        t.eventReceived("ExplorerTableDMListener.dmQueueManagerConnecting", 2, logText);
        boolean isProcessEvent = true;
        if (object instanceof DmQueueManager && this.isSuppressEventsForHiddenQmgrs) {
            isProcessEvent = ((DmQueueManager)object).isVisible(t);
        }
        if (isProcessEvent) {
            this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 2, object), false, false);
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.dmQueueManagerConnecting", 300, "connecting event suppressed for hidden queue manager '" + object.toString(t) + "'");
        }
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
        DmCoreException e;
        final Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "ExplorerTableDMListener.dmObjectSummary", 300, "count = " + event.getCount());
        }
        if ((e = event.getException()) != null) {
            switch (e.getReasonCode()) {
                case 2009: 
                case 2033: 
                case 2322: {
                    if (Trace.isTracing) {
                        t.data(67, "ExplorerTableDMListener.dmObjectSummary", 900, "dmObjectSummary with connection or timeout error, stop listening");
                    }
                    if (UiPlugin.isShutdownInProgress()) break;
                    UiPlugin.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ExplorerTableDMListener.this.explorerTable.isDisposed()) {
                                if (ExplorerTableDMListener.this.isListening) {
                                    ExplorerTableDMListener.this.explorerTable.stopListener(t, ExplorerTableDMListener.this.observableObject);
                                }
                                ExplorerTableDMListener.this.explorerTable.removeAll(t);
                            }
                        }
                    });
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(67, "ExplorerTableDMListener.dmObjectSummary", 900, "dmObjectSummary with unexpected error: cc=" + e.getCompCode() + " rc=" + e.getReasonCode());
                    }
                    this.displayExceptionErrorMessage(t, e);
                    this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 6), true, false);
                }
            }
        }
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 8, 4), false, false);
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 5), true, false);
        this.inUpdate = false;
    }

    private void displayExceptionErrorMessage(final Trace t, final DmCoreException e) {
        if (!UiPlugin.isShutdownInProgress()) {
            UiPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ExplorerTableDMListener.this.explorerTable.isDisposed() && ExplorerTableDMListener.this.explorerTable.isShowListenerExceptions()) {
                        Shell msgShell = null;
                        try {
                            msgShell = ExplorerTableDMListener.this.explorerTable.getShell();
                        }
                        catch (Exception exception) {
                            msgShell = null;
                        }
                        if (msgShell == null) {
                            msgShell = UiPlugin.getShell();
                        }
                        MessageBox.showExceptionMessage(t, msgShell, e);
                    }
                }
            });
        }
    }

    public void setSuppressEventsForHiddenQmgrs(boolean suppress) {
        this.isSuppressEventsForHiddenQmgrs = suppress;
    }
}

