/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.comparewith.CompareWithProvider;
import com.ibm.mq.explorer.ui.internal.comparewith.ObjectDifferenceDialog;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

public class ExplorerTableContextMenuListener
implements IMenuListener {
    private ExplorerTable explorerTable;
    private Action actionCompare = null;
    private Object contextObject;

    public ExplorerTableContextMenuListener(ExplorerTable explorerTable, Object contextObject) {
        this.explorerTable = explorerTable;
        this.contextObject = contextObject;
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.fillTableContextMenu(manager);
        IContributionItem[] contributions = manager.getItems();
        if (contributions.length == 0) {
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IContributionItem)new GroupMarker("additions_p2"));
        }
    }

    private void fillTableContextMenu(IMenuManager manager) {
        List<UiMQObject> selList = this.explorerTable.getSelectedItems();
        UiMQObject selObject = null;
        if (selList.size() > 0) {
            CompareWithProvider uiCompareWithProvider;
            boolean isSingle;
            selObject = selList.get(0);
            boolean bl = isSingle = selList.size() == 1;
            if (this.actionCompare == null) {
                this.actionCompare = new CompareAction();
                this.actionCompare.setText(ExplorerTable.nlsCompareWith);
                UiPlugin.getHelpSystem().setHelp((IAction)this.actionCompare, "com.ibm.mq.explorer.ui.infopop.UI_CompareWithMenuItem");
            }
            if ((uiCompareWithProvider = selObject.getCompareWithProvider(Trace.getDefault())) != null && uiCompareWithProvider.isSupportCompareWith()) {
                manager.add((IAction)this.actionCompare);
                manager.add((IContributionItem)new Separator("com.ibm.mq.explorer.comparewith"));
            }
            selObject.appendToContextMenu(this.explorerTable.getShell(), manager, this.contextObject);
            IContributionItem[] citems = manager.getItems();
            int i = 0;
            while (i < citems.length) {
                if (citems[i] instanceof ActionContributionItem) {
                    IAction action = ((ActionContributionItem)citems[i]).getAction();
                    boolean enable = isSingle;
                    if (action instanceof CompareAction) {
                        enable = isSingle || selList.size() == 2;
                    }
                    action.setEnabled(enable);
                } else if (citems[i] instanceof MenuManager) {
                    IContributionItem[] subitems = ((MenuManager)citems[i]).getItems();
                    int j = 0;
                    while (j < subitems.length) {
                        if (subitems[j] instanceof ActionContributionItem) {
                            IAction action = ((ActionContributionItem)subitems[j]).getAction();
                            action.setEnabled(isSingle);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            manager.add((IContributionItem)new Separator("com.ibm.mq.explorer.explorertable"));
        }
    }

    private void compareWith() {
        List<UiMQObject> selUiMQObjects = this.explorerTable.getSelectedItems();
        Trace t = Trace.getDefault();
        if (selUiMQObjects.size() == 1) {
            UiMQObject selUiMQObject = selUiMQObjects.get(0);
            if (selUiMQObject != null) {
                ObjectDifferenceDialog objectDifferenceDialog = new ObjectDifferenceDialog(this.explorerTable.getShell());
                AttributeOrder fullAttrOrder = UiPlugin.getAttributeOrderManager().getFullAttributeOrder(t, this.explorerTable.getOrderId());
                objectDifferenceDialog.setAttributeOrder(fullAttrOrder);
                objectDifferenceDialog.setObjectWithChoice(t, selUiMQObject, null, this.explorerTable.getParentObjectForFactory());
                objectDifferenceDialog.setTickCrossMode(this.explorerTable.isTickCrossMode(), this.explorerTable.getImageTick(), this.explorerTable.getImageCross());
                objectDifferenceDialog.open();
            }
        } else if (selUiMQObjects.size() > 1) {
            UiMQObject selUiMQObject1 = selUiMQObjects.get(0);
            UiMQObject selUiMQObject2 = selUiMQObjects.get(1);
            if (selUiMQObject1 != null && selUiMQObject2 != null) {
                ObjectDifferenceDialog objectDifferenceDialog = new ObjectDifferenceDialog(this.explorerTable.getShell());
                AttributeOrder fullAttrOrder = UiPlugin.getAttributeOrderManager().getFullAttributeOrder(t, this.explorerTable.getOrderId());
                objectDifferenceDialog.setAttributeOrder(fullAttrOrder);
                objectDifferenceDialog.multiSelectCompareWithChoice(t, selUiMQObject1, selUiMQObject1.toFormattedString(), selUiMQObject2, selUiMQObject2.toFormattedString());
                objectDifferenceDialog.setTickCrossMode(this.explorerTable.isTickCrossMode(), this.explorerTable.getImageTick(), this.explorerTable.getImageCross());
                objectDifferenceDialog.open();
            }
        }
    }

    private class CompareAction
    extends Action {
        private CompareAction() {
        }

        public void run() {
            ExplorerTableContextMenuListener.this.compareWith();
        }
    }
}

