/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObjectLink;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objects.UiObject;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ExplorerTableContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/explorertable/ExplorerTableContentProvider.java";
    private ArrayList objectArray = null;
    private Hashtable<IDmObject, UiMQObject> hashTable = null;
    private boolean isTableTreeMode = false;
    private IUiMQObjectFactory uiMQObjectFactory = null;
    private UiMQObject parentObjectForFactory = null;

    public ExplorerTableContentProvider(Trace t, Hashtable<IDmObject, UiMQObject> hashtable, boolean isTableTree) {
        this.hashTable = hashtable;
        this.isTableTreeMode = isTableTree;
    }

    public Object[] getElements(Object inputElement) {
        Trace t = Trace.getDefault();
        ArrayList<MQExtObject> retElements = new ArrayList<MQExtObject>();
        ArrayList<MQExtObject> extElements = new ArrayList<MQExtObject>();
        if (this.objectArray != null) {
            int i = 0;
            while (i < this.objectArray.size()) {
                Object object = this.objectArray.get(i);
                MQExtObject mqExtObject = null;
                if (object instanceof UiMQObject) {
                    UiMQObject uiMQObject = (UiMQObject)object;
                    mqExtObject = uiMQObject.getExternalObject();
                } else if (object instanceof MQExtObject) {
                    mqExtObject = (MQExtObject)object;
                }
                if (mqExtObject != null) {
                    extElements.add(mqExtObject);
                    if (this.isTableTreeMode) {
                        IDmObject dmObj = ((UiMQObject)mqExtObject.getInstanceId()).getDmObject();
                        if (dmObj instanceof IDmObjectLink) {
                            if (((IDmObjectLink)dmObj).getParent(t) == null) {
                                retElements.add(mqExtObject);
                            }
                        } else {
                            retElements.add(mqExtObject);
                        }
                    } else {
                        retElements.add(mqExtObject);
                    }
                }
                ++i;
            }
        }
        int size = retElements.size();
        return retElements.toArray(new MQExtObject[size]);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ArrayList) {
            this.objectArray = (ArrayList)newInput;
        }
    }

    public Object[] getChildren(Object parentElement) {
        IDmObjectLink[] childObjectLinks;
        Trace t = Trace.getDefault();
        MQExtObject[] children = null;
        ArrayList<MQExtObject> mqExtObjectChildren = new ArrayList<MQExtObject>();
        IDmObject dmObject = this.getDmObjectFromObject(t, parentElement);
        if (dmObject != null && dmObject instanceof IDmObjectLink && (childObjectLinks = ((IDmObjectLink)dmObject).getChildren(t)) != null) {
            int i = 0;
            while (i < childObjectLinks.length) {
                IDmObjectLink childObjectLink = childObjectLinks[i];
                UiObject uiChild = null;
                if (childObjectLink instanceof IDmObject) {
                    IDmObject childObject = (IDmObject)childObjectLink;
                    uiChild = this.hashTable.get(childObject);
                    if (uiChild == null) {
                        if (Trace.isTracing) {
                            t.data(67, "ExplorerTableContentProvider.getChildren", 300, "DmObject added, does not exist in table, trying to create using factory");
                        }
                        if (this.uiMQObjectFactory != null) {
                            uiChild = this.uiMQObjectFactory.create(t, childObject, this.parentObjectForFactory);
                            if (uiChild == null) {
                                if (Trace.isTracing) {
                                    t.data(67, "ExplorerTableContentProvider.getChildren", 900, "failed to create uiMQObject from factory for IDmObject '" + childObject + "'");
                                }
                            } else {
                                this.hashTable.put(childObject, (UiMQObject)uiChild);
                            }
                        } else if (Trace.isTracing) {
                            t.data(67, "ExplorerTableContentProvider.getChildren", 900, "No object factory, unable to make UiMQObject from IDmObject '" + childObject + "'");
                        }
                    }
                } else if (Trace.isTracing) {
                    t.data(67, "ExplorerTableContentProvider.getChildren", 900, "Object '" + childObjectLink + "' is not an IDmObject, unable to make UiMQObject from it");
                }
                if (uiChild != null) {
                    mqExtObjectChildren.add(uiChild.getExternalObject());
                }
                ++i;
            }
            children = mqExtObjectChildren.toArray(new MQExtObject[mqExtObjectChildren.size()]);
        }
        return children;
    }

    private IDmObject getDmObjectFromObject(Trace t, Object object) {
        IDmObject dmObject = null;
        if (object instanceof MQExtObject) {
            UiMQObject uiMQObject = (UiMQObject)((MQExtObject)object).getInstanceId();
            dmObject = uiMQObject.getDmObject();
        } else if (object instanceof UiMQObject) {
            dmObject = ((UiMQObject)object).getDmObject();
        } else if (object instanceof IDmObject) {
            dmObject = (IDmObject)object;
        }
        return dmObject;
    }

    public Object getParent(Object element) {
        Trace t = Trace.getDefault();
        IDmObjectLink parent = null;
        IDmObject dmObject = this.getDmObjectFromObject(t, element);
        if (dmObject != null && dmObject instanceof IDmObjectLink) {
            parent = ((IDmObjectLink)dmObject).getParent(t);
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        Object[] children = this.getChildren(element);
        if (children != null && children.length > 0) {
            hasChildren = true;
        }
        return hasChildren;
    }

    public void setUiMQObjectFactoryClass(Trace t, IUiMQObjectFactory factoryClass, UiMQObject parentToNewObjects) {
        this.uiMQObjectFactory = factoryClass;
        this.parentObjectForFactory = parentToNewObjects;
    }
}

