/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.extensions.IMQExtObjectChangedListener;
import com.ibm.mq.explorer.ui.extensions.IMQExtObjectDeletedListener;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQExtObjectChangedEvent;
import com.ibm.mq.explorer.ui.extensions.MQExtObjectDeletedEvent;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderChangedEvent;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.IAttributeOrderChangedListener;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableColumnManager;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableGreyCellManager;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableLabelProvider;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableViewer;
import com.ibm.mq.explorer.ui.internal.explorertable.CompareColumnItems;
import com.ibm.mq.explorer.ui.internal.explorertable.CopyTableAction;
import com.ibm.mq.explorer.ui.internal.explorertable.DeleteTableObjectAction;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentProvider;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContextMenuListener;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableDMListener;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableLabelProvider;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSystemObjectsFilter;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableUpdate;
import com.ibm.mq.explorer.ui.internal.explorertable.FilterBar;
import com.ibm.mq.explorer.ui.internal.explorertable.SchemeBar;
import com.ibm.mq.explorer.ui.internal.explorertable.StatusBar;
import com.ibm.mq.explorer.ui.internal.explorertable.TableColumnControlAdapter;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterChangedEvent;
import com.ibm.mq.explorer.ui.internal.filters.FilterManager;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.filters.IFilterChangedListener;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.IQueueManagerDisconnectActionListener;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerDisconnectActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class ExplorerTable
extends Composite
implements IMQExtObjectChangedListener,
IMQExtObjectDeletedListener,
IAttributeOrderChangedListener,
IFilterChangedListener,
DisposeListener,
IQueueManagerDisconnectActionListener,
IPropertyChangeListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/explorertable/ExplorerTable.java";
    public static final int TABLE_TYPE_TABLE = 0;
    public static final int TABLE_TYPE_TABLETREE = 1;
    public static final int TABLE_TYPE_CHECKBOXTABLE = 2;
    public static final int ALL_LEVELS = -1;
    private static final double MAX_COLUMN_WIDTH_PERCENT = 0.5;
    public static final int TABLE_LOADING = 1;
    public static final int TABLE_CLEARING = 2;
    public static final int TABLE_RETRIEVING = 3;
    public static final int TABLE_NONE = 4;
    public static final int TABLE_REFRESHING = 5;
    private ExtTableViewer tableViewer = null;
    private Table table = null;
    private ExplorerTableContentProvider contentProvider = null;
    private ExplorerTableLabelProvider labelProvider = null;
    private ExtTableColumnManager columnManager = null;
    private ExplorerTableSystemObjectsFilter systemObjectsFilter = null;
    private ViewPart explorerViewPart = null;
    private String orderId = null;
    private AttributeOrder attrOrder = null;
    private ArrayList<TableColumn> tableColumns = null;
    private ArrayList<UiMQObject> items = null;
    private CompareColumnItems compareItems = null;
    private FilterBar filterBar = null;
    private SchemeBar schemeBar = null;
    private StatusBar statusBar = null;
    private Vector<ExplorerTableSelectionChangedListener> selChangedListeners = null;
    private Vector<ExplorerTableContentChangedListener> contentChangedListeners = null;
    private ExplorerTableDMListener explorerTableDMListener = null;
    private FilterManager filterManager = null;
    private AttributeOrderManager attrOrderManager = null;
    private String filterId = "";
    private String instanceId = null;
    private boolean isInstanceSecondary = false;
    private String objectId = "";
    private String objectName = "";
    private boolean isFilterBar = true;
    private boolean isStatusBar = true;
    private boolean isSchemeBar = true;
    private boolean enableContextMenu = true;
    private IUiMQObjectFactory uiMQObjectFactory = null;
    private UiMQObject parentObjectForFactory = null;
    private MenuManager menuMgr = null;
    private boolean contextMenuRegistered = false;
    protected static String nlsCompareWith = "";
    private static String nlsClearing = "";
    private static String nlsLoading = "";
    private static String nlsRetrievingData = "";
    private static String nlsRefreshing = "";
    private Hashtable<IDmObject, UiMQObject> hashtable = null;
    private int updateCounter = 0;
    private FilterProvider filterProvider = null;
    private boolean isDMListenerUpdate = false;
    private Integer filterQSGDisposition = null;
    private Message msgFile = null;
    private boolean isTableRedraw = true;
    private Object contextObject = null;
    private boolean isInitialResize = true;
    private List<ExplorerTableUpdate> listUpdateQueue = null;
    private boolean isUpdateQueueActive = false;
    private int updatesSinceNotify = 0;
    private int updateBatchSize = 100;
    private boolean isInitialUpdate = true;
    private boolean isShowListenerExceptions = true;
    private boolean isEndUpdateTimerRunning = false;
    private boolean restartEndUpdateTimer = false;
    private static final int END_UPDATE_TIMER_DELAY = 500;
    private boolean isTickCrossMode = false;
    private Image imageTick = null;
    private Image imageCross = null;
    private String preselectObjectName = null;
    private StructuredSelection preSelection = null;
    private int tableType = 0;
    private boolean isColumnUpdate = false;
    private boolean isEnabled = true;
    private boolean isListening = false;
    private IDmObservable observableObject = null;
    private boolean isAttrOrderCloned = false;
    private MQExtObject[] preCheckedObjects = null;
    private ArrayList<MQExtObject> objectsToPreCheck = null;
    private boolean isClientFiltering = false;
    private Filter clientFilter = null;
    private boolean isSuppressColumnResizing = false;
    private Date lastUpdateDate = null;
    private boolean isBusyCursorSet = false;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    private Clipboard fClipboard;
    private CopyTableAction copyAction;
    private DeleteTableObjectAction deleteAction;
    private Action selectAllAction;
    private ExplorerTableContextMenuListener contextMenuListener = null;

    public ExplorerTable(Trace t, Composite parent, int style, String objName, boolean showFilterBar, boolean showSchemeBar, boolean showStatusBar, boolean contextMenu, Object contextObj) {
        super(parent, style);
        this.createTable(t, parent, style, objName, showFilterBar, showSchemeBar, showStatusBar, contextMenu, contextObj, 0, null, true);
    }

    public ExplorerTable(Trace t, Composite parent, int style, String objName, boolean showFilterBar, boolean showSchemeBar, boolean showStatusBar, boolean contextMenu, Object contextObj, int tableType, ExplorerTableLabelProvider labelProvider, boolean multiSelection) {
        super(parent, style);
        this.createTable(t, parent, style, objName, showFilterBar, showSchemeBar, showStatusBar, contextMenu, contextObj, tableType, labelProvider, multiSelection);
    }

    private void createTable(Trace t, Composite parent, int style, String objName, boolean showFilterBar, boolean showSchemeBar, boolean showStatusBar, boolean contextMenu, Object contextObj, int tabType, ExplorerTableLabelProvider tableLabelProvider, boolean multiSelection) {
        GridData gridData;
        this.selChangedListeners = new Vector();
        this.contentChangedListeners = new Vector();
        this.listUpdateQueue = Collections.synchronizedList(new LinkedList());
        this.explorerTableDMListener = new ExplorerTableDMListener(t, this);
        this.isUpdateQueueActive = false;
        this.attrOrderManager = UiPlugin.getAttributeOrderManager();
        this.filterManager = UiPlugin.getFilterManager();
        this.contextObject = contextObj;
        this.updateBatchSize = UiPlugin.getExplorerTableUpdateBatchSize();
        this.objectName = objName;
        this.isFilterBar = showFilterBar;
        this.isStatusBar = showStatusBar;
        this.isSchemeBar = showSchemeBar;
        this.enableContextMenu = contextMenu;
        this.tableType = tabType;
        this.tableColumns = new ArrayList();
        this.items = new ArrayList();
        this.hashtable = new Hashtable();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Tables");
        nlsCompareWith = this.msgFile.getMessage(t, "UI.TABLES.Table.CompareWith");
        nlsClearing = this.msgFile.getMessage(t, "UI.TABLES.Table.Clearing");
        nlsLoading = this.msgFile.getMessage(t, "UI.TABLES.Table.Loading");
        nlsRetrievingData = this.msgFile.getMessage(t, "UI.TABLES.Table.Retrieving");
        nlsRefreshing = this.msgFile.getMessage(t, "UI.TABLES.Table.Refreshing");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)gridLayout);
        if (showFilterBar) {
            this.filterBar = new FilterBar(t, this, 2048);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            this.filterBar.setLayoutData(gridData);
        }
        Composite compTable = new Composite((Composite)this, 0);
        FillLayout fillLayout = new FillLayout();
        compTable.setLayout((Layout)fillLayout);
        this.tableViewer = new ExtTableViewer(compTable, (multiSelection ? 2 : 4) | 0x10000 | 0x800, tabType);
        this.table = this.tableViewer.getTable();
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumHeight = 3 * this.table.getItemHeight() + this.table.getHeaderHeight();
        compTable.setLayoutData((Object)gridData);
        this.contentProvider = new ExplorerTableContentProvider(t, this.hashtable, tabType == 1);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = tableLabelProvider == null ? new ExplorerTableLabelProvider() : tableLabelProvider;
        this.fClipboard = new Clipboard(this.table.getDisplay());
        this.copyAction = new CopyTableAction(this.tableViewer, this.fClipboard);
        this.deleteAction = new DeleteTableObjectAction(this, this.tableViewer);
        this.selectAllAction = new Action(){

            public void run() {
                ExplorerTable.this.table.selectAll();
                ExplorerTable.this.deleteAction.selectionChanged((IStructuredSelection)ExplorerTable.this.tableViewer.getSelection());
            }
        };
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.compareItems = new CompareColumnItems(this.table);
        this.setSorterFromPreference();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IViewSite viewSite;
                if (ExplorerTable.this.table.getSelectionIndices().length == 0 && ExplorerTable.this.table.getItems().length > 0) {
                    ExplorerTable.this.table.setSelection(ExplorerTable.this.table.getTopIndex());
                    List<UiMQObject> selObjects = ExplorerTable.this.getSelectedItems();
                    if (selObjects != null && selObjects.size() > 0) {
                        ExplorerTable.this.sendSelectionChangedEvent(Trace.getDefault(), selObjects);
                    }
                }
                if (ExplorerTable.this.explorerViewPart != null && (viewSite = ExplorerTable.this.explorerViewPart.getViewSite()) != null) {
                    IActionBars bars = viewSite.getActionBars();
                    bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)ExplorerTable.this.selectAllAction);
                    bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)ExplorerTable.this.copyAction);
                    bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)ExplorerTable.this.deleteAction);
                    bars.updateActionBars();
                }
            }

            public void focusLost(FocusEvent e) {
                IViewSite viewSite;
                if (ExplorerTable.this.explorerViewPart != null && (viewSite = ExplorerTable.this.explorerViewPart.getViewSite()) != null) {
                    IActionBars bars = viewSite.getActionBars();
                    bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
                    bars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
                    bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
                    bars.updateActionBars();
                }
            }
        });
        this.addTableSelectionListeners(t);
        this.tableViewer.setInput(this.items);
        this.columnManager = new ExtTableColumnManager(t, this.tableViewer, this.labelProvider, false);
        this.columnManager.setViewerSorter(t, this.compareItems, false);
        this.columnManager.setMaximumColumnWidthPercent(t, 0.5);
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Trace tr = Trace.getDefault();
                if (!ExplorerTable.this.isSuppressColumnResizing) {
                    ExplorerTable.this.resizeTableColumns(tr, !ExplorerTable.this.isInitialResize);
                    ExplorerTable.this.isInitialResize = false;
                }
            }
        });
        this.table.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeiconified(ShellEvent e) {
                Trace tr = Trace.getDefault();
                if (Trace.isTracing) {
                    tr.data(67, "ExplorerTable.createTable", 300, "shell de-iconified - repainting");
                }
                ExplorerTable.this.repaint();
            }
        });
        if (this.enableContextMenu) {
            this.hookTableContextMenu(t);
        }
        if (this.isSchemeBar) {
            this.schemeBar = new SchemeBar(t, this, 2048);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            this.schemeBar.setLayoutData(gridData);
            Action actionResetWidths = new Action(){

                public void run() {
                    Trace tr = Trace.getDefault();
                    ExplorerTable.this.resetColumnWidths(tr);
                }
            };
            actionResetWidths.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.ResetColumnWidths"));
            UiPlugin.getHelpSystem().setHelp((IAction)actionResetWidths, "com.ibm.mq.explorer.ui.infopop.UI_ResetColumnWidthsMenuItem");
            if (ExtTableColumnManager.isGetColumnWidths(t)) {
                this.schemeBar.addAdditionalMenuAction(t, actionResetWidths);
            }
        }
        if (this.isStatusBar) {
            this.statusBar = new StatusBar(t, this, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            this.statusBar.setLayoutData(gridData);
            this.columnManager.setStatusBar(t, this.statusBar);
        }
        UiPlugin.getPrefStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.addDisposeListener(this);
        this.attrOrderManager.addChangedListener(t, this);
        this.filterManager.addChangedListener(t, this);
        UiPlugin.addQueueManagerDisconnectActionListener(t, this);
    }

    private void setSorterFromPreference() {
        IPreferenceStore prefStore = UiPlugin.getPrefStore();
        boolean sortTables = prefStore.getBoolean("SortTables");
        if (sortTables || this.columnManager != null && this.columnManager.isManuallySorted()) {
            this.tableViewer.setSorter(this.compareItems);
        } else {
            this.tableViewer.setSorter(null);
        }
    }

    private void hookTableContextMenu(Trace t) {
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.contextMenuListener = new ExplorerTableContextMenuListener(this, this.contextObject);
        this.menuMgr.addMenuListener((IMenuListener)this.contextMenuListener);
        Menu menu = this.menuMgr.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
        if (this.explorerViewPart != null) {
            this.explorerViewPart.getSite().registerContextMenu(this.menuMgr, this.tableViewer.getSelectionProvider());
            this.contextMenuRegistered = true;
        }
    }

    private void addTableSelectionListeners(Trace t) {
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExplorerTable.this.deleteAction.selectionChanged((IStructuredSelection)ExplorerTable.this.tableViewer.getSelection());
                List<UiMQObject> selObjects = ExplorerTable.this.getSelectedItems();
                if (selObjects != null && selObjects.size() > 0) {
                    ExplorerTable.this.sendSelectionChangedEvent(Trace.getDefault(), selObjects);
                    ExplorerTable.this.preselectObjectName = null;
                    ExplorerTable.this.preSelection = null;
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                UiMQObject selObject = ExplorerTable.this.getSelectedItem(tr);
                if (selObject != null && selObject.isAllowProperties() && ExplorerTable.this.enableContextMenu) {
                    selObject.showProperties(tr, ExplorerTable.this.getParent().getShell());
                }
            }
        });
    }

    private void sendSelectionChangedEvent(Trace t, List<UiMQObject> selObjects) {
        ExplorerTableSelectionChangedEvent selEvent = new ExplorerTableSelectionChangedEvent(this, selObjects);
        int size = this.selChangedListeners.size();
        int i = 0;
        while (i < size) {
            ExplorerTableSelectionChangedListener listener = this.selChangedListeners.elementAt(i);
            listener.selChanged(selEvent);
            ++i;
        }
    }

    public void setViewPart(Trace t, ViewPart part) {
        this.explorerViewPart = part;
        if (this.enableContextMenu && !this.contextMenuRegistered) {
            this.explorerViewPart.getSite().registerContextMenu(this.menuMgr, this.tableViewer.getSelectionProvider());
            this.contextMenuRegistered = true;
        }
        if (this.systemObjectsFilter == null) {
            this.systemObjectsFilter = new ExplorerTableSystemObjectsFilter();
            this.tableViewer.addFilter(this.systemObjectsFilter);
        }
    }

    public void setFilterId(Trace t, String id) {
        this.filterId = id;
        if (this.isFilterBar) {
            this.filterBar.setInstance(t, this.filterId, this.instanceId);
        }
    }

    public void setObjectId(Trace t, String objId) {
        this.objectId = objId;
    }

    public void setAttributeOrderId(Trace t, String id) {
        this.orderId = id;
        AttributeOrder attOrder = null;
        if (this.attrOrderManager.isRegistered(t, this.orderId)) {
            attOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, this.orderId, this.instanceId);
            this.isAttrOrderCloned = false;
        }
        if (attOrder == null) {
            t.FFST(67, "ExplorerTable.setAttributeOrderId", 10, 50020, 0, 0, "Failed to get RegisteredCurrentAttributeOrder", id, this.instanceId);
        } else {
            this.useAttributeOrder(t, attOrder);
        }
    }

    private void useAttributeOrder(Trace t, AttributeOrder attOrder) {
        AttributeOrderItem attrOrderItem;
        int maxPosition = -1;
        this.unhideAllColumns(t);
        this.attrOrder = attOrder;
        this.setTableRedraw(t, false);
        int i = 0;
        while (i < this.attrOrder.size()) {
            attrOrderItem = this.attrOrder.getAttributeOrderItemFromPosition(t, i, this.isInstanceSecondary);
            if (attrOrderItem != null && attrOrderItem.isVisible(this.isInstanceSecondary)) {
                int position = attrOrderItem.getAttributePosition(this.isInstanceSecondary);
                if (position > maxPosition) {
                    maxPosition = position;
                }
                TableColumn tabcol = this.createTableColumn(t, attrOrderItem, position);
                tabcol.setData((Object)attrOrderItem);
                this.tableColumns.add(tabcol);
            }
            ++i;
        }
        i = 0;
        while (i < this.attrOrder.size()) {
            attrOrderItem = this.attrOrder.get(t, i);
            if (!attrOrderItem.isVisible(this.isInstanceSecondary)) {
                TableColumn tabcol = this.createTableColumn(t, attrOrderItem, ++maxPosition);
                this.tableColumns.add(tabcol);
                this.columnManager.setResizingByProgram(true);
                tabcol.setWidth(0);
                attrOrderItem.setWidth(0);
                this.columnManager.setResizingByProgram(false);
                tabcol.setResizable(false);
            }
            ++i;
        }
        this.labelProvider.setAttributeOrder(this.attrOrder);
        if (this.attrOrder.getOrderId() != null) {
            this.labelProvider.setIconAttributeId(this.attrOrderManager.getIconAttributeId(t, this.attrOrder.getOrderId(), this.instanceId));
        } else {
            int attrId = this.attrOrder.getAttributeId(t, 0, false);
            this.labelProvider.setIconAttributeId(attrId);
        }
        if (this.isSchemeBar) {
            this.schemeBar.setScheme(t, this.attrOrder);
        }
        this.columnManager.addColumnSortListeners(t);
        this.columnManager.setResizingByProgram(true);
        this.columnManager.sortOnColumn(t, 0);
        this.columnManager.setResizingByProgram(false);
        this.setTableRedraw(t, true);
    }

    private TableColumn createTableColumn(Trace t, AttributeOrderItem attrOrderItem, int position) {
        TableColumn tabcol = new TableColumn(this.table, 0, position);
        tabcol.setText(attrOrderItem.getAttributeName());
        this.columnManager.setResizingByProgram(true);
        tabcol.setResizable(true);
        tabcol.pack();
        if (!attrOrderItem.isVisible(this.isInstanceSecondary)) {
            tabcol.setWidth(0);
            tabcol.setResizable(false);
            ExplorerTable.trace(t, "ExplorerTable.createTableColumn", "invisible column");
        }
        this.columnManager.setResizingByProgram(false);
        tabcol.setData((Object)attrOrderItem);
        tabcol.addControlListener((ControlListener)new TableColumnControlAdapter(this.columnManager));
        return tabcol;
    }

    public void setInstance(Trace t, String instId, boolean isSecondary) {
        AttributeOrder attOrder = null;
        boolean isSecondaryChanged = isSecondary ^ this.isInstanceSecondary;
        if (this.isDifferentInstance(t, instId, isSecondary)) {
            this.instanceId = instId;
            this.isInstanceSecondary = isSecondary;
            this.labelProvider.setInstanceSecondary(isSecondary);
            if (this.isFilterBar) {
                this.filterBar.setInstance(t, this.filterId, instId);
            }
            if (this.isSchemeBar) {
                this.schemeBar.setInstance(t, instId, isSecondary);
            }
            this.columnManager.setInstance(t, instId, isSecondary);
            if (this.attrOrderManager.isRegistered(t, this.orderId)) {
                attOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, this.orderId, instId);
                this.isAttrOrderCloned = false;
            }
            if (attOrder == null) {
                t.FFST(67, "ExplorerTable.setInstance", 10, 50020, 0, 0, "Failed to get RegisteredCurrentAttributeOrder", this.orderId, instId);
            } else if (attOrder.compareTo(this.attrOrder) != 0 || isSecondaryChanged) {
                this.reshowColumns(t, attOrder);
            }
        }
    }

    private boolean isDifferentInstance(Trace t, String instId, boolean isSecondary) {
        boolean result = false;
        boolean instanceIdDifferent = true;
        if (instId == null && this.instanceId == null) {
            instanceIdDifferent = false;
        } else if (instId == null || this.instanceId == null) {
            instanceIdDifferent = true;
        } else if (instId.compareTo(this.instanceId) == 0) {
            instanceIdDifferent = false;
        }
        boolean isSecondaryDifferent = isSecondary ^ this.isInstanceSecondary;
        result = instanceIdDifferent || isSecondaryDifferent;
        return result;
    }

    private void reshowColumns(Trace t, AttributeOrder attOrder) {
        this.showBusyCursor(t);
        this.attrOrder = attOrder;
        this.setTableRedraw(t, false);
        int i = 0;
        while (i < this.tableColumns.size()) {
            TableColumn tabcol = this.tableColumns.get(i);
            AttributeOrderItem attrOrderItem = this.attrOrder.getAttributeOrderItemFromPosition(t, i, this.isInstanceSecondary);
            if (attrOrderItem != null) {
                tabcol.setText(attrOrderItem.getAttributeName());
                this.columnManager.setResizingByProgram(true);
                int width = attrOrderItem.getWidth();
                if (width <= 0) {
                    width = 100;
                }
                tabcol.setWidth(width);
                this.columnManager.setResizingByProgram(false);
                tabcol.setResizable(true);
                tabcol.setData((Object)attrOrderItem);
            } else {
                this.columnManager.setResizingByProgram(true);
                tabcol.setWidth(0);
                this.columnManager.setResizingByProgram(false);
                tabcol.setResizable(false);
                tabcol.setData(null);
            }
            ++i;
        }
        this.resizeTableColumns(t, false);
        this.setTableRedraw(t, true);
        this.labelProvider.setAttributeOrder(this.attrOrder);
        if (this.attrOrder.getOrderId() != null) {
            this.labelProvider.setIconAttributeId(this.attrOrder.getIconAttrId(t));
        } else {
            int attrId = this.attrOrder.getAttributeId(t, 0, false);
            this.labelProvider.setIconAttributeId(attrId);
        }
        if (this.isSchemeBar) {
            this.schemeBar.setScheme(t, this.attrOrder);
        }
        this.refresh();
        this.showNormalCursor(t);
    }

    public void removeAll(Trace t) {
        this.setStatus(t, nlsClearing);
        int i = 0;
        while (i < this.items.size()) {
            UiMQObject uiMQObject = this.items.get(i);
            MQExtObject mqExtObject = uiMQObject.getExternalObject();
            mqExtObject.removeObjectChangedListener(this);
            ++i;
        }
        this.items.clear();
        this.hashtable.clear();
        ExtTableGreyCellManager greyCellMgr = this.labelProvider.getGreyCellManager();
        greyCellMgr.removeAllObjectsFromList();
        this.tableViewer.refresh();
        this.tableViewer.getControl().redraw();
        this.setStatus(t, "");
        this.sendContentChangedEvent(t);
    }

    public void asyncRemoveAll(Trace t) {
        this.queueUpdate(t, new ExplorerTableUpdate(t, 6, null), true, true);
    }

    public void sort(Trace t) {
        this.tableViewer.refresh();
        ExplorerTable.paintGreyCells(t, this.table, this.labelProvider);
    }

    private void setStatus(Trace t, String status) {
        if (this.statusBar != null && !this.statusBar.isDisposed()) {
            this.statusBar.showMessage(t, status);
        }
    }

    public void addTableItem(Trace t, UiMQObject object) {
        boolean isAddObject = true;
        if (this.isClientFiltering && this.clientFilter != null) {
            isAddObject = this.clientFilter.doesObjectMatch(t, object);
        }
        if (isAddObject) {
            this.items.add(object);
            this.hashtable.put(object.getDmObject(), object);
            MQExtObject mqExtObject = object.getExternalObject();
            mqExtObject.addObjectChangedListener(this);
            if (this.preselectObjectName != null && object.toString().compareTo(this.preselectObjectName) == 0) {
                this.preSelection = new StructuredSelection((Object)mqExtObject);
            }
            if (this.preCheckedObjects != null) {
                int i = 0;
                while (i < this.preCheckedObjects.length) {
                    boolean matches = false;
                    if (mqExtObject instanceof MQQmgrExtObject && this.preCheckedObjects[i] instanceof MQQmgrExtObject) {
                        MQQmgrExtObject mqQmgrExtObject = (MQQmgrExtObject)mqExtObject;
                        MQQmgrExtObject preCheckQmgr = (MQQmgrExtObject)this.preCheckedObjects[i];
                        if (mqQmgrExtObject.getUuid().compareTo(preCheckQmgr.getUuid()) == 0) {
                            matches = true;
                        }
                    } else {
                        UiMQObject uiMQObject = (UiMQObject)mqExtObject.getInternalObject();
                        if (uiMQObject.getDataModelObjectType(t) == 1002) {
                            DmQueueManagerHandle dmQueueManagerHandle = (DmQueueManagerHandle)uiMQObject.getDmObject();
                            DmQueueManagerHandle preCheckDmQueueManagerHandle = null;
                            UiMQObject preCheckUiMQObject = (UiMQObject)this.preCheckedObjects[i].getInternalObject();
                            if (preCheckUiMQObject.getDataModelObjectType(t) == 1002) {
                                preCheckDmQueueManagerHandle = (DmQueueManagerHandle)preCheckUiMQObject.getDmObject();
                            } else if (preCheckUiMQObject.getDataModelObjectType(t) == 2) {
                                DmQueueManager dmQueueManager = (DmQueueManager)preCheckUiMQObject.getDmObject();
                                preCheckDmQueueManagerHandle = dmQueueManager.getConnectionHandle();
                            }
                            if (dmQueueManagerHandle == preCheckDmQueueManagerHandle) {
                                matches = true;
                            }
                        } else if (mqExtObject.toString().compareTo(this.preCheckedObjects[i].toString()) == 0) {
                            matches = true;
                        }
                    }
                    if (matches) {
                        if (this.objectsToPreCheck == null) {
                            this.objectsToPreCheck = new ArrayList();
                        }
                        this.objectsToPreCheck.add(mqExtObject);
                    }
                    ++i;
                }
            }
        }
        if (this.updateCounter == 0) {
            if (!this.getShell().getMinimized()) {
                ExplorerTable.trace(t, "ExplorerTable.addTableItem", "add outside a begin/end update - refreshing table");
                this.tableViewer.refresh();
                ExplorerTable.paintGreyCells(t, this.table, this.labelProvider);
                this.sendContentChangedEvent(t);
            } else if (Trace.isTracing) {
                t.data(67, "ExplorerTable.addTableItem", 300, "suppressing update - shell is minimized");
            }
        }
    }

    public void asyncAddTableItem(Trace t, UiMQObject object) {
        boolean notifyNow = this.updateCounter == 0;
        this.queueUpdate(t, new ExplorerTableUpdate(t, 1, object), notifyNow, true);
    }

    public boolean removeTableItem(Trace t, UiMQObject object) {
        return this.removeTableItem(t, object, true);
    }

    public boolean removeTableItem(Trace t, UiMQObject object, boolean updateSeq) {
        boolean result = this.deleteItem(object, updateSeq);
        return result;
    }

    public void beginUpdate(Trace t) {
        this.showBusyCursor(t);
        if (this.isStatusBar && !this.statusBar.isDisposed()) {
            this.statusBar.setProgressBarVisible(t, true);
        }
        this.setTableRedraw(t, false);
        ++this.updateCounter;
    }

    public void asyncBeginUpdate(Trace t) {
        this.queueUpdate(t, new ExplorerTableUpdate(t, 4, null), true, true);
    }

    public void endUpdate(Trace t) {
        if (this.isEndUpdateTimerRunning) {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTable.endUpdate", 300, "EndUpdateTimer already running, setting flag to restart when pops");
            }
            this.restartEndUpdateTimer = true;
        } else {
            this.startEndUpdateTimer(t);
        }
    }

    private void startEndUpdateTimer(Trace t) {
        if (!UiPlugin.isShutdownInProgress() && !this.table.isDisposed()) {
            this.getDisplay().timerExec(500, new Runnable(){

                @Override
                public void run() {
                    Trace tr = Trace.getDefault();
                    if (ExplorerTable.this.restartEndUpdateTimer) {
                        if (Trace.isTracing) {
                            tr.data(67, "ExplorerTable.startEndUpdateTimer", 300, "restarting EndUpdateTimer");
                        }
                        ExplorerTable.this.restartEndUpdateTimer = false;
                        ExplorerTable.this.startEndUpdateTimer(tr);
                    } else {
                        if (Trace.isTracing) {
                            tr.data(67, "ExplorerTable.startEndUpdateTimer", 300, "end update timer popped - doing end update");
                        }
                        if (!UiPlugin.isShutdownInProgress()) {
                            ExplorerTable.this.doEndUpdate(tr);
                        }
                        ExplorerTable.this.isEndUpdateTimerRunning = false;
                    }
                }
            });
            this.isEndUpdateTimerRunning = true;
        }
    }

    public void doEndUpdate(Trace t) {
        if (!this.isListening) {
            this.processUpdates(t, this.updatesSinceNotify);
            this.updatesSinceNotify = 0;
        }
        if (this.updateCounter > 0) {
            Shell shell;
            if (!UiPlugin.isShutdownInProgress() && !this.table.isDisposed() && (shell = this.getShell()) != null) {
                if (!this.getShell().getMinimized()) {
                    this.repaint();
                    this.resizeTableColumns(t, false);
                } else if (Trace.isTracing) {
                    t.data(67, "ExplorerTable.doEndUpdate", 300, "suppressing update - shell is minimized");
                }
                if (this.isStatusBar) {
                    this.statusBar.setProgressBarVisible(t, false);
                    if (!this.isListening) {
                        this.lastUpdateDate = new Date();
                        this.updateLastRefreshText(t);
                    }
                }
                --this.updateCounter;
                this.isDMListenerUpdate = false;
                this.sendContentChangedEvent(t);
                this.showNormalCursor(t);
            }
        } else if (this.isInitialUpdate) {
            this.sendContentChangedEvent(t);
            this.isInitialUpdate = false;
        }
        if (this.preSelection != null) {
            this.tableViewer.setSelection((ISelection)this.preSelection, true);
            ArrayList<UiMQObject> uiMQObjects = new ArrayList<UiMQObject>();
            for (MQExtObject mqExtObject : this.preSelection) {
                UiMQObject uiMQObject = (UiMQObject)mqExtObject.getInternalObject();
                uiMQObjects.add(uiMQObject);
            }
            if (uiMQObjects.size() > 0) {
                this.sendSelectionChangedEvent(t, uiMQObjects);
            }
            this.preSelection = null;
        }
        if (this.preCheckedObjects != null && this.objectsToPreCheck != null) {
            this.tableViewer.setChecked(t, this.objectsToPreCheck.toArray(new MQExtObject[this.objectsToPreCheck.size()]));
            this.preCheckedObjects = null;
            this.objectsToPreCheck.clear();
        }
    }

    private void resizeTableColumns(Trace t, boolean canDelay) {
        this.updateTableLoadingStatus(t, 5);
        boolean setBusyCursor = this.showBusyCursor(t);
        this.columnManager.setResizingByProgram(true);
        this.columnManager.resizeTableColumns(t, canDelay);
        this.columnManager.setResizingByProgram(false);
        if (setBusyCursor) {
            this.showNormalCursor(t);
        }
        this.updateTableLoadingStatus(t, 4);
    }

    public void asyncEndUpdate(Trace t) {
        this.queueUpdate(t, new ExplorerTableUpdate(t, 5, null), true, true);
    }

    public void addSelChangedListener(Trace t, ExplorerTableSelectionChangedListener listener) {
        this.selChangedListeners.addElement(listener);
    }

    public void removeSelChangedListener(Trace t, ExplorerTableSelectionChangedListener listener) {
        this.selChangedListeners.removeElement(listener);
    }

    public void addContentChangedListener(Trace t, ExplorerTableContentChangedListener listener) {
        this.contentChangedListeners.addElement(listener);
    }

    public void removeContentChangedListener(Trace t, ExplorerTableContentChangedListener listener) {
        this.contentChangedListeners.removeElement(listener);
    }

    public int getItemCount(Trace t) {
        int count = 0;
        if (!UiPlugin.isShutdownInProgress() && !this.table.isDisposed()) {
            count = this.table.getItemCount();
        }
        ExplorerTable.trace(t, "ExplorerTable.getItemCount", "count = " + count);
        return count;
    }

    public boolean setSelection(Trace t, int index) {
        boolean result = false;
        if (!UiPlugin.isShutdownInProgress() && !this.table.isDisposed() && index < this.table.getItemCount()) {
            this.table.deselectAll();
            this.table.select(index);
            result = true;
            this.deleteAction.selectionChanged((IStructuredSelection)this.tableViewer.getSelection());
        }
        return result;
    }

    public UiMQObject getSelectedItem(Trace t) {
        UiMQObject selObject = null;
        ISelection iSel = this.tableViewer.getSelection();
        if (iSel != null && iSel instanceof IStructuredSelection) {
            IStructuredSelection iStructSel = (IStructuredSelection)iSel;
            Object object = iStructSel.getFirstElement();
            if (object instanceof MQExtObject) {
                MQExtObject mqExtObject = (MQExtObject)object;
                selObject = (UiMQObject)mqExtObject.getInternalObject();
            } else if (object instanceof UiMQObject) {
                selObject = (UiMQObject)object;
            }
        }
        return selObject;
    }

    public List<UiMQObject> getSelectedItems() {
        ArrayList<UiMQObject> selList = new ArrayList<UiMQObject>();
        ISelection iSel = this.tableViewer.getSelection();
        if (iSel != null && iSel instanceof IStructuredSelection) {
            IStructuredSelection iStructSel = (IStructuredSelection)iSel;
            for (Object object : iStructSel.toList()) {
                if (object instanceof MQExtObject) {
                    MQExtObject mqExtObject = (MQExtObject)object;
                    selList.add((UiMQObject)mqExtObject.getInternalObject());
                    continue;
                }
                if (!(object instanceof UiMQObject)) continue;
                selList.add((UiMQObject)object);
            }
        }
        return selList;
    }

    public void addFocusListener(Trace t, FocusListener listener) {
        if (this.tableViewer != null) {
            this.table.addFocusListener(listener);
        }
    }

    public void removeFocusListener(Trace t, FocusListener listener) {
        if (this.tableViewer != null) {
            this.table.removeFocusListener(listener);
        }
    }

    public boolean setFocus() {
        if (this.tableViewer != null) {
            return this.table.setFocus();
        }
        return false;
    }

    @Override
    public void mqExtObjectChanged(MQExtObjectChangedEvent event) {
        Trace t = Trace.getDefault();
        MQExtObject mqExtObject = event.getMQExtObject();
        UiMQObject uiMQObject = (UiMQObject)mqExtObject.getInternalObject();
        ExplorerTable.trace(t, "ExplorerTable.mqExtObjectChanged", "object changed is " + uiMQObject.toString());
        this.tableViewer.update(uiMQObject.getExternalObject(), null);
        this.repaint();
    }

    @Override
    public void mqExtObjectDeleted(MQExtObjectDeletedEvent event) {
        Trace t = Trace.getDefault();
        MQExtObject mqExtObject = event.getMQExtObject();
        UiMQObject uiMQObject = (UiMQObject)mqExtObject.getInternalObject();
        ExplorerTable.trace(t, "ExplorerTable.mqExtObjectDeleted", "object deleted is " + uiMQObject.toString());
        IDmObject dmObject = uiMQObject.getDmObject();
        if (this.items.remove(uiMQObject)) {
            this.hashtable.remove(dmObject);
            MQExtObject externalObject = uiMQObject.getExternalObject();
            ExtTableGreyCellManager greyCellMgr = this.labelProvider.getGreyCellManager();
            greyCellMgr.removeMQExtObject(t, externalObject);
            this.repaint();
            this.sendContentChangedEvent(t);
        }
    }

    public boolean startListener(Trace t, IDmObservable observable) {
        boolean res = false;
        Filter uiFilter = null;
        if (this.filterProvider != null && this.filterId != null) {
            uiFilter = this.filterManager.getRegisteredCurrentFilter(t, this.filterId, this.instanceId);
        }
        if (uiFilter != null) {
            DmObjectFilter dmObjectFilter = uiFilter.getDmObjectFilter(t);
            if (this.filterQSGDisposition != null) {
                dmObjectFilter.setDisp(t, this.filterQSGDisposition.intValue());
            }
            res = this.startListener(t, observable, dmObjectFilter, false);
        } else {
            res = this.startListener(t, observable, null, false);
        }
        return res;
    }

    public boolean startListener(Trace t, IDmObservable observable, int objId) {
        DmObjectFilter dmObjectFilter = new DmObjectFilter(t, objId);
        boolean res = this.startListener(t, observable, dmObjectFilter, false);
        return res;
    }

    public boolean startListener(Trace t, IDmObservable observable, DmObjectFilter filter) {
        boolean res = false;
        boolean filterProvided = true;
        if (filter == null) {
            filterProvided = false;
        }
        res = this.startListener(t, observable, filter, filterProvided);
        return res;
    }

    private boolean startListener(Trace t, IDmObservable observable, DmObjectFilter filter, boolean isExplicit) {
        boolean res = false;
        if (!this.isListening) {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTable.startListener", 300, "first listen call - clearing up");
            }
            this.listUpdateQueue.clear();
            this.isUpdateQueueActive = true;
        }
        this.updateTableLoadingStatus(t, 3);
        this.showBusyCursor(t);
        if (this.isStatusBar) {
            this.statusBar.setProgressBarVisible(t, true);
        }
        if (isExplicit && this.filterQSGDisposition != null) {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTable.startListener", 300, "setting QSG disp on explicit filter");
            }
            filter.setDisp(t, this.filterQSGDisposition.intValue());
        }
        if (observable != null) {
            res = this.explorerTableDMListener.startListening(t, observable, filter);
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTable.startListener", 900, "null observable passed!");
        }
        if (res) {
            this.observableObject = observable;
            this.isListening = true;
        } else {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTable.startListener", 300, "failed to start listening");
            }
            this.updateTableLoadingStatus(t, 4);
            this.showNormalCursor(t);
            if (this.isStatusBar) {
                this.statusBar.setProgressBarVisible(t, false);
            }
            if (isExplicit) {
                String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4169");
                MessageBox.showMessageFailure(t, this.getShell(), msg, "AMQ4169");
            } else {
                String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4168");
                MessageBox.showMessageFailure(t, this.getShell(), msg, "AMQ4168");
            }
        }
        return res;
    }

    public boolean stopListener(Trace t, IDmObservable observable) {
        boolean res = false;
        this.isUpdateQueueActive = false;
        res = this.explorerTableDMListener.stopListening(t, observable);
        if (res) {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTable.stopListener", 300, "stopped listening - clearing up");
            }
            this.isListening = false;
            this.listUpdateQueue.clear();
            if (this.isStatusBar && !this.statusBar.isDisposed()) {
                this.statusBar.setProgressBarVisible(t, false);
            }
        }
        return res;
    }

    public boolean isListening(Trace t) {
        return this.isListening;
    }

    public void refresh() {
        Trace t = Trace.getDefault();
        if (this.isListening) {
            this.observableObject.refreshObservable(t, (DmObjectListener)this.explorerTableDMListener);
        }
        this.repaint();
    }

    public void refreshTableViewer() {
        this.tableViewer.refresh();
    }

    public void repaint() {
        Trace t = Trace.getDefault();
        this.updateTableLoadingStatus(t, 5);
        boolean setBusyCursor = this.showBusyCursor(t);
        this.setSorterFromPreference();
        this.tableViewer.refresh();
        ExplorerTable.paintGreyCells(t, this.table, this.labelProvider);
        this.setTableRedraw(t, true);
        if (setBusyCursor) {
            this.showNormalCursor(t);
        }
        this.updateTableLoadingStatus(t, 4);
    }

    protected boolean refreshItem(Object item) {
        Trace t = Trace.getDefault();
        boolean result = false;
        UiMQObject uiMQObject = null;
        if (item instanceof UiMQObject) {
            uiMQObject = (UiMQObject)item;
        } else if (item instanceof DmObject) {
            DmObject dmObject = (DmObject)item;
            if (this.objectId.compareTo("com.ibm.mq.explorer.queuemanagerhandle") == 0 && dmObject instanceof DmQueueManager) {
                dmObject = ((DmQueueManager)dmObject).getConnectionHandle();
            }
            if ((uiMQObject = this.hashtable.get(dmObject)) == null) {
                ExplorerTable.trace(t, "ExplorerTable.refreshItem", "dmObject " + ((DmObject)item).getTitle() + " not in table, ignoring");
            }
        }
        if (uiMQObject != null) {
            ExplorerTable.trace(t, "ExplorerTable.refreshItem", "refreshing UiMQObject " + uiMQObject.toString());
            if (this.items.contains(uiMQObject)) {
                if (!this.isDMListenerUpdate) {
                    this.beginUpdate(t);
                    this.isDMListenerUpdate = true;
                }
                boolean filterMatch = true;
                if (this.isClientFiltering && this.clientFilter != null) {
                    filterMatch = this.clientFilter.doesObjectMatch(t, uiMQObject);
                }
                if (filterMatch) {
                    ExplorerTable.trace(t, "ExplorerTable.refreshItem", "UiMQObject " + uiMQObject.toString() + " is in table, refreshing it");
                    this.clearGreyCellListForObject(t, uiMQObject.getExternalObject());
                    this.tableViewer.update(uiMQObject.getExternalObject(), null);
                    result = true;
                } else {
                    this.deleteItem(uiMQObject, true);
                }
            } else {
                ExplorerTable.trace(t, "ExplorerTable.refreshItem", "UiMQObject " + uiMQObject.toString() + " not in table, ignoring");
            }
        } else {
            this.addItem(item);
        }
        return result;
    }

    protected boolean addItem(Object item) {
        DmObject dmObject;
        Trace t = Trace.getDefault();
        boolean result = false;
        if (!this.isDMListenerUpdate) {
            this.beginUpdate(t);
            this.isDMListenerUpdate = true;
        }
        UiMQObject uiMQObject = null;
        if (item instanceof UiMQObject) {
            ExplorerTable.trace(t, "ExplorerTable.addItem", "item being added is a UiMQObject");
            uiMQObject = (UiMQObject)item;
        } else if (item instanceof DmObject) {
            dmObject = (DmObject)item;
            if (this.objectId.compareTo("com.ibm.mq.explorer.queuemanagerhandle") == 0 && dmObject instanceof DmQueueManager) {
                dmObject = ((DmQueueManager)dmObject).getConnectionHandle();
            }
            uiMQObject = this.hashtable.get(dmObject);
            ExplorerTable.trace(t, "ExplorerTable.addItem", "item being added is a DmObject");
        }
        if (uiMQObject != null) {
            if (this.items.contains(uiMQObject)) {
                ExplorerTable.trace(t, "ExplorerTable.addItem", "UiMQObject " + uiMQObject.toString() + " is already in table, refreshing it");
                this.tableViewer.update(uiMQObject.getExternalObject(), null);
                result = true;
            } else {
                ExplorerTable.trace(t, "ExplorerTable.addItem", "adding supplied UiMQObject " + uiMQObject.toString());
                this.addTableItem(t, uiMQObject);
                result = true;
            }
        } else {
            ExplorerTable.trace(t, "ExplorerTable.addItem", "DmObject added, does not exist in table, trying to create using factory");
            if (this.uiMQObjectFactory != null && item instanceof IDmObject) {
                dmObject = (DmObject)item;
                uiMQObject = this.uiMQObjectFactory.create(t, (IDmObject)dmObject, this.parentObjectForFactory);
                if (uiMQObject != null) {
                    ExplorerTable.trace(t, "ExplorerTable.addItem", "adding UiMQObject " + uiMQObject.toString());
                    this.addTableItem(t, uiMQObject);
                    result = true;
                } else {
                    ExplorerTable.trace(t, "ExplorerTable.addItem", "failed to create uiMQObject from factory " + dmObject);
                }
            } else if (this.uiMQObjectFactory == null) {
                ExplorerTable.trace(t, "ExplorerTable.addItem", "No object factory, unable to make UiMQObject from object " + item.toString());
            } else {
                ExplorerTable.trace(t, "ExplorerTable.addItem", "Object " + item.toString() + " is not a DmObject, unable to make UiMQObject from it");
            }
        }
        return result;
    }

    protected boolean deleteItem(Object item, boolean updateSeq) {
        DmObject dmObject;
        Trace t = Trace.getDefault();
        boolean result = false;
        UiMQObject uiMQObject = null;
        if (item instanceof UiMQObject) {
            uiMQObject = (UiMQObject)item;
        } else if (item instanceof DmObject) {
            dmObject = (DmObject)item;
            if (this.objectId.compareTo("com.ibm.mq.explorer.queuemanagerhandle") == 0 && dmObject instanceof DmQueueManager) {
                dmObject = ((DmQueueManager)dmObject).getConnectionHandle();
            }
            if ((uiMQObject = this.hashtable.get(dmObject)) == null) {
                ExplorerTable.trace(t, "ExplorerTable.deleteItem", "dmObject " + ((DmObject)item).getTitle() + " not in table, ignoring");
            }
        }
        if (uiMQObject != null) {
            ExplorerTable.trace(t, "ExplorerTable.deleteItem", "deleting UiMQObject " + uiMQObject.toString());
            if (this.items.remove(uiMQObject)) {
                if (!this.isDMListenerUpdate && updateSeq) {
                    this.beginUpdate(t);
                    this.isDMListenerUpdate = true;
                }
                ExplorerTable.trace(t, "ExplorerTable.deleteItem", "UiMQObject " + uiMQObject.toString() + " was in table, removing it");
                dmObject = uiMQObject.getDmObject();
                this.hashtable.remove(dmObject);
                MQExtObject externalObject = uiMQObject.getExternalObject();
                ExtTableGreyCellManager greyCellMgr = this.labelProvider.getGreyCellManager();
                greyCellMgr.removeMQExtObject(t, externalObject);
                List<UiMQObject> selObjects = this.getSelectedItems();
                if (selObjects.contains(uiMQObject)) {
                    ArrayList<UiMQObject> newSelUiObjects = new ArrayList<UiMQObject>();
                    ArrayList<MQExtObject> newSelObjects = new ArrayList<MQExtObject>();
                    for (UiMQObject obj : selObjects) {
                        if (obj == uiMQObject) continue;
                        newSelUiObjects.add(obj);
                        newSelObjects.add(obj.getExternalObject());
                    }
                    this.tableViewer.setSelection((ISelection)new StructuredSelection(newSelObjects), true);
                    this.sendSelectionChangedEvent(t, newSelUiObjects);
                }
                result = true;
            } else {
                ExplorerTable.trace(t, "ExplorerTable.deleteItem", "UiMQObject " + uiMQObject.toString() + " not in table, ignoring");
            }
        }
        return result;
    }

    public void setUiMQObjectFactoryClass(Trace t, IUiMQObjectFactory factoryClass, UiMQObject parentToNewObjects) {
        this.uiMQObjectFactory = factoryClass;
        this.parentObjectForFactory = parentToNewObjects;
        this.contentProvider.setUiMQObjectFactoryClass(t, factoryClass, parentToNewObjects);
    }

    public void setFilterProvider(Trace t, FilterProvider filterProv) {
        this.filterProvider = filterProv;
        if (this.isFilterBar) {
            this.filterBar.setFilterProvider(this.filterProvider);
        }
    }

    private static void trace(Trace t, String fid, String msg) {
        if (Trace.isTracing) {
            t.data(67, fid, 300, msg);
        }
    }

    public void addViewerFilter(Trace t, ViewerFilter filter) {
        this.tableViewer.addFilter(filter);
        this.sendContentChangedEvent(t);
    }

    public void removeViewerFilter(Trace t, ViewerFilter filter) {
        this.tableViewer.removeFilter(filter);
        this.sendContentChangedEvent(t);
    }

    public void resetViewerFilters(Trace t) {
        this.tableViewer.resetFilters();
        this.sendContentChangedEvent(t);
    }

    @Override
    public void changed(AttributeOrderChangedEvent e) {
        Trace t = Trace.getDefault();
        if (this.orderId != null && e.getOrderId().compareTo(this.orderId) == 0) {
            AttributeOrder attOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, this.orderId, this.instanceId);
            this.isAttrOrderCloned = false;
            if (attOrder == null) {
                t.FFST(67, "ExplorerTable.changed", 10, 50020, 0, 0, "Failed to get RegisteredCurrentAttributeOrder", this.orderId, this.instanceId);
            } else {
                this.reshowColumns(t, attOrder);
            }
        }
    }

    @Override
    public void selectionChanged(AttributeOrderChangedEvent e) {
        Trace t = Trace.getDefault();
        if (this.orderId != null && e.getOrderId().compareTo(this.orderId) == 0) {
            AttributeOrder attOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, this.orderId, this.instanceId);
            this.isAttrOrderCloned = false;
            if (attOrder == null) {
                t.FFST(67, "ExplorerTable.selectionChanged", 10, 50020, 0, 0, "Failed to get RegisteredCurrentAttributeOrder", this.orderId, this.instanceId);
            } else {
                this.reshowColumns(t, attOrder);
            }
        }
    }

    private void sendContentChangedEvent(Trace t) {
        int size = this.contentChangedListeners.size();
        if (size > 0) {
            ExplorerTableContentChangedEvent ccEvent = new ExplorerTableContentChangedEvent(this);
            int i = 0;
            while (i < size) {
                ExplorerTableContentChangedListener listener = this.contentChangedListeners.elementAt(i);
                listener.contentChanged(ccEvent);
                ++i;
            }
        }
    }

    @Override
    public void changed(FilterChangedEvent e) {
        Trace t = Trace.getDefault();
        if (this.filterId != null && e.getFilterId().compareTo(this.filterId) == 0) {
            this.applyCurrentFilter(t);
        }
    }

    @Override
    public void selectionChanged(FilterChangedEvent e) {
        Trace t = Trace.getDefault();
        if (this.filterId != null && e.getFilterId().compareTo(this.filterId) == 0) {
            this.applyCurrentFilter(t);
        }
    }

    private void applyCurrentFilter(Trace t) {
        Filter filter = this.filterManager.getRegisteredCurrentFilter(t, this.filterId, this.instanceId);
        if (this.isClientFiltering) {
            this.clientFilter = filter;
        }
        if (filter.isAssociatedAttributeOrder() && this.filterProvider != null) {
            if (filter.isAttrOrderDefault()) {
                AttributeOrder attOrder = this.attrOrderManager.getDefaultAttributeOrder(t, this.filterProvider.getAttributeOrderId());
                this.attrOrderManager.setSelectedAttrOrder(t, attOrder.getOrderId(), this.instanceId, attOrder, true, true);
                this.isAttrOrderCloned = false;
            } else {
                AttributeOrder attOrder = this.attrOrderManager.getAttributeOrderFromUID(t, this.filterProvider.getAttributeOrderId(), filter.getAttrOrderUniversalId());
                if (attOrder == null) {
                    if (Trace.isTracing) {
                        t.data(67, "ExplorerTable.applyCurrentFilter", 900, "failed to find attribute order with univeral id '" + filter.getAttrOrderUniversalId() + "' specified in the filter '" + filter.getFilterName() + "'");
                    }
                    if ((attOrder = this.attrOrderManager.getAttributeOrderFromName(t, this.filterProvider.getAttributeOrderId(), filter.getAttrOrderName())) != null) {
                        if (Trace.isTracing) {
                            t.data(67, "ExplorerTable.applyCurrentFilter", 900, "using the attribute order with the name specified in the filter");
                        }
                        filter.setAssociatedAttributeOrder(attOrder.getOrderName(t), false, attOrder.getOrderUniversalId());
                    } else {
                        if (Trace.isTracing) {
                            t.data(67, "ExplorerTable.applyCurrentFilter", 900, "failed to find attribute order with the name specified in the filter, using the default attribute order");
                        }
                        attOrder = this.attrOrderManager.getDefaultAttributeOrder(t, this.filterProvider.getAttributeOrderId());
                        filter.setAssociatedAttributeOrder(attOrder.getOrderName(t), true, null);
                    }
                    this.filterManager.saveFilters(t);
                }
                this.attrOrderManager.setSelectedAttrOrder(t, this.filterProvider.getAttributeOrderId(), this.instanceId, attOrder, true, true);
                this.isAttrOrderCloned = false;
            }
        }
        if (this.isListening) {
            this.stopListener(t, this.observableObject);
            this.removeAll(t);
            this.startListener(t, this.observableObject);
        } else if (Trace.isTracing) {
            t.data(67, "ExplorerTable.applyCurrentFilter", 300, "being asked to change filter when not listening");
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        Trace t = Trace.getDefault();
        this.isUpdateQueueActive = false;
        if (this.isListening) {
            this.stopListener(t, this.observableObject);
        }
        if (e.getSource().equals(this)) {
            this.attrOrderManager.removeChangedListener(t, this);
            this.filterManager.removeChangedListener(t, this);
            UiPlugin.removeQueueManagerDisconnectActionListener(t, this);
            this.unhideAllColumns(t);
            if (this.fClipboard != null) {
                this.fClipboard.dispose();
                this.fClipboard = null;
            }
        }
        UiPlugin.getPrefStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.contextMenuListener != null) {
            this.menuMgr.removeMenuListener((IMenuListener)this.contextMenuListener);
        }
    }

    public void setFilterQSGDisposition(Integer integer) {
        this.filterQSGDisposition = integer;
    }

    public ArrayList<MQExtObject> getObjects(Trace t) {
        ArrayList<MQExtObject> retObjects = new ArrayList<MQExtObject>();
        ArrayList<Object> tableObjects = this.tableViewer.getObjects();
        int i = 0;
        while (i < tableObjects.size()) {
            Object object = tableObjects.get(i);
            MQExtObject mqExtObject = null;
            if (object instanceof MQExtObject) {
                mqExtObject = (MQExtObject)object;
            } else if (object instanceof UiMQObject) {
                mqExtObject = ((UiMQObject)object).getExternalObject();
            }
            if (mqExtObject != null) {
                retObjects.add(mqExtObject);
            }
            ++i;
        }
        return retObjects;
    }

    public void updateLastRefreshText(Trace t) {
        if (this.isStatusBar) {
            int i;
            String dateString = this.lastUpdateDate != null ? this.dateFormat.format(this.lastUpdateDate) : this.dateFormat.format(new Date());
            String statusText = this.table != null && !this.table.isDisposed() ? ((i = this.table.getItemCount()) == 1 ? this.msgFile.getMessage(t, "UI.TABLES.Table.Status.Update.1.Item.Count", dateString) : this.msgFile.getMessage(t, "UI.TABLES.Table.Status.Update.Item.Count", new String[]{dateString, String.valueOf(i)})) : this.msgFile.getMessage(t, "UI.TABLES.Table.Status.Update", dateString);
            this.setStatus(t, statusText);
        }
    }

    public void updateTableLoadingStatus(Trace t, int status) {
        switch (status) {
            case 1: {
                this.setStatus(t, nlsLoading);
                break;
            }
            case 3: {
                this.setStatus(t, nlsRetrievingData);
                break;
            }
            case 4: {
                this.updateLastRefreshText(t);
                break;
            }
            case 5: {
                this.setStatus(t, nlsRefreshing);
                break;
            }
            default: {
                this.setStatus(t, "");
            }
        }
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setFilteringAvailable(Trace t, boolean available) {
        if (this.filterBar != null) {
            this.filterBar.setFilteringAvailable(t, available);
        }
    }

    private void setTableRedraw(Trace t, boolean isRedraw) {
        if (this.isTableRedraw != isRedraw) {
            this.table.setRedraw(isRedraw);
            this.isTableRedraw = isRedraw;
        }
    }

    private void resetColumnWidths(Trace t) {
        this.showBusyCursor(t);
        ArrayList<AttributeOrderItem> aoItems = this.attrOrder.getAttributeOrderItems(t);
        int i = 0;
        while (i < aoItems.size()) {
            AttributeOrderItem attrOrderItem = aoItems.get(i);
            if (attrOrderItem.getWidth() != 0) {
                attrOrderItem.setWidth(-1);
            }
            ++i;
        }
        this.reshowColumns(t, this.attrOrder);
        this.showNormalCursor(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdates(Trace t, int count) {
        List<ExplorerTableUpdate> list = this.listUpdateQueue;
        synchronized (list) {
            if (Trace.isTracing) {
                t.data(67, "ExplorerTable.processUpdates", 300, "starting processUpdates, depth now " + this.listUpdateQueue.size());
            }
            int i = 0;
            while (i < count && this.listUpdateQueue.size() > 0) {
                ExplorerTableUpdate obj = this.listUpdateQueue.remove(0);
                if (obj != null && obj instanceof ExplorerTableUpdate) {
                    ExplorerTableUpdate update = obj;
                    int updateType = update.getUpdateType();
                    if (Trace.isTracing) {
                        t.data(67, "ExplorerTable.processUpdates", 300, "processing update, type = " + updateType);
                    }
                    switch (updateType) {
                        case 4: {
                            if (Trace.isTracing) {
                                t.data(67, "ExplorerTable.processUpdates", 300, "processUpdate: begin update");
                            }
                            this.beginUpdate(t);
                            break;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (Trace.isTracing) {
                                t.data(67, "ExplorerTable.processUpdates", 300, "processUpdate: add item " + update.getObject().toString());
                            }
                            this.addItem(update.getObject());
                            break;
                        }
                        case 2: {
                            if (Trace.isTracing) {
                                t.data(67, "ExplorerTable.processUpdates", 300, "processUpdate: refresh item " + update.getObject().toString());
                            }
                            this.refreshItem(update.getObject());
                            break;
                        }
                        case 3: {
                            if (Trace.isTracing) {
                                t.data(67, "ExplorerTable.processUpdates", 300, "processUpdate: delete item " + update.getObject().toString());
                            }
                            this.deleteItem(update.getObject(), true);
                            break;
                        }
                        case 5: {
                            if (Trace.isTracing) {
                                t.data(67, "ExplorerTable.processUpdates", 300, "processUpdate: end update");
                            }
                            this.endUpdate(t);
                            break;
                        }
                        case 6: {
                            if (Trace.isTracing) {
                                t.data(67, "ExplorerTable.processUpdates", 300, "processUpdate: remove all");
                            }
                            this.removeAll(t);
                            break;
                        }
                        case 7: {
                            if (Trace.isTracing) {
                                t.data(67, "ExplorerTable.processUpdates", 300, "processUpdate: update last refresh msg");
                            }
                            this.lastUpdateDate = new Date();
                            this.updateLastRefreshText(t);
                            if (this.updateCounter != 0) break;
                            if (this.isStatusBar && !this.statusBar.isDisposed()) {
                                this.statusBar.setProgressBarVisible(t, false);
                            }
                            this.showNormalCursor(t);
                            break;
                        }
                        case 8: {
                            if (Trace.isTracing) {
                                t.data(67, "ExplorerTable.processUpdates", 300, "processUpdate: update status msg");
                            }
                            this.updateTableLoadingStatus(t, update.getUpdateSubType());
                            break;
                        }
                        default: {
                            if (!Trace.isTracing) break;
                            t.data(67, "ExplorerTable.processUpdates", 900, "unknown updateType " + updateType + " ignored");
                        }
                    }
                }
                ++i;
            }
            if (Trace.isTracing) {
                t.data(67, "ExplorerTable.processUpdates", 300, "finished processing " + count + " updates, depth now " + this.listUpdateQueue.size());
            }
        }
    }

    public int calculateHeight(Trace t, int rows, boolean incHeader) {
        int height = 0;
        if (incHeader) {
            height += this.table.getHeaderHeight();
        }
        height += rows * (this.table.getItemHeight() + this.table.getGridLineWidth());
        return height += this.table.getHorizontalBar().getSize().x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpdate(Trace t, ExplorerTableUpdate update, boolean notifyNow, boolean isAsync) {
        boolean isProcess;
        boolean bl = isProcess = isAsync || this.isUpdateQueueActive;
        if (isProcess) {
            List<ExplorerTableUpdate> list = this.listUpdateQueue;
            synchronized (list) {
                this.listUpdateQueue.add(update);
                ++this.updatesSinceNotify;
            }
            if (this.updatesSinceNotify >= this.updateBatchSize || notifyNow) {
                if (Trace.isTracing) {
                    t.data(67, "ExplorerTable.queueUpdate", 300, "calling ExplorerTable to process updates, depth = " + this.listUpdateQueue.size());
                }
                final int count = this.updatesSinceNotify;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ExplorerTable.this.isDisposed()) {
                            Trace tr = Trace.getDefault();
                            ExplorerTable.this.processUpdates(tr, count);
                        }
                    }
                });
                this.updatesSinceNotify = 0;
            }
        }
    }

    public boolean isShowListenerExceptions() {
        return this.isShowListenerExceptions;
    }

    public void setShowListenerExceptions(boolean show) {
        this.isShowListenerExceptions = show;
    }

    @Override
    public void queueManagerBeingDisconnected(QueueManagerDisconnectActionEvent event) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQmgr = event.getDmQueueManager();
        if (this.isListening && dmQmgr.equals((Object)this.observableObject)) {
            this.stopListener(t, this.observableObject);
            this.removeAll(t);
        }
    }

    public void setTickCrossMode(Trace t, boolean isTickCross) {
        this.setTickCrossMode(t, isTickCross, null, null);
    }

    public void setTickCrossMode(Trace t, boolean isTickCross, Image imgTick, Image imgCross) {
        this.isTickCrossMode = isTickCross;
        if (imgTick != null) {
            this.imageTick = imgTick;
        }
        if (imgCross != null) {
            this.imageCross = imgCross;
        }
        if (this.labelProvider != null) {
            this.labelProvider.setTickCrossMode(isTickCross, imgTick, imgCross);
            this.repaint();
        }
    }

    public Filter getCurrentFilterSelection(Trace t) {
        Filter filter = this.filterManager.getRegisteredCurrentFilter(t, this.filterId, this.instanceId);
        return filter;
    }

    public void setPreselectObjectName(String name) {
        this.preselectObjectName = name;
    }

    public boolean setColumns(Trace t, int[] attrIds, String[] attrNames) {
        boolean result = false;
        if (!this.isSchemeBar && attrIds.length > 0 && attrIds.length == attrNames.length) {
            AttributeOrder attOrder = new AttributeOrder(t, null, null, null, false, true);
            int i = 0;
            while (i < attrIds.length) {
                AttributeOrderItem attrOrderItem = new AttributeOrderItem(t, attrIds[i], attrNames[i], i);
                attOrder.add(t, attrOrderItem);
                ++i;
            }
            this.useAttributeOrder(t, attOrder);
            result = true;
        }
        return result;
    }

    public void beginColumnUpdate(Trace t) {
        if (!this.isAttrOrderCloned) {
            AttributeOrder cloneAttrOrder = new AttributeOrder(t, this.attrOrder);
            this.isAttrOrderCloned = true;
            this.reshowColumns(t, cloneAttrOrder);
        }
        this.isColumnUpdate = true;
        if (!ExtTableColumnManager.isGetColumnWidths(t)) {
            this.resetColumnWidths(t);
        }
    }

    public boolean showColumn(Trace t, int attrId, boolean visible) {
        AttributeOrderItem attrOrderItem;
        boolean result = false;
        if (this.attrOrder != null && (attrOrderItem = this.attrOrder.getAttributeOrderItemFromId(t, attrId)) != null) {
            boolean set = true;
            if (this.tableType == 1 && attrOrderItem.getAttributePosition(false) == 0) {
                set = false;
            }
            if (set) {
                attrOrderItem.setForcedNotVisible(!visible);
                result = true;
            }
        }
        return result;
    }

    public void endColumnUpdate(Trace t) {
        if (this.isColumnUpdate) {
            this.reshowColumns(t, this.attrOrder);
        }
    }

    private void unhideAllColumns(Trace t) {
        if (this.attrOrder != null) {
            int i = 0;
            while (i < this.attrOrder.size()) {
                AttributeOrderItem attrOrderItem = this.attrOrder.get(t, i);
                if (attrOrderItem != null) {
                    attrOrderItem.setForcedNotVisible(false);
                }
                ++i;
            }
        }
    }

    public void setSorting(Trace t, boolean sorting) {
        if (sorting) {
            t.data(67, "ExplorerTable.setSorting", 300, "enabling sorting");
            this.columnManager.setViewerSorter(t, this.compareItems, true);
        } else {
            t.data(67, "ExplorerTable.setSorting", 300, "disabling sorting");
            this.columnManager.setViewerSorter(t, null, true);
        }
    }

    public boolean isTableEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        Trace t = Trace.getDefault();
        super.setEnabled(enabled);
        if (this.table != null) {
            this.table.setEnabled(enabled);
            if (!enabled) {
                this.removeAll(t);
                this.setStatus(t, "");
            }
        }
        this.isEnabled = enabled;
    }

    public void expandAll(Trace t) {
        this.tableViewer.expandAll();
    }

    public void expandToLevel(Trace t, int level) {
        this.tableViewer.expandToLevel(level);
    }

    public void collapseAll(Trace t) {
        this.tableViewer.collapseAll();
    }

    public String getColumnTitles() {
        StringBuffer buf = new StringBuffer();
        for (TableColumn tc : this.tableColumns) {
            if (tc.getWidth() <= 0) continue;
            buf.append(tc.getText());
            buf.append(",");
        }
        return buf.toString();
    }

    public boolean addCheckStateListener(Trace t, ICheckStateListener listener) {
        boolean result = false;
        if (this.tableType == 2) {
            result = this.tableViewer.addCheckStateListener(t, listener);
        }
        return result;
    }

    public boolean removeCheckStateListener(Trace t, ICheckStateListener listener) {
        boolean result = false;
        if (this.tableType == 2) {
            result = this.tableViewer.removeCheckStateListener(t, listener);
        }
        return result;
    }

    public void setPreCheckedObjects(Trace t, MQExtObject[] objects) {
        if (this.tableType == 2) {
            this.preCheckedObjects = objects;
        }
    }

    public void checkAll(Trace t) {
        if (this.tableType == 2) {
            this.tableViewer.checkAll(t);
        }
    }

    public void checkNone(Trace t) {
        if (this.tableType == 2) {
            this.tableViewer.checkNone(t);
        }
    }

    public void setClientFiltering(Trace t, boolean clientFiltering) {
        this.isClientFiltering = clientFiltering;
        if (clientFiltering) {
            this.clientFilter = this.filterManager.getRegisteredCurrentFilter(t, this.filterId, this.instanceId);
        }
    }

    public void setSuppressColumnResizing(boolean suppress) {
        this.isSuppressColumnResizing = suppress;
    }

    private boolean showBusyCursor(Trace t) {
        boolean result = false;
        if (!this.isBusyCursorSet) {
            UiPlugin.showBusyCursor(t, true);
            this.isBusyCursorSet = true;
            result = true;
        }
        return result;
    }

    private void showNormalCursor(Trace t) {
        UiPlugin.showBusyCursor(t, false);
        this.isBusyCursorSet = false;
    }

    public void setSuppressEventsForHiddenQmgrs(boolean suppress) {
        this.explorerTableDMListener.setSuppressEventsForHiddenQmgrs(suppress);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Trace t = Trace.getDefault();
        String strProperty = event.getProperty();
        if (strProperty.compareTo("InvalidCellColorChanged") == 0) {
            ExplorerTable.paintGreyCells(t, this.table, this.labelProvider);
        }
    }

    public static void paintGreyCells(Trace t, Table table, ExtTableLabelProvider tableLabelProvider) {
        if (table != null && tableLabelProvider != null) {
            Color color = UiPlugin.getDisabledColor();
            int i = 0;
            while (i < table.getItemCount()) {
                TableItem tableItem = table.getItem(i);
                Object object = tableItem.getData();
                if (object instanceof MQExtObject) {
                    ArrayList<Integer> greyCellList = tableLabelProvider.getGreyCellManager().getGreyCellList(t, (MQExtObject)object);
                    int j = 0;
                    while (j < table.getColumnCount()) {
                        if (greyCellList.contains(j)) {
                            tableItem.setBackground(j, color);
                        } else {
                            tableItem.setBackground(j, null);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public boolean clearGreyCellListForObject(Trace t, Object object) {
        boolean result = false;
        if (!this.table.isDisposed()) {
            int i = 0;
            while (i < this.table.getItemCount()) {
                TableItem tableItem = this.table.getItem(i);
                Object obj = tableItem.getData();
                if (obj instanceof MQExtObject && object instanceof MQExtObject) {
                    if (object == obj) {
                        this.labelProvider.getGreyCellManager().clearGreyCellList(t, (MQExtObject)obj);
                        result = true;
                        break;
                    }
                } else if (obj instanceof MQExtObject && object == ((MQExtObject)obj).getInternalObject()) {
                    this.labelProvider.getGreyCellManager().clearGreyCellList(t, (MQExtObject)obj);
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void addMouseListener(MouseListener listener) {
        this.table.addMouseListener(listener);
    }

    public int getSelectionIndex() {
        if (this.table != null) {
            return this.table.getSelectionIndex();
        }
        return -1;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    protected String getOrderId() {
        return this.orderId;
    }

    protected UiMQObject getParentObjectForFactory() {
        return this.parentObjectForFactory;
    }

    protected boolean isTickCrossMode() {
        return this.isTickCrossMode;
    }

    protected Image getImageCross() {
        return this.imageCross;
    }

    protected Image getImageTick() {
        return this.imageTick;
    }
}

