/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.actions.DeleteObjectAction;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableViewer;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class DeleteTableObjectAction
extends SelectionListenerAction {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/explorertable/DeleteTableObjectAction.java";
    private ExtTableViewer fViewer;

    public DeleteTableObjectAction(ExplorerTable table, ExtTableViewer viewer) {
        super(null);
        this.fViewer = viewer;
        Trace t = Trace.getDefault();
        Message msgFile = UiPlugin.getUIMessages(t, null);
        String text = msgFile.getMessage(Trace.getDefault(), "UI.GENERAL.DELETE");
        this.setText(text);
        this.setToolTipText(text);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        table.addContentChangedListener(t, new ExplorerTableContentChangedListener(){

            @Override
            public void contentChanged(ExplorerTableContentChangedEvent event) {
                DeleteTableObjectAction.this.selectionChanged((IStructuredSelection)DeleteTableObjectAction.this.fViewer.getSelection());
            }
        });
    }

    public void run() {
        ISelection selection = this.fViewer.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            DeleteObjectAction.deleteSelectedObjects(Trace.getDefault(), (IStructuredSelection)selection);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return this.isDeleteable(selection);
    }

    private boolean isDeleteable(IStructuredSelection selection) {
        boolean foundDeleteable = false;
        for (Object obj : selection.toList()) {
            Object treeNodeObj;
            MQExtObject mqExt = null;
            if (obj instanceof MQExtObject) {
                mqExt = (MQExtObject)obj;
            } else if (obj instanceof TreeNode && (treeNodeObj = ((TreeNode)((Object)obj)).getObject()) instanceof MQExtObject) {
                mqExt = (MQExtObject)treeNodeObj;
            }
            if (mqExt != null) {
                Object intObj = mqExt.getInternalObject();
                if (!(intObj instanceof UiMQObject)) continue;
                UiMQObject uiobj = (UiMQObject)intObj;
                if (uiobj.isSupportDelete()) {
                    foundDeleteable = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundDeleteable;
    }
}

