/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class CopyTableAction
extends Action {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/explorertable/CopyTableAction.java";
    private ExtTableViewer fViewer;
    private Clipboard fClipboard;

    public CopyTableAction(ExtTableViewer viewer, Clipboard clipboard) {
        this.fClipboard = clipboard;
        this.fViewer = viewer;
        Message msgFile = UiPlugin.getUIMessages(Trace.getDefault(), null);
        String text = msgFile.getMessage(Trace.getDefault(), "UI.GENERAL.COPY");
        this.setText(text);
        this.setToolTipText(text);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
    }

    public void run() {
        this.fClipboard.setContents(new Object[]{this.getContentsAsText()}, new Transfer[]{TextTransfer.getInstance()});
    }

    public String getContentsAsText() {
        String newLine = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        int numCols = this.fViewer.getTable().getColumnCount();
        int i = 0;
        while (i < numCols) {
            TableColumn col = this.fViewer.getTable().getColumn(i);
            if (col.getWidth() > 0) {
                String colText = col.getText();
                buf.append(colText);
                buf.append('\t');
            }
            ++i;
        }
        if (buf.charAt(buf.length() - 1) == '\t') {
            buf.deleteCharAt(buf.length() - 1);
        }
        buf.append(newLine);
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object[] items = structured.toArray();
            int i2 = 0;
            while (i2 < items.length) {
                IBaseLabelProvider base = this.fViewer.getLabelProvider();
                if (base instanceof ITableLabelProvider) {
                    ITableLabelProvider provider = (ITableLabelProvider)base;
                    int j = 0;
                    while (j < numCols) {
                        TableColumn col = this.fViewer.getTable().getColumn(j);
                        if (col.getWidth() > 0) {
                            String text = provider.getColumnText(items[i2], j);
                            buf.append(text);
                            buf.append('\t');
                        }
                        ++j;
                    }
                    if (buf.charAt(buf.length() - 1) == '\t') {
                        buf.deleteCharAt(buf.length() - 1);
                    }
                    buf.append(newLine);
                }
                ++i2;
            }
        }
        return buf.toString();
    }
}

