/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.explorertable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeDateTime;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLong;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.controls.ExtViewerSorter;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.text.Collator;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CompareColumnItems
extends ExtViewerSorter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/explorertable/CompareColumnItems.java";
    private boolean isCurrentSortAscending = true;
    private int currentSortAttrId = -1;
    private boolean isPreviousSortAscending = true;
    private int previousSortAttrId = -1;
    private Table table = null;

    public CompareColumnItems(Table tab) {
        this.table = tab;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        int[] mandatoryAttrIds;
        Trace t = Trace.getDefault();
        int retValue = 0;
        MQExtObject mqExtObject1 = (MQExtObject)o1;
        MQExtObject mqExtObject2 = (MQExtObject)o2;
        UiMQObject uiMQObject1 = (UiMQObject)mqExtObject1.getInternalObject();
        UiMQObject uiMQObject2 = (UiMQObject)mqExtObject2.getInternalObject();
        IDmObject dmObject1 = uiMQObject1.getDmObject();
        IDmObject dmObject2 = uiMQObject2.getDmObject();
        Attr attr1 = dmObject1.getAttribute(t, this.currentSortAttrId, 0);
        Attr attr2 = dmObject2.getAttribute(t, this.currentSortAttrId, 0);
        boolean isCompareByName = false;
        if (attr1 == null) {
            mandatoryAttrIds = dmObject1.getMandatoryIds(t);
            if (mandatoryAttrIds.length > 0 && this.currentSortAttrId == mandatoryAttrIds[0]) {
                isCompareByName = true;
            }
        } else if (attr2 == null && (mandatoryAttrIds = dmObject2.getMandatoryIds(t)).length > 0 && this.currentSortAttrId == mandatoryAttrIds[0]) {
            isCompareByName = true;
        }
        if (isCompareByName) {
            String value1 = dmObject1.toString(t);
            String value2 = dmObject2.toString(t);
            Collator coll = Collator.getInstance(Locale.getDefault());
            retValue = this.isCurrentSortAscending ? coll.compare(value1, value2) : coll.compare(value2, value1);
        } else if (attr1 == null && attr2 == null) {
            retValue = 0;
        } else if (attr1 == null) {
            retValue = this.isCurrentSortAscending ? -1 : 1;
        } else if (attr2 == null) {
            retValue = this.isCurrentSortAscending ? 1 : -1;
        } else {
            retValue = this.compareObjects(t, attr1, attr2);
            if (retValue == 0 && this.previousSortAttrId > 0) {
                attr1 = dmObject1.getAttribute(t, this.previousSortAttrId, 0);
                attr2 = dmObject2.getAttribute(t, this.previousSortAttrId, 0);
                if (attr1 != null && attr2 != null) {
                    retValue = this.isPreviousSortAscending ? this.compareObjects(t, attr1, attr2) : this.compareObjects(t, attr2, attr1);
                }
            }
        }
        if (Trace.isTracing) {
            t.data(67, "CompareColumnItems.compare", 300, "retValue = " + retValue);
        }
        return retValue;
    }

    private int compareObjects(Trace t, Attr attr1, Attr attr2) {
        int retValue;
        boolean isSortAsInt = false;
        boolean isSortAsLong = false;
        boolean isSortAsIntArray = false;
        boolean isSortAsDate = false;
        boolean isSortAsTime = false;
        boolean isSortAsIsoTime = false;
        AttrType attrType1 = attr1.getAttrType();
        AttrType attrType2 = attr2.getAttrType();
        if (attrType1 instanceof AttrTypeEnum) {
            isSortAsInt = ((AttrTypeEnum)attrType1).isSortByInt(t);
        } else if (attrType1 instanceof AttrTypeInt && attrType2 instanceof AttrTypeInt) {
            isSortAsInt = true;
        } else if (attrType1 instanceof AttrTypeIntArray && attrType2 instanceof AttrTypeIntArray) {
            isSortAsIntArray = true;
        } else if (attrType1 instanceof AttrTypeLong) {
            isSortAsLong = true;
        } else if (attrType1 instanceof AttrTypeDateTime && attrType2 instanceof AttrTypeDateTime) {
            if (((AttrTypeDateTime)attrType1).getType() == 50 && ((AttrTypeDateTime)attrType2).getType() == 50) {
                isSortAsDate = true;
            } else if (((AttrTypeDateTime)attrType1).getType() == 60 && ((AttrTypeDateTime)attrType2).getType() == 60) {
                isSortAsTime = true;
            } else if (((AttrTypeDateTime)attrType1).getType() == 70 && ((AttrTypeDateTime)attrType2).getType() == 70) {
                isSortAsIsoTime = true;
            }
        }
        if (isSortAsInt) {
            Object obj1 = attr1.getValue(t);
            Object obj2 = attr2.getValue(t);
            Integer value1 = (Integer)obj1;
            Integer value2 = (Integer)obj2;
            retValue = this.isCurrentSortAscending ? value1.compareTo(value2) : value2.compareTo(value1);
        } else if (isSortAsIntArray) {
            Object obj1 = attr1.getValue(t);
            Object obj2 = attr2.getValue(t);
            ArrayList value1 = (ArrayList)obj1;
            ArrayList value2 = (ArrayList)obj2;
            Integer int1 = (Integer)value1.get(0);
            Integer int2 = (Integer)value2.get(0);
            retValue = this.isCurrentSortAscending ? int1.compareTo(int2) : int2.compareTo(int1);
        } else if (isSortAsLong) {
            Object obj1 = attr1.getValue(t);
            Object obj2 = attr2.getValue(t);
            Long value1 = (Long)obj1;
            Long value2 = (Long)obj2;
            retValue = this.isCurrentSortAscending ? value1.compareTo(value2) : value2.compareTo(value1);
        } else if (isSortAsDate) {
            Calendar cal1 = ((AttrTypeDateTime)attrType1).getCalendarDate(t, attr1.getValue(t).toString());
            Calendar cal2 = ((AttrTypeDateTime)attrType1).getCalendarDate(t, attr2.getValue(t).toString());
            retValue = this.isCurrentSortAscending ? (cal1.after(cal2) ? 1 : (cal1.equals(cal2) ? 0 : -1)) : (cal1.before(cal2) ? 1 : (cal1.equals(cal2) ? 0 : -1));
        } else if (isSortAsTime) {
            Calendar cal1 = ((AttrTypeDateTime)attrType1).getCalendarTime(t, attr1.getValue(t).toString());
            Calendar cal2 = ((AttrTypeDateTime)attrType1).getCalendarTime(t, attr2.getValue(t).toString());
            retValue = this.isCurrentSortAscending ? (cal1.after(cal2) ? 1 : (cal1.equals(cal2) ? 0 : -1)) : (cal1.before(cal2) ? 1 : (cal1.equals(cal2) ? 0 : -1));
        } else if (isSortAsIsoTime) {
            Instant cal1 = ((AttrTypeDateTime)attrType1).getInstantIsoTime(t, attr1.getValue(t).toString());
            Instant cal2 = ((AttrTypeDateTime)attrType1).getInstantIsoTime(t, attr2.getValue(t).toString());
            retValue = this.isCurrentSortAscending ? (cal1.isAfter(cal2) ? 1 : (cal1.equals(cal2) ? 0 : -1)) : (cal1.isBefore(cal2) ? 1 : (cal1.equals(cal2) ? 0 : -1));
        } else {
            String value1 = attr1.toString(t);
            String value2 = attr2.toString(t);
            Collator coll = Collator.getInstance(Locale.getDefault());
            retValue = this.isCurrentSortAscending ? coll.compare(value1, value2) : coll.compare(value2, value1);
        }
        return retValue;
    }

    @Override
    public void setSortDirection(Trace t, boolean sortAscending) {
        this.isCurrentSortAscending = sortAscending;
    }

    @Override
    public void setSortColumnIndex(Trace t, int index) {
        int newAttrId = this.getAttributeIdForColumnIndex(t, index);
        if (newAttrId != this.currentSortAttrId) {
            this.previousSortAttrId = this.currentSortAttrId;
            this.currentSortAttrId = newAttrId;
            this.isPreviousSortAscending = this.isCurrentSortAscending;
        }
    }

    @Override
    public void setSortDirections(Trace t, boolean primarySortAscending, boolean secondarySortAscending) {
        this.isCurrentSortAscending = primarySortAscending;
        this.isPreviousSortAscending = secondarySortAscending;
    }

    @Override
    public void setSortColumnIndices(Trace t, int primaryIndex, int secondaryIndex) {
        this.currentSortAttrId = this.getAttributeIdForColumnIndex(t, primaryIndex);
        this.previousSortAttrId = this.getAttributeIdForColumnIndex(t, secondaryIndex);
    }

    private int getAttributeIdForColumnIndex(Trace t, int colIndex) {
        int attributeId = -1;
        TableColumn[] tabCols = this.table.getColumns();
        AttributeOrderItem attrOrderItem = (AttributeOrderItem)tabCols[colIndex].getData();
        if (attrOrderItem != null) {
            attributeId = attrOrderItem.getAttributeId();
        }
        return attributeId;
    }
}

