/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.dragdrop;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.DragDropTreeNode;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.navigator.RootTreeNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class TreeNodeTransfer
extends ByteArrayTransfer {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/dragdrop/TreeNodeTransfer.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String VERSION = "1.0";
    private static final String TYPE_NAME = "IBM_MQ_Explorer_TreeNode_Transfer";
    private static final int TYPE_ID = TreeNodeTransfer.registerType((String)"IBM_MQ_Explorer_TreeNode_Transfer");
    private static TreeNodeTransfer _instance = new TreeNodeTransfer(Trace.getDefault());
    private List<TreeNode> draggedTreeNodes = null;

    public TreeNodeTransfer(Trace t) {
    }

    public static TreeNodeTransfer getInstance() {
        return _instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        Trace t = Trace.getDefault();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        try {
            if (object instanceof List) {
                List treeNodes = (List)object;
                for (TreeNode treeNode : treeNodes) {
                    this.writeToOutputStream(t, treeNode, out);
                }
            }
            out.close();
        }
        catch (IOException e) {
            if (Trace.isTracing) {
                t.data(67, "TreeNodeTransfer.javaToNative", 900, "IOException writing details of the TreeNodes to the stream");
            }
            t.FFST(67, "TreeNodeTransfer.javaToNative", 0, -1, 0, 0, e.getMessage(), null, null);
        }
        byte[] bytes = byteOut.toByteArray();
        if (bytes != null) {
            super.javaToNative((Object)bytes, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        Trace t = Trace.getDefault();
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        return this.fromByteArray(t, bytes);
    }

    private void writeToOutputStream(Trace t, TreeNode treeNode, DataOutputStream out) throws IOException {
        out.writeUTF(treeNode.toString());
        out.writeUTF(treeNode.getTreeNodeId());
        out.writeUTF(treeNode.getPlugin_id());
        this.writeParentDetails(t, treeNode, out);
    }

    private void writeParentDetails(Trace t, TreeNode treeNode, DataOutputStream out) throws IOException {
        TreeNode parent = treeNode.getParent();
        boolean hasParent = parent != null && !(parent instanceof RootTreeNode);
        out.writeBoolean(hasParent);
        if (hasParent && parent != null) {
            out.writeUTF(parent.toString());
            out.writeUTF(parent.getTreeNodeId());
            out.writeUTF(parent.getPlugin_id());
            this.writeParentDetails(t, parent, out);
        }
    }

    private DragDropTreeNode readFromInputStream(Trace t, DataInputStream in) throws IOException {
        String name = in.readUTF();
        String treeNodeId = in.readUTF();
        String pluginId = in.readUTF();
        DragDropTreeNode dragDropTreeNode = new DragDropTreeNode(name, treeNodeId, pluginId);
        this.readParentDetails(t, in, dragDropTreeNode);
        return dragDropTreeNode;
    }

    private List<DragDropTreeNode> fromByteArray(Trace t, byte[] bytes) {
        ArrayList<DragDropTreeNode> list = new ArrayList<DragDropTreeNode>();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            DragDropTreeNode dragDropTreeNode = this.readFromInputStream(t, in);
            if (dragDropTreeNode != null) {
                list.add(dragDropTreeNode);
            }
            while (in.available() > 0) {
                dragDropTreeNode = this.readFromInputStream(t, in);
                if (dragDropTreeNode == null) continue;
                list.add(dragDropTreeNode);
            }
        }
        catch (IOException e) {
            if (Trace.isTracing) {
                t.data(67, "TreeNodeTransfer.fromByteArray", 900, "IOException reading details of the DragDropTreeNodes from the stream");
            }
            t.FFST(67, "TreeNodeTransfer.fromByteArray", 0, -1, 0, 0, e.getMessage(), null, null);
        }
        if (list.size() == 0) {
            list = null;
        }
        return list;
    }

    private void readParentDetails(Trace t, DataInputStream in, DragDropTreeNode dragDropTreeNode) throws IOException {
        boolean hasParent = in.readBoolean();
        if (hasParent) {
            String parentName = in.readUTF();
            String parentTreeNodeId = in.readUTF();
            String parentPluginId = in.readUTF();
            DragDropTreeNode parent = new DragDropTreeNode(parentName, parentTreeNodeId, parentPluginId);
            dragDropTreeNode.setParent(parent);
            this.readParentDetails(t, in, parent);
        }
    }

    public void setDraggedTreeNodes(List<TreeNode> treeNodes) {
        this.draggedTreeNodes = treeNodes;
    }

    public List<TreeNode> getDraggedTreeNodes() {
        return this.draggedTreeNodes;
    }
}

