/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.dragdrop;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.dragdrop.TreeNodeTransfer;
import java.util.Hashtable;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;

public class DragDropManager {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/dragdrop/DragDropManager.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final String[] supportedViewerIds = new String[]{"com.ibm.mq.explorer.ui.internal.views.mqnavigator"};
    private static final Transfer[][] dragTransferClasses = new Transfer[][]{{TreeNodeTransfer.getInstance(), FileTransfer.getInstance()}};
    private static final Transfer[][] dropTransferClasses = new Transfer[][]{{TreeNodeTransfer.getInstance(), FileTransfer.getInstance()}};
    private Hashtable<String, Transfer[]> tableDragSourceTransferClasses = new Hashtable();
    private Hashtable<String, Transfer[]> tableDropTargetTransferClasses = new Hashtable();

    public DragDropManager(Trace t) {
        int i = 0;
        while (i < supportedViewerIds.length) {
            this.tableDragSourceTransferClasses.put(supportedViewerIds[i], dragTransferClasses[i]);
            this.tableDropTargetTransferClasses.put(supportedViewerIds[i], dropTransferClasses[i]);
            ++i;
        }
    }

    public Transfer[] getDragSourceTransferClasses(Trace t, String viewerId) {
        return this.tableDragSourceTransferClasses.get(viewerId);
    }

    public Transfer[] getDropTargetTransferClasses(Trace t, String viewerId) {
        return this.tableDropTargetTransferClasses.get(viewerId);
    }

    public static String getOperationsAsTraceString(int ops) {
        String string = "";
        if (ops == 0) {
            string = "None";
        } else {
            if ((ops & 2) != 0) {
                string = String.valueOf(string) + "Move";
            }
            if ((ops & 1) != 0) {
                if (string.length() > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + "Copy";
            }
        }
        return string;
    }
}

