/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.base.WorkspaceDescriptor;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableColumnManager;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class WorkspaceMigrationDialog
extends TitleAreaDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/dialogs/WorkspaceMigrationDialog.java";
    protected Message msgFile;
    private Button radioButtonNoCopy;
    private Button radioButtonCopyWorkspace;
    private Label labelInstallName;
    private List<WorkspaceDescriptor> workspaces;
    private WorkspaceDescriptor selectedWorkspace;
    private ExtCombo comboWorkspaces;
    private Table tableWorkspaceInfo;
    private TableItem itemInstallationName;
    private TableItem itemInstallationDesc;
    private TableItem itemInstallationState;
    private TableItem itemWorkspaceVersion;
    private TableItem itemWorkspacePath;
    private TableColumn colName;
    private TableColumn colValue;
    private static int HORIZONTAL_INDENT = 18;

    public WorkspaceMigrationDialog(Trace t, Shell parent, List<WorkspaceDescriptor> workspaces) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        this.workspaces = workspaces;
    }

    protected Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.msgFile.getMessage(t, "UI.GENERAL.MQ"));
        this.setTitle(this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.TitleArea.Title"));
        this.setMessage(this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.TitleArea.Desc"));
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite radioComposite = new Composite(composite, 0);
        radioComposite.setLayout((Layout)new GridLayout(2, false));
        radioComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.radioButtonNoCopy = new Button(radioComposite, 16);
        this.radioButtonNoCopy.setText(this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.Button.NoCopy.Title"));
        this.radioButtonNoCopy.setLayoutData((Object)gridData);
        this.radioButtonNoCopy.setSelection(true);
        this.radioButtonNoCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                WorkspaceMigrationDialog.this.checkMigrationChoice(t2);
            }
        });
        gridData = new GridData(4, 0x1000000, true, false);
        this.radioButtonCopyWorkspace = new Button(radioComposite, 16);
        this.radioButtonCopyWorkspace.setText(this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.Button.Copy.Title"));
        this.radioButtonCopyWorkspace.setLayoutData((Object)gridData);
        this.radioButtonCopyWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                WorkspaceMigrationDialog.this.checkMigrationChoice(t2);
            }
        });
        Link warningLink = new Link(radioComposite, 0);
        warningLink.setText(this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.Warning.Title"));
        warningLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UiPlugin.getHelpSystem().displayHelp("com.ibm.mq.explorer.ui.infopop.UI_WorkspaceMigration_Dialog");
            }
        });
        Group groupCopySettings = new Group(composite, 0);
        groupCopySettings.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        groupCopySettings.setLayoutData((Object)gridData);
        this.labelInstallName = new Label((Composite)groupCopySettings, 0);
        this.labelInstallName.setText(this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.Label.Title"));
        this.comboWorkspaces = new ExtCombo((Composite)groupCopySettings, 12);
        this.comboWorkspaces.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.comboWorkspaces.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                WorkspaceMigrationDialog.this.updateWorkspaceTable(t2);
            }
        });
        UiUtils.createBlankLine((Composite)groupCopySettings, 2);
        this.tableWorkspaceInfo = new Table((Composite)groupCopySettings, 2048);
        this.tableWorkspaceInfo.setLinesVisible(true);
        this.colName = new TableColumn(this.tableWorkspaceInfo, 0);
        this.colValue = new TableColumn(this.tableWorkspaceInfo, 0);
        this.colName.setWidth(100);
        this.colValue.setWidth(100);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.tableWorkspaceInfo.setLayoutData((Object)gridData);
        this.itemInstallationName = new TableItem(this.tableWorkspaceInfo, 0);
        this.itemInstallationName.setText(0, this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.Table.InstallName.Title"));
        this.itemInstallationDesc = new TableItem(this.tableWorkspaceInfo, 0);
        this.itemInstallationDesc.setText(0, this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.Table.InstallDesc.Title"));
        this.itemInstallationState = new TableItem(this.tableWorkspaceInfo, 0);
        this.itemInstallationState.setText(0, this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.Table.InstallState.Title"));
        this.itemWorkspaceVersion = new TableItem(this.tableWorkspaceInfo, 0);
        this.itemWorkspaceVersion.setText(0, this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.Table.InstallVersion.Title"));
        this.itemWorkspacePath = new TableItem(this.tableWorkspaceInfo, 0);
        this.itemWorkspacePath.setText(0, this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.Table.WorkspacePath.Title"));
        for (WorkspaceDescriptor workspace : this.workspaces) {
            this.comboWorkspaces.add(workspace);
        }
        this.comboWorkspaces.select(0);
        this.tableWorkspaceInfo.pack();
        UiPlugin.getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.mq.explorer.ui.infopop.UI_WorkspaceMigration_Dialog");
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Trace t2 = Trace.getDefault();
                WorkspaceMigrationDialog.this.resizeTableColumns(t2);
            }
        });
        this.updateWorkspaceTable(t);
        this.checkMigrationChoice(t);
        return composite;
    }

    private void checkMigrationChoice(Trace t) {
        if (this.radioButtonNoCopy != null) {
            boolean selected = this.radioButtonCopyWorkspace.getSelection();
            UiUtils.enableControls(t, new Control[]{this.labelInstallName, this.comboWorkspaces, this.tableWorkspaceInfo}, selected);
            if (selected) {
                this.updateWorkspaceTable(t);
            } else {
                this.selectedWorkspace = null;
            }
        }
    }

    private void resizeTableColumns(Trace t) {
        int tableWidth = this.tableWorkspaceInfo.getClientArea().width;
        if (tableWidth > 0) {
            int numCols = this.tableWorkspaceInfo.getColumnCount();
            int availableWidth = tableWidth - numCols * this.tableWorkspaceInfo.getGridLineWidth();
            int maxWidth = 999999999;
            this.tableWorkspaceInfo.setRedraw(false);
            ArrayList<Integer> constrainedColumns = new ArrayList<Integer>();
            TableColumn[] tabCols = this.tableWorkspaceInfo.getColumns();
            if (tabCols.length > 0) {
                if (!ExtTableColumnManager.isGetColumnWidths(t)) {
                    int i = 0;
                    while (i < tabCols.length) {
                        tabCols[i].pack();
                        ++i;
                    }
                } else {
                    int excessWidthColumnIndex;
                    int actualWidth = 0;
                    int i = 0;
                    while (i < tabCols.length) {
                        int tabcolWidth;
                        if (tabCols[i].getWidth() > 0) {
                            Image image;
                            tabCols[i].pack();
                            if (tabCols[i].getWidth() > maxWidth && maxWidth != 0) {
                                tabCols[i].setWidth(maxWidth);
                                constrainedColumns.add(i);
                            }
                            if ((image = tabCols[i].getImage()) != null) {
                                tabCols[i].setWidth(tabCols[i].getWidth() + image.getBounds().width);
                            }
                        }
                        if ((tabcolWidth = tabCols[i].getWidth()) > 0) {
                            // empty if block
                        }
                        actualWidth += tabcolWidth;
                        ++i;
                    }
                    int spareWidth = availableWidth - actualWidth;
                    if (spareWidth > 0 && (excessWidthColumnIndex = 1) < tabCols.length) {
                        int width = tabCols[excessWidthColumnIndex].getWidth();
                        tabCols[excessWidthColumnIndex].setWidth(width + spareWidth);
                    }
                }
            }
            this.tableWorkspaceInfo.setRedraw(true);
            this.tableWorkspaceInfo.update();
        }
    }

    protected void updateWorkspaceTable(Trace t) {
        int selection = this.comboWorkspaces.getSelectionIndex();
        this.selectedWorkspace = null;
        Object selectedObject = this.comboWorkspaces.getObject(selection);
        if (selectedObject instanceof WorkspaceDescriptor) {
            WorkspaceDescriptor selectedDescriptor = (WorkspaceDescriptor)selectedObject;
            this.itemInstallationName.setText(1, selectedDescriptor.getInstallationName());
            this.itemInstallationDesc.setText(1, selectedDescriptor.getInstallationDesc());
            if (selectedDescriptor.getInstallationState() == 1) {
                this.itemInstallationState.setText(1, this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.Table.Installed.Title"));
            } else if (selectedDescriptor.getInstallationState() == 0) {
                this.itemInstallationState.setText(1, this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.Table.Uninstalled.Title"));
            } else if (selectedDescriptor.getInstallationState() == -1) {
                this.itemInstallationState.setText(1, this.msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.Table.Unknown.Title"));
            } else {
                this.itemInstallationState.setText(1, "");
            }
            this.itemWorkspacePath.setText(1, selectedDescriptor.getLocation());
            this.itemWorkspaceVersion.setText(1, selectedDescriptor.getWorkspaceVersionString());
            this.tableWorkspaceInfo.setEnabled(true);
            this.selectedWorkspace = selectedDescriptor;
        }
        this.resizeTableColumns(t);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public WorkspaceDescriptor getSelectedWorkspace() {
        return this.selectedWorkspace;
    }
}

