/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.event.DmMonitor;
import com.ibm.mq.explorer.core.internal.event.DmObjectAdapter;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.core.internal.utils.OtherQueueManager;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.StatusBar;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TransferQMDialog
extends TitleAreaDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/dialogs/TransferQMDialog.java";
    private Message msgFile;
    private Table qmStoppedTable;
    private Table qmActiveTable;
    private StatusBar activeStatusBar;
    private StatusBar stoppedStatusBar;
    private Button transferButton;
    private List<String> selectedQMs;
    private boolean performingResize = false;
    private boolean performingRefresh = false;
    private Date lastUpdateDate = null;
    private DmObjectAdapter dmListener;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    public static int MQQMSTA_STOPPED = -1;
    private static final int NAME_COL = 0;
    private static final int INST_COL = 1;
    private static final int STATUS_COL = 2;

    public TransferQMDialog(Trace t, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_General");
    }

    private Table createTable(final Composite parent, boolean isCheck) {
        int style = 67586;
        if (isCheck) {
            style |= 0x20;
        }
        final Table table = new Table(parent, style);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = table.getItemHeight() * 3 + table.getHeaderHeight();
        table.setLayoutData((Object)gridData);
        TableColumn col1 = new TableColumn(table, 0);
        col1.setText(this.msgFile.getMessage("UI.TransferQM.Dialog.Column.Name"));
        col1.setMoveable(true);
        col1.pack();
        TableColumn col2 = new TableColumn(table, 0);
        col2.setText(this.msgFile.getMessage("UI.TransferQM.Dialog.Column.Installation"));
        col2.setMoveable(true);
        col2.pack();
        TableColumn col3 = new TableColumn(table, 0);
        col3.setText(this.msgFile.getMessage("UI.TransferQM.Dialog.Column.Status"));
        col3.setMoveable(true);
        col3.pack();
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                ScrollBar vBar = table.getVerticalBar();
                int width = area.width - table.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
                Point vBarSize = vBar.getSize();
                width -= vBarSize.x;
                Point oldSize = table.getSize();
                if (oldSize.x > area.width) {
                    TableColumn[] cols = table.getColumns();
                    int widthEach = width / 3;
                    cols[0].setWidth(widthEach);
                    cols[1].setWidth(widthEach);
                    cols[2].setWidth(widthEach);
                    table.setSize(area.width, area.height);
                } else {
                    table.setSize(area.width, area.height);
                    TableColumn[] cols = table.getColumns();
                    int widthEach = width / 3;
                    cols[0].setWidth(widthEach);
                    cols[1].setWidth(widthEach);
                    cols[2].setWidth(widthEach);
                }
            }
        });
        return table;
    }

    protected Control createDialogArea(Composite parent) {
        TableColumn tc;
        Trace t = Trace.getDefault();
        Composite main = (Composite)super.createDialogArea(parent);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite scrolledComp = new ScrolledComposite(main, 768);
        Composite composite = new Composite((Composite)scrolledComp, 0);
        scrolledComp.setContent((Control)composite);
        scrolledComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.getShell().setText(this.msgFile.getMessage("UI.TransferQM.Dialog.Title"));
        this.setTitle(this.msgFile.getMessage("UI.TransferQM.Dialog.Main.Title"));
        this.setMessage(this.msgFile.getMessage("UI.TransferQM.Dialog.Sub.Title"));
        UiPlugin.getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.mq.explorer.ui.infopop.UI_QMGR_TRANSFER_DIALOG");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite listGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        listGroup.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        listGroup.setLayoutData((Object)gridData);
        Label prompt = new Label(listGroup, 0);
        prompt.setText(this.msgFile.getMessage("UI.TransferQM.Dialog.Stopped.QMs.Text"));
        this.qmStoppedTable = this.createTable(listGroup, true);
        this.qmStoppedTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransferQMDialog.this.processSelection();
            }
        });
        this.stoppedStatusBar = new StatusBar(t, listGroup, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.stoppedStatusBar.setLayoutData(gridData);
        new Label(listGroup, 0);
        prompt = new Label(listGroup, 0);
        prompt.setText(this.msgFile.getMessage("UI.TransferQM.Dialog.Running.QMs.Text"));
        this.qmActiveTable = this.createTable(listGroup, false);
        this.activeStatusBar = new StatusBar(t, listGroup, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.activeStatusBar.setLayoutData(gridData);
        TableColumn[] tableColumnArray = this.qmActiveTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            tc = tableColumnArray[n2];
            tc.addControlListener((ControlListener)new ControlAdapter(){

                public void controlMoved(ControlEvent e) {
                    TransferQMDialog.this.updateTableColumns(TransferQMDialog.this.qmActiveTable);
                }

                public void controlResized(ControlEvent e) {
                    TransferQMDialog.this.updateTableColumns(TransferQMDialog.this.qmActiveTable);
                }
            });
            ++n2;
        }
        tableColumnArray = this.qmStoppedTable.getColumns();
        n = tableColumnArray.length;
        n2 = 0;
        while (n2 < n) {
            tc = tableColumnArray[n2];
            tc.addControlListener((ControlListener)new ControlAdapter(){

                public void controlMoved(ControlEvent e) {
                    TransferQMDialog.this.updateTableColumns(TransferQMDialog.this.qmStoppedTable);
                }

                public void controlResized(ControlEvent e) {
                    TransferQMDialog.this.updateTableColumns(TransferQMDialog.this.qmStoppedTable);
                }
            });
            ++n2;
        }
        Text explain = new Text(composite, 66);
        explain.setText(this.msgFile.getMessage("UI.TransferQM.Dialog.Footnote"));
        UiUtils.makeTextControlReadOnly(t, explain, true);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 400;
        explain.setLayoutData((Object)gridData);
        this.dmListener = new DmObjectAdapter(){

            public void dmRefreshComplete(DmObjectEvent event) {
                if (event.getObjectType() == 1001) {
                    UiPlugin.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TransferQMDialog.this.refreshStatus();
                        }
                    });
                }
            }
        };
        DmMonitor.addMachineListener((Trace)t, (DmObjectListener)this.dmListener);
        this.refreshStatus();
        composite.layout();
        scrolledComp.setMinSize(composite.computeSize(-1, -1));
        scrolledComp.setExpandHorizontal(true);
        scrolledComp.setExpandVertical(true);
        UiUtils.addScrollListeners(scrolledComp);
        return composite;
    }

    public boolean close() {
        DmMonitor.removeMachineListener((Trace)Trace.getDefault(), (DmObjectListener)this.dmListener);
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 8) {
            this.refreshStatus();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void processSelection() {
        this.selectedQMs = new ArrayList<String>();
        TableItem[] items = this.qmStoppedTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                this.selectedQMs.add(items[i].getText(0));
            }
            ++i;
        }
        if (this.selectedQMs.size() > 0) {
            this.transferButton.setEnabled(true);
            this.setErrorMessage(null);
        } else {
            this.transferButton.setEnabled(false);
            this.setErrorMessage(this.msgFile.getMessage("UI.TransferQM.Dialog.Transfer.NoneSelectedError"));
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 8, this.msgFile.getMessage("UI.TransferQM.Dialog.Refresh.Button"), true);
        this.transferButton = this.createButton(parent, 0, this.msgFile.getMessage("UI.TransferQM.Dialog.Transfer.Button"), true);
        this.transferButton.setEnabled(false);
        Button button = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        button.setFocus();
    }

    public List<String> getSelectedQueueManagers() {
        return this.selectedQMs;
    }

    private void refreshStatus() {
        final Trace t = Trace.getDefault();
        if (!this.performingRefresh) {
            this.performingRefresh = true;
            this.activeStatusBar.setProgressBarVisible(t, true);
            this.stoppedStatusBar.setProgressBarVisible(t, true);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    TransferQMDialog.this.refreshStatusFromCoreServices(t);
                }
            };
            Thread internalThread = new Thread(r);
            internalThread.setName("TransferQMDialog.RefreshStatusThread");
            internalThread.start();
        }
    }

    private void refreshStatusFromCoreServices(Trace t) {
        if (this.performingRefresh) {
            final List otherQmgrs = CoreServices.getQueueManagersWithStatusFromOtherInstallations();
            UiPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TransferQMDialog.this.updateTables(Trace.getDefault(), otherQmgrs);
                }
            });
        }
    }

    private void updateTables(Trace t, List<OtherQueueManager> otherQmgrs) {
        ArrayList<TableItem> toActiveTable = new ArrayList<TableItem>();
        ArrayList<TableItem> toStoppedTable = new ArrayList<TableItem>();
        for (OtherQueueManager qmgr : otherQmgrs) {
            TableItem item;
            boolean found = false;
            TableItem[] tableItemArray = this.qmActiveTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                item = tableItemArray[n2];
                if (item.getText(0).equals(qmgr.getQueueManagerName())) {
                    this.updateTableItemFromQmgr(t, qmgr, item);
                    if (qmgr.getStatus() == MQQMSTA_STOPPED) {
                        toStoppedTable.add(item);
                    }
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                tableItemArray = this.qmStoppedTable.getItems();
                n = tableItemArray.length;
                n2 = 0;
                while (n2 < n) {
                    item = tableItemArray[n2];
                    if (item.getText(0).equals(qmgr.getQueueManagerName())) {
                        this.updateTableItemFromQmgr(t, qmgr, item);
                        if (qmgr.getStatus() != MQQMSTA_STOPPED) {
                            toActiveTable.add(item);
                        }
                        found = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (found) continue;
            Table addToTable = qmgr.getStatus() != MQQMSTA_STOPPED ? this.qmActiveTable : this.qmStoppedTable;
            TableItem item2 = new TableItem(addToTable, 0);
            item2.setText(0, qmgr.getQueueManagerName());
            this.updateTableItemFromQmgr(t, qmgr, item2);
        }
        for (TableItem item : toActiveTable) {
            TableItem itemToAdd = new TableItem(this.qmActiveTable, 0);
            itemToAdd.setText(0, item.getText(0));
            itemToAdd.setText(1, item.getText(1));
            itemToAdd.setText(2, item.getText(2));
            itemToAdd.setImage(item.getImage());
            this.qmStoppedTable.remove(this.qmStoppedTable.indexOf(item));
        }
        for (TableItem item : toStoppedTable) {
            TableItem itemToAdd = new TableItem(this.qmStoppedTable, 0);
            itemToAdd.setText(0, item.getText(0));
            itemToAdd.setText(1, item.getText(1));
            itemToAdd.setText(2, item.getText(2));
            itemToAdd.setImage(item.getImage());
            this.qmActiveTable.remove(this.qmActiveTable.indexOf(item));
        }
        this.activeStatusBar.setProgressBarVisible(t, false);
        this.stoppedStatusBar.setProgressBarVisible(t, false);
        this.updateLastRefreshText(t, this.qmActiveTable);
        this.updateLastRefreshText(t, this.qmStoppedTable);
        this.performingRefresh = false;
    }

    private void updateTableItemFromQmgr(Trace t, OtherQueueManager qmgr, TableItem item) {
        item.setText(1, qmgr.getInstallationName());
        item.setText(2, this.getStatusString(t, qmgr.getStatus()));
        switch (qmgr.getStatus()) {
            case 0: 
            case 6: 
            case 14: {
                item.setImage(Icons.get(Icons.iconkeyQmgrSmallLocalStartedConnected));
                break;
            }
            case 13: {
                item.setImage(Icons.get(Icons.iconkeyQmgrSmallLocalStandby));
                break;
            }
            default: {
                item.setImage(Icons.get(Icons.iconkeyQmgrSmallLocalStopped));
            }
        }
    }

    private String getStatusString(Trace t, int statusCode) {
        String statusString;
        switch (statusCode) {
            case 0: {
                statusString = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Local.Started.Text");
                break;
            }
            case 14: {
                statusString = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Local.Elsewhere.title");
                break;
            }
            case 13: {
                statusString = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Local.Standby.title");
                break;
            }
            case 6: {
                statusString = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Local.Quiescing.title");
                break;
            }
            default: {
                statusString = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Local.Stopped.Text");
            }
        }
        return statusString;
    }

    private void updateTableColumns(Table originTable) {
        if (!this.performingResize) {
            this.performingResize = true;
            Table tableToMod = originTable == this.qmActiveTable ? this.qmStoppedTable : this.qmActiveTable;
            int i = 0;
            while (i < originTable.getColumnCount()) {
                tableToMod.getColumn(i).setWidth(originTable.getColumn(i).getWidth());
                ++i;
            }
            tableToMod.setColumnOrder(originTable.getColumnOrder());
            this.performingResize = false;
        }
    }

    private void updateLastRefreshText(Trace t, Table table) {
        int i;
        String dateString = this.lastUpdateDate != null ? this.dateFormat.format(this.lastUpdateDate) : this.dateFormat.format(new Date());
        String statusText = table != null && !table.isDisposed() ? ((i = table.getItemCount()) == 1 ? this.msgFile.getMessage(t, "UI.TABLES.Table.Status.Update.1.Item.Count", dateString) : this.msgFile.getMessage(t, "UI.TABLES.Table.Status.Update.Item.Count", new String[]{dateString, String.valueOf(i)})) : this.msgFile.getMessage(t, "UI.TABLES.Table.Status.Update", dateString);
        StatusBar sb = table == this.qmActiveTable ? this.activeStatusBar : this.stoppedStatusBar;
        sb.showMessage(t, statusText);
    }
}

