/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.explorertable.StatusBar;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Locale;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public abstract class SubscribeDialogBase
extends Dialog
implements ShellListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/dialogs/SubscribeDialogBase.java";
    public static final double messageRatio = 0.6;
    public static final int MAX_MSG_LENGTH = 500;
    public static final String DATE_FORMAT = "HH:mm:ss";
    public static final String COLON = ":";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final Locale locale = Locale.getDefault();
    protected Shell myShell;
    protected Shell parent = null;
    protected Button buttonClear = null;
    protected Button buttonSubscribe = null;
    protected Button buttonUnsubscribe = null;
    protected Button buttonClose = null;
    protected Button selectButton = null;
    protected Text messageText = null;
    protected Table messageTable = null;
    protected ExtCombo combo;
    protected Text topicText;
    protected BusyDialog busyDialog = null;
    protected Message msgFile;
    protected Text qmgrText;
    protected ExtCombo wildcardCombo = null;
    protected StatusBar statusBar = null;
    protected boolean containsMessages = false;
    protected static String TOPIC_STRING_NOT_FOUND = "";
    protected static final String MESSAGE_SEPARATOR = "---------------------------------------------------------------------------------------";

    public SubscribeDialogBase(Trace t, Shell parent) {
        super(parent);
        this.parent = parent;
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
        TOPIC_STRING_NOT_FOUND = this.msgFile.getMessage(t, "UI.GENERAL.NOT.FOUND");
    }

    public void open(Trace t, String qmgr, String topic, boolean isStream, String stream, Image dialogImage, String helpId, boolean displayMsgsInTable, boolean displayWildcardCombo, boolean displayTopicString) {
        int shellOptions = 3312;
        if ((this.parent.getStyle() & 0x10000) == 65536) {
            shellOptions |= 0x10000;
        }
        this.myShell = new Shell(this.parent, shellOptions);
        this.myShell.setText(this.msgFile.getMessage(t, "Ui.Test.Subscribe.Dialog.Title"));
        this.myShell.setImage(dialogImage);
        UiPlugin.getHelpSystem().setHelp((Control)this.myShell, helpId);
        FillLayout fillLayout = new FillLayout();
        this.myShell.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.myShell.setLayoutData((Object)gridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.myShell, 768);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        Composite top = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        top.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        top.setLayoutData((Object)gridData);
        Group message = new Group(top, 0);
        message.setText(this.msgFile.getMessage(t, "Ui.Test.Subscribe.Group.Info"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        message.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        message.setLayoutData((Object)gridData);
        Composite group = new Composite((Composite)message, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        group.setLayoutData((Object)gridData);
        Label label = new Label(group, 0);
        label.setText(this.msgFile.getMessage(t, "Ui.Test.Qmgr.Title"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.qmgrText = new Text(group, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.qmgrText.setLayoutData((Object)gridData);
        if (qmgr != null) {
            UiUtils.makeTextControlReadOnly(t, this.qmgrText, true);
            this.qmgrText.setText(qmgr);
        }
        if (isStream) {
            this.drawStreamBox(t, group, stream);
        }
        Label topicLabel = new Label(group, 0);
        if (displayTopicString) {
            topicLabel.setText(this.msgFile.getMessage(t, "Ui.Test.Topic.String.Title"));
        } else {
            topicLabel.setText(this.msgFile.getMessage(t, "Ui.Test.Topic.Title"));
        }
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        topicLabel.setLayoutData((Object)gridData);
        this.topicText = new Text(group, 2048);
        GridData topicGrid = new GridData(768);
        topicGrid.horizontalSpan = 4;
        topicGrid.grabExcessHorizontalSpace = true;
        this.topicText.setLayoutData((Object)topicGrid);
        if (topic != null) {
            this.topicText.setText(topic);
        }
        this.topicText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                SubscribeDialogBase.this.enableSubscribe(t2);
            }
        });
        int maxWidth = 0;
        Point sizeTopic = this.qmgrText.computeSize(-1, -1);
        maxWidth = sizeTopic.x;
        if (maxWidth < 350) {
            maxWidth = 350;
        }
        topicGrid.widthHint = maxWidth;
        if (displayWildcardCombo) {
            this.drawWildcardCombo(t, group);
        }
        Composite subscribeButtons = new Composite(group, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        subscribeButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        subscribeButtons.setLayoutData((Object)gridData);
        this.buttonSubscribe = new Button(subscribeButtons, 8);
        GridData subscribeGrid = new GridData();
        subscribeGrid.horizontalSpan = 1;
        this.buttonSubscribe.setText(this.msgFile.getMessage(t, "Ui.Button.Subscribe.Text"));
        this.buttonSubscribe.setLayoutData((Object)subscribeGrid);
        this.buttonSubscribe.setEnabled(false);
        this.buttonSubscribe.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                SubscribeDialogBase.this.subscribe(t2);
            }
        });
        this.buttonUnsubscribe = new Button(subscribeButtons, 8);
        GridData unsubscribeGrid = new GridData();
        unsubscribeGrid.horizontalSpan = 1;
        this.buttonUnsubscribe.setText(this.msgFile.getMessage(t, "Ui.Button.Unsubscribe.Text"));
        this.buttonUnsubscribe.setLayoutData((Object)unsubscribeGrid);
        this.buttonUnsubscribe.setEnabled(false);
        this.buttonUnsubscribe.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                SubscribeDialogBase.this.unsubscribe(t2);
            }
        });
        int buttonMaxWidth = 0;
        Point sizeSubscribe = this.buttonSubscribe.computeSize(-1, -1);
        Point sizeUnsubscribe = this.buttonUnsubscribe.computeSize(-1, -1);
        if (sizeSubscribe.x > buttonMaxWidth) {
            buttonMaxWidth = sizeSubscribe.x;
        }
        if (sizeUnsubscribe.x > buttonMaxWidth) {
            buttonMaxWidth = sizeUnsubscribe.x;
        }
        unsubscribeGrid.widthHint = buttonMaxWidth;
        subscribeGrid.widthHint = buttonMaxWidth;
        Label padding = new Label(subscribeButtons, 0);
        gridData = new GridData(3);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        padding.setLayoutData((Object)gridData);
        Group messageReceived = new Group(top, 0);
        messageReceived.setText(this.msgFile.getMessage(t, "Ui.Test.Subscribe.Group.Messages"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        messageReceived.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        messageReceived.setLayoutData((Object)gridData);
        Composite messageGroup = new Composite((Composite)messageReceived, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        messageGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        messageGroup.setLayoutData((Object)gridData);
        this.messageText = new Text(messageGroup, 2824);
        this.messageText.setLayoutData((Object)gridData);
        this.messageText.setBackground(UiPlugin.getConsoleBackgroundColor());
        this.messageText.insert(String.valueOf(LINE_SEPARATOR) + LINE_SEPARATOR + LINE_SEPARATOR + LINE_SEPARATOR + LINE_SEPARATOR);
        this.messageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SubscribeDialogBase.this.messageText.getText().length() > 0) {
                    SubscribeDialogBase.this.buttonClear.setEnabled(true);
                } else {
                    SubscribeDialogBase.this.buttonClear.setEnabled(false);
                }
            }
        });
        this.buttonClear = new Button(messageGroup, 8);
        GridData clearGrid = new GridData();
        this.buttonClear.setText(this.msgFile.getMessage(t, "UI.GENERAL.CLEAR"));
        this.buttonClear.setLayoutData((Object)clearGrid);
        this.buttonClear.setEnabled(false);
        this.buttonClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                SubscribeDialogBase.this.clearText(t2);
            }
        });
        this.statusBar = new StatusBar(t, composite, 0);
        this.statusBar.setCompressedMode(t);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.statusBar.setLayoutData(gridData);
        Composite compCloseButton = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        compCloseButton.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        compCloseButton.setLayoutData((Object)gridData);
        Label labels = new Label(compCloseButton, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        labels.setLayoutData((Object)gridData);
        this.buttonClose = new Button(compCloseButton, 8);
        GridData closeGrid = new GridData();
        this.buttonClose.setText(this.msgFile.getMessage(t, "UI.GENERAL.CLOSE"));
        this.buttonClose.setLayoutData((Object)closeGrid);
        this.buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                SubscribeDialogBase.this.closePressed(tr);
                SubscribeDialogBase.this.myShell.close();
            }
        });
        Point size = composite.computeSize(-1, -1);
        scrolledComposite.setMinSize(size);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.myShell.pack();
        this.myShell.open();
        if (topic != null && topic != "") {
            this.subscribe(t);
        }
        this.myShell.addShellListener((ShellListener)this);
        this.topicText.setFocus();
    }

    protected void clearText(Trace t) {
        this.messageText.setText("");
    }

    protected void enableSubscribe(Trace t) {
        int charCount = this.topicText.getText().length();
        if (!this.isSubscribed()) {
            if (charCount > 0) {
                this.buttonSubscribe.setEnabled(true);
                this.buttonUnsubscribe.setEnabled(false);
                this.myShell.setDefaultButton(this.buttonSubscribe);
            } else {
                this.buttonSubscribe.setEnabled(false);
                this.buttonUnsubscribe.setEnabled(false);
                this.myShell.setDefaultButton(this.buttonClose);
            }
        } else {
            this.buttonSubscribe.setEnabled(false);
            this.buttonUnsubscribe.setEnabled(true);
            this.myShell.setDefaultButton(this.buttonUnsubscribe);
        }
    }

    protected abstract void subscribe(Trace var1);

    protected abstract void unsubscribe(Trace var1);

    protected abstract void drawStreamBox(Trace var1, Composite var2, String var3);

    protected void drawWildcardCombo(Trace t, Composite composite) {
    }

    protected boolean isSubscribed() {
        return true;
    }

    protected void closePressed(Trace t) {
    }

    public void shellClosed(ShellEvent e) {
        this.closePressed(Trace.getDefault());
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public void setStatus(Trace t, String status) {
        if (this.statusBar != null && !this.statusBar.isDisposed()) {
            this.statusBar.showMessage(t, status);
        }
    }
}

