/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.StatusBar;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Locale;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class PublishDialogBase
extends Dialog
implements ShellListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/dialogs/PublishDialogBase.java";
    public static final int TOPIC_GRID_WIDTH_HINT = 350;
    protected Shell myShell;
    protected Shell parent = null;
    protected Button buttonPublish = null;
    protected Button buttonClose = null;
    protected Text messageText = null;
    protected Text qmgrText = null;
    protected boolean retained = false;
    protected Message msgFile;
    protected Text topicText;
    protected StatusBar statusBar = null;
    public static final String DATE_FORMAT = "HH:mm:ss";
    public static final Locale locale = Locale.getDefault();

    public PublishDialogBase(Trace t, Shell parent) {
        super(parent);
        this.parent = parent;
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
    }

    public void open(Trace t, String qmgr, String topic, boolean isStream, String stream, Image dialogImage, String helpId, boolean displayTopicString) {
        int shellOptions = 3312;
        if ((this.parent.getStyle() & 0x10000) == 65536) {
            shellOptions |= 0x10000;
        }
        this.myShell = new Shell(this.parent, shellOptions);
        this.myShell.setText(this.msgFile.getMessage(t, "Ui.Test.Publish.Dialog.Title"));
        this.myShell.setImage(dialogImage);
        UiPlugin.getHelpSystem().setHelp((Control)this.myShell, helpId);
        FillLayout fillLayout = new FillLayout();
        this.myShell.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.myShell.setLayoutData((Object)gridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.myShell, 768);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        Composite top = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        top.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        top.setLayoutData((Object)gridData);
        Group message = new Group(top, 0);
        message.setText(this.msgFile.getMessage(t, "Ui.Test.Publish.Group.Info"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        message.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        message.setLayoutData((Object)gridData);
        Composite group = new Composite((Composite)message, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        group.setLayoutData((Object)gridData);
        Label label = new Label(group, 0);
        label.setText(this.msgFile.getMessage(t, "Ui.Test.Qmgr.Title"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.qmgrText = new Text(group, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.qmgrText.setLayoutData((Object)gridData);
        if (qmgr != null) {
            UiUtils.makeTextControlReadOnly(t, this.qmgrText, true);
            this.qmgrText.setText(qmgr);
        }
        if (isStream) {
            this.drawStreamBox(t, group, stream);
        }
        Label topicLabel = new Label(group, 0);
        if (displayTopicString) {
            topicLabel.setText(this.msgFile.getMessage(t, "Ui.Test.Topic.String.Title"));
        } else {
            topicLabel.setText(this.msgFile.getMessage(t, "Ui.Test.Topic.Title"));
        }
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        topicLabel.setLayoutData((Object)gridData);
        this.topicText = new Text(group, 2048);
        GridData topicGrid = new GridData(768);
        topicGrid.horizontalSpan = 4;
        topicGrid.grabExcessHorizontalSpace = true;
        this.topicText.setLayoutData((Object)topicGrid);
        if (topic != null) {
            this.topicText.setText(topic);
        }
        this.topicText.setFocus();
        this.topicText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                PublishDialogBase.this.enablePublish(t2);
            }
        });
        int maxWidth = 0;
        Point sizeTopic = this.qmgrText.computeSize(-1, -1);
        maxWidth = sizeTopic.x;
        if (maxWidth < 350) {
            maxWidth = 350;
        }
        topicGrid.widthHint = maxWidth;
        Label messageLabel = new Label(top, 0);
        messageLabel.setText(this.msgFile.getMessage(t, "Ui.Test.Publish.MessageData"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        messageLabel.setLayoutData((Object)gridData);
        this.messageText = new Text(top, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.messageText.setLayoutData((Object)gridData);
        if (topic != null) {
            this.messageText.setFocus();
        }
        this.messageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                PublishDialogBase.this.enablePublish(t2);
            }
        });
        final Button retainedButton = new Button(top, 32);
        retainedButton.setEnabled(true);
        retainedButton.setText(this.msgFile.getMessage(t, "Ui.Test.Publish.Retained"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        retainedButton.setLayoutData((Object)gridData);
        retainedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishDialogBase.this.retained = retainedButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group warningGroup = new Group(top, 0);
        GridLayout infoLayout = new GridLayout();
        infoLayout.numColumns = 2;
        warningGroup.setLayout((Layout)infoLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        warningGroup.setLayoutData((Object)gridData);
        Label imageLabel = new Label((Composite)warningGroup, 0);
        gridData = new GridData(258);
        imageLabel.setLayoutData((Object)gridData);
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        imageLabel.setImage(imageRegistry.get("dialog_messasge_info_image"));
        Label textLabel = new Label((Composite)warningGroup, 64);
        gridData = new GridData(768);
        textLabel.setLayoutData((Object)gridData);
        textLabel.setText(this.msgFile.getMessage(t, "Ui.Test.Publish.Warning"));
        this.statusBar = new StatusBar(t, composite, 0);
        this.statusBar.setCompressedMode(t);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.statusBar.setLayoutData(gridData);
        Composite compRefreshCloseButtons = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        compRefreshCloseButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        compRefreshCloseButtons.setLayoutData((Object)gridData);
        Label padding = new Label(compRefreshCloseButtons, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        padding.setLayoutData((Object)gridData);
        this.buttonPublish = new Button(compRefreshCloseButtons, 8);
        GridData publishGrid = new GridData();
        this.buttonPublish.setText(this.msgFile.getMessage(t, "Ui.Button.Publish.Text"));
        this.buttonPublish.setLayoutData((Object)publishGrid);
        this.buttonPublish.setEnabled(false);
        this.buttonPublish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PublishDialogBase.this.publish(t2);
                PublishDialogBase.this.enablePublish(t2);
            }
        });
        this.buttonClose = new Button(compRefreshCloseButtons, 8);
        GridData closeGrid = new GridData();
        this.buttonClose.setText(this.msgFile.getMessage(t, "UI.GENERAL.CLOSE"));
        this.buttonClose.setLayoutData((Object)closeGrid);
        this.buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PublishDialogBase.this.closePressed(t2);
                PublishDialogBase.this.myShell.close();
            }
        });
        int buttonMaxWidth = 0;
        Point sizePublish = this.buttonPublish.computeSize(-1, -1);
        Point sizeClose = this.buttonClose.computeSize(-1, -1);
        if (sizePublish.x > buttonMaxWidth) {
            buttonMaxWidth = sizePublish.x;
        }
        if (sizeClose.x > buttonMaxWidth) {
            buttonMaxWidth = sizeClose.x;
        }
        publishGrid.widthHint = buttonMaxWidth;
        closeGrid.widthHint = buttonMaxWidth;
        Point size = composite.computeSize(-1, -1);
        scrolledComposite.setMinSize(size);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.myShell.pack();
        this.myShell.open();
        this.myShell.addShellListener((ShellListener)this);
    }

    protected void enablePublish(Trace t) {
        if (!this.messageText.isDisposed()) {
            int charCount = this.messageText.getText().length();
            int topicTextCount = this.topicText.getText().length();
            if (charCount > 0 && topicTextCount > 0) {
                this.buttonPublish.setEnabled(true);
                this.myShell.setDefaultButton(this.buttonPublish);
            } else {
                this.buttonPublish.setEnabled(false);
                this.myShell.setDefaultButton(this.buttonClose);
            }
        }
    }

    public abstract void publish(Trace var1);

    protected abstract void drawStreamBox(Trace var1, Composite var2, String var3);

    protected void closePressed(Trace t) {
    }

    public void setStatus(Trace t, String status) {
        if (this.statusBar != null && !this.statusBar.isDisposed()) {
            this.statusBar.showMessage(t, status);
        }
    }

    public void shellClosed(ShellEvent e) {
        this.closePressed(Trace.getDefault());
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }
}

