/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.dialogs.IPasswordValidation;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordDialog
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/dialogs/PasswordDialog.java";
    private static int HORIZONTAL_INDENT = 5;
    private Point preferredSize = new Point(200, 100);
    private Text textPassword1 = null;
    private Text textPassword2 = null;
    private Text textPassword3 = null;
    private String title = null;
    private String description = null;
    private String descPassword1 = null;
    private String descPassword2 = null;
    private String descPassword3 = null;
    private String errorMessage = null;
    private String password = "";
    private String currentPassword = "";
    private Shell parentShell = null;
    private Message msgFile = null;
    private boolean okToContinue = false;
    private int minimumLengthCheck = 1;
    private int minimumLength = 8;
    private int maximumLength = 8;
    public static final int DEFAULT_PASSWORD_LENGTH = 8;
    public IPasswordValidation validator = null;
    private boolean passwordValidation = false;
    private boolean changePassword = false;
    private boolean enableOkOnCreate = false;

    public PasswordDialog(Shell parent) {
        super(parent, 0);
        this.parentShell = parent;
        this.init(Trace.getDefault());
    }

    public PasswordDialog(Shell parent, boolean v) {
        super(parent, 0);
        this.parentShell = parent;
        this.passwordValidation = v;
        this.init(Trace.getDefault());
    }

    public PasswordDialog(Shell parent, int min, int max) {
        super(parent, 0);
        this.parentShell = parent;
        this.passwordValidation = true;
        if (min > 0 && min <= max) {
            this.minimumLength = min;
        }
        if (max > 0 && max >= min) {
            this.maximumLength = max;
        }
        this.init(Trace.getDefault());
    }

    private void init(Trace t) {
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
        this.title = this.msgFile.getMessage("Ui.Dialog.Passwords.Title");
        this.description = this.msgFile.getMessage("Ui.Dialog.Passwords.Description");
        this.descPassword1 = this.msgFile.getMessage("Ui.Dialog.Passwords.Password1");
        this.descPassword2 = this.msgFile.getMessage("Ui.Dialog.Passwords.Password2");
        this.descPassword3 = this.msgFile.getMessage("Ui.Dialog.Passwords.Password3");
        this.errorMessage = this.msgFile.getMessage("Ui.Dialog.Passwords.Mismatch");
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        final Text textDescription = new Text(composite, 66);
        gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 100;
        textDescription.setLayoutData((Object)gridData);
        textDescription.setText(this.description);
        UiUtils.makeTextControlReadOnly(t, textDescription, false);
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Trace t2 = Trace.getDefault();
                UiUtils.resizeControl(t2, (Control)textDescription);
            }
        });
        if (this.changePassword) {
            UiUtils.createBlankLine(composite, 1);
            Label labelPassword1 = new Label(composite, 0);
            labelPassword1.setText(this.descPassword1);
            gridData = new GridData(768);
            gridData.horizontalIndent = HORIZONTAL_INDENT;
            labelPassword1.setLayoutData((Object)gridData);
            this.textPassword1 = new Text(composite, 0x400800);
            this.textPassword1.setText("");
            gridData = new GridData(768);
            gridData.horizontalIndent = HORIZONTAL_INDENT;
            this.textPassword1.setLayoutData((Object)gridData);
            this.textPassword1.setTextLimit(this.maximumLength);
            this.textPassword1.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Trace t2 = Trace.getDefault();
                    PasswordDialog.this.enableOkButton(t2);
                }
            });
        }
        UiUtils.createBlankLine(composite, 1);
        Label labelPassword2 = new Label(composite, 0);
        labelPassword2.setText(this.descPassword2);
        gridData = new GridData(768);
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        labelPassword2.setLayoutData((Object)gridData);
        this.textPassword2 = new Text(composite, 0x400800);
        this.textPassword2.setText("");
        gridData = new GridData(768);
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        this.textPassword2.setLayoutData((Object)gridData);
        this.textPassword2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                PasswordDialog.this.enableOkButton(t2);
            }
        });
        if (this.passwordValidation) {
            this.textPassword2.setTextLimit(this.maximumLength);
            UiUtils.createBlankLine(composite, 1);
            Label labelPassword3 = new Label(composite, 0);
            labelPassword3.setText(this.descPassword3);
            gridData = new GridData(768);
            gridData.horizontalIndent = HORIZONTAL_INDENT;
            labelPassword3.setLayoutData((Object)gridData);
            this.textPassword3 = new Text(composite, 0x400800);
            this.textPassword3.setText("");
            gridData = new GridData(768);
            gridData.horizontalIndent = HORIZONTAL_INDENT;
            this.textPassword3.setLayoutData((Object)gridData);
            this.textPassword3.setTextLimit(this.maximumLength);
            this.textPassword3.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Trace t2 = Trace.getDefault();
                    PasswordDialog.this.enableOkButton(t2);
                }
            });
        }
        composite.pack();
        if (this.changePassword) {
            this.textPassword1.setFocus();
        } else {
            this.textPassword2.setFocus();
        }
    }

    private void enableOkButton(Trace t) {
        this.enableOK(t, false);
        if (this.passwordValidation) {
            if (this.changePassword) {
                if (this.textPassword1 != null && this.textPassword2 != null && this.textPassword3 != null && this.textPassword1.getText().length() >= this.minimumLengthCheck && this.textPassword2.getText().length() >= this.minimumLength && this.textPassword2.getText().length() == this.textPassword3.getText().length()) {
                    this.enableOK(t, true);
                }
            } else if (this.textPassword2 != null && this.textPassword3 != null) {
                if (this.textPassword2.getText().length() >= this.minimumLength && this.textPassword2.getText().length() == this.textPassword3.getText().length()) {
                    this.enableOK(t, true);
                }
            } else if (this.textPassword2 == null && this.minimumLengthCheck == 0) {
                this.enableOkOnCreate = true;
            }
        } else if (this.changePassword) {
            if (this.textPassword1 != null && this.textPassword1.getText().length() >= this.minimumLengthCheck && this.textPassword2 != null && this.textPassword2.getText().length() >= this.minimumLengthCheck) {
                this.enableOK(t, true);
            }
        } else if (this.textPassword2 != null && this.textPassword2.getText().length() >= this.minimumLengthCheck) {
            this.enableOK(t, true);
        } else if (this.textPassword2 == null && this.minimumLengthCheck == 0) {
            this.enableOkOnCreate = true;
        }
    }

    private boolean comparePasswords(Trace t) {
        boolean same = false;
        if (this.textPassword2 != null && this.textPassword3 != null) {
            this.password = this.textPassword2.getText();
            if (this.textPassword2.getText().equals(this.textPassword3.getText())) {
                same = true;
            }
        }
        if (!same) {
            MessageBox.showMessageFailure(t, this.getShell(), this.errorMessage);
            this.textPassword3.selectAll();
            this.textPassword3.setFocus();
        }
        return same;
    }

    private boolean validate(Trace t) {
        boolean valid = true;
        if (this.validator != null && !(valid = this.validator.validate(t, this.password))) {
            if (this.validator.getErrorMessage(t) != null) {
                MessageBox.showMessageFailure(t, this.getShell(), this.validator.getErrorMessage(t));
            }
            this.textPassword2.selectAll();
            this.textPassword2.setFocus();
            this.textPassword3.setText("");
        }
        return valid;
    }

    @Override
    public boolean okPressed(Trace t) {
        if (this.passwordValidation) {
            this.okToContinue = this.comparePasswords(t);
            if (this.okToContinue) {
                this.okToContinue = this.validate(t);
            }
        } else {
            this.okToContinue = true;
            this.password = this.textPassword2.getText();
        }
        if (this.changePassword) {
            this.currentPassword = this.textPassword1.getText();
        }
        return this.okToContinue;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
    }

    @Override
    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_PasswordDialog";
    }

    @Override
    public Image getImage(Trace t) {
        return null;
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    @Override
    public String getTitle(Trace t) {
        return this.title;
    }

    @Override
    public boolean isEnableOK(Trace t) {
        if (this.enableOkOnCreate) {
            this.enableOkOnCreate = false;
            return true;
        }
        return this.okToContinue;
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return false;
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return false;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public void setCurrentPasswordDescription(String s) {
        this.descPassword1 = s;
    }

    public void setPassword1Description(String s) {
        this.descPassword2 = s;
    }

    public void setPassword2Description(String s) {
        this.descPassword3 = s;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public void setErrorMessage(String s) {
        this.errorMessage = s;
    }

    public void useChangePassword() {
        this.changePassword = true;
        this.passwordValidation = true;
    }

    public boolean setMinPasswordLength(int i) {
        if (i <= this.maximumLength) {
            this.minimumLength = i;
            this.minimumLengthCheck = this.minimumLength == 0 ? 0 : 1;
            this.enableOkButton(Trace.getDefault());
            return true;
        }
        return false;
    }

    public boolean setMaxPasswordLength(int i) {
        if (i >= this.minimumLength) {
            this.maximumLength = i;
            return true;
        }
        return false;
    }

    public Shell getParentShell() {
        return this.parentShell;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setUserValidation(IPasswordValidation v) {
        this.validator = v;
    }

    @Override
    public void cancelPressed(Trace t) {
    }

    @Override
    public void packDialog(Trace t) {
    }
}

