/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.dialogs;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.BaseMQInstallationDetails;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.commonservices.internal.utils.QueryValue;
import com.ibm.mq.explorer.ui.internal.actions.TransferQMAction;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class InstallationsDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/dialogs/InstallationsDialog.java";
    private Message msgFile;
    private static final int NAME_COL = 0;
    private static final int VERSION_COL = 1;
    private static final int DESCRIPT_COL = 2;
    private static final int PATH_COL = 3;
    private static final int PRIMARY_COL = 4;
    private static final int STATE_COL = 5;
    private static final int ID_COL = 6;
    private Table thisInstallTable;
    private Table otherInstallTable;
    private boolean peformingResize = false;

    public InstallationsDialog(Trace t, Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(false);
        this.setShellStyle(0x870 | InstallationsDialog.getDefaultOrientation());
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_General");
    }

    protected Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite main = (Composite)super.createDialogArea(parent);
        main.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledComp = new ScrolledComposite(main, 768);
        Composite composite = new Composite((Composite)scrolledComp, 0);
        scrolledComp.setContent((Control)composite);
        this.getShell().setText(this.msgFile.getMessage("UI.Installations.Dialog.Title"));
        UiPlugin.getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.mq.explorer.ui.infopop.UI_Installations_Dialog");
        GridLayout layout = new GridLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 600;
        gridData.heightHint = 350;
        composite.setLayoutData((Object)gridData);
        Label prompt = new Label(composite, 0);
        prompt.setText(this.msgFile.getMessage("UI.Installations.Dialog.This.Install"));
        this.addInstallationTable(t, composite);
        new Label(composite, 0);
        Button transferButton = new Button(composite, 8);
        transferButton.setText(this.msgFile.getMessage("UI.Installations.Dialog.Transfer.Button"));
        transferButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransferQMAction transfer = new TransferQMAction();
                transfer.setParentShell(InstallationsDialog.this.getShell());
                transfer.run(null);
            }
        });
        composite.layout();
        scrolledComp.setMinSize(composite.computeSize(-1, -1));
        scrolledComp.setExpandHorizontal(true);
        scrolledComp.setExpandVertical(true);
        UiUtils.addScrollListeners(scrolledComp);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
        button.setFocus();
    }

    private Table createTable(final Composite compMain, int rows) {
        String stateInvalid;
        final Table table = new Table(compMain, 67590);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] titles = new String[7];
        titles[0] = "Installation9999";
        titles[1] = this.msgFile.getMessage("UI.Installations.Dialog.Column.Version");
        titles[2] = this.msgFile.getMessage("UI.Installations.Dialog.Column.Description");
        titles[3] = this.msgFile.getMessage("UI.Installations.Dialog.Column.Path");
        titles[4] = this.msgFile.getMessage("UI.Installations.Dialog.Column.Primary");
        String stateLong = this.msgFile.getMessage("UI.Installations.Dialog.Column.Primary");
        String stateValid = this.msgFile.getMessage("UI.Installations.Dialog.State.Valid");
        if (stateValid.length() > stateLong.length()) {
            stateLong = stateValid;
        }
        if ((stateInvalid = this.msgFile.getMessage("UI.Installations.Dialog.State.Invalid")).length() > stateLong.length()) {
            stateLong = stateInvalid;
        }
        titles[5] = stateLong;
        titles[6] = this.msgFile.getMessage("UI.Installations.Dialog.Column.Identifier");
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            column.setMoveable(true);
            column.pack();
            ++i;
        }
        if (SWT.getPlatform().toLowerCase().contains("gtk")) {
            TableColumn extra = new TableColumn(table, 0);
            extra.setText("");
            extra.pack();
        }
        table.getColumn(0).setText(this.msgFile.getMessage("UI.Installations.Dialog.Column.Name"));
        table.getColumn(5).setText(this.msgFile.getMessage("UI.Installations.Dialog.Column.State"));
        GridData gridData = new GridData(4, 4, true, true);
        if (rows == 1) {
            gridData = new GridData(4, 1, true, false);
        }
        gridData.heightHint = table.getItemHeight() * rows + table.getHeaderHeight();
        gridData.horizontalSpan = 2;
        table.setLayoutData((Object)gridData);
        compMain.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = compMain.getClientArea();
                ScrollBar vBar = table.getVerticalBar();
                int width = area.width - table.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
                Point vBarSize = vBar.getSize();
                width -= vBarSize.x;
                Point oldSize = table.getSize();
                if (oldSize.x > area.width) {
                    TableColumn[] cols = table.getColumns();
                    int restWidth = cols[0].getWidth() + cols[1].getWidth() + cols[4].getWidth() + cols[5].getWidth() + cols[6].getWidth();
                    int remaining = width - restWidth;
                    if (remaining > 20) {
                        cols[2].setWidth(40 * remaining / 100);
                        cols[3].setWidth(60 * remaining / 100);
                    }
                    table.setSize(area.width, area.height);
                } else {
                    table.setSize(area.width, area.height);
                    TableColumn[] cols = table.getColumns();
                    int restWidth = cols[0].getWidth() + cols[1].getWidth() + cols[4].getWidth() + cols[5].getWidth() + cols[6].getWidth();
                    int remaining = width - restWidth;
                    if (remaining > 20) {
                        cols[2].setWidth(40 * remaining / 100);
                        cols[3].setWidth(60 * remaining / 100);
                    }
                }
            }
        });
        return table;
    }

    private void addInstallationTable(Trace t, Composite compMain) {
        block6: {
            try {
                TableColumn tc;
                String installName = QueryValue.queryInstallName((Trace)t);
                BaseMQInstallationDetails[] details = NativeCalls.getInstallationDetails((Trace)t);
                this.thisInstallTable = this.createTable(compMain, 1);
                new Label(compMain, 0);
                Text infoText = new Text(compMain, 4);
                infoText.setText(this.msgFile.getMessage("UI.Installations.Dialog.Other.Installs"));
                UiUtils.makeTextControlReadOnly(t, infoText, true);
                GridData gridData = new GridData(4, 1, true, false);
                infoText.setLayoutData((Object)gridData);
                this.otherInstallTable = this.createTable(compMain, 3);
                TableColumn[] tableColumnArray = this.thisInstallTable.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    tc = tableColumnArray[n2];
                    tc.addControlListener((ControlListener)new ControlAdapter(){

                        public void controlMoved(ControlEvent e) {
                            InstallationsDialog.this.updateTableColumns(InstallationsDialog.this.thisInstallTable);
                        }

                        public void controlResized(ControlEvent e) {
                            InstallationsDialog.this.updateTableColumns(InstallationsDialog.this.thisInstallTable);
                        }
                    });
                    ++n2;
                }
                tableColumnArray = this.otherInstallTable.getColumns();
                n = tableColumnArray.length;
                n2 = 0;
                while (n2 < n) {
                    tc = tableColumnArray[n2];
                    tc.addControlListener((ControlListener)new ControlAdapter(){

                        public void controlMoved(ControlEvent e) {
                            InstallationsDialog.this.updateTableColumns(InstallationsDialog.this.otherInstallTable);
                        }

                        public void controlResized(ControlEvent e) {
                            InstallationsDialog.this.updateTableColumns(InstallationsDialog.this.otherInstallTable);
                        }
                    });
                    ++n2;
                }
                tableColumnArray = details;
                n = details.length;
                n2 = 0;
                while (n2 < n) {
                    TableColumn install = tableColumnArray[n2];
                    Table table = this.otherInstallTable;
                    if (install.name.equals(installName)) {
                        table = this.thisInstallTable;
                    }
                    TableItem item = new TableItem(table, 0);
                    item.setText(0, install.name);
                    item.setText(1, install.VRMF);
                    item.setText(2, install.description);
                    item.setText(3, install.path);
                    item.setText(4, install.isPrimary ? this.msgFile.getMessage("UI.GENERAL.YES") : this.msgFile.getMessage("UI.GENERAL.NO"));
                    item.setText(5, install.valid ? this.msgFile.getMessage("UI.Installations.Dialog.State.Valid") : this.msgFile.getMessage("UI.Installations.Dialog.State.Invalid"));
                    item.setText(6, "" + install.identifier);
                    ++n2;
                }
            }
            catch (CommonServicesException e) {
                if (!Trace.isTracing) break block6;
                t.data(67, "InstallationsDialog.addInstallationTable", 900, "CommonServicesException from QueryValue.queryInstallName: " + e.getMessage());
            }
        }
    }

    private void updateTableColumns(Table originTable) {
        if (!this.peformingResize) {
            this.peformingResize = true;
            Table tableToMod = originTable == this.thisInstallTable ? this.otherInstallTable : this.thisInstallTable;
            int i = 0;
            while (i < originTable.getColumnCount()) {
                tableToMod.getColumn(i).setWidth(originTable.getColumn(i).getWidth());
                ++i;
            }
            tableToMod.setColumnOrder(originTable.getColumnOrder());
            this.peformingResize = false;
        }
    }
}

