/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GetObjectNameDialog
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/dialogs/GetObjectNameDialog.java";
    private static final int MAX_WIDTH = 500;
    private static final int MIN_WIDTH = 300;
    private Point preferredSize = null;
    private Text textBox;
    private String objectName = "";
    private int maxLength = 48;
    private String dlgTitle = "";
    private String[] informationStrings = null;
    private String objectPrompt = "";
    private Image image = Icons.get(Icons.iconkeyExplorerSmall);
    private String helpId = null;
    private boolean isRestrictToMQCharset = false;
    protected boolean valid = true;
    private Composite compMsg;

    public GetObjectNameDialog(Shell parent, int style) {
        super(parent, style);
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)gridLayout);
        if (this.informationStrings != null) {
            int num = this.informationStrings.length;
            final Label[] labelInfoStrings = new Label[num];
            int i = 0;
            while (i < num) {
                UiUtils.createBlankLine(composite, 1);
                labelInfoStrings[i] = new Label(composite, 64);
                if (this.informationStrings[i] != null) {
                    labelInfoStrings[i].setText(this.informationStrings[i]);
                }
                GridData gridData = new GridData();
                gridData.widthHint = 500 - gridLayout.marginLeft - gridLayout.marginRight;
                labelInfoStrings[i].setLayoutData((Object)gridData);
                ++i;
            }
            composite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Trace t2 = Trace.getDefault();
                    int i = 0;
                    while (i < labelInfoStrings.length) {
                        UiUtils.resizeControl(t2, (Control)labelInfoStrings[i]);
                        ++i;
                    }
                }
            });
        }
        UiUtils.createBlankLine(composite, 1);
        Composite objectComposite = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        objectComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        objectComposite.setLayoutData((Object)gridData);
        Label objectLabel = new Label(objectComposite, 0);
        objectLabel.setText(this.objectPrompt);
        gridData = new GridData();
        objectLabel.setLayoutData((Object)gridData);
        this.textBox = new Text(objectComposite, 2048);
        this.textBox.setText(this.objectName);
        this.textBox.selectAll();
        this.nameModified();
        this.textBox.setTextLimit(this.maxLength);
        gridData = new GridData(768);
        this.textBox.setLayoutData((Object)gridData);
        this.textBox.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                GetObjectNameDialog.this.valid = GetObjectNameDialog.this.isRestrictToMQCharset ? StringValidation.verifyMQObjectName(Trace.getDefault(), e) : true;
            }
        });
        this.textBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GetObjectNameDialog.this.nameModified();
            }
        });
        this.compMsg = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.compMsg.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        this.compMsg.setLayoutData((Object)gridData);
        this.compMsg.setVisible(false);
        Label labelIcon = new Label(this.compMsg, 1);
        labelIcon.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        labelIcon.setLayoutData((Object)gridData);
        Label labelMsg = new Label(this.compMsg, 0);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        labelMsg.setLayoutData((Object)gridData);
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        labelMsg.setText(msgFile.getMessage("UI.GENERAL.NAME.INVALID.CHARS"));
        composite.pack();
        this.preferredSize = composite.getSize();
        if (this.preferredSize.x > 500) {
            this.preferredSize.x = 500;
        }
        if (this.preferredSize.x < 300) {
            this.preferredSize.x = 300;
        }
    }

    protected void nameModified() {
        if (this.compMsg != null) {
            this.compMsg.setVisible(!this.valid);
        }
        super.enableOK(Trace.getDefault(), this.valid && this.textBox.getText().length() > 0);
    }

    @Override
    public String getTitle(Trace t) {
        return this.dlgTitle;
    }

    @Override
    public String getHelpId(Trace t) {
        return this.helpId;
    }

    @Override
    public Image getImage(Trace t) {
        return this.image;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    @Override
    public boolean isEnableOK(Trace t) {
        return this.textBox.getText().length() > 0;
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return false;
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return false;
    }

    @Override
    public boolean okPressed(Trace t) {
        String objectText = this.textBox.getText();
        if (!objectText.equals("")) {
            this.objectName = objectText;
        }
        return true;
    }

    @Override
    public void packDialog(Trace t) {
    }

    @Override
    public void cancelPressed(Trace t) {
    }

    public void setInformationStrings(String[] infoStrings) {
        this.informationStrings = infoStrings;
    }

    public void setObjectPrompt(String objPrompt) {
        this.objectPrompt = objPrompt;
    }

    public void setImage(Image im) {
        this.image = im;
    }

    public void setHelpId(String id) {
        this.helpId = id;
    }

    public void setRestrictToMQCharset(boolean restrict) {
        this.isRestrictToMQCharset = restrict;
    }

    public void setTitle(String title) {
        this.dlgTitle = title;
    }

    public void setObjectNameMaxLength(int maxLen) {
        this.maxLength = maxLen;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objname) {
        this.objectName = objname;
    }
}

