/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSecurityExit;
import com.ibm.mq.explorer.ui.internal.dialogs.PasswordDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class ConnectionDetailsUserid
extends Composite {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/qmgrs/ConnectionDetailsUserid.java";
    private static int MIN_PASSWORD_LENGTH = 0;
    private static int MAX_PASSWORD_LENGTH = 12;
    private static int MAX_USERID_LENGTH = 64;
    private Label labelUseridName = null;
    private Text textUseridName = null;
    private Label labelUseridPassword = null;
    private Text textPassword = null;
    private Button buttonEnable = null;
    private Button buttonCompatMode = null;
    private Button buttonPassword = null;
    private Button buttonClearPassword = null;
    private String password = null;
    private Message msgFile = null;
    private boolean addEnableButton = true;
    private boolean passwordValidation = true;
    private boolean passwordSavingEnabled = true;
    private Link linkPasswordWarning = null;
    private boolean isPreference = false;
    private Group groupPassword = null;
    private Button buttonNoPassword = null;
    private Button buttonPromptPassword = null;
    private Button buttonStoredPassword = null;
    private int passwordMode = -1;

    public ConnectionDetailsUserid(Composite parent, int style, int span, boolean isPreference) {
        super(parent, style);
        this.isPreference = isPreference;
        Trace t = Trace.getDefault();
        this.createContents(t, span);
    }

    private Control createContents(Trace t, int span) {
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Preferences");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        if (this.addEnableButton) {
            this.buttonEnable = new Button((Composite)this, 32);
            if (this.isPreference) {
                this.buttonEnable.setText(this.msgFile.getMessage(t, "UI.PREF.ConnDetails.DefaultUserid.Enable"));
            } else {
                this.buttonEnable.setText(this.msgFile.getMessage(t, "UI.PREF.ConnDetails.Userid.Enable"));
            }
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            gridData.horizontalAlignment = 1;
            gridData.verticalAlignment = 1;
            this.buttonEnable.setLayoutData((Object)gridData);
            this.buttonEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    ConnectionDetailsUserid.this.enableControls(t2);
                }
            });
            UiUtils.createBlankLine(this, 2);
        }
        this.buttonCompatMode = new Button((Composite)this, 32);
        this.buttonCompatMode.setText(this.msgFile.getMessage(t, "UI.PREF.ConnDetails.Userid.Compatibility.Mode"));
        gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.buttonCompatMode.setLayoutData((Object)gridData);
        this.buttonCompatMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsUserid.this.enableControls(t2);
            }
        });
        UiUtils.createBlankLine(this, 2);
        this.labelUseridName = new Label((Composite)this, 0);
        this.labelUseridName.setText(this.msgFile.getMessage(t, "UI.PREF.UseridName.Label"));
        gridData = new GridData(32);
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.labelUseridName.setLayoutData((Object)gridData);
        this.textUseridName = new Text((Composite)this, 2048);
        gridData = new GridData(4, 4, true, false);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.textUseridName.setTextLimit(MAX_USERID_LENGTH);
        this.textUseridName.setLayoutData((Object)gridData);
        this.textUseridName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsUserid.this.enablePasswordButton(t2);
            }
        });
        UiUtils.createBlankLine(this, 2);
        this.groupPassword = new Group((Composite)this, 0);
        this.groupPassword.setText(this.msgFile.getMessage(t, "UI.PREF.UseridPassword.Group"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.groupPassword.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.groupPassword.setLayoutData((Object)gridData);
        Composite passwordButtonComp = new Composite((Composite)this.groupPassword, 0);
        passwordButtonComp.setLayout((Layout)new GridLayout());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        passwordButtonComp.setLayoutData((Object)gridData);
        this.buttonNoPassword = new Button(passwordButtonComp, 16);
        this.buttonNoPassword.setText(this.msgFile.getMessage(t, "UI.PREF.UseridNoPassword.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.buttonNoPassword.setLayoutData((Object)gridData);
        this.buttonNoPassword.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionDetailsUserid.this.passwordMode = 0;
                ConnectionDetailsUserid.this.enablePasswordGroup();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.buttonPromptPassword = new Button(passwordButtonComp, 16);
        this.buttonPromptPassword.setText(this.msgFile.getMessage(t, "UI.PREF.UseridPromptPassword.Button"));
        this.buttonPromptPassword.setSelection(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.buttonPromptPassword.setLayoutData((Object)gridData);
        this.buttonPromptPassword.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionDetailsUserid.this.passwordMode = 1;
                ConnectionDetailsUserid.this.enablePasswordGroup();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.buttonStoredPassword = new Button(passwordButtonComp, 16);
        this.buttonStoredPassword.setText(this.msgFile.getMessage(t, "UI.PREF.UseridSavePassword.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.buttonStoredPassword.setLayoutData((Object)gridData);
        this.buttonStoredPassword.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionDetailsUserid.this.passwordMode = 2;
                ConnectionDetailsUserid.this.enablePasswordGroup();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        UiUtils.createBlankLine((Composite)this.groupPassword, 2);
        this.labelUseridPassword = new Label((Composite)this.groupPassword, 0);
        this.labelUseridPassword.setText(this.msgFile.getMessage(t, "UI.PREF.UseridSavedPassword.Label"));
        gridData = new GridData(32);
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.labelUseridPassword.setLayoutData((Object)gridData);
        this.textPassword = new Text((Composite)this.groupPassword, 0x400800);
        gridData = new GridData(4, 4, true, false);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.textPassword.setLayoutData((Object)gridData);
        UiUtils.enableControls(t, new Control[]{this.textPassword}, false);
        Composite buttonComposite = new Composite((Composite)this.groupPassword, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 2;
        buttonComposite.setLayoutData((Object)gridData);
        Label label = new Label(buttonComposite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonClearPassword = new Button(buttonComposite, 8);
        this.buttonClearPassword.setText(this.msgFile.getMessage(t, "UI.PREF.Clear.Password.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        this.buttonClearPassword.setLayoutData((Object)gridData);
        this.buttonClearPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsUserid.this.clearPassword(t2);
            }
        });
        this.buttonPassword = new Button(buttonComposite, 8);
        this.buttonPassword.setText(this.msgFile.getMessage(t, "UI.PREF.Enter.Password.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        this.buttonPassword.setLayoutData((Object)gridData);
        this.buttonPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsUserid.this.passwordPrompt(t2);
            }
        });
        this.linkPasswordWarning = new Link((Composite)this.groupPassword, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.linkPasswordWarning.setLayoutData((Object)gridData);
        this.linkPasswordWarning.setText(this.msgFile.getMessage(t, "UI.PREF.Password.DisabledWarning.Label"));
        return this;
    }

    private void enablePasswordGroup() {
        Trace t = Trace.getInstance();
        if (this.passwordSavingEnabled) {
            this.buttonStoredPassword.setEnabled(true);
            if (this.passwordMode == 2) {
                this.labelUseridPassword.setEnabled(true);
            }
        } else {
            this.buttonStoredPassword.setEnabled(false);
            this.labelUseridPassword.setEnabled(false);
        }
        this.enablePasswordButton(t);
    }

    public void enableControls(Trace t) {
        if (this.buttonEnable != null) {
            boolean b = this.buttonEnable.getSelection();
            if (Trace.isTracing) {
                t.data(67, "ConnectionDetailsUserid.enableControls", 300, "Userid defaults enabled : " + b);
            }
            if (b) {
                UiUtils.enableControls(t, new Control[]{this.buttonCompatMode, this.labelUseridName, this.labelUseridPassword, this.textUseridName, this.groupPassword, this.buttonNoPassword, this.buttonPromptPassword, this.buttonStoredPassword, this.buttonClearPassword, this.linkPasswordWarning}, true);
                this.enablePasswordButton(t);
                this.enablePasswordGroup();
            } else {
                UiUtils.enableControls(t, new Control[]{this.buttonCompatMode, this.labelUseridName, this.labelUseridPassword, this.textUseridName, this.groupPassword, this.buttonNoPassword, this.buttonPromptPassword, this.buttonStoredPassword, this.buttonClearPassword, this.buttonPassword, this.linkPasswordWarning}, false);
                this.enableClearPasswordButton(t);
            }
        }
    }

    private void enablePasswordButton(Trace t) {
        boolean enable = false;
        if (this.getUserid().length() > 0 && this.passwordMode == 2) {
            enable = true;
        }
        UiUtils.enableControls(t, new Control[]{this.buttonPassword}, enable && this.passwordSavingEnabled);
        if (Trace.isTracing) {
            t.data(67, "ConnectionDetailsUserid.enablePasswordButton", 300, "Userid password button enabled : " + enable);
        }
        this.enableClearPasswordButton(t);
    }

    private void enableClearPasswordButton(Trace t) {
        boolean enable = false;
        if (this.password != null && this.password.length() >= 0 && this.passwordMode == 2) {
            enable = true;
        }
        UiUtils.enableControls(t, new Control[]{this.buttonClearPassword}, enable);
        if (Trace.isTracing) {
            t.data(67, "ConnectionDetailsUserid.enableClearPasswordButton", 300, "Clear password button enabled : " + enable);
        }
    }

    private void passwordPrompt(Trace t) {
        PasswordDialog dialog = new PasswordDialog(this.getShell(), this.passwordValidation);
        String userid = this.getUserid();
        dialog.setDescription(this.msgFile.getMessage("Ui.Dialog.Passwords.Enter.Password", userid));
        dialog.setMinPasswordLength(MIN_PASSWORD_LENGTH);
        dialog.setMaxPasswordLength(MAX_PASSWORD_LENGTH);
        dialog.create(t);
        if (dialog.open(t)) {
            this.password = dialog.getPassword();
            this.textPassword.setText("********");
            if (Trace.isTracing) {
                t.data(67, "ConnectionDetailsUserid.passwordPrompt", 300, "A password was entered for user " + userid);
            }
        } else if (Trace.isTracing) {
            t.data(67, "ConnectionDetailsUserid.passwordPrompt", 300, "No password entered for user " + userid);
        }
        this.enableClearPasswordButton(t);
    }

    private void clearPassword(Trace t) {
        String title = this.msgFile.getMessage(t, "Ui.Clear.Password.Button");
        String message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4096");
        int result = MessageBox.showYesNoMessage(t, this.getShell(), title, null, message, 1, null);
        if (result == 0) {
            this.textPassword.setText("");
            this.password = null;
            this.enableClearPasswordButton(t);
        }
    }

    public Button getButtonEnable() {
        return this.buttonEnable;
    }

    public Button getButtonCompatmode() {
        return this.buttonCompatMode;
    }

    public Button getButtonPassword() {
        return this.buttonPassword;
    }

    public Button getButtonNoPassword() {
        return this.buttonNoPassword;
    }

    public Button getButtonPromptPassword() {
        return this.buttonPromptPassword;
    }

    public Button getButtonStoredPassword() {
        return this.buttonStoredPassword;
    }

    public Text getTextUseridName() {
        return this.textUseridName;
    }

    public Text getTextPassword() {
        return this.textPassword;
    }

    public Link getPasswordWarningLink() {
        return this.linkPasswordWarning;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pw) {
        this.password = pw;
    }

    public void setUserIdStateSelection(boolean enabled) {
        if (this.buttonEnable != null) {
            this.buttonEnable.setSelection(enabled);
        }
    }

    public boolean getUserIdStateSelection() {
        return this.buttonEnable.getSelection();
    }

    public void setCompatModeStateSelection(boolean enabled) {
        if (this.buttonCompatMode != null) {
            this.buttonCompatMode.setSelection(enabled);
        }
    }

    public boolean getCompatModeStateSelection() {
        return this.buttonCompatMode.getSelection();
    }

    public void setPasswordModeStateSelection(int requestedPasswordMode) {
        this.passwordMode = requestedPasswordMode;
        this.buttonNoPassword.setSelection(false);
        this.buttonPromptPassword.setSelection(false);
        this.buttonStoredPassword.setSelection(false);
        if (this.passwordMode == 0) {
            if (this.buttonNoPassword != null) {
                this.buttonNoPassword.setSelection(true);
            }
        } else if (this.passwordMode == 1) {
            if (this.buttonPromptPassword != null) {
                this.buttonPromptPassword.setSelection(true);
            }
        } else if (this.passwordMode == 2 && this.buttonStoredPassword != null) {
            this.buttonStoredPassword.setSelection(true);
        }
    }

    public int getPasswordModeStateSelection() {
        return this.passwordMode;
    }

    private String getUserid() {
        if (this.textUseridName != null) {
            return this.textUseridName.getText().trim();
        }
        return "";
    }

    public void setPasswordValidation(boolean b) {
        this.passwordValidation = b;
    }

    public void setPasswordSaving(Trace t, boolean passwordStoreEnabled) {
        this.passwordSavingEnabled = passwordStoreEnabled;
        this.enableControls(t);
    }
}

