/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConnectionDetailsSecurityExit
extends Composite {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/qmgrs/ConnectionDetailsSecurityExit.java";
    public static int HORIZONTAL_INDENT = 10;
    private Label labelSecurityName = null;
    private Text textSecurityName = null;
    private Text textDirectoryName = null;
    private Text textJarFileName = null;
    private Label labelSecurityData = null;
    private Text textSecurityData = null;
    private Button buttonEnable = null;
    private Button buttonBrowseDirectoryName = null;
    private Button buttonBrowseJarFileName = null;
    private Button buttonDirectory = null;
    private Button buttonJarFile = null;
    private Composite compositeFileLocation = null;
    private boolean addEnableButton = true;

    public ConnectionDetailsSecurityExit(Composite parent, int style, int span) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.createContents(t, span);
    }

    public ConnectionDetailsSecurityExit(Composite parent, int style, int span, boolean add) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.addEnableButton = add;
        this.createContents(t, span);
    }

    private Control createContents(Trace t, int span) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Preferences");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        if (this.addEnableButton) {
            this.buttonEnable = new Button((Composite)this, 32);
            this.buttonEnable.setText(msgFile.getMessage(t, "UI.PREF.ConnDetails.SecurityExit.Enable"));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            gridData.horizontalAlignment = 1;
            gridData.verticalAlignment = 1;
            this.buttonEnable.setLayoutData((Object)gridData);
            this.buttonEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    ConnectionDetailsSecurityExit.this.enableControls(t2);
                }
            });
            UiUtils.createBlankLine(this, 2);
        }
        this.labelSecurityName = new Label((Composite)this, 0);
        this.labelSecurityName.setText(msgFile.getMessage(t, "UI.PREF.SecurityName.Label"));
        gridData = new GridData(32);
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        this.labelSecurityName.setLayoutData((Object)gridData);
        this.textSecurityName = new Text((Composite)this, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.textSecurityName.setLayoutData((Object)gridData);
        this.compositeFileLocation = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = HORIZONTAL_INDENT;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeFileLocation.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 50;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.compositeFileLocation.setLayoutData((Object)gridData);
        this.buttonDirectory = new Button(this.compositeFileLocation, 16);
        this.buttonDirectory.setText(msgFile.getMessage(t, "UI.PREF.SecurityName.DirName.Label"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        this.buttonDirectory.setLayoutData((Object)gridData);
        this.buttonDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSecurityExit.this.setFileLocationControls(t2);
            }
        });
        this.textDirectoryName = new Text(this.compositeFileLocation, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        this.textDirectoryName.setLayoutData((Object)gridData);
        this.buttonBrowseDirectoryName = new Button(this.compositeFileLocation, 8);
        this.buttonBrowseDirectoryName.setText(msgFile.getMessage(t, "UI.PREF.SSL.Browse.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        this.buttonBrowseDirectoryName.setLayoutData((Object)gridData);
        this.buttonBrowseDirectoryName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSecurityExit.this.browse(t2, true);
            }
        });
        this.buttonJarFile = new Button(this.compositeFileLocation, 16);
        this.buttonJarFile.setText(msgFile.getMessage(t, "UI.PREF.SecurityName.JarName.Label"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        this.buttonJarFile.setLayoutData((Object)gridData);
        this.buttonJarFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSecurityExit.this.setFileLocationControls(t2);
            }
        });
        this.textJarFileName = new Text(this.compositeFileLocation, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        this.textJarFileName.setLayoutData((Object)gridData);
        this.buttonBrowseJarFileName = new Button(this.compositeFileLocation, 8);
        this.buttonBrowseJarFileName.setText(msgFile.getMessage(t, "UI.PREF.SSL.Browse.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        this.buttonBrowseJarFileName.setLayoutData((Object)gridData);
        this.buttonBrowseJarFileName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSecurityExit.this.browse(t2, false);
            }
        });
        UiUtils.createBlankLine(this, 2);
        this.labelSecurityData = new Label((Composite)this, 0);
        this.labelSecurityData.setText(msgFile.getMessage(t, "UI.PREF.SecurityData.Label"));
        gridData = new GridData(32);
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        this.labelSecurityData.setLayoutData((Object)gridData);
        this.textSecurityData = new Text((Composite)this, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.textSecurityData.setLayoutData((Object)gridData);
        this.textSecurityData.setTextLimit(32);
        return this;
    }

    public void enableControls(Trace t) {
        if (this.buttonEnable != null) {
            boolean selected = this.buttonEnable.getSelection();
            UiUtils.enableControls(t, new Control[]{this.labelSecurityData, this.labelSecurityName, this.textSecurityData, this.textSecurityName, this.buttonBrowseDirectoryName, this.buttonBrowseJarFileName, this.buttonDirectory, this.buttonJarFile, this.textDirectoryName, this.textJarFileName}, selected);
            if (selected) {
                this.setFileLocationControls(t);
            }
        }
    }

    public Button getButtonEnable() {
        return this.buttonEnable;
    }

    public Text getTextSecurityName() {
        return this.textSecurityName;
    }

    public Text getTextSecurityData() {
        return this.textSecurityData;
    }

    public Text getTextDirectoryName() {
        return this.textDirectoryName;
    }

    public Text getTextJarFileName() {
        return this.textJarFileName;
    }

    public Button getButtonDirectory() {
        return this.buttonDirectory;
    }

    public Button getButtonJarFile() {
        return this.buttonJarFile;
    }

    public void setFileLocationControls(Trace t) {
        boolean selected = this.buttonDirectory.getSelection();
        this.buttonJarFile.setSelection(!selected);
        UiUtils.enableControls(t, new Control[]{this.textDirectoryName, this.buttonBrowseDirectoryName}, selected);
        UiUtils.enableControls(t, new Control[]{this.textJarFileName, this.buttonBrowseJarFileName}, !selected);
        if (this.buttonEnable != null) {
            UiUtils.enableControls(t, new Control[]{this.buttonJarFile, this.buttonDirectory}, this.buttonEnable.getSelection());
        } else {
            UiUtils.enableControls(t, new Control[]{this.buttonJarFile, this.buttonDirectory}, true);
        }
    }

    protected void browse(Trace t, boolean directory) {
        String name = null;
        if (directory) {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
            dialog.setFilterPath(this.textDirectoryName.getText());
            name = dialog.open();
            if (name != null) {
                this.textDirectoryName.setText(name);
            }
        } else {
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            dialog.setFileName(this.textJarFileName.getText());
            name = dialog.open();
            if (name != null) {
                this.textJarFileName.setText(name);
            }
        }
        if (Trace.isTracing) {
            t.data(67, "ConnectionDetailsSecurityExit.browse", 300, "File name is " + name);
        }
    }
}

