/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.passwords.internal.store.IPwCredentials;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSecurityExit;
import com.ibm.mq.explorer.ui.internal.dialogs.PasswordDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.passwords.PwStoreManager;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class ConnectionDetailsSSLStores
extends Composite {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/qmgrs/ConnectionDetailsSSLStores.java";
    public static final String FILETYPE_JKS = "*.jks";
    public static final String FILETYPE_PKCS12 = "*.p12";
    public static final String FILETYPE_ALL = "*.*";
    public static int HORIZONTAL_INDENT = 10;
    private static int MIN_PASSWORD_LENGTH = 1;
    private static int MAX_PASSWORD_LENGTH = 1024;
    private Group groupSSLTrusted = null;
    private Group groupSSLPersonal = null;
    Text textTrustedStore = null;
    private Label labelTrustedStore = null;
    Text textPersonalStore = null;
    private Label labelPersonalStore = null;
    private Button buttonBrowseTrusted = null;
    private Button buttonBrowsePersonal = null;
    private Button buttonTrustedPassword = null;
    private Button buttonClearTrustedPassword = null;
    private Button buttonPersonalPassword = null;
    private Button buttonClearPersonalPassword = null;
    private Button buttonEnable = null;
    private Label labelTrustedPassword = null;
    private Text textTrustedPassword = null;
    private Label labelPersonalPassword = null;
    private Text textPersonalPassword = null;
    private String passwordTrustedStore = null;
    private String passwordPersonalStore = null;
    private String ownerId = null;
    private String objectId = null;
    private Message msgFile = null;
    private boolean addEnableButton = true;
    private boolean passwordValidation = true;
    private boolean passwordSaving = true;
    private Link[] linkPasswordWarnings = null;

    public ConnectionDetailsSSLStores(Composite parent, int style, int span) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.createContents(t, span);
    }

    public ConnectionDetailsSSLStores(Composite parent, int style, int span, boolean add) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.addEnableButton = add;
        this.createContents(t, span);
    }

    private Control createContents(Trace t, int span) {
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Preferences");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        if (this.addEnableButton) {
            this.buttonEnable = new Button((Composite)this, 32);
            this.buttonEnable.setText(this.msgFile.getMessage(t, "UI.PREF.ConnDetails.SSLStores.Enable"));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            gridData.horizontalAlignment = 1;
            gridData.verticalAlignment = 1;
            this.buttonEnable.setLayoutData((Object)gridData);
            this.buttonEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    ConnectionDetailsSSLStores.this.enableControls(t2);
                }
            });
            UiUtils.createBlankLine(this, 2);
        }
        this.groupSSLTrusted = new Group((Composite)this, 0);
        this.groupSSLTrusted.setText(this.msgFile.getMessage(t, "UI.PREF.SSL.TrustedStore.Group"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        this.groupSSLTrusted.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.groupSSLTrusted.setLayoutData((Object)gridData);
        UiUtils.createBlankLine(this, 2);
        this.labelTrustedStore = new Label((Composite)this.groupSSLTrusted, 0);
        this.labelTrustedStore.setText(this.msgFile.getMessage(t, "UI.PREF.SSL.StoreName.Label"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        this.labelTrustedStore.setLayoutData((Object)gridData);
        this.textTrustedStore = new Text((Composite)this.groupSSLTrusted, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.textTrustedStore.setLayoutData((Object)gridData);
        this.textTrustedStore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSSLStores.this.enablePasswordButton(t2);
            }
        });
        this.buttonBrowseTrusted = new Button((Composite)this.groupSSLTrusted, 8);
        this.buttonBrowseTrusted.setText(this.msgFile.getMessage(t, "UI.PREF.SSL.Browse.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        this.buttonBrowseTrusted.setLayoutData((Object)gridData);
        this.buttonBrowseTrusted.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSSLStores.this.browseStore(t2, 1);
            }
        });
        this.labelTrustedPassword = new Label((Composite)this.groupSSLTrusted, 0);
        this.labelTrustedPassword.setText(this.msgFile.getMessage(t, "UI.PREF.UseridPassword.Label"));
        gridData = new GridData(32);
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.labelTrustedPassword.setLayoutData((Object)gridData);
        this.textTrustedPassword = new Text((Composite)this.groupSSLTrusted, 0x400800);
        gridData = new GridData(4, 4, true, false);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.textTrustedPassword.setLayoutData((Object)gridData);
        UiUtils.enableControls(t, new Control[]{this.textTrustedPassword}, false);
        Composite buttonComposite = new Composite((Composite)this.groupSSLTrusted, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 3;
        buttonComposite.setLayoutData((Object)gridData);
        Label label = new Label(buttonComposite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonClearTrustedPassword = new Button(buttonComposite, 8);
        this.buttonClearTrustedPassword.setText(this.msgFile.getMessage(t, "UI.PREF.Clear.Password.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        this.buttonClearTrustedPassword.setLayoutData((Object)gridData);
        this.buttonClearTrustedPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSSLStores.this.clearPassword(t2, 1);
            }
        });
        this.buttonTrustedPassword = new Button(buttonComposite, 8);
        this.buttonTrustedPassword.setText(this.msgFile.getMessage(t, "UI.PREF.SSL.EnterPassword.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        this.buttonTrustedPassword.setLayoutData((Object)gridData);
        this.buttonTrustedPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSSLStores.this.passwordPrompt(t2, 1);
            }
        });
        this.linkPasswordWarnings = new Link[2];
        this.linkPasswordWarnings[0] = new Link((Composite)this.groupSSLTrusted, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.linkPasswordWarnings[0].setLayoutData((Object)gridData);
        this.linkPasswordWarnings[0].setText(this.msgFile.getMessage(t, "UI.PREF.Password.DisabledWarning.Label"));
        UiUtils.createBlankLine(this, 2);
        this.groupSSLPersonal = new Group((Composite)this, 0);
        this.groupSSLPersonal.setText(this.msgFile.getMessage(t, "UI.PREF.SSL.PersonalStore.Group"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        this.groupSSLPersonal.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.groupSSLPersonal.setLayoutData((Object)gridData);
        UiUtils.createBlankLine(this, 2);
        this.labelPersonalStore = new Label((Composite)this.groupSSLPersonal, 0);
        this.labelPersonalStore.setText(this.msgFile.getMessage(t, "UI.PREF.SSL.StoreName.Label"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        this.labelPersonalStore.setLayoutData((Object)gridData);
        this.textPersonalStore = new Text((Composite)this.groupSSLPersonal, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.textPersonalStore.setLayoutData((Object)gridData);
        this.textPersonalStore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSSLStores.this.enablePasswordButton(t2);
            }
        });
        this.buttonBrowsePersonal = new Button((Composite)this.groupSSLPersonal, 8);
        this.buttonBrowsePersonal.setText(this.msgFile.getMessage(t, "UI.PREF.SSL.Browse.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        this.buttonBrowsePersonal.setLayoutData((Object)gridData);
        this.buttonBrowsePersonal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSSLStores.this.browseStore(t2, 2);
            }
        });
        this.labelPersonalPassword = new Label((Composite)this.groupSSLPersonal, 0);
        this.labelPersonalPassword.setText(this.msgFile.getMessage(t, "UI.PREF.UseridPassword.Label"));
        gridData = new GridData(32);
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.labelPersonalPassword.setLayoutData((Object)gridData);
        this.textPersonalPassword = new Text((Composite)this.groupSSLPersonal, 0x400800);
        gridData = new GridData(4, 4, true, false);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.textPersonalPassword.setLayoutData((Object)gridData);
        UiUtils.enableControls(t, new Control[]{this.textPersonalPassword}, false);
        buttonComposite = new Composite((Composite)this.groupSSLPersonal, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 3;
        buttonComposite.setLayoutData((Object)gridData);
        label = new Label(buttonComposite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonClearPersonalPassword = new Button(buttonComposite, 8);
        this.buttonClearPersonalPassword.setText(this.msgFile.getMessage(t, "UI.PREF.Clear.Password.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 3;
        this.buttonClearPersonalPassword.setLayoutData((Object)gridData);
        this.buttonClearPersonalPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSSLStores.this.clearPassword(t2, 2);
            }
        });
        this.buttonPersonalPassword = new Button(buttonComposite, 8);
        this.buttonPersonalPassword.setText(this.msgFile.getMessage(t, "UI.PREF.SSL.EnterPassword.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 1;
        this.buttonPersonalPassword.setLayoutData((Object)gridData);
        this.buttonPersonalPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSSLStores.this.passwordPrompt(t2, 2);
            }
        });
        this.linkPasswordWarnings[1] = new Link((Composite)this.groupSSLPersonal, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.linkPasswordWarnings[1].setLayoutData((Object)gridData);
        this.linkPasswordWarnings[1].setText(this.msgFile.getMessage(t, "UI.PREF.Password.DisabledWarning.Label"));
        return this;
    }

    private void passwordPrompt(Trace t, int store) {
        PasswordDialog dialog = new PasswordDialog(this.getShell(), this.passwordValidation);
        if (store == 1) {
            dialog.setDescription(this.msgFile.getMessage(t, "UI.SSL.Password.Dialog.Purpose", this.getTextTrustedStore().getText()));
        } else {
            dialog.setDescription(this.msgFile.getMessage(t, "UI.SSL.Password.Dialog.Purpose", this.getTextPersonalStore().getText()));
        }
        dialog.setMinPasswordLength(MIN_PASSWORD_LENGTH);
        dialog.setMaxPasswordLength(MAX_PASSWORD_LENGTH);
        dialog.create(t);
        if (dialog.open(t)) {
            if (store == 1) {
                this.textTrustedPassword.setText("********");
                this.passwordTrustedStore = dialog.getPassword();
                if (Trace.isTracing) {
                    t.data(67, "ConnectionDetailsSSLStores.passwordPrompt", 300, "A password was entered for the trusted store " + this.getTextTrustedStore().getText());
                }
            } else {
                this.textPersonalPassword.setText("********");
                this.passwordPersonalStore = dialog.getPassword();
                if (Trace.isTracing) {
                    t.data(67, "ConnectionDetailsSSLStores.passwordPrompt", 300, "A password was entered for the personal store " + this.getTextPersonalStore().getText());
                }
            }
        } else if (Trace.isTracing) {
            t.data(67, "ConnectionDetailsSSLStores.passwordPrompt", 300, "No password entered for SSL store");
        }
        this.enableClearPasswordButton(t);
    }

    private void clearPassword(Trace t, int store) {
        String title = this.msgFile.getMessage(t, "Ui.Clear.Password.Button");
        String message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4096");
        int result = MessageBox.showYesNoMessage(t, this.getShell(), title, null, message, 1, null);
        if (result == 0) {
            if (store == 1) {
                this.textTrustedPassword.setText("");
                this.passwordTrustedStore = "";
                UiUtils.enableControls(t, new Control[]{this.buttonClearTrustedPassword}, false);
                if (Trace.isTracing) {
                    t.data(67, "ConnectionDetailsSSLStores.clearPassword", 300, "The password was cleared for the trusted store");
                }
            } else {
                this.textPersonalPassword.setText("");
                this.passwordPersonalStore = "";
                UiUtils.enableControls(t, new Control[]{this.buttonClearPersonalPassword}, false);
                if (Trace.isTracing) {
                    t.data(67, "ConnectionDetailsSSLStores.clearPassword", 300, "The password was cleared for the personal store");
                }
            }
        }
    }

    protected void browseStore(Trace t, int store) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{FILETYPE_JKS, FILETYPE_PKCS12, FILETYPE_ALL});
        if (store == 1) {
            fileDialog.setFileName(this.textTrustedStore.getText());
        } else {
            fileDialog.setFileName(this.textPersonalStore.getText());
        }
        String strFilename = fileDialog.open();
        if (strFilename != null) {
            if (store == 1) {
                this.textTrustedStore.setText(strFilename);
                if (Trace.isTracing) {
                    t.data(67, "ConnectionDetailsSSLStores.browseStore", 300, "Trusted store file name is " + strFilename);
                }
            } else {
                this.textPersonalStore.setText(strFilename);
                if (Trace.isTracing) {
                    t.data(67, "ConnectionDetailsSSLStores.browseStore", 300, "Personal store file name is " + strFilename);
                }
            }
            this.checkForStorePassword(t);
        }
    }

    public void enableControls(Trace t) {
        if (this.buttonEnable != null) {
            boolean b = this.buttonEnable.getSelection();
            if (Trace.isTracing) {
                t.data(67, "ConnectionDetailsSSLStores.enableControls", 300, "SSL stores defaults enabled : " + b);
            }
            if (b) {
                UiUtils.enableControls(t, new Control[]{this.groupSSLPersonal, this.groupSSLTrusted, this.labelPersonalPassword, this.labelPersonalStore, this.labelTrustedPassword, this.labelTrustedStore, this.textPersonalStore, this.textTrustedStore, this.buttonBrowsePersonal, this.buttonBrowseTrusted, this.buttonClearPersonalPassword, this.buttonClearTrustedPassword}, b);
                this.enablePasswordButton(t);
                UiUtils.enableControls(t, (Control[])this.linkPasswordWarnings, b);
            } else {
                UiUtils.enableControls(t, new Control[]{this.groupSSLPersonal, this.groupSSLTrusted, this.labelPersonalPassword, this.labelPersonalStore, this.labelTrustedPassword, this.labelTrustedStore, this.textPersonalStore, this.textTrustedStore, this.buttonBrowsePersonal, this.buttonBrowseTrusted, this.buttonPersonalPassword, this.buttonTrustedPassword, this.buttonClearPersonalPassword, this.buttonClearTrustedPassword}, b);
                UiUtils.enableControls(t, (Control[])this.linkPasswordWarnings, b);
            }
        }
    }

    private void enablePasswordButton(Trace t) {
        boolean enable = false;
        if (this.textPersonalStore != null && this.textPersonalStore.getText().length() > 0) {
            enable = true;
        }
        UiUtils.enableControls(t, new Control[]{this.buttonPersonalPassword}, enable && this.passwordSaving);
        if (Trace.isTracing) {
            t.data(67, "ConnectionDetailsSSLStores.enablePasswordButton", 300, "Personal store password button enabled : " + enable);
        }
        enable = false;
        if (this.textTrustedStore != null && this.textTrustedStore.getText().length() > 0) {
            enable = true;
        }
        UiUtils.enableControls(t, new Control[]{this.buttonTrustedPassword}, enable && this.passwordSaving);
        if (Trace.isTracing) {
            t.data(67, "ConnectionDetailsSSLStores.enablePasswordButton", 300, "Trusted store password button enabled : " + enable);
        }
        this.enableClearPasswordButton(t);
    }

    private void enableClearPasswordButton(Trace t) {
        boolean enable = false;
        if (this.textPersonalPassword != null && this.textPersonalPassword.getText().length() > 0) {
            enable = true;
        }
        UiUtils.enableControls(t, new Control[]{this.buttonClearPersonalPassword}, enable);
        if (Trace.isTracing) {
            t.data(67, "ConnectionDetailsSSLStores.enableClearPasswordButton", 300, "Personal store clear password button enabled : " + enable);
        }
        enable = false;
        if (this.textTrustedPassword != null && this.textTrustedPassword.getText().length() > 0) {
            enable = true;
        }
        UiUtils.enableControls(t, new Control[]{this.buttonClearTrustedPassword}, enable);
        if (Trace.isTracing) {
            t.data(67, "ConnectionDetailsSSLStores.enableClearPasswordButton", 300, "Trusted store clear password button enabled : " + enable);
        }
    }

    public Button getButtonEnable() {
        return this.buttonEnable;
    }

    public Text getTextPersonalStore() {
        return this.textPersonalStore;
    }

    public Text getTextTrustedStore() {
        return this.textTrustedStore;
    }

    public Text getTextTrustedPassword() {
        return this.textTrustedPassword;
    }

    public Text getTextPersonalPassword() {
        return this.textPersonalPassword;
    }

    public Link[] getPasswordWarningLinks() {
        return this.linkPasswordWarnings;
    }

    public String getPersonalStorePassword() {
        return this.passwordPersonalStore;
    }

    public String getTrustedStorePassword() {
        return this.passwordTrustedStore;
    }

    public void setPersonalStorePassword(String pw) {
        this.passwordPersonalStore = pw;
    }

    public void setTrustedStorePassword(String pw) {
        this.passwordTrustedStore = pw;
    }

    public void setPasswordValidation(boolean b) {
        this.passwordValidation = b;
    }

    public void setPasswordSaving(Trace t, boolean passwordStoreEnabled) {
        this.passwordSaving = passwordStoreEnabled;
        this.enableControls(t);
    }

    public void setOwnerId(String oid) {
        this.ownerId = oid;
    }

    public void setObjectId(String oid) {
        this.objectId = oid;
    }

    public void checkForStorePassword(Trace t) {
        if (this.ownerId != null && this.objectId != null) {
            IPwCredentials c;
            if (this.textTrustedStore.getText() != null) {
                c = PwStoreManager.getStoreManager(t).getCredentials(t, this.ownerId, this.objectId, this.textTrustedStore.getText());
                if (c != null) {
                    this.textTrustedPassword.setText("********");
                    this.setTrustedStorePassword(c.getPassword());
                } else {
                    this.textTrustedPassword.setText("");
                }
            }
            if (this.textPersonalStore.getText() != null) {
                c = PwStoreManager.getStoreManager(t).getCredentials(t, this.ownerId, this.objectId, this.textPersonalStore.getText());
                if (c != null) {
                    this.textPersonalPassword.setText("********");
                    this.setPersonalStorePassword(c.getPassword());
                } else {
                    this.textPersonalPassword.setText("");
                }
            }
            this.enablePasswordButton(t);
        }
    }
}

