/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnum;
import com.ibm.mq.explorer.core.internal.objects.DmClientChannel;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.Common;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.ConnectionDetailsSecurityExit;
import com.ibm.mq.explorer.ui.internal.controls.qmgrs.SSLPeerNameTextWrapper;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import com.ibm.mq.jmqi.JmqiUtils;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ConnectionDetailsSSLOptions
extends Composite {
    private static final String SSL_FIPS_NOT_SUPPORTED = "AMQ4642";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/qmgrs/ConnectionDetailsSSLOptions.java";
    private static final int RESET_COUNT_MINIMUM = 0;
    private static final int RESET_COUNT_MAXIMUM = 999999999;
    private static final int PEER_NAME_LENGTH = 1024;
    private Group groupCipherSuite = null;
    private Label labelSecurityMessage = null;
    private Label labelCipherSuite = null;
    Text textCipherSuiteDescription = null;
    private Label labelResetCount = null;
    private Label labelPeerName = null;
    private Label labelFIPSRequired = null;
    private SSLPeerNameTextWrapper textPeerName = null;
    private Spinner spinnerResetCount = null;
    private ExtCombo comboFIPSRequired = null;
    private Text textFIPSRequired = null;
    private int currentFIPSRequired = 0;
    private ExtCombo comboCipherSuites = null;
    private Button buttonEnable = null;
    private Message msgFile = null;
    private boolean addEnableButton = true;
    private boolean enableFips = false;
    private boolean isCCDTConnection = false;

    public ConnectionDetailsSSLOptions(Composite parent, int style, int span, boolean fips) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.enableFips = fips;
        this.createContents(t, span);
    }

    public ConnectionDetailsSSLOptions(Composite parent, int style, int span, boolean add, boolean fips) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.addEnableButton = add;
        this.enableFips = fips;
        this.createContents(t, span);
    }

    private Control createContents(Trace t, int span) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        this.currentFIPSRequired = store.getInt("SSLFIPSRequired");
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Preferences");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        this.labelFIPSRequired = new Label((Composite)this, 0);
        this.labelFIPSRequired.setText(this.msgFile.getMessage(t, "UI.PREF.SSLFipsRequired.Label"));
        gridData = new GridData(32);
        this.labelFIPSRequired.setLayoutData((Object)gridData);
        if (this.enableFips && (CommonServices.isSSLFIPSSupported() || this.currentFIPSRequired == 1)) {
            this.comboFIPSRequired = new ExtCombo(this, 12);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            this.comboFIPSRequired.setLayoutData(gridData);
            this.loadFIPSRequired(t);
            UiUtils.enableControls(t, new Control[]{this.comboFIPSRequired}, true);
            this.comboFIPSRequired.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    ConnectionDetailsSSLOptions.this.reloadCipherSuites(t2);
                }
            });
        } else {
            this.textFIPSRequired = new Text((Composite)this, 2056);
            gridData = new GridData(256);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 100;
            this.textFIPSRequired.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly(t, this.textFIPSRequired, true);
        }
        if (!CommonServices.isSSLFIPSSupported()) {
            UiUtils.createBlankLine(this, 2);
            Composite fipsAlertComposite = new Composite((Composite)this, 2048);
            GridLayout fipsAlertLayout = new GridLayout();
            fipsAlertLayout.makeColumnsEqualWidth = false;
            fipsAlertComposite.setLayout((Layout)fipsAlertLayout);
            GridData fipsAlertData = new GridData();
            fipsAlertData.horizontalSpan = 2;
            fipsAlertData.horizontalAlignment = 4;
            fipsAlertData.grabExcessHorizontalSpace = true;
            fipsAlertComposite.setLayoutData((Object)fipsAlertData);
            Composite fipsAlertCompositeInner = new Composite(fipsAlertComposite, 0);
            GridLayout fipsAlertLayoutInner = new GridLayout();
            fipsAlertLayoutInner.numColumns = 2;
            fipsAlertLayoutInner.makeColumnsEqualWidth = false;
            fipsAlertCompositeInner.setLayout((Layout)fipsAlertLayoutInner);
            Label lblFipsAlertIcon = new Label(fipsAlertCompositeInner, 4);
            lblFipsAlertIcon.setImage(UiPlugin.getDisplay().getSystemImage(8));
            GridData lblFipsAlertIconData = new GridData();
            lblFipsAlertIcon.setLayoutData((Object)lblFipsAlertIconData);
            Label lblFipsAlertText = new Label(fipsAlertCompositeInner, 64);
            String fipsAlertText = String.valueOf(CommonServices.getSystemMessage((String)SSL_FIPS_NOT_SUPPORTED)) + "\n" + CommonServices.getSystemMessage((String)"AMQ4642.URESP");
            lblFipsAlertText.setText(fipsAlertText);
            GridData lblFipsAlertTextData = new GridData(772);
            lblFipsAlertText.setLayoutData((Object)lblFipsAlertTextData);
        }
        UiUtils.createBlankLine(this, 2);
        UiUtils.createBlankLine(this, 2);
        if (this.addEnableButton) {
            this.buttonEnable = new Button((Composite)this, 32);
            this.buttonEnable.setText(this.msgFile.getMessage(t, "UI.PREF.ConnDetails.SSLOptions.Enable"));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            gridData.horizontalAlignment = 1;
            gridData.verticalAlignment = 1;
            this.buttonEnable.setLayoutData((Object)gridData);
            this.buttonEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    ConnectionDetailsSSLOptions.this.enableControls(t2);
                }
            });
            UiUtils.createBlankLine(this, 2);
        }
        this.groupCipherSuite = new Group((Composite)this, 0);
        this.groupCipherSuite.setText(this.msgFile.getMessage(t, "UI.PREF.SSL.Cipher.Suite.Group"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.groupCipherSuite.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.groupCipherSuite.setLayoutData((Object)gridData);
        this.labelSecurityMessage = new Label((Composite)this.groupCipherSuite, 0);
        this.labelSecurityMessage.setText(this.msgFile.getMessage(t, "UI.PREF.SSL.Cipher.Suite.Message"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.labelSecurityMessage.setLayoutData((Object)gridData);
        this.labelCipherSuite = new Label((Composite)this.groupCipherSuite, 0);
        this.labelCipherSuite.setText(this.msgFile.getMessage(t, "UI.PREF.SSLCipherSpec.Label"));
        gridData = new GridData(32);
        this.labelCipherSuite.setLayoutData((Object)gridData);
        this.comboCipherSuites = new ExtCombo((Composite)this.groupCipherSuite, 12);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 50;
        this.comboCipherSuites.setLayoutData(gridData);
        this.loadCipherSuites(t);
        this.comboCipherSuites.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ConnectionDetailsSSLOptions.this.setCipherSuiteDescription(t2);
            }
        });
        Group groupCipherSuiteDescription = new Group((Composite)this.groupCipherSuite, 0);
        gridLayout = new GridLayout();
        groupCipherSuiteDescription.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        groupCipherSuiteDescription.setLayoutData((Object)gridData);
        this.textCipherSuiteDescription = new Text((Composite)groupCipherSuiteDescription, 64);
        gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 100;
        this.textCipherSuiteDescription.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly(t, this.textCipherSuiteDescription, true);
        this.setCipherSuiteDescription(t);
        UiUtils.createBlankLine(this, 2);
        this.labelResetCount = new Label((Composite)this, 0);
        this.labelResetCount.setText(this.msgFile.getMessage(t, "UI.PREF.SSLResetCount.Label"));
        gridData = new GridData(32);
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.labelResetCount.setLayoutData((Object)gridData);
        this.spinnerResetCount = new Spinner((Composite)this, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.spinnerResetCount.setLayoutData((Object)gridData);
        this.spinnerResetCount.setMaximum(999999999);
        this.spinnerResetCount.setMinimum(0);
        UiUtils.limitSpinner(t, this.spinnerResetCount);
        UiUtils.createBlankLine(this, 2);
        this.labelPeerName = new Label((Composite)this, 0);
        this.labelPeerName.setText(this.msgFile.getMessage(t, "UI.PREF.PeerName.Label"));
        gridData = new GridData(32);
        gridData.horizontalIndent = ConnectionDetailsSecurityExit.HORIZONTAL_INDENT;
        this.labelPeerName.setLayoutData((Object)gridData);
        Text text = new Text((Composite)this, 2818);
        this.textPeerName = new SSLPeerNameTextWrapper(text);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        GC gc = new GC((Drawable)text);
        try {
            gc.setFont(text.getFont());
            FontMetrics fontInfo = gc.getFontMetrics();
            gridData.heightHint = 4 * fontInfo.getHeight();
        }
        finally {
            gc.dispose();
        }
        text.setLayoutData((Object)gridData);
        text.setTextLimit(1024);
        return this;
    }

    void setCipherSuiteDescription(Trace t) {
        String description = null;
        if (this.isCCDTConnection) {
            description = this.msgFile.getMessage("UI.CHL.SSL.Cipher.CCDT");
        } else {
            AttrTypeFixedLengthStringEnum attrTypeCipherSuites = null;
            boolean match = false;
            String selectedCipherSuite = this.comboCipherSuites.getText();
            attrTypeCipherSuites = (AttrTypeFixedLengthStringEnum)DmClientChannel.getAttributeType((Trace)t, (int)3544);
            String[] enumIds = attrTypeCipherSuites.getEnumerationIds(t);
            int i = 0;
            while (i < enumIds.length) {
                String enumName = attrTypeCipherSuites.getEnumeratedValue(t, enumIds[i]);
                if (enumName.compareTo(selectedCipherSuite) == 0) {
                    match = true;
                    break;
                }
                ++i;
            }
            String key = "UI.CHL.SSL.Cipher." + selectedCipherSuite;
            description = match ? String.valueOf(this.msgFile.getMessage(key)) + Common.NEW_LINE : Common.NEW_LINE;
        }
        if (Trace.isTracing) {
            t.data(67, "ConnectionDetailsSSLOptions.setCipherSuiteDescription", 300, "Cipher suite descriptions set to :" + Common.NEW_LINE + description);
        }
        this.textCipherSuiteDescription.setText(description);
    }

    private void loadCipherSuites(Trace t) {
        this.comboCipherSuites.removeAll();
        this.comboCipherSuites.add("");
        this.comboCipherSuites.setData("", "");
        ArrayList cipherSpecs = null;
        cipherSpecs = this.currentFIPSRequired == 0 ? (ArrayList)JmqiUtils.getCipherSpecs((boolean)false) : (ArrayList)JmqiUtils.getCipherSpecs((boolean)true);
        int i = 0;
        while (i < cipherSpecs.size()) {
            String key = (String)cipherSpecs.get(i);
            String value = JmqiUtils.toCipherSuite((String)key, (this.currentFIPSRequired != 0 ? 1 : 0) != 0);
            if (value == null) {
                value = "";
            }
            this.comboCipherSuites.add(key);
            this.comboCipherSuites.setData(key, value);
            if (Trace.isTracing) {
                t.data(67, "ConnectionDetailsSSLOptions.loadCipherSuites", 300, "Added cipher suite " + value + ", matching cipher spec " + key);
            }
            ++i;
        }
        this.comboCipherSuites.sort();
    }

    private void loadFIPSRequired(Trace t) {
        AttrTypeEnum attrTypeFIPSRequired = null;
        if (this.comboFIPSRequired != null) {
            attrTypeFIPSRequired = (AttrTypeEnum)DmQueueManager.getAttributeType((Trace)t, (int)92);
            if (attrTypeFIPSRequired != null) {
                Integer[] enumIds = attrTypeFIPSRequired.getEnumerationIds(t);
                int i = 0;
                while (i < enumIds.length) {
                    String enumName = attrTypeFIPSRequired.getEnumeratedValue(t, (Number)enumIds[i]);
                    this.comboFIPSRequired.add(enumName);
                    if (Trace.isTracing) {
                        t.data(67, "ConnectionDetailsSSLOptions.loadFIPSRequired", 300, "Added value " + enumName);
                    }
                    this.comboFIPSRequired.setData(enumName, enumIds[i]);
                    ++i;
                }
            } else if (Trace.isTracing) {
                t.data(67, "ConnectionDetailsSSLOptions.loadFIPSRequired", 900, "Error getting attrType for FIPS required");
            }
        } else if (Trace.isTracing) {
            t.data(67, "ConnectionDetailsSSLOptions.loadFIPSRequired", 300, "FIPS required combo list field not defined");
        }
    }

    public void setCipherSuite(Trace t, String name) {
        block6: {
            if (Trace.isTracing) {
                t.data(65, "ConnectionDetailsSSLOptions.setCipherSuite", 300, "ConnectionDetailsSSLOptions.setCipherSuiteCipher Suite Name = '" + name + "'");
            }
            String key = null;
            String[] keys = this.comboCipherSuites.getItems();
            try {
                int i = 0;
                while (i < keys.length) {
                    key = keys[i];
                    String value = (String)this.comboCipherSuites.getData(key);
                    if (name.equals(value)) {
                        if (Trace.isTracing) {
                            t.data(65, "ConnectionDetailsSSLOptions.setCipherSuite", 300, "ConnectionDetailsSSLOptions.setCipherSuiteSelecting key = '" + key + "', value = '" + value + "'");
                        }
                        this.comboCipherSuites.select(i);
                        this.setCipherSuiteDescription(t);
                        break;
                    }
                    ++i;
                }
            }
            catch (ClassCastException classCastException) {
                if (!Trace.isTracing) break block6;
                t.data(67, "ConnectionDetailsSSLOptions.setCipherSuite", 900, "Error getting string value from cipher suite combo list for key " + key);
            }
        }
    }

    public void setFIPSRequired(Trace t, int id) {
        block12: {
            String key = null;
            this.currentFIPSRequired = id;
            if (this.comboFIPSRequired != null) {
                String[] keys = this.comboFIPSRequired.getItems();
                try {
                    int i = 0;
                    while (i < keys.length) {
                        key = keys[i];
                        Integer value = (Integer)this.comboFIPSRequired.getData(key);
                        if (id == value) {
                            this.comboFIPSRequired.select(i);
                            break block12;
                        }
                        ++i;
                    }
                    break block12;
                }
                catch (ClassCastException classCastException) {
                    if (Trace.isTracing) {
                        t.data(67, "ConnectionDetailsSSLOptions.setFIPSRequired", 900, "Error getting integer value from FIPS rqeuired combo list for key " + key);
                    }
                    break block12;
                }
            }
            if (this.textFIPSRequired != null) {
                AttrTypeEnum attrTypeFIPSRequired = (AttrTypeEnum)DmQueueManager.getAttributeType((Trace)t, (int)92);
                if (attrTypeFIPSRequired != null) {
                    Integer[] enumIds = attrTypeFIPSRequired.getEnumerationIds(t);
                    int i = 0;
                    while (i < enumIds.length) {
                        String enumName = attrTypeFIPSRequired.getEnumeratedValue(t, (Number)enumIds[i]);
                        if (this.currentFIPSRequired == enumIds[i]) {
                            this.textFIPSRequired.setText(enumName);
                            break;
                        }
                        ++i;
                    }
                }
            } else if (Trace.isTracing) {
                t.data(67, "ConnectionDetailsSSLOptions.setFIPSRequired", 900, "FIPS required fields not defined");
            }
        }
        this.reloadCipherSuites(t);
    }

    private int reloadCipherSuites(Trace t) {
        String s;
        Integer value;
        int retValue = this.currentFIPSRequired;
        if (this.comboFIPSRequired != null && (value = (Integer)this.comboFIPSRequired.getData(s = this.comboFIPSRequired.getText())) != null && (retValue = value.intValue()) != this.currentFIPSRequired) {
            this.comboCipherSuites.removeAll();
            this.currentFIPSRequired = retValue;
            this.loadCipherSuites(t);
            this.setCipherSuiteDescription(t);
        }
        return retValue;
    }

    public int getFIPSRequired(Trace t) {
        return this.currentFIPSRequired;
    }

    public void enableControls(Trace t) {
        if (this.buttonEnable != null) {
            boolean b = this.buttonEnable.getSelection();
            if (this.isCCDTConnection) {
                UiUtils.enableControls(t, new Control[]{this.groupCipherSuite, this.textCipherSuiteDescription, this.labelCipherSuite, this.labelPeerName, this.labelResetCount, this.labelSecurityMessage, this.textPeerName.getWidget(), this.spinnerResetCount}, b);
            } else {
                UiUtils.enableControls(t, new Control[]{this.groupCipherSuite, this.textCipherSuiteDescription, this.labelCipherSuite, this.labelPeerName, this.labelResetCount, this.labelSecurityMessage, this.comboCipherSuites, this.textPeerName.getWidget(), this.spinnerResetCount}, b);
            }
        }
    }

    public Button getButtonEnable() {
        return this.buttonEnable;
    }

    public SSLPeerNameTextWrapper getTextPeerName() {
        return this.textPeerName;
    }

    public ExtCombo getComboCipherSuites() {
        return this.comboCipherSuites;
    }

    public ExtCombo getComboFIPSRequired() {
        return this.comboFIPSRequired;
    }

    public Text getTextFIPSRequired() {
        return this.textFIPSRequired;
    }

    public Spinner getSpinnerResetCount() {
        return this.spinnerResetCount;
    }

    public void setIsCCDTConnection(boolean isCCDTConnection) {
        this.isCCDTConnection = isCCDTConnection;
        this.comboCipherSuites.setEnabled(!isCCDTConnection);
        if (isCCDTConnection) {
            this.comboCipherSuites.select(0);
        }
        this.setCipherSuiteDescription(Trace.getDefault());
    }
}

