/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls.qmgrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ConnectionDetailsRemoteQmgr
extends Composite {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/qmgrs/ConnectionDetailsRemoteQmgr.java";
    public static int HORIZONTAL_INDENT = 0;
    private static final int MAX_PORT_VALUE = 65535;
    private Label labelPort = null;
    private Spinner spinnerPort = null;
    private Label labelChannel = null;
    private Text textChannel = null;
    private Button btnUseEnv = null;
    private Message msgFile = null;
    private boolean addUseEnvButton = true;
    private boolean channelValid = true;

    public ConnectionDetailsRemoteQmgr(Composite parent, int style, int span) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.createContents(t, span);
    }

    public ConnectionDetailsRemoteQmgr(Composite parent, int style, int span, boolean add) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.addUseEnvButton = add;
        this.createContents(t, span);
    }

    private Control createContents(Trace t, int span) {
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Preferences");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        gridData = new GridData(32);
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        this.labelPort = new Label((Composite)this, 0);
        this.labelPort.setText(this.msgFile.getMessage(t, "UI.PREF.ConnDetails.RemoteQmgr.Port"));
        this.labelPort.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, false);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.spinnerPort = new Spinner((Composite)this, 2048);
        this.spinnerPort.setMinimum(0);
        this.spinnerPort.setMaximum(65535);
        UiUtils.limitSpinner(t, this.spinnerPort);
        this.spinnerPort.setLayoutData((Object)gridData);
        UiUtils.createBlankLine(this, 2);
        gridData = new GridData(32);
        gridData.horizontalIndent = HORIZONTAL_INDENT;
        this.labelChannel = new Label((Composite)this, 0);
        this.labelChannel.setText(this.msgFile.getMessage(t, "UI.PREF.ConnDetails.RemoteQmgr.SvrConn"));
        this.labelChannel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, false);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.textChannel = new Text((Composite)this, 2048);
        this.textChannel.setTextLimit(20);
        this.textChannel.setLayoutData((Object)gridData);
        this.textChannel.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                ConnectionDetailsRemoteQmgr.this.channelValid = StringValidation.verifyMQObjectName(Trace.getDefault(), e);
                e.doit = ConnectionDetailsRemoteQmgr.this.channelValid;
            }
        });
        UiUtils.createBlankLine(this, 2);
        if (this.addUseEnvButton) {
            gridData = new GridData(32);
            gridData.horizontalIndent = HORIZONTAL_INDENT;
            this.btnUseEnv = new Button((Composite)this, 32);
            this.btnUseEnv.setText(this.msgFile.getMessage(t, "UI.PREF.ConnDetails.RemoteQmgr.UseEnv"));
            this.btnUseEnv.setLayoutData((Object)gridData);
            this.btnUseEnv.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ConnectionDetailsRemoteQmgr.this.enableControls(Trace.getDefault());
                }
            });
        }
        return this;
    }

    public void enableControls(Trace t) {
        boolean b = false;
        if (this.btnUseEnv != null) {
            b = this.btnUseEnv.getSelection();
        }
        if (Trace.isTracing) {
            t.data(67, "ConnectionDetailsRemoteQmgr.enableControls", 300, "Using System environment enabled : " + b);
        }
        UiUtils.enableControls(t, new Control[]{this.labelPort, this.labelChannel, this.spinnerPort, this.textChannel}, !b);
    }

    public Button getButtonUseEnv() {
        return this.btnUseEnv;
    }

    public Spinner getSpinnerPort() {
        return this.spinnerPort;
    }

    public Text getTextChannel() {
        return this.textChannel;
    }
}

