/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class WizPage
extends WizardPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/WizPage.java";
    private String helpId;

    public WizPage(String pageId) {
        super(pageId);
    }

    public WizPage(String pageId, String helpId) {
        this(pageId);
        this.helpId = helpId;
    }

    public WizPage(String pageId, String title, ImageDescriptor titleImage) {
        super(pageId, title, titleImage);
    }

    public WizPage(String pageId, String title, ImageDescriptor titleImage, String helpId) {
        this(pageId, title, titleImage);
        this.helpId = helpId;
    }

    public void createControl(Composite parent, int numColumns) {
        Trace t = Trace.getDefault();
        ScrolledComposite scrolledComp = new ScrolledComposite(parent, 768);
        if (this.helpId != null) {
            UiPlugin.getHelpSystem().setHelp((Control)scrolledComp, this.helpId);
        }
        Composite mainComposite = new Composite((Composite)scrolledComp, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        gridLayout.makeColumnsEqualWidth = true;
        mainComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        mainComposite.setLayoutData((Object)gridData);
        this.createPageContent(t, mainComposite);
        this.setControl((Control)scrolledComp);
        this.setPageComplete(false);
        scrolledComp.setContent((Control)mainComposite);
        mainComposite.layout();
        Point size = mainComposite.computeSize(-1, -1);
        scrolledComp.setMinSize(size);
        scrolledComp.setExpandHorizontal(true);
        scrolledComp.setExpandVertical(true);
        scrolledComp.layout();
        UiUtils.addScrollListeners(scrolledComp);
    }

    public abstract void createPageContent(Trace var1, Composite var2);

    public abstract boolean performFinish();

    public abstract void checkIfEnableButtons();

    public abstract void nextPressed();

    public void backPressed() {
    }

    public void setHeadings(String title, String description) {
        super.setTitle(title);
        super.setDescription(description);
    }
}

