/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.CheckedSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.controls.ICheckedSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectUiMQObject
extends Composite
implements ShellListener,
ExplorerTableSelectionChangedListener,
ExplorerTableContentChangedListener,
ICheckStateListener,
ISelectionProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/SelectUiMQObject.java";
    public static final int ICON_INFO = 0;
    public static final int ICON_WARNING = 1;
    public static final int ICON_ERROR = 2;
    private static final String INSTANCE_ID_SEL_DLG = "com.ibm.mq.explorer.ui.select.dialog";
    private static final int NUM_COLS = 1;
    private String description = null;
    private Composite compDescription = null;
    private Text labelDescription = null;
    private String noObjectMessage = null;
    private int noObjectIcon = 1;
    private Composite compositeMsgBar = null;
    private Label labelMsgBarIcon = null;
    private Text labelMsgBarMessage = null;
    private Composite compositeTable = null;
    private ExplorerTable explorerTable = null;
    private static final int TABLE_WIDTH_HINT = 600;
    private static final int TABLE_HEIGHT_HINT = 300;
    private Composite compositeSelectButtons = null;
    private Button buttonSelectAll = null;
    private Button buttonSelectNone = null;
    private int tableType = 0;
    private UiMQObject selectedObject = null;
    private ArrayList<UiMQObject> checkedObjects = null;
    private int objectCountOnClose = 0;
    private String explicitAttrOrderUniversalId = null;
    private String preselectObjectName = null;
    private boolean isTickCrossMode = false;
    private Image imageTick = null;
    private Image imageCross = null;
    private boolean isListenToDataModel = false;
    private IDmObservable listenDmObject = null;
    private int listenDmObjectId = -1;
    private DmObjectFilter dmExplicitObjectFilter = null;
    private IUiMQObjectFactory uiMQObjectFactory = null;
    private UiMQObject parentObjectForFactory = null;
    private String objectId = null;
    private String genericObjectName = null;
    private String attrOrderId = null;
    private boolean isSecondaryOrder = false;
    private String filterId = null;
    private FilterProvider filterProvider = null;
    private Integer filterQSGDisposition = null;
    private ViewerFilter viewerFilter = null;
    private Vector<ISelectionChangedListener> selectionChangedListeners = null;
    private StructuredSelection structuredSelection = null;
    private UiMQObject[] tableObjects = null;
    private MQExtObject[] preCheckedObjects = null;
    private Vector<ICheckedSelectionChangedListener> checkedSelectionChangedListeners = null;
    private ArrayList<ViewerFilter> extraFilters;

    public SelectUiMQObject(Trace t, Composite parent, int style, int _tableType) {
        super(parent, style);
        if (_tableType == 2 && this.checkedObjects == null) {
            this.checkedObjects = new ArrayList();
        }
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
        this.noObjectMessage = msgFile.getMessage(t, "UI.PROP.Dialog.NoObjectsAvailable");
        this.tableType = _tableType;
        this.selectionChangedListeners = new Vector();
        this.checkedSelectionChangedListeners = new Vector();
        this.extraFilters = new ArrayList();
    }

    public void createContent(Trace t, String _description, String _objectId, String _genericObjectName, String _attrOrderId, boolean _isSecondaryOrder, String _filterId, FilterProvider _filterProvider, Integer _filterQSGDisposition, ViewerFilter _viewerFilter, boolean _showSchemeBar, boolean _showStatusBar) {
        this.description = _description;
        this.objectId = _objectId;
        this.genericObjectName = _genericObjectName;
        this.attrOrderId = _attrOrderId;
        this.isSecondaryOrder = _isSecondaryOrder;
        this.filterId = _filterId;
        this.filterProvider = _filterProvider;
        this.filterQSGDisposition = _filterQSGDisposition;
        this.viewerFilter = _viewerFilter;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        if (this.description != null) {
            this.compDescription = new Composite((Composite)this, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            this.compDescription.setLayout((Layout)layout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            this.compDescription.setLayoutData((Object)gridData);
            this.labelDescription = new Text(this.compDescription, 74);
            this.labelDescription.setText(this.description);
            UiUtils.makeTextControlReadOnly(t, this.labelDescription, true);
            GridData data = new GridData(4, 128, true, false, 4, 1);
            data.horizontalSpan = 1;
            this.labelDescription.setLayoutData((Object)data);
        }
        if (this.noObjectMessage != null) {
            this.compositeMsgBar = new Composite((Composite)this, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.makeColumnsEqualWidth = false;
            this.compositeMsgBar.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            this.compositeMsgBar.setLayoutData((Object)gridData);
            this.labelMsgBarIcon = new Label(this.compositeMsgBar, 0);
            this.labelMsgBarIcon.setVisible(false);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            this.labelMsgBarIcon.setLayoutData((Object)gridData);
            this.labelMsgBarMessage = new Text(this.compositeMsgBar, 0);
            this.labelMsgBarMessage.setText("");
            UiUtils.makeTextControlReadOnly(t, this.labelMsgBarMessage, true);
            this.labelMsgBarMessage.setVisible(false);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            this.labelMsgBarMessage.setLayoutData((Object)gridData);
        }
        this.compositeTable = new Composite((Composite)this, 0);
        FillLayout fillLayout = new FillLayout();
        this.compositeTable.setLayout((Layout)fillLayout);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 600;
        gridData.heightHint = 300;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.compositeTable.setLayoutData((Object)gridData);
        boolean isFiltering = this.filterId != null && this.filterProvider != null;
        this.explorerTable = new ExplorerTable(t, this.compositeTable, 0, this.genericObjectName, isFiltering, _showSchemeBar, _showStatusBar, false, "com.ibm.mq.explorer.context.selectuimqobject", this.tableType, null, false);
        this.explorerTable.setObjectId(t, this.objectId);
        this.explorerTable.setAttributeOrderId(t, this.attrOrderId);
        this.explorerTable.setFilteringAvailable(t, isFiltering);
        this.explorerTable.setTickCrossMode(t, this.isTickCrossMode, this.imageTick, this.imageCross);
        if (this.tableType == 2) {
            this.explorerTable.addCheckStateListener(t, this);
        }
        if (this.dmExplicitObjectFilter != null) {
            this.explorerTable.setFilterQSGDisposition(this.filterQSGDisposition);
        } else if (isFiltering) {
            this.explorerTable.setFilterId(t, this.filterId);
            this.explorerTable.setFilterProvider(t, this.filterProvider);
            this.explorerTable.setFilterQSGDisposition(this.filterQSGDisposition);
        }
        if (this.explicitAttrOrderUniversalId != null) {
            AttributeOrderManager attrOrderManager = UiPlugin.getAttributeOrderManager();
            attrOrderManager.setSelectedAttrOrder(t, this.attrOrderId, INSTANCE_ID_SEL_DLG, this.explicitAttrOrderUniversalId, false, false);
        }
        this.explorerTable.setInstance(t, INSTANCE_ID_SEL_DLG, this.isSecondaryOrder);
        this.explorerTable.addSelChangedListener(t, this);
        this.explorerTable.addContentChangedListener(t, this);
        if (this.viewerFilter != null) {
            this.explorerTable.addViewerFilter(t, this.viewerFilter);
        }
        Iterator<ViewerFilter> i = this.extraFilters.iterator();
        while (i.hasNext()) {
            this.explorerTable.addViewerFilter(t, i.next());
        }
        this.explorerTable.setPreselectObjectName(this.preselectObjectName);
        this.explorerTable.setPreCheckedObjects(t, this.preCheckedObjects);
        if (!this.isListenToDataModel && this.tableObjects != null) {
            this.explorerTable.beginUpdate(t);
            int i2 = 0;
            while (i2 < this.tableObjects.length) {
                this.explorerTable.addTableItem(t, this.tableObjects[i2]);
                ++i2;
            }
            this.explorerTable.endUpdate(t);
        }
        if (this.tableType == 2) {
            this.compositeSelectButtons = new Composite((Composite)this, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            gridLayout.makeColumnsEqualWidth = false;
            this.compositeSelectButtons.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = false;
            this.compositeSelectButtons.setLayoutData((Object)gridData);
            this.buttonSelectAll = new Button(this.compositeSelectButtons, 8);
            this.buttonSelectAll.setText(UiPlugin.getNLSString(t, "KEY_General", "UI.GENERAL.SELECT.ALL"));
            gridData = new GridData();
            this.buttonSelectAll.setLayoutData((Object)gridData);
            this.buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelectUiMQObject.this.selectAll(Trace.getDefault());
                }
            });
            this.buttonSelectNone = new Button(this.compositeSelectButtons, 8);
            this.buttonSelectNone.setText(UiPlugin.getNLSString(t, "KEY_General", "UI.GENERAL.SELECT.NONE"));
            gridData = new GridData();
            this.buttonSelectNone.setLayoutData((Object)gridData);
            this.buttonSelectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelectUiMQObject.this.selectNone(Trace.getDefault());
                }
            });
            Label label = new Label(this.compositeSelectButtons, 0);
            gridData = new GridData(768);
            label.setLayoutData((Object)gridData);
            ButtonTools.makeEqualWidthGridData(t, this.compositeSelectButtons);
        }
    }

    public void setNoObjectMessage(Trace t, int iconId, String msg) {
        this.noObjectMessage = msg;
        this.noObjectIcon = iconId;
    }

    public void setExplicitAttrOrderUniversalId(Trace t, String id) {
        this.explicitAttrOrderUniversalId = id;
    }

    public void setExplicitFilter(Trace t, DmObjectFilter filter) {
        this.dmExplicitObjectFilter = filter;
    }

    public void listenToDataModel(Trace t, IDmObservable listenQmgr, int listenObjectId, IUiMQObjectFactory objectFactory, UiMQObject parentToNewObjects) {
        this.isListenToDataModel = true;
        this.listenDmObject = listenQmgr;
        this.listenDmObjectId = listenObjectId;
        this.uiMQObjectFactory = objectFactory;
        this.parentObjectForFactory = parentToNewObjects;
        if (this.listenDmObjectId == 2) {
            this.listenDmObject = UiPlugin.getTheDataModel();
        }
    }

    @Override
    public void contentChanged(ExplorerTableContentChangedEvent event) {
        Trace t = Trace.getDefault();
        this.objectCountOnClose = this.explorerTable.getItemCount(t);
        if (this.objectCountOnClose == 0 && this.noObjectMessage != null && !this.labelMsgBarMessage.isDisposed()) {
            this.labelMsgBarMessage.setText(this.noObjectMessage);
            this.labelMsgBarMessage.setVisible(true);
            this.labelMsgBarIcon.setVisible(true);
            switch (this.noObjectIcon) {
                case 2: {
                    this.labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_message_error_image"));
                    break;
                }
                case 0: {
                    this.labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                    break;
                }
                default: {
                    this.labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                }
            }
            this.compositeMsgBar.layout();
            this.layout();
            this.update();
            if (this.checkedObjects == null) {
                this.checkedObjects = new ArrayList();
            }
            this.triggerSelectionChangedListeners(t, this.checkedObjects.toArray(new UiMQObject[this.checkedObjects.size()]));
        } else if (this.compositeMsgBar != null) {
            this.labelMsgBarMessage.setVisible(false);
            this.labelMsgBarIcon.setVisible(false);
        }
    }

    @Override
    public void selChanged(ExplorerTableSelectionChangedEvent event) {
        Trace t = Trace.getDefault();
        this.selectedObject = event.getObject();
        this.preselectObjectName = null;
        this.explorerTable.setPreselectObjectName(null);
        this.triggerSelectionChangedListeners(t, new UiMQObject[]{this.selectedObject});
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Trace t = Trace.getDefault();
        UiMQObject selUiMQObject = null;
        Object obj = event.getElement();
        if (obj instanceof MQExtObject) {
            selUiMQObject = (UiMQObject)((MQExtObject)obj).getInternalObject();
        }
        if (selUiMQObject != null) {
            boolean state = event.getChecked();
            if (state) {
                this.checkedObjects.add(selUiMQObject);
            } else if (this.checkedObjects.contains(selUiMQObject)) {
                this.checkedObjects.remove(selUiMQObject);
            }
        }
        this.triggerCheckedSelectionChangedListeners(t, this.checkedObjects.toArray(new UiMQObject[this.checkedObjects.size()]));
    }

    public ArrayList<UiMQObject> getCheckedObjects() {
        return this.checkedObjects;
    }

    public boolean addObjectsToTable(Trace t, UiMQObject[] objects) {
        boolean result = false;
        if (!this.isListenToDataModel && objects != null) {
            this.explorerTable.beginUpdate(t);
            int i = 0;
            while (i < objects.length) {
                this.explorerTable.addTableItem(t, objects[i]);
                ++i;
            }
            this.explorerTable.endUpdate(t);
            result = true;
        }
        return result;
    }

    public boolean setFocus() {
        return this.explorerTable.setFocus();
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellClosed(ShellEvent e) {
        Trace t = Trace.getDefault();
        if (this.isListenToDataModel) {
            this.stopListening(t);
        }
        if (this.tableType == 2) {
            this.explorerTable.removeCheckStateListener(t, this);
        }
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public void startListening(Trace t) {
        this.explorerTable.setUiMQObjectFactoryClass(t, this.uiMQObjectFactory, this.parentObjectForFactory);
        if (this.dmExplicitObjectFilter != null) {
            if (!this.explorerTable.startListener(t, this.listenDmObject, this.dmExplicitObjectFilter) && Trace.isTracing) {
                t.data(67, "SelectUiMQObject.startListening", 900, "failed to start listening with explicit filter for changes on IDmObservable " + this.listenDmObject.getObservableName() + ", listenDmObjectId " + this.listenDmObjectId);
            }
        } else if (!this.explorerTable.startListener(t, this.listenDmObject, this.listenDmObjectId) && Trace.isTracing) {
            t.data(67, "SelectUiMQObject.startListening", 900, "failed to start listening for changes on IDmObservable " + this.listenDmObject.getObservableName() + ", listenDmObjectId " + this.listenDmObjectId);
        }
    }

    public void stopListening(Trace t) {
        if (!this.explorerTable.stopListener(t, this.listenDmObject) && Trace.isTracing) {
            t.data(67, "SelectUiMQObject.stopListening", 900, "failed to stop listening for changes - IDmObservable " + this.listenDmObject.getObservableName() + ", listenDmObjectId " + this.listenDmObjectId);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    private void triggerSelectionChangedListeners(Trace t, UiMQObject[] selObjects) {
        this.structuredSelection = new StructuredSelection((Object[])selObjects);
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.structuredSelection);
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(event);
        }
    }

    public void addCheckedSelectionChangedListener(ICheckedSelectionChangedListener listener) {
        this.checkedSelectionChangedListeners.add(listener);
    }

    public void removeCheckedSelectionChangedListener(ICheckedSelectionChangedListener listener) {
        this.checkedSelectionChangedListeners.remove(listener);
    }

    private void triggerCheckedSelectionChangedListeners(Trace t, UiMQObject[] checkedObjs) {
        CheckedSelectionChangedEvent event = new CheckedSelectionChangedEvent(this, checkedObjs);
        for (ICheckedSelectionChangedListener listener : this.checkedSelectionChangedListeners) {
            listener.changed(event);
        }
    }

    public ISelection getSelection() {
        return this.structuredSelection;
    }

    public void setSelection(ISelection selection) {
    }

    public void removeAll(Trace t) {
        if (this.explorerTable != null) {
            this.explorerTable.removeAll(t);
        }
    }

    public void setTickCrossMode(Trace t, boolean isTickCross, Image imgTick, Image imgCross) {
        this.isTickCrossMode = isTickCross;
        if (imgTick != null) {
            this.imageTick = imgTick;
        }
        if (imgCross != null) {
            this.imageCross = imgCross;
        }
        if (this.explorerTable != null) {
            this.explorerTable.setTickCrossMode(t, isTickCross, imgTick, imgCross);
        }
    }

    public int getObjectCountOnClose() {
        return this.objectCountOnClose;
    }

    public void setObjects(Trace t, UiMQObject[] objects) {
        if (!this.isListenToDataModel) {
            if (this.explorerTable != null) {
                this.addObjectsToTable(t, objects);
            } else {
                this.tableObjects = objects;
            }
        }
    }

    public UiMQObject getSelectedObject() {
        return this.selectedObject;
    }

    public void setPreselectObjectName(String name) {
        this.preselectObjectName = name;
    }

    public void setPreCheckedObjects(Trace t, MQExtObject[] objects) {
        if (this.tableType == 2) {
            this.preCheckedObjects = objects;
        }
    }

    protected void selectAll(Trace t) {
        this.explorerTable.checkAll(t);
        ArrayList<MQExtObject> objectsInTable = this.explorerTable.getObjects(t);
        this.checkedObjects.clear();
        Iterator<MQExtObject> iterator = objectsInTable.iterator();
        while (iterator.hasNext()) {
            this.checkedObjects.add((UiMQObject)iterator.next().getInternalObject());
        }
        this.triggerSelectionChangedListeners(t, this.checkedObjects.toArray(new UiMQObject[this.checkedObjects.size()]));
    }

    protected void selectNone(Trace t) {
        this.explorerTable.checkNone(t);
        this.checkedObjects.clear();
        this.triggerSelectionChangedListeners(t, this.checkedObjects.toArray(new UiMQObject[this.checkedObjects.size()]));
    }

    public void addViewerFilter(ViewerFilter vf) {
        this.extraFilters.add(vf);
    }

    public void addMouseListener(MouseListener listener) {
        if (this.explorerTable != null) {
            this.explorerTable.addMouseListener(listener);
        }
    }
}

