/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NumberRange
extends Composite {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/NumberRange.java";
    private Text text;
    private int minimum;
    private int maximum;
    private int oldValue;

    public NumberRange(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.text = new Text((Composite)this, 0);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 2;
        this.text.setLayoutData((Object)gridData);
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Trace tr = Trace.getDefault();
                NumberRange.verify(tr, e);
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                NumberRange.this.modify(tr, e);
            }
        });
    }

    private static void verify(Trace t, VerifyEvent e) {
        if (!StringValidation.verifyNumeric(t, e)) {
            e.doit = false;
        }
    }

    private void modify(Trace t, ModifyEvent e) {
        String textValue = this.text.getText();
        int value = this.oldValue;
        if (textValue.length() > 0) {
            try {
                value = Integer.parseInt(textValue);
                if (value < this.minimum) {
                    UiPlugin.getDisplay().beep();
                    value = this.oldValue;
                    this.text.setText(String.valueOf(value));
                } else if (value > this.maximum) {
                    UiPlugin.getDisplay().beep();
                    value = this.oldValue;
                    this.text.setText(String.valueOf(value));
                }
            }
            catch (NumberFormatException numberFormatException) {
                UiPlugin.getDisplay().beep();
                value = this.oldValue;
                this.text.setText(String.valueOf(value));
            }
            this.oldValue = value;
        }
    }

    public void setMaximum(int max) {
        this.maximum = max;
    }

    public void setMinimum(int min) {
        this.minimum = min;
    }

    public void setValue(int value) {
        this.text.setText(String.valueOf(value));
    }

    public Integer getValue() {
        String value = this.text.getText();
        Integer number = null;
        try {
            number = Integer.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            number = null;
        }
        return number;
    }

    public void addModifyListener(ModifyListener listener) {
        this.text.addModifyListener(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }
}

