/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ExtTableViewer {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/ExtTableViewer.java";
    public static final int VIEWER_TYPE_TABLE = 0;
    public static final int VIEWER_TYPE_TABLETREE = 1;
    public static final int VIEWER_TYPE_CHECKBOXTABLE = 2;
    private int viewerType = 0;
    private StructuredViewer viewer = null;
    private Vector<ICheckStateListener> checkedStateListeners = null;
    private Composite parentComposite = null;
    private int flags;

    public ExtTableViewer(Composite parent, int flags) {
        this.createViewer(parent, flags, 0);
    }

    public ExtTableViewer(Composite parent, int flags, boolean isTableTreeViewer) {
        if (isTableTreeViewer) {
            this.createViewer(parent, flags, 1);
        } else {
            this.createViewer(parent, flags, 0);
        }
    }

    public ExtTableViewer(Composite parent, int _flags, int tableType) {
        int viewType = 0;
        switch (tableType) {
            case 0: {
                viewType = 0;
                break;
            }
            case 1: {
                viewType = 1;
                break;
            }
            case 2: {
                viewType = 2;
            }
        }
        this.createViewer(parent, _flags, viewType);
        this.parentComposite = parent;
        this.flags = _flags;
    }

    private void createViewer(Composite parent, int flags, int type) {
        switch (type) {
            case 0: {
                this.viewer = new TableViewer(parent, flags);
                break;
            }
            case 1: {
                this.viewer = new TableViewer(parent, flags);
                break;
            }
            case 2: {
                Table table = new Table(parent, 2080);
                this.viewer = new CheckboxTableViewer(table);
            }
        }
        this.viewerType = type;
    }

    public Table getTable() {
        Table table = null;
        switch (this.viewerType) {
            case 0: {
                table = ((TableViewer)this.viewer).getTable();
                break;
            }
            case 1: {
                table = ((TableViewer)this.viewer).getTable();
                break;
            }
            case 2: {
                table = ((CheckboxTableViewer)this.viewer).getTable();
            }
        }
        return table;
    }

    public Control getLayoutControl() {
        Table control = null;
        switch (this.viewerType) {
            case 0: {
                control = ((TableViewer)this.viewer).getTable();
                break;
            }
            case 1: {
                control = ((TableViewer)this.viewer).getTable();
                break;
            }
            case 2: {
                control = ((CheckboxTableViewer)this.viewer).getTable();
            }
        }
        return control;
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public void addFilter(ViewerFilter filter) {
        this.viewer.addFilter(filter);
    }

    public void removeFilter(ViewerFilter filter) {
        this.viewer.removeFilter(filter);
    }

    public void resetFilters() {
        this.viewer.resetFilters();
    }

    public void update(Object element, String[] properties) {
        this.viewer.update(element, properties);
    }

    public final void setInput(Object input) {
        this.viewer.setInput(input);
    }

    public void setSorter(ViewerSorter sorter) {
        this.viewer.setSorter(sorter);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.viewer.setLabelProvider(labelProvider);
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.viewer.getLabelProvider();
    }

    public void setContentProvider(IContentProvider provider) {
        this.viewer.setContentProvider(provider);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.viewer.setSelection(selection, reveal);
    }

    public void expandAll() {
    }

    public void expandToLevel(int level) {
    }

    public void collapseAll() {
    }

    public ArrayList<Object> getObjects() {
        ArrayList<Object> array = new ArrayList<Object>();
        switch (this.viewerType) {
            case 0: {
                Table table = ((TableViewer)this.viewer).getTable();
                TableItem[] items = table.getItems();
                int i = 0;
                while (i < items.length) {
                    Object data = items[i].getData();
                    if (data != null) {
                        array.add(data);
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                TreeViewer treeViewer = new TreeViewer(this.parentComposite, this.flags);
                Tree tree = treeViewer.getTree();
                TreeItem[] tItems = tree.getItems();
                int i = 0;
                while (i < tItems.length) {
                    Object data = tItems[i].getData();
                    if (data != null) {
                        array.add(data);
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                Table cbTable = ((CheckboxTableViewer)this.viewer).getTable();
                TableItem[] cbItems = cbTable.getItems();
                int i = 0;
                while (i < cbItems.length) {
                    Object data = cbItems[i].getData();
                    if (data != null) {
                        array.add(data);
                    }
                    ++i;
                }
                break;
            }
        }
        return array;
    }

    public boolean addCheckStateListener(Trace t, ICheckStateListener listener) {
        boolean result = false;
        if (this.viewerType == 2) {
            ((CheckboxTableViewer)this.viewer).addCheckStateListener(listener);
            if (this.checkedStateListeners == null) {
                this.checkedStateListeners = new Vector();
            }
            this.checkedStateListeners.add(listener);
            result = true;
        }
        return result;
    }

    public boolean removeCheckStateListener(Trace t, ICheckStateListener listener) {
        boolean result = false;
        if (this.viewerType == 2) {
            ((CheckboxTableViewer)this.viewer).removeCheckStateListener(listener);
            if (this.checkedStateListeners != null) {
                this.checkedStateListeners.remove(listener);
            }
            result = true;
        }
        return result;
    }

    private void sendCheckedStateChangedEvent(Trace t, Object object, boolean state) {
        CheckStateChangedEvent event = new CheckStateChangedEvent((ICheckable)((CheckboxTableViewer)this.viewer), object, state);
        for (ICheckStateListener listener : this.checkedStateListeners) {
            listener.checkStateChanged(event);
        }
    }

    public void setChecked(Trace t, Object[] objectsToCheck) {
        if (this.viewerType == 2) {
            ((CheckboxTableViewer)this.viewer).setCheckedElements(objectsToCheck);
            int i = 0;
            while (i < objectsToCheck.length) {
                this.sendCheckedStateChangedEvent(t, objectsToCheck[i], true);
                ++i;
            }
        }
    }

    public void checkAll(Trace t) {
        if (this.viewerType == 2) {
            CheckboxTableViewer checkViewer = (CheckboxTableViewer)this.viewer;
            checkViewer.setAllChecked(true);
            Object[] elements = checkViewer.getCheckedElements();
            int i = 0;
            while (i < elements.length) {
                this.sendCheckedStateChangedEvent(t, elements[i], true);
                ++i;
            }
        }
    }

    public void checkNone(Trace t) {
        if (this.viewerType == 2) {
            CheckboxTableViewer checkViewer = (CheckboxTableViewer)this.viewer;
            checkViewer.setAllChecked(false);
            int index = 0;
            boolean isDone = false;
            while (!isDone) {
                Object element;
                if ((element = ((CheckboxTableViewer)this.viewer).getElementAt(index++)) != null) {
                    this.sendCheckedStateChangedEvent(t, element, false);
                    continue;
                }
                isDone = true;
            }
        }
    }
}

