/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import java.util.ArrayList;
import java.util.Hashtable;

public class ExtTableGreyCellManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/ExtTableGreyCellManager.java";
    private Hashtable<MQExtObject, ArrayList<Integer>> hashtable = new Hashtable();

    public ArrayList<Integer> getGreyCellList(Trace t, MQExtObject mqExtObject) {
        ArrayList<Integer> greyCellList = this.getGreyCellListFromHashtable(t, mqExtObject);
        return greyCellList;
    }

    public void addColumnToGreyCellList(Trace t, MQExtObject mqExtObject, int column) {
        ArrayList<Integer> greyCellList;
        int index;
        if (Trace.isTracing) {
            t.data(67, "ExtTableGreyCellManager.addColumnToGreyCellList", 300, "adding column: " + column);
        }
        if ((index = this.getIndexForColumn(t, greyCellList = this.getGreyCellListFromHashtable(t, mqExtObject), column)) == -1) {
            greyCellList.add(column);
        }
    }

    public void removeColumnFromGreyCellList(Trace t, MQExtObject mqExtObject, int column) {
        ArrayList<Integer> greyCellList;
        int index;
        if (Trace.isTracing) {
            t.data(67, "ExtTableGreyCellManager.removeColumnFromGreyCellList", 300, "removing column: " + column);
        }
        if ((index = this.getIndexForColumn(t, greyCellList = this.getGreyCellListFromHashtable(t, mqExtObject), column)) != -1) {
            greyCellList.remove(index);
        }
    }

    public void clearGreyCellList(Trace t, MQExtObject mqExtObject) {
        ArrayList<Integer> greyCellList = this.getGreyCellListFromHashtable(t, mqExtObject);
        greyCellList.clear();
    }

    public void removeAllObjectsFromList() {
        this.hashtable.clear();
    }

    public void removeMQExtObject(Trace t, MQExtObject mqExtObject) {
        if (mqExtObject != null) {
            if (Trace.isTracing) {
                t.data(67, "ExtTableGreyCellManager.removeMQExtObject", 300, "removing mqExtObject: " + mqExtObject.toString());
            }
            this.hashtable.remove(mqExtObject);
        }
    }

    private int getIndexForColumn(Trace t, ArrayList<Integer> greyCellList, int column) {
        int index = -1;
        int i = 0;
        while (i < greyCellList.size()) {
            Integer item = greyCellList.get(i);
            if (item == column) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private ArrayList<Integer> getGreyCellListFromHashtable(Trace t, MQExtObject mqExtObject) {
        if (!this.hashtable.containsKey(mqExtObject)) {
            ArrayList newGreyCellList = new ArrayList();
            this.hashtable.put(mqExtObject, newGreyCellList);
        }
        ArrayList<Integer> greyCellList = this.hashtable.get(mqExtObject);
        return greyCellList;
    }
}

