/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableLabelProvider;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableViewer;
import com.ibm.mq.explorer.ui.internal.controls.ExtViewerSorter;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.StatusBar;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ExtTableColumnManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/ExtTableColumnManager.java";
    private static final Integer SORT_ASCENDING = 1;
    private static final Integer SORT_DESCENDING = 0;
    private ExtTableViewer tableViewer = null;
    private Table table = null;
    private ExtTableLabelProvider extTableLabelProvider = null;
    private ExtViewerSorter extViewerSorter = null;
    private boolean isCurrentSortAscending = true;
    private TableColumn currentSortTableColumn = null;
    private int currentSortIndex = 0;
    private int previousSortIndex = 0;
    private boolean isPreviousSortAscending = true;
    private double widthConstraint = 0.0;
    private int excessWidthColumnIndex = -1;
    private Hashtable<String, Integer> currentSortColumn = null;
    private Hashtable<String, Integer> currentSortDirection = null;
    private Hashtable<String, Integer> previousSortColumn = null;
    private Hashtable<String, Integer> previousSortDirection = null;
    private String currentInstanceId = null;
    private boolean instanceChanged = false;
    private boolean isResizeColumnsTimerRunning = false;
    private boolean isResizeColumnsWhenTimerPops = false;
    private boolean isResizingByProgram = false;
    private StatusBar statusBar = null;
    private boolean isInstanceSecondary = false;
    private boolean busyResizing;
    private static boolean isTestedCanGetColWidth = false;
    private static boolean isGetColumnWidths = false;
    private boolean manuallySorted = false;

    public ExtTableColumnManager(Trace t, ExtTableViewer tableView, ExtTableLabelProvider labelProvider, boolean addTableResizeListener) {
        this.tableViewer = tableView;
        this.extTableLabelProvider = labelProvider;
        if (this.tableViewer != null) {
            this.table = this.tableViewer.getTable();
        }
        if (this.tableViewer != null && addTableResizeListener) {
            this.table.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Trace t2 = Trace.getDefault();
                    ExtTableColumnManager.this.resizeColumns(t2);
                }
            });
        }
        this.currentSortColumn = new Hashtable();
        this.currentSortDirection = new Hashtable();
        this.previousSortColumn = new Hashtable();
        this.previousSortDirection = new Hashtable();
    }

    public void setViewerSorter(Trace t, ExtViewerSorter viewerSorter, boolean setInTable) {
        this.extViewerSorter = viewerSorter;
        if (setInTable) {
            this.tableViewer.setSorter(viewerSorter);
            if (viewerSorter != null) {
                if (this.tableViewer.getTable().getColumnCount() > 0) {
                    if (this.currentSortTableColumn == null) {
                        this.currentSortTableColumn = this.tableViewer.getTable().getColumn(0);
                        this.currentSortIndex = 0;
                    }
                    viewerSorter.setSortColumnIndex(t, this.currentSortIndex);
                    if (this.isCurrentSortAscending) {
                        this.currentSortTableColumn.setImage(Icons.get(Icons.iconkeySortAscending));
                    } else {
                        this.currentSortTableColumn.setImage(Icons.get(Icons.iconkeySortDescending));
                    }
                }
            } else if (this.currentSortTableColumn != null) {
                this.currentSortTableColumn.setImage(null);
            }
        }
    }

    public void addColumnSortListeners(Trace t) {
        TableColumn[] tabCols = this.table.getColumns();
        int i = 0;
        while (i < tabCols.length) {
            tabCols[i].addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Trace t2 = Trace.getDefault();
                    ExtTableColumnManager.this.columnSelected(t2, e);
                }
            });
            ++i;
        }
        if (this.extViewerSorter != null) {
            this.extViewerSorter.setSortColumnIndex(t, 0);
        }
    }

    public synchronized void resizeTableColumns(Trace t, boolean canDelay) {
        if (Trace.isTracing) {
            Date date = new Date();
            t.data(67, "ExtTableColumnManager.resizeTableColumns", 300, "resizeColumns at " + date.toString());
        }
        if (this.isResizeColumnsTimerRunning && canDelay) {
            this.isResizeColumnsWhenTimerPops = true;
            if (Trace.isTracing) {
                t.data(67, "ExtTableColumnManager.resizeTableColumns", 300, "timer running, just setting isResizeColumnsWhenTimerPops flag");
            }
        } else if (canDelay) {
            int timerDelay = UiPlugin.getResizeColumnsTimerDelay();
            this.isResizeColumnsWhenTimerPops = false;
            if (timerDelay > 0) {
                this.table.getDisplay().timerExec(timerDelay, new Runnable(){

                    @Override
                    public void run() {
                        Trace t2 = Trace.getDefault();
                        if (Trace.isTracing) {
                            t2.data(67, "ExtTableColumnManager.resizeTableColumns", 300, "resize columns timer popped");
                        }
                        if (ExtTableColumnManager.this.isResizeColumnsWhenTimerPops) {
                            if (Trace.isTracing) {
                                t2.data(67, "ExtTableColumnManager.resizeTableColumns", 300, "flag set, resizing columns");
                            }
                            ExtTableColumnManager.this.setResizingByProgram(true);
                            ExtTableColumnManager.this.resizeColumns(t2);
                            ExtTableColumnManager.this.setResizingByProgram(false);
                        }
                        ExtTableColumnManager.this.isResizeColumnsTimerRunning = false;
                        ExtTableColumnManager.this.isResizeColumnsWhenTimerPops = false;
                    }
                });
                this.isResizeColumnsTimerRunning = true;
            }
            this.setResizingByProgram(true);
            this.resizeColumns(t);
            this.setResizingByProgram(false);
        } else {
            this.setResizingByProgram(true);
            this.resizeColumns(t);
            this.setResizingByProgram(false);
        }
    }

    private void resizeColumns(Trace t) {
        boolean isTableRedrawOff = false;
        if (!this.busyResizing) {
            this.busyResizing = true;
            boolean isFullColumnResize = true;
            if (UiPlugin.isShutdownInProgress() || this.table.isDisposed()) {
                return;
            }
            int tableWidth = this.table.getClientArea().width;
            if (tableWidth > 0) {
                Object obj;
                int numCols = this.table.getColumnCount();
                int availableWidth = tableWidth - numCols * this.table.getGridLineWidth();
                boolean isConstrain = false;
                int maxWidth = 999999999;
                if (this.widthConstraint > 0.0 && availableWidth > 0) {
                    isConstrain = true;
                    maxWidth = (int)((double)availableWidth * this.widthConstraint);
                }
                this.table.setRedraw(false);
                isTableRedrawOff = true;
                ArrayList<Integer> constrainedColumns = new ArrayList<Integer>();
                TableColumn[] tabCols = this.table.getColumns();
                if (tabCols.length > 0 && !ExtTableColumnManager.isGetColumnWidths(t)) {
                    boolean hasAttributeOrderItem = false;
                    int i = 0;
                    while (i < tabCols.length) {
                        boolean packColumn = true;
                        boolean visible = false;
                        obj = tabCols[i].getData();
                        if (obj instanceof AttributeOrderItem) {
                            hasAttributeOrderItem = true;
                            AttributeOrderItem aoi = (AttributeOrderItem)obj;
                            packColumn = aoi.getWidth() == -1;
                            visible = aoi.isVisible(this.isInstanceSecondary);
                        }
                        if (hasAttributeOrderItem) {
                            if (packColumn && visible) {
                                tabCols[i].pack();
                            } else if (!visible) {
                                tabCols[i].setWidth(0);
                            }
                        } else {
                            tabCols[i].pack();
                        }
                        ++i;
                    }
                    isFullColumnResize = false;
                }
                if (isFullColumnResize) {
                    int actualWidth = 0;
                    int visibleCount = 0;
                    int i = 0;
                    while (i < tabCols.length) {
                        int tabcolWidth;
                        boolean packColumn = tabCols[i].getWidth() > 0;
                        obj = tabCols[i].getData();
                        if (obj instanceof AttributeOrderItem) {
                            int width = ((AttributeOrderItem)obj).getWidth();
                            boolean bl = packColumn = width == -1 && tabCols[i].getWidth() > 0;
                            if (!packColumn && width > 0) {
                                tabCols[i].setWidth(width);
                            }
                        }
                        if (packColumn) {
                            Image image;
                            tabCols[i].pack();
                            if (isConstrain && tabCols[i].getWidth() > maxWidth && maxWidth != 0) {
                                tabCols[i].setWidth(maxWidth);
                                constrainedColumns.add(i);
                            }
                            if ((image = tabCols[i].getImage()) != null) {
                                tabCols[i].setWidth(tabCols[i].getWidth() + image.getBounds().width);
                            }
                        }
                        if ((tabcolWidth = tabCols[i].getWidth()) > 0) {
                            ++visibleCount;
                        }
                        actualWidth += tabcolWidth;
                        ++i;
                    }
                    int spareWidth = availableWidth - actualWidth;
                    if (spareWidth > 0) {
                        if (this.excessWidthColumnIndex != -1) {
                            if (this.excessWidthColumnIndex < tabCols.length) {
                                int width = tabCols[this.excessWidthColumnIndex].getWidth();
                                tabCols[this.excessWidthColumnIndex].setWidth(width + spareWidth);
                            }
                        } else {
                            int count = constrainedColumns.size();
                            if (count > 0) {
                                int delta = spareWidth / count;
                                int i2 = 0;
                                while (i2 < count) {
                                    Integer intIndex = (Integer)constrainedColumns.get(i2);
                                    int index = intIndex;
                                    tabCols[index].setWidth(tabCols[index].getWidth() + delta);
                                    ++i2;
                                }
                            } else {
                                count = tabCols.length;
                                if (visibleCount > 0) {
                                    int delta = spareWidth / visibleCount;
                                    int i3 = 0;
                                    while (i3 < count) {
                                        if (tabCols[i3].getWidth() > 0) {
                                            tabCols[i3].setWidth(tabCols[i3].getWidth() + delta);
                                        }
                                        ++i3;
                                    }
                                }
                            }
                        }
                    }
                }
                if (isTableRedrawOff) {
                    this.table.setRedraw(true);
                    isTableRedrawOff = false;
                }
                this.table.update();
            }
            this.busyResizing = false;
        }
    }

    private void columnSelected(Trace t, Event e) {
        if (this.extViewerSorter != null) {
            this.manuallySorted = true;
            if (this.statusBar != null && !this.statusBar.isDisposed()) {
                this.statusBar.setProgressBarVisible(t, true);
            }
            TableColumn tabCol = (TableColumn)e.widget;
            TableColumn[] tabCols = this.table.getColumns();
            int index = 0;
            int i = 0;
            while (i < tabCols.length) {
                if (tabCols[i] == tabCol) {
                    index = i;
                    break;
                }
                ++i;
            }
            this.sortOnColumn(t, index);
            if (this.statusBar != null && !this.statusBar.isDisposed()) {
                this.statusBar.setProgressBarVisible(t, false);
            }
        }
    }

    public void sortOnColumn(Trace t, int index) {
        TableColumn[] tabCols = this.table.getColumns();
        if (tabCols != null && index < tabCols.length) {
            TableColumn tabCol = tabCols[index];
            if (this.currentSortTableColumn != null && this.currentSortTableColumn != tabCol) {
                this.currentSortTableColumn.setImage(null);
            }
            if (this.instanceChanged) {
                if (this.extViewerSorter != null) {
                    this.extViewerSorter.setSortColumnIndices(t, this.currentSortIndex, this.previousSortIndex);
                    this.extViewerSorter.setSortDirections(t, this.isCurrentSortAscending, this.isPreviousSortAscending);
                }
                this.instanceChanged = false;
            } else {
                if (tabCol != this.currentSortTableColumn) {
                    this.previousSortIndex = this.currentSortIndex;
                    this.isPreviousSortAscending = this.isCurrentSortAscending;
                }
                if (this.extViewerSorter != null) {
                    this.extViewerSorter.setSortColumnIndex(t, index);
                }
                this.isCurrentSortAscending = tabCol == this.currentSortTableColumn ? !this.isCurrentSortAscending : true;
                if (this.extViewerSorter != null) {
                    this.extViewerSorter.setSortDirection(t, this.isCurrentSortAscending);
                }
            }
            if (this.isCurrentSortAscending) {
                tabCol.setImage(Icons.get(Icons.iconkeySortAscending));
            } else {
                tabCol.setImage(Icons.get(Icons.iconkeySortDescending));
            }
            if (this.table.getItemCount() > 0) {
                this.tableViewer.refresh();
                this.tableViewer.getControl().redraw();
                this.tableViewer.setSorter(this.extViewerSorter);
                ExplorerTable.paintGreyCells(t, this.table, this.extTableLabelProvider);
            }
            if (tabCol != this.currentSortTableColumn) {
                this.resizeColumns(t);
            }
            this.currentSortTableColumn = tabCol;
            this.currentSortIndex = index;
        }
    }

    public void setMaximumColumnWidthPercent(Trace t, double percent) {
        this.widthConstraint = percent;
    }

    public void setExcessWidthColumnIndex(Trace t, int index) {
        this.excessWidthColumnIndex = index;
    }

    public void setInstance(Trace t, String instanceId, boolean isSecondary) {
        Integer previousDirection;
        Integer currentDirection;
        String useInstanceId = ExtTableColumnManager.makeValidInstanceId(instanceId);
        this.isInstanceSecondary = isSecondary;
        if (this.currentInstanceId != null) {
            this.currentSortDirection.put(this.currentInstanceId, this.isCurrentSortAscending ? SORT_ASCENDING : SORT_DESCENDING);
            this.currentSortColumn.put(this.currentInstanceId, this.currentSortIndex);
            this.previousSortDirection.put(this.currentInstanceId, this.isPreviousSortAscending ? SORT_ASCENDING : SORT_DESCENDING);
            this.previousSortColumn.put(this.currentInstanceId, this.previousSortIndex);
        }
        if (!this.currentSortColumn.containsKey(useInstanceId)) {
            this.currentSortColumn.put(useInstanceId, 0);
        }
        Integer intCurrentSortCol = this.currentSortColumn.get(useInstanceId);
        this.currentSortIndex = intCurrentSortCol;
        if (!this.previousSortColumn.containsKey(useInstanceId)) {
            this.previousSortColumn.put(useInstanceId, 0);
        }
        Integer intPreviousSortCol = this.previousSortColumn.get(useInstanceId);
        this.previousSortIndex = intPreviousSortCol;
        if (!this.currentSortDirection.containsKey(useInstanceId)) {
            this.currentSortDirection.put(useInstanceId, SORT_ASCENDING);
        }
        boolean bl = this.isCurrentSortAscending = (currentDirection = this.currentSortDirection.get(useInstanceId)) == SORT_ASCENDING;
        if (!this.previousSortDirection.containsKey(useInstanceId)) {
            this.previousSortDirection.put(useInstanceId, SORT_ASCENDING);
        }
        this.isPreviousSortAscending = (previousDirection = this.previousSortDirection.get(useInstanceId)) == SORT_ASCENDING;
        this.currentInstanceId = useInstanceId;
        this.instanceChanged = true;
        this.sortOnColumn(t, intCurrentSortCol);
    }

    private static String makeValidInstanceId(String instanceId) {
        String useInstanceId = instanceId;
        if (useInstanceId == null) {
            useInstanceId = "com.ibm.mq.explorer.instanceid.common";
        }
        return useInstanceId;
    }

    public boolean isResizingByProgram() {
        return this.isResizingByProgram;
    }

    public void setResizingByProgram(boolean byProgram) {
        this.isResizingByProgram = byProgram;
    }

    public void setStatusBar(Trace t, StatusBar statBar) {
        this.statusBar = statBar;
    }

    public static boolean isGetColumnWidths(Trace t) {
        if (!isTestedCanGetColWidth) {
            int testwidth;
            Shell shell = new Shell();
            Composite comp = new Composite((Composite)shell, 0);
            Table table = new Table(comp, 0);
            TableColumn tabCol = new TableColumn(table, 0);
            int width = tabCol.getWidth();
            if (width == (testwidth = 256)) {
                ++testwidth;
            }
            tabCol.setWidth(testwidth);
            if (tabCol.getWidth() != testwidth) {
                isGetColumnWidths = false;
                if (Trace.isTracing) {
                    t.data(67, "ExtTableColumnManager.isGetColumnWidths", 300, "cannot reliably get column widths");
                }
            } else {
                isGetColumnWidths = true;
                if (Trace.isTracing) {
                    t.data(67, "ExtTableColumnManager.isGetColumnWidths", 300, "can reliably get column widths");
                }
            }
            tabCol.setWidth(width);
            isTestedCanGetColWidth = true;
        }
        return isGetColumnWidths;
    }

    public boolean isManuallySorted() {
        return this.manuallySorted;
    }
}

