/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.ui.internal.controls.CompareExtWidgetItems;
import com.ibm.mq.explorer.ui.internal.objects.UiObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class ExtList
extends Composite
implements SelectionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/ExtList.java";
    private List list = null;
    private ArrayList<Object> objectList = null;
    private CompareExtWidgetItems compareItems = new CompareExtWidgetItems();
    private Vector<SelectionListener> selectionListeners = null;

    public ExtList(Composite parent, int style) {
        super(parent, 0);
        FillLayout fillLayout = new FillLayout();
        this.setLayout((Layout)fillLayout);
        this.list = new List((Composite)this, style);
        this.list.addSelectionListener((SelectionListener)this);
        this.objectList = new ArrayList();
        this.selectionListeners = new Vector();
    }

    public void add(String string) {
        this.objectList.add(string);
        this.list.add(string);
    }

    public void add(String string, int index) {
        this.objectList.add(index, string);
        this.list.add(string, index);
    }

    public void add(Object object) {
        this.objectList.add(object);
        if (object instanceof UiObject) {
            this.list.add(((UiObject)object).toFormattedString());
        } else {
            this.list.add(object.toString());
        }
    }

    public void add(Object object, int index) {
        this.objectList.add(index, object);
        if (object instanceof UiObject) {
            this.list.add(((UiObject)object).toFormattedString(), index);
        } else if (object instanceof DmObject) {
            this.list.add(((DmObject)object).toString(Trace.getDefault()), index);
        } else {
            this.list.add(object.toString(), index);
        }
    }

    public Object getObject(int index) {
        Object object = null;
        if (index >= 0 && index < this.list.getItemCount()) {
            object = this.objectList.get(index);
        }
        return object;
    }

    public int indexOfObject(Object object) {
        int index = this.objectList.indexOf(object);
        return index;
    }

    public void remove(int index) {
        if (index >= 0 && index < this.list.getItemCount()) {
            this.objectList.remove(index);
            this.list.remove(index);
        }
    }

    public void remove(int start, int end) {
        int i = start;
        while (i <= end) {
            this.remove(i);
            ++i;
        }
    }

    public void remove(Object object) {
        int index = this.indexOfObject(object);
        if (index != -1) {
            this.remove(index);
        }
    }

    public void removeAll() {
        this.objectList.clear();
        this.list.removeAll();
    }

    public void sort() {
        this.sortObjects(false);
    }

    public void sortByNumericValue() {
        this.sortObjects(true);
    }

    public void sortObjects(boolean sortByNumericValue) {
        Object selObject = this.getObject(this.getSelectionIndex());
        int count = this.objectList.size();
        Object[] objArray = new Object[count];
        objArray = this.objectList.toArray(objArray);
        this.compareItems.setSortByNumericValue(sortByNumericValue);
        Arrays.sort(objArray, this.compareItems);
        this.objectList.clear();
        int i = 0;
        while (i < count) {
            this.objectList.add(objArray[i]);
            ++i;
        }
        this.list.setRedraw(false);
        this.list.removeAll();
        i = 0;
        while (i < this.objectList.size()) {
            Object object = this.objectList.get(i);
            if (object instanceof UiObject) {
                this.list.add(((UiObject)object).toFormattedString());
            } else {
                this.list.add(object.toString());
            }
            ++i;
        }
        if (selObject != null) {
            this.select(this.indexOfObject(selObject));
        }
        this.list.setRedraw(true);
    }

    public int getSelectionIndex() {
        return this.list.getSelectionIndex();
    }

    public String getText() {
        return this.list.toString();
    }

    public void select(int index) {
        this.list.select(index);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.addElement(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.removeElement(listener);
    }

    public void widgetSelected(SelectionEvent e) {
        int size = this.selectionListeners.size();
        int i = 0;
        while (i < size) {
            SelectionListener listener = this.selectionListeners.elementAt(i);
            listener.widgetSelected(e);
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        int size = this.selectionListeners.size();
        int i = 0;
        while (i < size) {
            SelectionListener listener = this.selectionListeners.elementAt(i);
            listener.widgetDefaultSelected(e);
            ++i;
        }
    }

    public void setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
    }

    public int indexOf(String string) {
        return this.list.indexOf(string);
    }

    public int indexOf(String string, int start) {
        return this.list.indexOf(string, start);
    }

    public int indexOfIgnoreCase(String string) {
        int index = -1;
        int i = 0;
        while (i < this.list.getItemCount()) {
            String item = this.list.getItem(i);
            if (string.compareToIgnoreCase(item) == 0) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int indexOfIgnoreCase(String string, int start) {
        int index = -1;
        int i = start;
        while (i < this.list.getItemCount()) {
            String item = this.list.getItem(i);
            if (string.compareToIgnoreCase(item) == 0) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public String[] getItems() {
        return this.list.getItems();
    }

    public int getItemCount() {
        return this.list.getItemCount();
    }

    public int getItemHeight() {
        return this.list.getItemHeight();
    }

    public void showSelection() {
        this.list.showSelection();
    }

    public int getTopIndex() {
        return this.list.getTopIndex();
    }

    public void setTopIndex(int index) {
        this.list.setTopIndex(index);
    }

    public void redraw() {
        this.list.redraw();
    }

    public void update() {
        this.list.update();
    }
}

