/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class ExtDialog
extends Dialog
implements ShellListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/ExtDialog.java";
    public static final int BUTTONS_OK_CANCEL = 0;
    public static final int BUTTONS_CLOSE = 1;
    public static final int BUTTONS_CONTINUE = 2;
    private int stdButtons = 0;
    private Shell shellDlg = null;
    private Composite compositeMain = null;
    private Composite compositeButtons = null;
    private Composite compositeUserButtons = null;
    private Button buttonOK = null;
    private Button buttonCancel = null;
    private Button buttonClose = null;
    private Button buttonContinue = null;
    private GridData gridDataOK = null;
    private GridData gridDataCancel = null;
    private boolean isOK = false;
    private Message msgFile = null;
    private boolean isCentreOnParent = true;

    public ExtDialog(Shell parent, int style) {
        super(parent, style);
    }

    public ExtDialog(Shell parent, int style, int buttons) {
        super(parent, style);
        this.stdButtons = buttons;
    }

    public void create(Trace t) {
        this.create(t, true);
    }

    public void create(Trace t, boolean modal) {
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        Shell parent = this.getParent();
        int flags = 2160;
        flags = modal ? (flags |= 0x10000) : (flags |= 0x480);
        this.shellDlg = new Shell(parent, flags);
        UiPlugin.getHelpSystem().setHelp((Control)this.shellDlg, this.getHelpId(t));
        this.shellDlg.setText(this.getTitle(t));
        if (this.getImage(t) == null) {
            this.shellDlg.setImage(Icons.get(Icons.iconkeyExplorerSmall));
        } else {
            this.shellDlg.setImage(this.getImage(t));
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        this.shellDlg.setLayout((Layout)gridLayout);
        Composite comp = new Composite((Composite)this.shellDlg, 0);
        FillLayout fillLayout = new FillLayout();
        comp.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        comp.setLayoutData((Object)gridData);
        ScrolledComposite scrolledComposite = new ScrolledComposite(comp, 768);
        this.compositeMain = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.compositeMain);
        this.createContent(t, this.compositeMain);
        this.compositeButtons = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.compositeButtons.setLayoutData((Object)gridData);
        this.createHelpControl(this.compositeButtons);
        if (this.isUserButtons(t)) {
            this.compositeUserButtons = new Composite(this.compositeButtons, 0);
            gridData = new GridData();
            this.compositeUserButtons.setLayoutData((Object)gridData);
            this.createUserButtons(t, this.compositeUserButtons);
            Label label = new Label(this.compositeButtons, 0);
            label.setVisible(false);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
        } else {
            Label label = new Label(this.compositeButtons, 0);
            label.setVisible(false);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
        }
        if (this.stdButtons == 1) {
            this.buttonClose = new Button(this.compositeButtons, 8);
            this.buttonClose.setText(this.msgFile.getMessage("UI.GENERAL.CLOSE"));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            gridData.horizontalAlignment = 3;
            this.buttonClose.setLayoutData((Object)gridData);
            this.buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    ExtDialog.this.isOK = true;
                    ExtDialog.this.closePressed(tr);
                    ExtDialog.this.shellDlg.close();
                }
            });
            this.shellDlg.setDefaultButton(this.buttonClose);
            this.buttonClose.setFocus();
        } else if (this.stdButtons == 2) {
            this.buttonContinue = new Button(this.compositeButtons, 8);
            this.buttonContinue.setText(this.msgFile.getMessage("UI.GENERAL.CONTINUE"));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            gridData.horizontalAlignment = 3;
            this.buttonContinue.setLayoutData((Object)gridData);
            this.buttonContinue.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    if (ExtDialog.this.continuePressed(tr)) {
                        ExtDialog.this.isOK = true;
                        ExtDialog.this.shellDlg.close();
                    }
                }
            });
            this.shellDlg.setDefaultButton(this.buttonContinue);
            this.buttonContinue.setFocus();
        } else {
            this.buttonOK = new Button(this.compositeButtons, 8);
            this.buttonOK.setText(this.msgFile.getMessage(t, "UI.GENERAL.OK"));
            this.gridDataOK = new GridData();
            this.gridDataOK.horizontalAlignment = 3;
            this.buttonOK.setLayoutData((Object)this.gridDataOK);
            this.buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    if (ExtDialog.this.okPressed(tr)) {
                        ExtDialog.this.isOK = true;
                        ExtDialog.this.shellDlg.close();
                    }
                }
            });
            this.buttonCancel = new Button(this.compositeButtons, 8);
            this.buttonCancel.setText(this.msgFile.getMessage(t, "UI.GENERAL.CANCEL"));
            this.gridDataCancel = new GridData();
            this.gridDataCancel.horizontalAlignment = 3;
            this.buttonCancel.setLayoutData((Object)this.gridDataCancel);
            this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    ExtDialog.this.isOK = false;
                    ExtDialog.this.cancelPressed(tr);
                    ExtDialog.this.shellDlg.close();
                }
            });
            int maxWidth = 0;
            Point sizeOK = this.buttonOK.computeSize(-1, -1);
            Point sizeCancel = this.buttonCancel.computeSize(-1, -1);
            if (sizeOK.x > maxWidth) {
                maxWidth = sizeOK.x;
            }
            if (sizeCancel.x > maxWidth) {
                maxWidth = sizeCancel.x;
            }
            this.gridDataOK.widthHint = maxWidth;
            this.gridDataCancel.widthHint = maxWidth;
            this.shellDlg.setDefaultButton(this.buttonOK);
        }
        if (this.isPackDialog(t)) {
            this.packDialog(t);
        } else {
            this.shellDlg.pack();
        }
        Point size = this.getPreferredSize(t);
        if (size.x == 0 || size.y == 0) {
            size = this.compositeMain.computeSize(-1, -1);
        }
        scrolledComposite.setMinSize(size);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.shellDlg.pack(true);
        if (this.isCentreOnParent) {
            UiUtils.makeShellCenteredOnParent(t, parent, this.shellDlg);
        }
        this.getShell().addShellListener((ShellListener)this);
    }

    protected Control createHelpControl(Composite parent) {
        Image helpImage = JFaceResources.getImage((String)"dialog_help_image");
        if (helpImage != null) {
            return this.createHelpImageButton(parent, helpImage);
        }
        return this.createHelpLink(parent);
    }

    private ToolBar createHelpImageButton(Composite parent, Image image) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            ++((GridLayout)layout).numColumns;
        }
        toolBar.setLayoutData((Object)new GridData(64));
        final Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        ToolItem item = new ToolItem(toolBar, 0);
        item.setImage(image);
        item.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtDialog.this.helpPressed();
            }
        });
        return toolBar;
    }

    private Link createHelpLink(Composite parent) {
        Link link = new Link(parent, 524352);
        ++((GridLayout)parent.getLayout()).numColumns;
        link.setLayoutData((Object)new GridData(64));
        link.setText("<a>" + IDialogConstants.HELP_LABEL + "</a>");
        link.setToolTipText(IDialogConstants.HELP_LABEL);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtDialog.this.helpPressed();
            }
        });
        return link;
    }

    private void helpPressed() {
        if (this.getShell() != null) {
            Control c = this.getShell().getDisplay().getFocusControl();
            while (c != null) {
                if (c.isListening(28)) {
                    c.notifyListeners(28, new Event());
                    break;
                }
                c = c.getParent();
            }
        }
    }

    public boolean open(Trace t) {
        boolean result = false;
        if (this.buttonOK != null) {
            this.buttonOK.setEnabled(this.isEnableOK(t));
        }
        if (this.buttonClose != null) {
            this.buttonClose.setEnabled(this.isEnableClose(t));
        } else if (this.buttonContinue != null) {
            this.buttonContinue.setEnabled(this.isEnableContinue(t));
        }
        this.shellDlg.open();
        Display display = this.getParent().getDisplay();
        while (!this.shellDlg.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        result = this.isOK;
        return result;
    }

    public abstract boolean isEnableOK(Trace var1);

    public void enableOK(Trace t, boolean enable) {
        if (this.buttonOK != null) {
            this.buttonOK.setEnabled(enable);
        }
    }

    public boolean isEnableClose(Trace t) {
        return true;
    }

    public void enableClose(Trace t, boolean enable) {
        if (this.buttonClose != null) {
            this.buttonClose.setEnabled(enable);
        }
    }

    public void showClose(Trace t, boolean visible) {
        if (this.buttonClose != null) {
            this.buttonClose.setVisible(visible);
        }
    }

    public boolean isEnableContinue(Trace t) {
        return true;
    }

    public void enableContinue(Trace t, boolean enable) {
        if (this.buttonContinue != null) {
            this.buttonContinue.setEnabled(enable);
        }
    }

    public void showContinue(Trace t, boolean visible) {
        if (this.buttonContinue != null) {
            this.buttonContinue.setVisible(visible);
        }
    }

    public Shell getShell() {
        return this.shellDlg;
    }

    public void updateTitle(Trace t, String title) {
        if (this.shellDlg != null) {
            this.shellDlg.setText(title);
        }
    }

    public abstract String getTitle(Trace var1);

    public abstract Image getImage(Trace var1);

    public abstract String getHelpId(Trace var1);

    public abstract boolean isPackDialog(Trace var1);

    public abstract void packDialog(Trace var1);

    public abstract void createContent(Trace var1, Composite var2);

    public abstract boolean isUserButtons(Trace var1);

    public abstract void createUserButtons(Trace var1, Composite var2);

    public abstract boolean okPressed(Trace var1);

    public abstract void cancelPressed(Trace var1);

    public abstract Point getPreferredSize(Trace var1);

    protected void closePressed(Trace t) {
    }

    protected boolean continuePressed(Trace t) {
        return true;
    }

    public void setCentreOnParent(boolean centre) {
        this.isCentreOnParent = centre;
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellClosed(ShellEvent e) {
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }
}

