/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.ui.internal.controls.CompareExtWidgetItems;
import com.ibm.mq.explorer.ui.internal.objects.UiObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ExtCCombo
extends Composite
implements SelectionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/ExtCCombo.java";
    private CCombo combo = null;
    private ArrayList<Object> objectList = null;
    private CompareExtWidgetItems compareItems = new CompareExtWidgetItems();
    private Vector<SelectionListener> selectionListeners = null;

    public ExtCCombo(Composite parent, int style) {
        super(parent, 0);
        FillLayout fillLayout = new FillLayout();
        this.setLayout((Layout)fillLayout);
        this.combo = new CCombo((Composite)this, style);
        this.combo.addSelectionListener((SelectionListener)this);
        this.objectList = new ArrayList();
        this.selectionListeners = new Vector();
    }

    public CCombo getCombo() {
        return this.combo;
    }

    public void add(String string) {
        this.objectList.add(string);
        this.combo.add(string);
    }

    public void add(String string, int index) {
        this.objectList.add(index, string);
        this.combo.add(string, index);
    }

    public void add(Object object) {
        this.objectList.add(object);
        if (object instanceof UiObject) {
            this.combo.add(((UiObject)object).toFormattedString());
        }
        if (object instanceof DmObject) {
            this.combo.add(((DmObject)object).toString(Trace.getDefault()));
        } else {
            this.combo.add(object.toString());
        }
    }

    public void add(Object object, int index) {
        this.objectList.add(index, object);
        if (object instanceof UiObject) {
            this.combo.add(((UiObject)object).toFormattedString(), index);
        } else {
            this.combo.add(object.toString(), index);
        }
    }

    public Object getObject(int index) {
        Object object = null;
        if (index >= 0 && index < this.combo.getItemCount()) {
            object = this.objectList.get(index);
        }
        return object;
    }

    public int indexOfObject(Object object) {
        int index = this.objectList.indexOf(object);
        return index;
    }

    public void remove(int index) {
        if (index >= 0 && index < this.combo.getItemCount()) {
            this.objectList.remove(index);
            this.combo.remove(index);
        }
    }

    public void remove(int start, int end) {
        int i = start;
        while (i <= end) {
            this.remove(i);
            ++i;
        }
    }

    public void remove(Object object) {
        int index = this.indexOfObject(object);
        if (index != -1) {
            this.remove(index);
        }
    }

    public void removeAll() {
        this.objectList.clear();
        this.combo.removeAll();
    }

    public void sort() {
        this.sortObjects(false);
    }

    public void sortByNumericValue() {
        this.sortObjects(true);
    }

    public void sortObjects(boolean sortByNumericValue) {
        Object selObject = this.getObject(this.getSelectionIndex());
        int count = this.objectList.size();
        Object[] objArray = new Object[count];
        objArray = this.objectList.toArray(objArray);
        this.compareItems.setSortByNumericValue(sortByNumericValue);
        Arrays.sort(objArray, this.compareItems);
        this.objectList.clear();
        int i = 0;
        while (i < count) {
            this.objectList.add(objArray[i]);
            ++i;
        }
        this.combo.setRedraw(false);
        this.combo.removeAll();
        i = 0;
        while (i < this.objectList.size()) {
            Object object = this.objectList.get(i);
            if (object instanceof UiObject) {
                this.combo.add(((UiObject)object).toFormattedString());
            } else {
                this.combo.add(object.toString());
            }
            ++i;
        }
        if (selObject != null) {
            this.select(this.indexOfObject(selObject));
        }
        this.combo.setRedraw(true);
    }

    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    public String getText() {
        return this.combo.getText();
    }

    public void select(int index) {
        this.combo.select(index);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.addElement(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.removeElement(listener);
    }

    public void widgetSelected(SelectionEvent e) {
        int size = this.selectionListeners.size();
        int i = 0;
        while (i < size) {
            SelectionListener listener = this.selectionListeners.elementAt(i);
            listener.widgetSelected(e);
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        int size = this.selectionListeners.size();
        int i = 0;
        while (i < size) {
            SelectionListener listener = this.selectionListeners.elementAt(i);
            listener.widgetDefaultSelected(e);
            ++i;
        }
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
    }

    public int indexOf(String string) {
        return this.combo.indexOf(string);
    }

    public int indexOf(String string, int start) {
        return this.combo.indexOf(string, start);
    }

    public int indexOfIgnoreCase(String string) {
        int index = -1;
        int i = 0;
        while (i < this.combo.getItemCount()) {
            String item = this.combo.getItem(i);
            if (string.compareToIgnoreCase(item) == 0) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int indexOfIgnoreCase(String string, int start) {
        int index = -1;
        int i = start;
        while (i < this.combo.getItemCount()) {
            String item = this.combo.getItem(i);
            if (string.compareToIgnoreCase(item) == 0) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public String[] getItems() {
        return this.combo.getItems();
    }

    public int getItemCount() {
        return this.combo.getItemCount();
    }

    public int getItemHeight() {
        return this.combo.getItemHeight();
    }

    public void redraw() {
        this.combo.redraw();
    }

    public void update() {
        this.combo.update();
    }
}

