/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class CustomSpinner
extends Composite {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/CustomSpinner.java";
    private static final int BUTTON_WIDTH = 18;
    private static final int DEFAULT_MIN_VALUE = 0;
    private static final int DEFAULT_MAX_VALUE = 9;
    private Text text = null;
    private Button up = null;
    private Button down = null;
    private long minimum = 0L;
    private long maximum = 9L;
    private long oldValue = -1L;

    public CustomSpinner(Composite parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.text = new Text((Composite)this, style | 4 | 0x800);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 2;
        this.text.setLayoutData((Object)gridData);
        this.up = new Button((Composite)this, style | 4 | 0x80);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 3;
        gridData.horizontalSpan = 1;
        gridData.widthHint = 18;
        this.up.setLayoutData((Object)gridData);
        this.down = new Button((Composite)this, style | 4 | 0x400);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 1;
        gridData.horizontalSpan = 1;
        gridData.widthHint = 18;
        this.down.setLayoutData((Object)gridData);
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Trace tr = Trace.getDefault();
                if (!StringValidation.verifyNumeric(tr, e)) {
                    e.doit = false;
                }
            }
        });
        this.text.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                Trace tr = Trace.getDefault();
                CustomSpinner.this.traverse(tr, e);
            }
        });
        this.text.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                Trace tr = Trace.getDefault();
                CustomSpinner.this.setLongSelection(tr, CustomSpinner.this.makeSelectionInRange(tr, true));
            }
        });
        this.up.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Trace tr = Trace.getDefault();
                CustomSpinner.this.up(tr);
            }
        });
        this.down.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Trace tr = Trace.getDefault();
                CustomSpinner.this.down(tr);
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                CustomSpinner.this.focusIn();
            }
        });
        this.text.setFont(this.getFont());
        this.minimum = 0L;
        this.maximum = 9L;
        this.setLongSelection(t, this.minimum);
    }

    private long makeSelectionInRange(Trace t, boolean notify) {
        long value = this.minimum;
        String textValue = this.text.getText();
        if (textValue.length() > 0) {
            try {
                value = Long.parseLong(textValue);
            }
            catch (NumberFormatException numberFormatException) {
                value = this.maximum;
            }
            if (value < this.minimum) {
                value = this.minimum;
                this.setLongSelection(t, this.minimum);
            }
            if (value > this.maximum) {
                value = this.maximum;
                this.setLongSelection(t, this.maximum);
            }
            if (value != this.oldValue) {
                if (notify) {
                    this.notifyListeners(13, new Event());
                }
                this.oldValue = value;
            }
        } else {
            this.setLongSelection(t, this.minimum);
        }
        return value;
    }

    private void traverse(Trace t, Event e) {
        switch (e.detail) {
            case 32: {
                if (e.keyCode != 0x1000001) break;
                e.doit = true;
                e.detail = 0;
                this.up(t);
                break;
            }
            case 64: {
                if (e.keyCode != 0x1000002) break;
                e.doit = true;
                e.detail = 0;
                this.down(t);
                break;
            }
        }
    }

    private void up(Trace t) {
        String textValue = this.text.getText();
        if (textValue.length() > 0) {
            long value;
            try {
                value = Long.parseLong(textValue);
            }
            catch (NumberFormatException numberFormatException) {
                value = this.maximum;
                this.setLongSelection(t, value);
            }
            if (value < this.minimum) {
                value = this.minimum;
                this.setLongSelection(t, this.minimum);
            } else if (value > this.maximum) {
                value = this.maximum;
                this.setLongSelection(t, this.maximum);
            } else if (value < this.maximum) {
                this.setLongSelection(t, this.getLongSelection() + 1L);
            }
        } else {
            this.setLongSelection(t, this.minimum);
        }
    }

    private void down(Trace t) {
        String textValue = this.text.getText();
        if (textValue.length() > 0) {
            long value;
            try {
                value = Long.parseLong(textValue);
            }
            catch (NumberFormatException numberFormatException) {
                value = this.maximum;
            }
            if (value < this.minimum) {
                value = this.minimum;
                this.setLongSelection(t, this.minimum);
            } else if (value > this.maximum) {
                value = this.maximum;
                this.setLongSelection(t, this.maximum);
            } else if (value > this.minimum) {
                this.setLongSelection(t, this.getLongSelection() - 1L);
            }
        } else {
            this.setLongSelection(t, this.minimum);
        }
    }

    private void focusIn() {
        this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
    }

    public void setLongSelection(Trace t, long selection) {
        long value = selection;
        if (selection < this.minimum) {
            value = this.minimum;
        } else if (selection > this.maximum) {
            value = this.maximum;
        }
        this.text.setText(String.valueOf(value));
    }

    public long getLongSelection() {
        long value = this.maximum;
        String textValue = this.text.getText();
        if (textValue.length() > 0) {
            try {
                value = Long.parseLong(textValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return value;
    }

    public void setLongMaximum(long max) {
        this.maximum = max;
        String val = null;
        try {
            val = Long.toString(max);
        }
        catch (NumberFormatException numberFormatException) {
            val = "9";
        }
        int l = val.length();
        this.text.setTextLimit(l);
    }

    public long getLongMaximum() {
        return this.maximum;
    }

    public void setLongMinimum(long min) {
        this.minimum = min;
    }

    public long getLongMinimum() {
        return this.minimum;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC gc = new GC((Drawable)this.text);
        Point textExtent = gc.textExtent(String.valueOf(this.maximum));
        gc.dispose();
        Point ptText = this.text.computeSize(textExtent.x, textExtent.y);
        Point ptButton = this.up.computeSize(-1, -1);
        int width = ptText.x + ptButton.x + this.text.getBorderWidth();
        int height = ptButton.y * 2;
        if (ptText.y > height) {
            height = ptText.y;
        }
        if (wHint != -1 && wHint > width) {
            width = wHint;
        }
        if (hHint != -1 && hHint > height) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            throw new SWTError(4);
        }
        this.addListener(13, (Listener)new TypedListener((SWTEventListener)listener));
    }

    public void addModifyListener(ModifyListener listener) {
        if (listener == null) {
            throw new SWTError(4);
        }
        this.text.addModifyListener(listener);
    }

    public void setEnabled(boolean isEnabled) {
        Trace t = Trace.getDefault();
        if (isEnabled) {
            UiUtils.makeTextControlReadWrite(t, this.text);
        } else {
            UiUtils.makeTextControlReadOnly(t, this.text, false);
            this.text.setEnabled(false);
        }
        this.up.setEnabled(isEnabled);
        this.down.setEnabled(isEnabled);
    }

    public void setSelection(Trace t, int selection) {
        this.setLongSelection(t, selection);
    }

    public int getSelection() {
        return (int)this.getLongSelection();
    }

    public void setMaximum(int max) {
        this.setLongMaximum(max);
    }

    public int getMaximum() {
        return (int)this.getLongMaximum();
    }

    public void setMinimum(int min) {
        this.setLongMinimum(min);
    }

    public int getMinimum() {
        return (int)this.getLongMinimum();
    }
}

