/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.controls;

import com.ibm.mq.commonservices.internal.trace.Trace;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CheckAndGreyTreeViewer
extends CheckboxTreeViewer
implements ICheckStateListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/controls/CheckAndGreyTreeViewer.java";

    public CheckAndGreyTreeViewer(Composite parent) {
        super(parent);
        this.addCheckStateListener(this);
    }

    public CheckAndGreyTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.addCheckStateListener(this);
    }

    public CheckAndGreyTreeViewer(Tree tree) {
        super(tree);
        this.addCheckStateListener(this);
    }

    public boolean setChecked(Object element, boolean state) {
        boolean ret = super.setChecked(element, state);
        this.updateTree(Trace.getDefault(), element, state);
        return ret;
    }

    public boolean setSubtreeChecked(Object element, boolean state) {
        boolean ret = super.setSubtreeChecked(element, state);
        this.updateTree(Trace.getDefault(), element, state);
        return ret;
    }

    protected void updateTree(Trace t, Object element, boolean state) {
        TreeItem[] items = this.getTree().getItems();
        TreeItem treeItem = this.findItem(t, items, element);
        this.checkTree(t, treeItem, state);
        CheckAndGreyTreeViewer.recurseTree(t, items, element, state);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Trace t = Trace.getDefault();
        Object element = event.getElement();
        boolean state = event.getChecked();
        this.updateTree(t, element, state);
    }

    private TreeItem findItem(Trace t, TreeItem[] items, Object find) {
        TreeItem ti = null;
        int k = 0;
        while (k < items.length) {
            TreeItem ti3;
            TreeItem ti2 = items[k];
            Object data = ti2.getData();
            if (data != null && data.equals(find)) {
                ti = ti2;
                break;
            }
            if (ti2.getItemCount() != 0 && (ti3 = this.findItem(t, ti2.getItems(), find)) != null) {
                ti = ti3;
            }
            ++k;
        }
        return ti;
    }

    private void checkTree(Trace t, TreeItem ti, boolean state) {
        if (ti != null && ti.getItemCount() != 0) {
            TreeItem[] items = ti.getItems();
            int k = 0;
            while (k < items.length) {
                TreeItem ti2 = items[k];
                ti2.setChecked(state);
                ti2.setGrayed(false);
                this.checkTree(t, ti2, state);
                ++k;
            }
        }
    }

    public static int recurseTree(Trace t, TreeItem[] items, Object findThis, boolean checkedState) {
        int k = 0;
        while (k < items.length) {
            TreeItem ti = items[k];
            Object data = ti.getData();
            if (data != null && data.equals(findThis)) {
                ti.setChecked(checkedState);
                ti.setGrayed(false);
                return 1;
            }
            if (ti.getItemCount() != 0 && CheckAndGreyTreeViewer.recurseTree(t, ti.getItems(), findThis, checkedState) == 1) {
                int checkCount = 0;
                boolean allChecked = true;
                boolean anyGrey = false;
                int l = 0;
                while (l < ti.getItems().length) {
                    if (ti.getItems()[l].getChecked()) {
                        ++checkCount;
                    } else {
                        allChecked = false;
                    }
                    if (ti.getItems()[l].getGrayed()) {
                        anyGrey = true;
                    }
                    ++l;
                }
                if (checkCount == 0 && !allChecked) {
                    ti.setGrayed(false);
                    ti.setChecked(false);
                } else if (checkCount > 0 && !allChecked) {
                    ti.setGrayed(true);
                    ti.setChecked(true);
                } else if (checkCount > 0 && allChecked) {
                    ti.setGrayed(false);
                    ti.setChecked(true);
                }
                if (anyGrey) {
                    ti.setGrayed(true);
                }
                return 1;
            }
            ++k;
        }
        return 0;
    }

    public void checkAllElements(Trace t, boolean checked) {
        Object input = this.getInput();
        if (input != null && input instanceof Object[]) {
            Object[] treeObjects;
            Object[] objectArray = treeObjects = (Object[])input;
            int n = treeObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.setChecked(object, checked);
                ++n2;
            }
        }
    }

    public boolean hasSelectedElements() {
        TreeItem[] treeItemArray = this.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getChecked() || item.getGrayed()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

