/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public abstract class TextOnlyContentPage
extends ContentPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/content/TextOnlyContentPage.java";
    private Composite composite = null;
    private Composite bannerComp = null;
    private static final int DESCRIPTION_WIDTH_HINT = 500;
    private Image bannerImage;

    public TextOnlyContentPage(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public void init() {
        Label label;
        Text text;
        ContentTitleBar contentTitleBar;
        GridData gridData;
        Trace t = Trace.getDefault();
        FillLayout fillLayout = new FillLayout();
        this.setLayout((Layout)fillLayout);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this, 768);
        this.composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.composite);
        int COL_SPAN = 3;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = COL_SPAN;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.composite.setLayout((Layout)gridLayout);
        if (this.isCreateBanner()) {
            this.bannerComp = new Composite(this.composite, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            gridLayout.verticalSpacing = 0;
            gridLayout.marginBottom = 0;
            this.bannerComp.setLayoutData((Object)gridData);
            this.createBanner(this.bannerComp);
        }
        Composite compMain = new Composite(this.composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = COL_SPAN;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginTop = 3;
        gridLayout.marginLeft = 3;
        gridLayout.marginBottom = 3;
        gridLayout.marginRight = 3;
        compMain.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.horizontalSpan = COL_SPAN;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        compMain.setLayoutData((Object)gridData);
        if (this.getPageTitle() != null) {
            String additionalButtonText;
            contentTitleBar = new ContentTitleBar(compMain, 0);
            contentTitleBar.setText(this.getPageTitle());
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            contentTitleBar.setLayoutData(gridData);
            if (this.getPageDescription() != null) {
                text = new Text(compMain, 66);
                text.setText(this.getPageDescription());
                gridData = new GridData(4, 1, true, false);
                gridData.horizontalSpan = COL_SPAN;
                gridData.widthHint = 500;
                gridLayout.marginRight = 30;
                text.setLayoutData((Object)gridData);
                UiUtils.makeTextControlReadOnly(t, text, true);
            }
            HyperlinkGroup linkGroup = new HyperlinkGroup(Display.getCurrent());
            if (this.getPageButtonText() != null) {
                Hyperlink helplink = new Hyperlink(compMain, 0);
                helplink.setText(this.getPageButtonText());
                gridData = new GridData();
                gridData.horizontalSpan = COL_SPAN;
                helplink.setLayoutData((Object)gridData);
                helplink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        UiPlugin.showBusyCursor(Trace.getDefault(), TextOnlyContentPage.this.getShell(), true);
                        UiPlugin.getHelpSystem().displayHelpResource(TextOnlyContentPage.this.getPageButtonHelpTopic());
                        UiPlugin.showBusyCursor(Trace.getDefault(), TextOnlyContentPage.this.getShell(), false);
                    }
                });
                linkGroup.add(helplink);
            }
            if (this.getIconsTitle() != null) {
                Hyperlink iconHelplink = new Hyperlink(compMain, 0);
                iconHelplink.setText(this.getIconsButtonText());
                gridData = new GridData();
                gridData.horizontalSpan = COL_SPAN;
                iconHelplink.setLayoutData((Object)gridData);
                iconHelplink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        UiPlugin.showBusyCursor(Trace.getDefault(), TextOnlyContentPage.this.getShell(), true);
                        UiPlugin.getHelpSystem().displayHelpResource(TextOnlyContentPage.this.getIconsButtonHelpTopic());
                        UiPlugin.showBusyCursor(Trace.getDefault(), TextOnlyContentPage.this.getShell(), false);
                    }
                });
                linkGroup.add(iconHelplink);
            }
            if ((additionalButtonText = this.getAdditionalButtonText()) != null) {
                Hyperlink extralink = new Hyperlink(compMain, 0);
                extralink.setText(additionalButtonText);
                gridData = new GridData();
                gridData.horizontalSpan = COL_SPAN;
                extralink.setLayoutData((Object)gridData);
                extralink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        TextOnlyContentPage.this.additionalButtonPressed();
                    }
                });
                linkGroup.add(extralink);
            }
            label = new Label(compMain, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            label.setLayoutData((Object)gridData);
        }
        if (this.getIconsTitle() != null) {
            contentTitleBar = new ContentTitleBar(compMain, 0);
            contentTitleBar.setText(this.getIconsTitle());
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            contentTitleBar.setLayoutData(gridData);
            if (this.getIconsDescription() != null) {
                text = new Text(compMain, 2);
                text.setText(this.getIconsDescription());
                gridData = new GridData(768);
                gridData.grabExcessHorizontalSpace = true;
                gridData.horizontalSpan = COL_SPAN;
                text.setLayoutData((Object)gridData);
                UiUtils.makeTextControlReadOnly(t, text, true);
                Composite iconComp = new Composite(compMain, 0);
                gridData = new GridData(768);
                gridData.horizontalSpan = 5;
                iconComp.setLayoutData((Object)gridData);
                GridLayout gl = new GridLayout(2, false);
                gl.numColumns = 2;
                iconComp.setLayout((Layout)gl);
                Image[] icons = this.getIcons();
                String[] iconsText = this.getIconsText();
                int k = 0;
                while (k < icons.length) {
                    label = new Label(iconComp, 0);
                    label.setImage(icons[k]);
                    Label label2 = new Label(iconComp, 0);
                    label2.setText(iconsText[k]);
                    ++k;
                }
            }
        }
        if (this.getBottomTitle() != null) {
            Label fill = new Label(compMain, 0);
            gridData = new GridData(1808);
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalSpan = COL_SPAN;
            fill.setLayoutData((Object)gridData);
            label = new Label(compMain, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            label.setLayoutData((Object)gridData);
            ContentTitleBar contentTitleBar2 = new ContentTitleBar(compMain, 0);
            contentTitleBar2.setText(this.getBottomTitle());
            gridData = new GridData(768);
            gridData.horizontalSpan = COL_SPAN;
            contentTitleBar2.setLayoutData(gridData);
            Text text2 = new Text(compMain, 66);
            text2.setText(this.getBottomText());
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = COL_SPAN;
            gridData.widthHint = 400;
            text2.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly(t, text2, true);
        }
        ButtonTools.makeEqualWidthGridData(t, compMain);
        if (this.bannerComp != null) {
            this.bannerComp.layout();
        }
        compMain.layout();
        this.composite.layout();
        scrolledComposite.setMinSize(this.composite.computeSize(-1, -1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        UiUtils.addScrollListeners(scrolledComposite);
    }

    @Override
    public abstract String getId();

    @Override
    public void setObject(MQExtObject object) {
    }

    @Override
    public void updatePage() {
    }

    @Override
    public void refresh() {
    }

    @Override
    public void repaint() {
    }

    @Override
    public boolean isEnableRefreshAction() {
        return false;
    }

    @Override
    public void instanceDeleted(Object object) {
    }

    public abstract boolean isCreateBanner();

    public void createBanner(Composite comp) {
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        comp.setLayout((Layout)gl);
        final Label banner = new Label(comp, 0);
        GridData gd = new GridData(4, 1, true, false);
        Image bannerSrcImg = Icons.get(Icons.iconkeyBanner);
        gd.heightHint = bannerSrcImg.getBounds().height;
        banner.setLayoutData((Object)gd);
        banner.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Trace t = Trace.getDefault();
                Display display = banner.getDisplay();
                Rectangle rect = banner.getBounds();
                Image bannerSrcImg = Icons.get(Icons.iconkeyBanner);
                Rectangle bannerRect = bannerSrcImg.getBounds();
                rect.height = bannerRect.height;
                Image newImage = new Image((Device)display, Math.max(1, rect.width), rect.height);
                GC gc = new GC((Drawable)newImage);
                gc.setForeground(display.getSystemColor(1));
                if (rect.width > bannerRect.width) {
                    Image tile = Icons.get(Icons.iconkeyBannerTile);
                    int width = rect.width - bannerRect.width;
                    gc.drawImage(tile, 0, 0, 1, rect.height, 0, 0, width, rect.height);
                }
                gc.drawImage(bannerSrcImg, rect.width - bannerRect.width, 0);
                Font brandingFont = new Font((Device)display, "Helvetica", 12, 1);
                gc.setFont(brandingFont);
                gc.drawText(UiPlugin.getUIMessages(t, "KEY_Machine").getMessage(t, "UI.GENERAL.MQ"), 10, 9, true);
                gc.dispose();
                brandingFont.dispose();
                banner.setImage(newImage);
                if (TextOnlyContentPage.this.bannerImage != null) {
                    TextOnlyContentPage.this.bannerImage.dispose();
                }
                TextOnlyContentPage.this.bannerImage = newImage;
            }
        });
    }

    public abstract String getPageTitle();

    public abstract String getPageDescription();

    public abstract String getPageButtonText();

    public abstract String getPageButtonHelpTopic();

    public abstract String getIconsTitle();

    public abstract String getIconsDescription();

    public abstract String[] getIconsText();

    public abstract Image[] getIcons();

    public abstract String getIconsButtonText();

    public abstract String getIconsButtonHelpTopic();

    public abstract String getBottomTitle();

    public abstract String getBottomText();

    public String getAdditionalButtonText() {
        return null;
    }

    public void additionalButtonPressed() {
    }
}

