/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterManager;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTable;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class MQContentPage
extends ContentPage
implements ExplorerTableSelectionChangedListener,
ExplorerTableContentChangedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/content/MQContentPage.java";
    private static final int NUM_COLS = 12;
    private MQExtObject object = null;
    private ContentTitleBar contentTitleBar = null;
    private ExplorerTable explorerTable = null;
    private ObjectTable objectTable = null;
    private Label labelObjectTable = null;
    private Message msgFile = null;
    private boolean isListenToDataModelForObjects = false;
    private boolean isListenToDataModelForQueueManagerChanges = false;
    private IDmObservable listenDmObject = null;
    private ArrayList toolbarActions = null;
    private ArrayList menuActions = null;
    protected FilterProvider filterProvider = null;
    private boolean showSystemObjectsChanged = false;
    private UiMQObject objtableUiMQObject = null;
    private Composite compositeMain = null;
    private ScrolledComposite mainScrolledComposite = null;
    private Composite compositeSelection = null;
    private ScrolledComposite selectionScrolledComposite = null;
    private static final int[] weights = new int[]{66, 34};
    private boolean isExplorerTableColummResizeSuppressed = false;

    public MQContentPage(Composite parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        String fileKey = this.getNLSResourceFileKey();
        this.msgFile = UiPlugin.getUIMessages(t, fileKey);
    }

    @Override
    public void init() {
        Point size;
        Trace t = Trace.getDefault();
        boolean isSelectionComposite = false;
        if (this.getSelectionCategoryIds(t) != null || this.showSelectionObjectTable(t)) {
            isSelectionComposite = true;
        }
        if (isSelectionComposite) {
            FillLayout fillLayout = new FillLayout();
            this.setLayout((Layout)fillLayout);
            SashForm sashForm = new SashForm((Composite)this, 512);
            Composite compMain = new Composite((Composite)sashForm, 2048);
            fillLayout = new FillLayout();
            compMain.setLayout((Layout)fillLayout);
            this.mainScrolledComposite = new ScrolledComposite(compMain, 512);
            this.compositeMain = new Composite((Composite)this.mainScrolledComposite, 0);
            this.mainScrolledComposite.setContent((Control)this.compositeMain);
            Composite compSel = new Composite((Composite)sashForm, 2048);
            fillLayout = new FillLayout();
            compSel.setLayout((Layout)fillLayout);
            this.selectionScrolledComposite = new ScrolledComposite(compSel, 512);
            this.compositeSelection = new Composite((Composite)this.selectionScrolledComposite, 0);
            this.selectionScrolledComposite.setContent((Control)this.compositeSelection);
            sashForm.setWeights(weights);
        } else {
            this.compositeMain = this;
        }
        this.createMainContent(t, this.compositeMain);
        if (isSelectionComposite) {
            this.createSelectionContent(t, this.compositeSelection);
        }
        this.explorerTable.addSelChangedListener(t, this);
        this.explorerTable.addContentChangedListener(t, this);
        if (this.mainScrolledComposite != null) {
            this.explorerTable.setSuppressColumnResizing(true);
            this.isExplorerTableColummResizeSuppressed = true;
            this.compositeMain.layout();
            size = this.compositeMain.computeSize(-1, -1);
            this.mainScrolledComposite.setMinHeight(size.y + this.explorerTable.calculateHeight(t, 4, false));
            this.mainScrolledComposite.setExpandHorizontal(true);
            this.mainScrolledComposite.setExpandVertical(true);
        }
        if (this.selectionScrolledComposite != null) {
            this.compositeSelection.layout();
            size = this.compositeSelection.computeSize(-1, -1);
            this.selectionScrolledComposite.setMinHeight(size.y);
            this.selectionScrolledComposite.setExpandHorizontal(true);
            this.selectionScrolledComposite.setExpandVertical(true);
        }
    }

    private void createMainContent(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 12;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        this.contentTitleBar = new ContentTitleBar(composite, 0);
        this.contentTitleBar.setText(this.getPageTitle(t, this.object));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 12;
        this.contentTitleBar.setLayoutData(gridData);
        String filterId = this.getFilterId();
        this.explorerTable = new ExplorerTable(t, composite, 0, this.getGenericObjectName(t), filterId != null, true, true, true, this.getPageId());
        this.explorerTable.setViewPart(t, this.getViewPart());
        this.explorerTable.setFilterId(t, filterId);
        this.explorerTable.setObjectId(t, this.getObjectId());
        this.explorerTable.setAttributeOrderId(t, this.getAttributeOrderId());
        this.explorerTable.setFilterProvider(t, this.getFilterProvider(t));
        this.explorerTable.setClientFiltering(t, this.isClientFiltering());
        this.toolbarActions = this.getToolbarActions(t);
        this.menuActions = this.getMenuActions(t);
        ArrayList viewerFilters = this.getViewerFilters(t);
        if (viewerFilters != null) {
            int i = 0;
            while (i < viewerFilters.size()) {
                this.explorerTable.addViewerFilter(t, (ViewerFilter)viewerFilters.get(i));
                ++i;
            }
        }
        gridData = new GridData(1808);
        gridData.horizontalSpan = 12;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.explorerTable.setLayoutData(gridData);
    }

    private void createSelectionContent(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 12;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        String[] selCatIds = this.getSelectionCategoryIds(t);
        Composite[] selComps = null;
        TabItem[] tabItems = null;
        if (selCatIds != null) {
            tabItems = new TabItem[selCatIds.length];
            selComps = new Composite[selCatIds.length];
            TabFolder tabFolder = new TabFolder(composite, 128);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 12;
            tabFolder.setLayoutData((Object)gridData);
            int i = 0;
            while (i < selCatIds.length) {
                tabItems[i] = new TabItem(tabFolder, 0, i);
                selComps[i] = new Composite((Composite)tabFolder, 0);
                tabItems[i].setControl((Control)selComps[i]);
                tabItems[i].setText("  " + this.getSelectionCategoryName(t, selCatIds[i]) + "  ");
                this.createSelectionCategoryContent(t, selCatIds[i], selComps[i]);
                ++i;
            }
        }
        Composite compObjTable = composite;
        if (selComps != null) {
            compObjTable = selComps[0];
        }
        if (this.showSelectionObjectTable(t)) {
            this.createSelectionObjectTable(t, compObjTable);
        }
    }

    private void createSelectionObjectTable(Trace t, Composite composite) {
        this.labelObjectTable = new Label(composite, 16384);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 12;
        this.labelObjectTable.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.objectTable = new ObjectTable(t, composite, 0, false, false, false);
        String attrOrderId = this.getAttributeOrderIdForSelectionObjectTable(t);
        this.objectTable.setAttributeOrderId(t, attrOrderId);
        this.objectTable.setObjectId(t, this.getObjectIdForSelectionObjectTable(t));
        gridData = new GridData(1808);
        gridData.horizontalSpan = 10;
        gridData.grabExcessHorizontalSpace = true;
        this.objectTable.setLayoutData(gridData);
        label = new Label(composite, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
    }

    @Override
    public String getId() {
        return this.getPageId();
    }

    @Override
    public void setObject(MQExtObject obj) {
        Trace t = Trace.getDefault();
        if (obj != this.object && this.explorerTable != null && !this.explorerTable.isDisposed()) {
            if (!this.explorerTable.stopListener(t, this.listenDmObject) && Trace.isTracing) {
                if (this.listenDmObject == null) {
                    t.data(67, "MQContentPage.setObject", 900, "failed to start listening for changes - listenDmQmgr is null");
                } else {
                    t.data(67, "MQContentPage.setObject", 900, "failed to stop listening for changes - listenDmQmgr " + this.listenDmObject.getObservableName());
                }
            }
            this.explorerTable.removeAll(t);
        }
        this.object = obj;
    }

    @Override
    public void updatePage() {
        Trace t = Trace.getDefault();
        this.contentTitleBar.setText(this.getPageTitle(t, this.object));
        if (this.explorerTable != null) {
            UiMQObject uiMQObject;
            IUiMQObjectFactory factoryClass;
            IDmObject dmObject;
            this.explorerTable.setInstance(t, this.getInstanceId(t, this.object), this.getIsInstanceZOS(t, this.object));
            this.explorerTable.setFilterQSGDisposition(this.getFilterQSGDisposition(t));
            if (this.object != null && (dmObject = ((UiMQObject)this.object.getInternalObject()).getDmObject()) != null) {
                this.explorerTable.setFilteringAvailable(t, this.isEnableFilterBar(t));
            }
            this.isListenToDataModelForObjects = this.isListenToDataModelForObjects(t);
            if (this.isListenToDataModelForObjects) {
                this.listenDmObject = this.getListenObject(t, this.object);
                factoryClass = this.getUiMQObjectFactory(t, this.object);
                if (this.listenDmObject != null && factoryClass != null) {
                    uiMQObject = (UiMQObject)this.object.getInternalObject();
                    this.explorerTable.setUiMQObjectFactoryClass(t, factoryClass, uiMQObject);
                } else {
                    this.isListenToDataModelForObjects = false;
                    if (Trace.isTracing) {
                        if (this.listenDmObject == null) {
                            t.data(67, "MQContentPage.updatePage", 900, "unable to listen for objects - listenDmObject is invalid");
                        } else if (factoryClass == null) {
                            t.data(67, "MQContentPage.updatePage", 900, "unable to listen for objects - factoryClass is invalid");
                        }
                    }
                }
            }
            this.isListenToDataModelForQueueManagerChanges = this.isListenToDataModelForQueueManagerChanges(t);
            if (this.isListenToDataModelForQueueManagerChanges) {
                this.listenDmObject = UiPlugin.getTheDataModel();
                factoryClass = this.getUiMQObjectFactory(t, this.object);
                if (factoryClass != null) {
                    uiMQObject = (UiMQObject)this.object.getInternalObject();
                    this.explorerTable.setUiMQObjectFactoryClass(t, factoryClass, uiMQObject);
                } else {
                    this.isListenToDataModelForQueueManagerChanges = false;
                    if (Trace.isTracing) {
                        t.data(67, "MQContentPage.updatePage", 900, "unable to listen for objects - factoryClass is invalid");
                    }
                }
            }
        }
    }

    @Override
    public void refresh() {
        if (this.explorerTable != null) {
            this.explorerTable.refresh();
        }
    }

    @Override
    public void repaint() {
        if (this.explorerTable != null) {
            this.explorerTable.repaint();
        }
    }

    public abstract String getPageTitle(Trace var1, Object var2);

    public abstract String getPageId();

    public abstract String getGenericObjectName(Trace var1);

    public abstract String getObjectId();

    public abstract String getFilterId();

    public abstract String getAttributeOrderId();

    public abstract String getInstanceId(Trace var1, MQExtObject var2);

    public abstract boolean getIsInstanceZOS(Trace var1, MQExtObject var2);

    public abstract UiMQObject[] getObjects(Trace var1, MQExtObject var2, Filter var3);

    public abstract ArrayList getToolbarActions(Trace var1);

    public abstract ArrayList getMenuActions(Trace var1);

    public abstract ArrayList getViewerFilters(Trace var1);

    public abstract FilterProvider getFilterProvider(Trace var1);

    public abstract Integer getFilterQSGDisposition(Trace var1);

    public abstract String getNLSResourceFileKey();

    public abstract boolean isListenToDataModelForObjects(Trace var1);

    public abstract boolean isListenToDataModelForQueueManagerChanges(Trace var1);

    public abstract IDmObservable getListenObject(Trace var1, MQExtObject var2);

    public abstract IUiMQObjectFactory getUiMQObjectFactory(Trace var1, MQExtObject var2);

    public abstract boolean showSelectionObjectTable(Trace var1);

    public abstract UiMQObject getObjectForSelectionObjectTable(Trace var1, UiMQObject var2);

    public abstract String getTextForSelectionObjectTable(Trace var1, UiMQObject var2);

    public abstract String getAttributeOrderIdForSelectionObjectTable(Trace var1);

    public abstract String getObjectIdForSelectionObjectTable(Trace var1);

    public String[] getSelectionCategoryIds(Trace t) {
        return null;
    }

    public String getSelectionCategoryName(Trace t, String selectionCategoryId) {
        return "";
    }

    public void createSelectionCategoryContent(Trace t, String selectionCategoryId, Composite composite) {
    }

    public void selectionChanged(Trace t, UiMQObject selectedUiMQObject) {
    }

    public String getNLSString(Trace t, String textKey) {
        String nlsString = "+++" + textKey + "+++";
        if (this.msgFile != null) {
            nlsString = this.msgFile.getMessage(t, textKey);
        }
        return nlsString;
    }

    @Override
    public void setActive(boolean isActive) {
        IToolBarManager manager;
        int i;
        Trace t = Trace.getDefault();
        if (isActive && this.isExplorerTableColummResizeSuppressed) {
            this.explorerTable.setSuppressColumnResizing(false);
            this.isExplorerTableColummResizeSuppressed = false;
        }
        if (this.explorerTable != null) {
            this.explorerTable.setShowListenerExceptions(isActive);
            if (this.listenDmObject != null) {
                if (isActive) {
                    if (!this.explorerTable.isListening(t)) {
                        if (!this.explorerTable.startListener(t, this.listenDmObject) && Trace.isTracing) {
                            if (this.listenDmObject == null) {
                                t.data(67, "MQContentPage.setActive", 900, "failed to start listening for changes - listenDmObject is null");
                            } else {
                                t.data(67, "MQContentPage.setActive", 900, "failed to start listening for changes - listenDmObject " + this.listenDmObject.getObservableName());
                            }
                        }
                    } else if (this.showSystemObjectsChanged && this.explorerTable != null) {
                        this.explorerTable.refresh();
                        this.showSystemObjectsChanged = false;
                    }
                }
            } else if (isActive) {
                this.explorerTable.beginUpdate(t);
                this.explorerTable.removeAll(t);
                UiMQObject[] objects = this.getObjects(t, this.object, null);
                if (objects != null) {
                    i = 0;
                    while (i < objects.length) {
                        this.explorerTable.addTableItem(t, objects[i]);
                        ++i;
                    }
                }
                this.explorerTable.endUpdate(t);
            }
        }
        if (this.toolbarActions != null) {
            manager = this.getViewPart().getViewSite().getActionBars().getToolBarManager();
            if (isActive) {
                i = 0;
                while (i < this.toolbarActions.size()) {
                    manager.appendToGroup("com.ibm.mq.explorer.contentview.toolbar", (IAction)((Action)this.toolbarActions.get(i)));
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.toolbarActions.size()) {
                    manager.remove(((Action)this.toolbarActions.get(i)).getId());
                    ++i;
                }
            }
            manager.update(true);
        }
        if (this.menuActions != null) {
            manager = this.getViewPart().getViewSite().getActionBars().getMenuManager();
            if (isActive) {
                i = 0;
                while (i < this.menuActions.size()) {
                    manager.appendToGroup("com.ibm.mq.explorer.contentview.menu", (IAction)((Action)this.menuActions.get(i)));
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.menuActions.size()) {
                    manager.remove(((Action)this.menuActions.get(i)).getId());
                    ++i;
                }
            }
            manager.update(true);
        }
        if (isActive && this.objectTable != null) {
            this.objectTable.removeAll(t);
            this.objectTable.setEnabled(false);
            this.labelObjectTable.setText(this.getTextForSelectionObjectTable(t, null));
        }
    }

    @Override
    public void selChanged(ExplorerTableSelectionChangedEvent event) {
        Trace t = Trace.getDefault();
        if (this.objectTable != null) {
            UiMQObject selUiMQObject = event.getObject();
            this.objtableUiMQObject = this.getObjectForSelectionObjectTable(t, selUiMQObject);
            this.objectTable.setAttributeOrderId(t, this.getAttributeOrderIdForSelectionObjectTable(t));
            this.objectTable.removeAll(t);
            if (this.objtableUiMQObject != null) {
                this.objectTable.setEnabled(true);
                this.objectTable.setObject(t, this.objtableUiMQObject);
            } else {
                this.objectTable.setEnabled(false);
            }
            this.labelObjectTable.setText(this.getTextForSelectionObjectTable(t, selUiMQObject));
        }
        if (this.getSelectionCategoryIds(t) != null) {
            this.selectionChanged(t, event.getObject());
        }
    }

    @Override
    public void instanceDeleted(Object objDeleted) {
        Trace t = Trace.getDefault();
        if (this.object != null) {
            FilterManager filterManager = UiPlugin.getFilterManager();
            filterManager.instanceDeleted(t, this.getFilterId(), this.getInstanceId(t, this.object));
            AttributeOrderManager attrOrderManager = UiPlugin.getAttributeOrderManager();
            attrOrderManager.instanceDeleted(t, this.getAttributeOrderId(), this.getInstanceId(t, this.object));
        }
    }

    @Override
    public void showSystemObjects(boolean show) {
        this.showSystemObjectsChanged = true;
    }

    @Override
    public void contentChanged(ExplorerTableContentChangedEvent event) {
        Trace t = Trace.getDefault();
        if (this.objectTable != null && this.objtableUiMQObject != null) {
            this.objectTable.setObject(t, this.objtableUiMQObject);
        }
    }

    public void addExplorerTableViewerFilter(Trace t, ViewerFilter viewerFilter) {
        if (this.explorerTable != null) {
            this.explorerTable.addViewerFilter(t, viewerFilter);
        }
    }

    public boolean isClientFiltering() {
        return false;
    }

    public boolean isEnableFilterBar(Trace t) {
        boolean enable = false;
        IDmObject dmObject = ((UiMQObject)this.object.getInternalObject()).getDmObject();
        if (dmObject != null) {
            enable = dmObject.isFilteringSupported(t);
        }
        return enable;
    }

    public void refreshTableViewer() {
        this.explorerTable.refreshTableViewer();
    }
}

