/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ContentPersistence {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/content/ContentPersistence.java";
    public String contentFilename = "";
    private XMLMemento rootWrite = null;
    private XMLMemento rootRead = null;
    private static final String ROOT_KEY = "Content";
    private static final String VERSION_KEY = "FileVersion";
    private static final String THIS_VERSION = "1.0.0";
    private static final String SHOW_SYSTEM_OBJECTS_KEY = "ShowSystemObjects";
    private boolean showSystemObjects = false;

    public ContentPersistence(Trace t, File workingDir) {
        this.contentFilename = workingDir + File.separator + "WMQ_Content.xml";
        this.rootWrite = XMLMemento.createWriteRoot((String)ROOT_KEY);
    }

    public boolean load(Trace t) {
        boolean result = true;
        InputStreamReader reader = null;
        try {
            try {
                Integer intShow;
                File file = new File(this.contentFilename);
                FileInputStream input = new FileInputStream(file);
                reader = new InputStreamReader(input);
                this.rootRead = XMLMemento.createReadRoot((Reader)reader);
                String fileVersion = this.rootRead.getString(VERSION_KEY);
                if (fileVersion != null) {
                    fileVersion.compareTo(THIS_VERSION);
                }
                this.showSystemObjects = (intShow = this.rootRead.getInteger(SHOW_SYSTEM_OBJECTS_KEY)) == 1;
            }
            catch (FileNotFoundException e) {
                if (Trace.isTracing) {
                    t.data(67, "ContentPersistence.load", 300, e.getMessage());
                }
                result = false;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "ContentPersistence.load", 8, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
            catch (WorkbenchException e) {
                if (Trace.isTracing) {
                    t.data(67, "ContentPersistence.load", 300, e.getMessage());
                }
                result = false;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "ContentPersistence.load", 8, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                t.FFST(67, "ContentPersistence.load", 8, -1, 0, 0, e1.getMessage(), null, null);
            }
        }
        return result;
    }

    public boolean save(Trace t) {
        boolean result;
        block16: {
            result = false;
            int value = 0;
            this.rootWrite.putString(VERSION_KEY, THIS_VERSION);
            value = this.showSystemObjects ? 1 : 0;
            this.rootWrite.putInteger(SHOW_SYSTEM_OBJECTS_KEY, value);
            OutputStreamWriter writer = null;
            try {
                try {
                    File file = new File(this.contentFilename);
                    FileOutputStream output = new FileOutputStream(file);
                    writer = new OutputStreamWriter(output);
                    this.rootWrite.save((Writer)writer);
                    result = true;
                }
                catch (IOException iOException) {
                    if (Trace.isTracing) {
                        t.data(67, "ContentPersistence.save", 900, "IOException writing the XMLMemento file to disk");
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException2) {
                        if (Trace.isTracing) {
                            t.data(67, "ContentPersistence.save", 900, "IOException closing the XMLMemento file to disk");
                        }
                        break block16;
                    }
                }
            }
            catch (Throwable throwable) {
                block17: {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Trace.isTracing) break block17;
                        t.data(67, "ContentPersistence.save", 900, "IOException closing the XMLMemento file to disk");
                    }
                }
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {
                if (!Trace.isTracing) break block16;
                t.data(67, "ContentPersistence.save", 900, "IOException closing the XMLMemento file to disk");
            }
        }
        return result;
    }

    public boolean isShowSystemObjects() {
        return this.showSystemObjects;
    }

    public void setShowSystemObjects(boolean showSystemObjects) {
        this.showSystemObjects = showSystemObjects;
    }
}

